/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.GammaIntegerCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class GammaIntegerEncoding
implements Encoding<Integer> {
    private static final EncodingID ENCODING_ID = EncodingID.GAMMA;
    private int offset;

    public GammaIntegerEncoding() {
        this(0);
    }

    public GammaIntegerEncoding(int offset) {
        this.offset = offset;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int offset) {
        GammaIntegerEncoding gammaIntegerEncoding = new GammaIntegerEncoding();
        gammaIntegerEncoding.offset = offset;
        return new EncodingParams(ENCODING_ID, gammaIntegerEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        this.offset = ITF8.readUnsignedITF8(data);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new GammaIntegerCodec(this.offset);
    }
}

