/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeInstanceStatusRequest
extends AmazonWebServiceRequest {
    private Boolean dryRun;
    private List<String> instanceIds;
    private List<Filter> filters;
    private String nextToken;
    private Integer maxResults;
    private Boolean includeAllInstances;

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public DescribeInstanceStatusRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new ArrayList<String>();
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        ArrayList<String> instanceIdsCopy = new ArrayList<String>(instanceIds.size());
        instanceIdsCopy.addAll(instanceIds);
        this.instanceIds = instanceIdsCopy;
    }

    public DescribeInstanceStatusRequest withInstanceIds(String ... instanceIds) {
        if (this.getInstanceIds() == null) {
            this.setInstanceIds(new ArrayList<String>(instanceIds.length));
        }
        for (String value : instanceIds) {
            this.getInstanceIds().add(value);
        }
        return this;
    }

    public DescribeInstanceStatusRequest withInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
        } else {
            ArrayList<String> instanceIdsCopy = new ArrayList<String>(instanceIds.size());
            instanceIdsCopy.addAll(instanceIds);
            this.instanceIds = instanceIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ArrayList<Filter> filtersCopy = new ArrayList<Filter>(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeInstanceStatusRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeInstanceStatusRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ArrayList<Filter> filtersCopy = new ArrayList<Filter>(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeInstanceStatusRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeInstanceStatusRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public Boolean isIncludeAllInstances() {
        return this.includeAllInstances;
    }

    public void setIncludeAllInstances(Boolean includeAllInstances) {
        this.includeAllInstances = includeAllInstances;
    }

    public DescribeInstanceStatusRequest withIncludeAllInstances(Boolean includeAllInstances) {
        this.includeAllInstances = includeAllInstances;
        return this;
    }

    public Boolean getIncludeAllInstances() {
        return this.includeAllInstances;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dryRun != null) {
            sb.append("DryRun: " + this.dryRun + ", ");
        }
        if (this.instanceIds != null) {
            sb.append("InstanceIds: " + this.instanceIds + ", ");
        }
        if (this.filters != null) {
            sb.append("Filters: " + this.filters + ", ");
        }
        if (this.nextToken != null) {
            sb.append("NextToken: " + this.nextToken + ", ");
        }
        if (this.maxResults != null) {
            sb.append("MaxResults: " + this.maxResults + ", ");
        }
        if (this.includeAllInstances != null) {
            sb.append("IncludeAllInstances: " + this.includeAllInstances + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.isIncludeAllInstances() == null ? 0 : this.isIncludeAllInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceStatusRequest)) {
            return false;
        }
        DescribeInstanceStatusRequest other = (DescribeInstanceStatusRequest)((Object)obj);
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        if (other.getInstanceIds() != null && !other.getInstanceIds().equals(this.getInstanceIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.isIncludeAllInstances() == null ^ this.isIncludeAllInstances() == null) {
            return false;
        }
        return other.isIncludeAllInstances() == null || other.isIncludeAllInstances().equals(this.isIncludeAllInstances());
    }
}

