/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeRegionsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeRegionsRequestMarshaller
implements Marshaller<Request<DescribeRegionsRequest>, DescribeRegionsRequest> {
    public Request<DescribeRegionsRequest> marshall(DescribeRegionsRequest describeRegionsRequest) {
        if (describeRegionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeRegionsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeRegions");
        request.addParameter("Version", "2013-10-15");
        if (describeRegionsRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)describeRegionsRequest.isDryRun()));
        }
        List<String> regionNamesList = describeRegionsRequest.getRegionNames();
        int regionNamesListIndex = 1;
        for (String regionNamesListValue : regionNamesList) {
            if (regionNamesListValue != null) {
                request.addParameter("RegionName." + regionNamesListIndex, StringUtils.fromString((String)regionNamesListValue));
            }
            ++regionNamesListIndex;
        }
        List<Filter> filtersList = describeRegionsRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

