/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.files;

import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.files.FileUtils;
import amazon.fws.clicommando.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileUtils {
    public static JarFile getJarFile(Class<?> classReference) {
        try {
            URL jarPath = classReference.getProtectionDomain().getCodeSource().getLocation();
            String path = jarPath.getPath();
            URLCodec urlCodec = new URLCodec();
            path = urlCodec.decode(path);
            return new JarFile(path);
        }
        catch (IOException e) {
            throw new InternalErrorException("Cannot open current jar (Jar file open)", e);
        }
        catch (DecoderException e) {
            throw new InternalErrorException("Cannot open current jar (URL decoder)", (Exception)((Object)e));
        }
    }

    public static JarFile getJarFile(String path) {
        try {
            return new JarFile(path);
        }
        catch (Exception e) {
            throw new InternalErrorException("Cannot open current jar");
        }
    }

    public static List<JarEntry> getFilesInDirectory(JarFile jarFile, String directory, String extension) {
        if (StringUtils.isEmpty(extension)) {
            return JarFileUtils.getFilesInDirectory(jarFile, directory);
        }
        ArrayList<JarEntry> jarEntries = new ArrayList<JarEntry>();
        for (JarEntry je : JarFileUtils.getFilesInDirectory(jarFile, directory)) {
            if (!FileUtils.hasExtension(je.getName(), extension)) continue;
            jarEntries.add(je);
        }
        return jarEntries;
    }

    public static List<JarEntry> getFilesInDirectory(JarFile jarFile, String directory) {
        ArrayList<JarEntry> jarEntries = new ArrayList<JarEntry>();
        String dir = JarFileUtils.isRootDir(directory) ? "" : directory;
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (je.isDirectory() || !FileUtils.inDir(je.getName(), dir, '/')) continue;
            jarEntries.add(je);
        }
        return jarEntries;
    }

    public static boolean isJarArchive(String path) {
        return FileUtils.hasExtension(path, "jar");
    }

    public static boolean isRootDir(String path) {
        return StringUtils.isEmpty(path) || "/".equals(path);
    }
}

