/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestSuite;
import junit.runner.ReloadingTestSuiteLoader;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;

public abstract class BaseTestRunner
implements TestListener {
    public static final String SUITE_METHODNAME = "suite";
    static Properties fPreferences;
    static int fgMaxMessageLength;
    static boolean fgFilterStack;
    boolean fLoading = true;

    static {
        fgMaxMessageLength = 500;
        fgFilterStack = true;
    }

    public BaseTestRunner() {
        fPreferences = new Properties();
        ((Hashtable)fPreferences).put("loading", "true");
        ((Hashtable)fPreferences).put("filterstack", "true");
        BaseTestRunner.readPreferences();
        fgMaxMessageLength = BaseTestRunner.getPreference("maxmessage", fgMaxMessageLength);
    }

    public abstract void addError(Test var1, Throwable var2);

    public abstract void addFailure(Test var1, AssertionFailedError var2);

    protected void clearStatus() {
    }

    public String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }

    public abstract void endTest(Test var1);

    public String extractClassName(String className) {
        if (className.startsWith("Default package for")) {
            return className.substring(className.lastIndexOf(".") + 1);
        }
        return className;
    }

    static boolean filterLine(String line) {
        String[] patterns = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "java.lang.reflect.Method.invoke("};
        int i = 0;
        while (i < patterns.length) {
            if (line.indexOf(patterns[i]) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String filterStack(String stack) {
        if (!BaseTestRunner.getPreference("filterstack").equals("true") || !fgFilterStack) {
            return stack;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (BaseTestRunner.filterLine(line)) continue;
                pw.println(line);
            }
        }
        catch (Exception exception) {
            return stack;
        }
        return sw.toString();
    }

    public static String getFilteredTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        String trace = buffer.toString();
        return BaseTestRunner.filterStack(trace);
    }

    public TestSuiteLoader getLoader() {
        if (this.useReloadingTestSuiteLoader()) {
            return new ReloadingTestSuiteLoader();
        }
        return new StandardTestSuiteLoader();
    }

    public static String getPreference(String key) {
        return fPreferences.getProperty(key);
    }

    public static int getPreference(String key, int dflt) {
        String value = BaseTestRunner.getPreference(key);
        int intValue = dflt;
        if (value == null) {
            return intValue;
        }
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {}
        return intValue;
    }

    private static File getPreferencesFile() {
        String home = System.getProperty("user.home");
        return new File(home, "junit.properties");
    }

    public Test getTest(String suiteClassName) {
        if (suiteClassName.length() <= 0) {
            this.clearStatus();
            return null;
        }
        Class testClass = null;
        try {
            testClass = this.loadSuiteClass(suiteClassName);
        }
        catch (ClassNotFoundException e) {
            String clazz = e.getMessage();
            if (clazz == null) {
                clazz = suiteClassName;
            }
            this.runFailed("Class not found \"" + clazz + "\"");
            return null;
        }
        catch (Exception e) {
            this.runFailed("Error: " + e.toString());
            return null;
        }
        Method suiteMethod = null;
        try {
            suiteMethod = testClass.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception exception) {
            this.clearStatus();
            return new TestSuite(testClass);
        }
        Test test = null;
        try {
            test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (InvocationTargetException e) {
            this.runFailed("Failed to invoke suite():" + e.getTargetException().toString());
            return null;
        }
        catch (IllegalAccessException e) {
            this.runFailed("Failed to invoke suite():" + e.toString());
            return null;
        }
        this.clearStatus();
        return test;
    }

    public static boolean inVAJava() {
        try {
            Class.forName("com.ibm.uvm.tools.DebugSupport");
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected Class loadSuiteClass(String suiteClassName) throws ClassNotFoundException {
        return this.getLoader().load(suiteClassName);
    }

    protected String processArguments(String[] args) {
        String suiteName = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-noloading")) {
                this.setLoading(false);
            } else if (args[i].equals("-nofilterstack")) {
                fgFilterStack = false;
            } else if (args[i].equals("-c")) {
                if (args.length > i + 1) {
                    suiteName = this.extractClassName(args[i + 1]);
                } else {
                    System.out.println("Missing Test class name");
                }
                ++i;
            } else {
                suiteName = args[i];
            }
            ++i;
        }
        return suiteName;
    }

    private static void readPreferences() {
        block4: {
            FileInputStream is = null;
            try {
                is = new FileInputStream(BaseTestRunner.getPreferencesFile());
                fPreferences = new Properties(fPreferences);
                fPreferences.load(is);
            }
            catch (IOException iOException) {
                try {
                    if (is == null) break block4;
                    ((InputStream)is).close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    protected abstract void runFailed(String var1);

    public void setLoading(boolean enable) {
        this.fLoading = enable;
    }

    public abstract void startTest(Test var1);

    public static String truncate(String s) {
        if (fgMaxMessageLength != -1 && s.length() > fgMaxMessageLength) {
            s = String.valueOf(s.substring(0, fgMaxMessageLength)) + "...";
        }
        return s;
    }

    protected boolean useReloadingTestSuiteLoader() {
        return BaseTestRunner.getPreference("loading").equals("true") && !BaseTestRunner.inVAJava() && this.fLoading;
    }
}

