#!/usr/bin/python3

import os
import subprocess
import unittest


def hasMyPy():
    try:
        subprocess.check_call(["mypy", "--version"])
    except Exception:
        return False
    return True


class PackagePep484TestCase(unittest.TestCase):
    @unittest.skipIf(not hasMyPy(), "no mypy available")
    def test_pep484_clean(self):
        top_src_dir = os.path.join(os.path.dirname(__file__), "..")
        # FIXME: add pyi file for python-apt to get rid of the
        # --ignore-missing-imports
        res = subprocess.call(["mypy", "--ignore-missing-imports", top_src_dir])
        self.assertEqual(res, 0)

    def test_faux(self):
        """Empty test to avoid error.

        Makes sure this test case doesn't exit with code 5 on 3.12"""

        self.assertTrue(True)


if __name__ == "__main__":
    unittest.main()
