/**
 * This file defines all virtual keycodes for synthesizeNativeKey() of
 * EventUtils.js and nsIDOMWindowUtils.sendNativeKeyEvent().
 * These values are defined in each platform's SDK or documents.
 */

// Windows
// Windows' native key code values may include scan code value which can be
// retrieved with |((code & 0xFFFF0000 >> 16)|.  If the value is 0, it will
// be computed with active keyboard layout automatically.
// FYI: Don't define scan code here for printable keys, numeric keys and
//      IME keys because they depend on active keyboard layout.
// XXX: Although, ABNT C1 key depends on keyboard layout in strictly speaking.
//      However, computing its scan code from the virtual keycode,
//      WIN_VK_ABNT_C1, doesn't work fine (computed as 0x0073, "IntlRo").
//      Therefore, we should specify it here explicitly (it should be 0x0056,
//      "IntlBackslash").  Fortunately, the key always generates 0x0056 with
//      any keyboard layouts as far as I've tested.  So, this must be safe to
//      test new regressions.

const WIN_VK_LBUTTON                    = 0x00000001;
const WIN_VK_RBUTTON                    = 0x00000002;
const WIN_VK_CANCEL                     = 0xE0460003;
const WIN_VK_MBUTTON                    = 0x00000004;
const WIN_VK_XBUTTON1                   = 0x00000005;
const WIN_VK_XBUTTON2                   = 0x00000006;
const WIN_VK_BACK                       = 0x000E0008;
const WIN_VK_TAB                        = 0x000F0009;
const WIN_VK_CLEAR                      = 0x004C000C;
const WIN_VK_RETURN                     = 0x001C000D;
const WIN_VK_SHIFT                      = 0x002A0010;
const WIN_VK_CONTROL                    = 0x001D0011;
const WIN_VK_MENU                       = 0x00380012;
const WIN_VK_PAUSE                      = 0x00450013;
const WIN_VK_CAPITAL                    = 0x003A0014;
const WIN_VK_KANA                       = 0x00000015;
const WIN_VK_HANGUEL                    = 0x00000015;
const WIN_VK_HANGUL                     = 0x00000015;
const WIN_VK_JUNJA                      = 0x00000017;
const WIN_VK_FINAL                      = 0x00000018;
const WIN_VK_HANJA                      = 0x00000019;
const WIN_VK_KANJI                      = 0x00000019;
const WIN_VK_ESCAPE                     = 0x0001001B;
const WIN_VK_CONVERT                    = 0x0000001C;
const WIN_VK_NONCONVERT                 = 0x0000001D;
const WIN_VK_ACCEPT                     = 0x0000001E;
const WIN_VK_MODECHANGE                 = 0x0000001F;
const WIN_VK_SPACE                      = 0x00390020;
const WIN_VK_PRIOR                      = 0xE0490021;
const WIN_VK_NEXT                       = 0xE0510022;
const WIN_VK_END                        = 0xE04F0023;
const WIN_VK_HOME                       = 0xE0470024;
const WIN_VK_LEFT                       = 0xE04B0025;
const WIN_VK_UP                         = 0xE0480026;
const WIN_VK_RIGHT                      = 0xE04D0027;
const WIN_VK_DOWN                       = 0xE0500028;
const WIN_VK_SELECT                     = 0x00000029;
const WIN_VK_PRINT                      = 0x0000002A;
const WIN_VK_EXECUTE                    = 0x0000002B;
const WIN_VK_SNAPSHOT                   = 0xE037002C;
const WIN_VK_INSERT                     = 0xE052002D;
const WIN_VK_DELETE                     = 0xE053002E;
const WIN_VK_HELP                       = 0x0000002F;
const WIN_VK_0                          = 0x00000030;
const WIN_VK_1                          = 0x00000031;
const WIN_VK_2                          = 0x00000032;
const WIN_VK_3                          = 0x00000033;
const WIN_VK_4                          = 0x00000034;
const WIN_VK_5                          = 0x00000035;
const WIN_VK_6                          = 0x00000036;
const WIN_VK_7                          = 0x00000037;
const WIN_VK_8                          = 0x00000038;
const WIN_VK_9                          = 0x00000039;
const WIN_VK_A                          = 0x00000041;
const WIN_VK_B                          = 0x00000042;
const WIN_VK_C                          = 0x00000043;
const WIN_VK_D                          = 0x00000044;
const WIN_VK_E                          = 0x00000045;
const WIN_VK_F                          = 0x00000046;
const WIN_VK_G                          = 0x00000047;
const WIN_VK_H                          = 0x00000048;
const WIN_VK_I                          = 0x00000049;
const WIN_VK_J                          = 0x0000004A;
const WIN_VK_K                          = 0x0000004B;
const WIN_VK_L                          = 0x0000004C;
const WIN_VK_M                          = 0x0000004D;
const WIN_VK_N                          = 0x0000004E;
const WIN_VK_O                          = 0x0000004F;
const WIN_VK_P                          = 0x00000050;
const WIN_VK_Q                          = 0x00000051;
const WIN_VK_R                          = 0x00000052;
const WIN_VK_S                          = 0x00000053;
const WIN_VK_T                          = 0x00000054;
const WIN_VK_U                          = 0x00000055;
const WIN_VK_V                          = 0x00000056;
const WIN_VK_W                          = 0x00000057;
const WIN_VK_X                          = 0x00000058;
const WIN_VK_Y                          = 0x00000059;
const WIN_VK_Z                          = 0x0000005A;
const WIN_VK_LWIN                       = 0xE05B005B;
const WIN_VK_RWIN                       = 0xE05C005C;
const WIN_VK_APPS                       = 0xE05D005D;
const WIN_VK_SLEEP                      = 0x0000005F;
const WIN_VK_NUMPAD0                    = 0x00520060;
const WIN_VK_NUMPAD1                    = 0x004F0061;
const WIN_VK_NUMPAD2                    = 0x00500062;
const WIN_VK_NUMPAD3                    = 0x00510063;
const WIN_VK_NUMPAD4                    = 0x004B0064;
const WIN_VK_NUMPAD5                    = 0x004C0065;
const WIN_VK_NUMPAD6                    = 0x004D0066;
const WIN_VK_NUMPAD7                    = 0x00470067;
const WIN_VK_NUMPAD8                    = 0x00480068;
const WIN_VK_NUMPAD9                    = 0x00490069;
const WIN_VK_MULTIPLY                   = 0x0037006A;
const WIN_VK_ADD                        = 0x004E006B;
const WIN_VK_SEPARATOR                  = 0x0000006C;
const WIN_VK_OEM_NEC_SEPARATE           = 0x0000006C;
const WIN_VK_SUBTRACT                   = 0x004A006D;
const WIN_VK_DECIMAL                    = 0x0053006E;
const WIN_VK_DIVIDE                     = 0xE035006F;
const WIN_VK_F1                         = 0x003B0070;
const WIN_VK_F2                         = 0x003C0071;
const WIN_VK_F3                         = 0x003D0072;
const WIN_VK_F4                         = 0x003E0073;
const WIN_VK_F5                         = 0x003F0074;
const WIN_VK_F6                         = 0x00400075;
const WIN_VK_F7                         = 0x00410076;
const WIN_VK_F8                         = 0x00420077;
const WIN_VK_F9                         = 0x00430078;
const WIN_VK_F10                        = 0x00440079;
const WIN_VK_F11                        = 0x0057007A;
const WIN_VK_F12                        = 0x0058007B;
const WIN_VK_F13                        = 0x0064007C;
const WIN_VK_F14                        = 0x0065007D;
const WIN_VK_F15                        = 0x0066007E;
const WIN_VK_F16                        = 0x0067007F;
const WIN_VK_F17                        = 0x00680080;
const WIN_VK_F18                        = 0x00690081;
const WIN_VK_F19                        = 0x006A0082;
const WIN_VK_F20                        = 0x006B0083;
const WIN_VK_F21                        = 0x006C0084;
const WIN_VK_F22                        = 0x006D0085;
const WIN_VK_F23                        = 0x006E0086;
const WIN_VK_F24                        = 0x00760087;
const WIN_VK_NUMLOCK                    = 0xE0450090;
const WIN_VK_SCROLL                     = 0x00460091;
const WIN_VK_OEM_FJ_JISHO               = 0x00000092;
const WIN_VK_OEM_NEC_EQUAL              = 0x00000092;
const WIN_VK_OEM_FJ_MASSHOU             = 0x00000093;
const WIN_VK_OEM_FJ_TOUROKU             = 0x00000094;
const WIN_VK_OEM_FJ_LOYA                = 0x00000095;
const WIN_VK_OEM_FJ_ROYA                = 0x00000096;
const WIN_VK_LSHIFT                     = 0x002A00A0;
const WIN_VK_RSHIFT                     = 0x003600A1;
const WIN_VK_LCONTROL                   = 0x001D00A2;
const WIN_VK_RCONTROL                   = 0xE01D00A3;
const WIN_VK_LMENU                      = 0x003800A4;
const WIN_VK_RMENU                      = 0xE03800A5;
const WIN_VK_BROWSER_BACK               = 0xE06A00A6;
const WIN_VK_BROWSER_FORWARD            = 0xE06900A7;
const WIN_VK_BROWSER_REFRESH            = 0xE06700A8;
const WIN_VK_BROWSER_STOP               = 0xE06800A9;
const WIN_VK_BROWSER_SEARCH             = 0x000000AA;
const WIN_VK_BROWSER_FAVORITES          = 0xE06600AB;
const WIN_VK_BROWSER_HOME               = 0xE03200AC;
const WIN_VK_VOLUME_MUTE                = 0xE02000AD;
const WIN_VK_VOLUME_DOWN                = 0xE02E00AE;
const WIN_VK_VOLUME_UP                  = 0xE03000AF;
const WIN_VK_MEDIA_NEXT_TRACK           = 0xE01900B0;
const WIN_VK_OEM_FJ_000                 = 0x000000B0;
const WIN_VK_MEDIA_PREV_TRACK           = 0xE01000B1;
const WIN_VK_OEM_FJ_EUQAL               = 0x000000B1;
const WIN_VK_MEDIA_STOP                 = 0xE02400B2;
const WIN_VK_MEDIA_PLAY_PAUSE           = 0xE02200B3;
const WIN_VK_OEM_FJ_00                  = 0x000000B3;
const WIN_VK_LAUNCH_MAIL                = 0xE06C00B4;
const WIN_VK_LAUNCH_MEDIA_SELECT        = 0xE06D00B5;
const WIN_VK_LAUNCH_APP1                = 0xE06B00B6;
const WIN_VK_LAUNCH_APP2                = 0xE02100B7;
const WIN_VK_OEM_1                      = 0x000000BA;
const WIN_VK_OEM_PLUS                   = 0x000000BB;
const WIN_VK_OEM_COMMA                  = 0x000000BC;
const WIN_VK_OEM_MINUS                  = 0x000000BD;
const WIN_VK_OEM_PERIOD                 = 0x000000BE;
const WIN_VK_OEM_2                      = 0x000000BF;
const WIN_VK_OEM_3                      = 0x000000C0;
const WIN_VK_ABNT_C1                    = 0x005600C1;
const WIN_VK_ABNT_C2                    = 0x000000C2;
const WIN_VK_OEM_4                      = 0x000000DB;
const WIN_VK_OEM_5                      = 0x000000DC;
const WIN_VK_OEM_6                      = 0x000000DD;
const WIN_VK_OEM_7                      = 0x000000DE;
const WIN_VK_OEM_8                      = 0x000000DF;
const WIN_VK_OEM_NEC_DP1                = 0x000000E0;
const WIN_VK_OEM_AX                     = 0x000000E1;
const WIN_VK_OEM_NEC_DP2                = 0x000000E1;
const WIN_VK_OEM_102                    = 0x000000E2;
const WIN_VK_OEM_NEC_DP3                = 0x000000E2;
const WIN_VK_ICO_HELP                   = 0x000000E3;
const WIN_VK_OEM_NEC_DP4                = 0x000000E3;
const WIN_VK_ICO_00                     = 0x000000E4;
const WIN_VK_PROCESSKEY                 = 0x000000E5;
const WIN_VK_ICO_CLEAR                  = 0x000000E6;
const WIN_VK_PACKET                     = 0x000000E7;
const WIN_VK_ERICSSON_BASE              = 0x000000E8;
const WIN_VK_OEM_RESET                  = 0x000000E9;
const WIN_VK_OEM_JUMP                   = 0x000000EA;
const WIN_VK_OEM_PA1                    = 0x000000EB;
const WIN_VK_OEM_PA2                    = 0x000000EC;
const WIN_VK_OEM_PA3                    = 0x000000ED;
const WIN_VK_OEM_WSCTRL                 = 0x000000EE;
const WIN_VK_OEM_CUSEL                  = 0x000000EF;
const WIN_VK_OEM_ATTN                   = 0x000000F0;
const WIN_VK_OEM_FINISH                 = 0x000000F1;
const WIN_VK_OEM_COPY                   = 0x000000F2;
const WIN_VK_OEM_AUTO                   = 0x000000F3;
const WIN_VK_OEM_ENLW                   = 0x000000F4;
const WIN_VK_OEM_BACKTAB                = 0x000000F5;
const WIN_VK_ATTN                       = 0x000000F6;
const WIN_VK_CRSEL                      = 0x000000F7;
const WIN_VK_EXSEL                      = 0x000000F8;
const WIN_VK_EREOF                      = 0x000000F9;
const WIN_VK_PLAY                       = 0x000000FA;
const WIN_VK_ZOOM                       = 0x000000FB;
const WIN_VK_NONAME                     = 0x000000FC;
const WIN_VK_PA1                        = 0x000000FD;
const WIN_VK_OEM_CLEAR                  = 0x000000FE;

const WIN_VK_NUMPAD_RETURN              = 0xE01C000D;
const WIN_VK_NUMPAD_PRIOR               = 0x00490021;
const WIN_VK_NUMPAD_NEXT                = 0x00510022;
const WIN_VK_NUMPAD_END                 = 0x004F0023;
const WIN_VK_NUMPAD_HOME                = 0x00470024;
const WIN_VK_NUMPAD_LEFT                = 0x004B0025;
const WIN_VK_NUMPAD_UP                  = 0x00480026;
const WIN_VK_NUMPAD_RIGHT               = 0x004D0027;
const WIN_VK_NUMPAD_DOWN                = 0x00500028;
const WIN_VK_NUMPAD_INSERT              = 0x0052002D;
const WIN_VK_NUMPAD_DELETE              = 0x0053002E;

// Mac

const MAC_VK_ANSI_A                     = 0x00;
const MAC_VK_ANSI_S                     = 0x01;
const MAC_VK_ANSI_D                     = 0x02;
const MAC_VK_ANSI_F                     = 0x03;
const MAC_VK_ANSI_H                     = 0x04;
const MAC_VK_ANSI_G                     = 0x05;
const MAC_VK_ANSI_Z                     = 0x06;
const MAC_VK_ANSI_X                     = 0x07;
const MAC_VK_ANSI_C                     = 0x08;
const MAC_VK_ANSI_V                     = 0x09;
const MAC_VK_ISO_Section                = 0x0A;
const MAC_VK_ANSI_B                     = 0x0B;
const MAC_VK_ANSI_Q                     = 0x0C;
const MAC_VK_ANSI_W                     = 0x0D;
const MAC_VK_ANSI_E                     = 0x0E;
const MAC_VK_ANSI_R                     = 0x0F;
const MAC_VK_ANSI_Y                     = 0x10;
const MAC_VK_ANSI_T                     = 0x11;
const MAC_VK_ANSI_1                     = 0x12;
const MAC_VK_ANSI_2                     = 0x13;
const MAC_VK_ANSI_3                     = 0x14;
const MAC_VK_ANSI_4                     = 0x15;
const MAC_VK_ANSI_6                     = 0x16;
const MAC_VK_ANSI_5                     = 0x17;
const MAC_VK_ANSI_Equal                 = 0x18;
const MAC_VK_ANSI_9                     = 0x19;
const MAC_VK_ANSI_7                     = 0x1A;
const MAC_VK_ANSI_Minus                 = 0x1B;
const MAC_VK_ANSI_8                     = 0x1C;
const MAC_VK_ANSI_0                     = 0x1D;
const MAC_VK_ANSI_RightBracket          = 0x1E;
const MAC_VK_ANSI_O                     = 0x1F;
const MAC_VK_ANSI_U                     = 0x20;
const MAC_VK_ANSI_LeftBracket           = 0x21;
const MAC_VK_ANSI_I                     = 0x22;
const MAC_VK_ANSI_P                     = 0x23;
const MAC_VK_Return                     = 0x24;
const MAC_VK_ANSI_L                     = 0x25;
const MAC_VK_ANSI_J                     = 0x26;
const MAC_VK_ANSI_Quote                 = 0x27;
const MAC_VK_ANSI_K                     = 0x28;
const MAC_VK_ANSI_Semicolon             = 0x29;
const MAC_VK_ANSI_Backslash             = 0x2A;
const MAC_VK_ANSI_Comma                 = 0x2B;
const MAC_VK_ANSI_Slash                 = 0x2C;
const MAC_VK_ANSI_N                     = 0x2D;
const MAC_VK_ANSI_M                     = 0x2E;
const MAC_VK_ANSI_Period                = 0x2F;
const MAC_VK_Tab                        = 0x30;
const MAC_VK_Space                      = 0x31;
const MAC_VK_ANSI_Grave                 = 0x32;
const MAC_VK_Delete                     = 0x33;
const MAC_VK_PC_Backspace               = 0x33;
const MAC_VK_Powerbook_KeypadEnter      = 0x34;
const MAC_VK_Escape                     = 0x35;
const MAC_VK_RightCommand               = 0x36;
const MAC_VK_Command                    = 0x37;
const MAC_VK_Shift                      = 0x38;
const MAC_VK_CapsLock                   = 0x39;
const MAC_VK_Option                     = 0x3A;
const MAC_VK_Control                    = 0x3B;
const MAC_VK_RightShift                 = 0x3C;
const MAC_VK_RightOption                = 0x3D;
const MAC_VK_RightControl               = 0x3E;
const MAC_VK_Function                   = 0x3F;
const MAC_VK_F17                        = 0x40;
const MAC_VK_ANSI_KeypadDecimal         = 0x41;
const MAC_VK_ANSI_KeypadMultiply        = 0x43;
const MAC_VK_ANSI_KeypadPlus            = 0x45;
const MAC_VK_ANSI_KeypadClear           = 0x47;
const MAC_VK_VolumeUp                   = 0x48;
const MAC_VK_VolumeDown                 = 0x49;
const MAC_VK_Mute                       = 0x4A;
const MAC_VK_ANSI_KeypadDivide          = 0x4B;
const MAC_VK_ANSI_KeypadEnter           = 0x4C;
const MAC_VK_ANSI_KeypadMinus           = 0x4E;
const MAC_VK_F18                        = 0x4F;
const MAC_VK_F19                        = 0x50;
const MAC_VK_ANSI_KeypadEquals          = 0x51;
const MAC_VK_ANSI_Keypad0               = 0x52;
const MAC_VK_ANSI_Keypad1               = 0x53;
const MAC_VK_ANSI_Keypad2               = 0x54;
const MAC_VK_ANSI_Keypad3               = 0x55;
const MAC_VK_ANSI_Keypad4               = 0x56;
const MAC_VK_ANSI_Keypad5               = 0x57;
const MAC_VK_ANSI_Keypad6               = 0x58;
const MAC_VK_ANSI_Keypad7               = 0x59;
const MAC_VK_F20                        = 0x5A;
const MAC_VK_ANSI_Keypad8               = 0x5B;
const MAC_VK_ANSI_Keypad9               = 0x5C;
const MAC_VK_JIS_Yen                    = 0x5D;
const MAC_VK_JIS_Underscore             = 0x5E;
const MAC_VK_JIS_KeypadComma            = 0x5F;
const MAC_VK_F5                         = 0x60;
const MAC_VK_F6                         = 0x61;
const MAC_VK_F7                         = 0x62;
const MAC_VK_F3                         = 0x63;
const MAC_VK_F8                         = 0x64;
const MAC_VK_F9                         = 0x65;
const MAC_VK_JIS_Eisu                   = 0x66;
const MAC_VK_F11                        = 0x67;
const MAC_VK_JIS_Kana                   = 0x68;
const MAC_VK_F13                        = 0x69;
const MAC_VK_PC_PrintScreen             = 0x69;
const MAC_VK_F16                        = 0x6A;
const MAC_VK_F14                        = 0x6B;
const MAC_VK_PC_ScrollLock              = 0x6B;
const MAC_VK_F10                        = 0x6D;
const MAC_VK_PC_ContextMenu             = 0x6E;
const MAC_VK_F12                        = 0x6F;
const MAC_VK_F15                        = 0x71;
const MAC_VK_PC_Pause                   = 0x71;
const MAC_VK_Help                       = 0x72;
const MAC_VK_PC_Insert                  = 0x72;
const MAC_VK_Home                       = 0x73;
const MAC_VK_PageUp                     = 0x74;
const MAC_VK_ForwardDelete              = 0x75;
const MAC_VK_PC_Delete                  = 0x75;
const MAC_VK_F4                         = 0x76;
const MAC_VK_End                        = 0x77;
const MAC_VK_F2                         = 0x78;
const MAC_VK_PageDown                   = 0x79;
const MAC_VK_F1                         = 0x7A;
const MAC_VK_LeftArrow                  = 0x7B;
const MAC_VK_RightArrow                 = 0x7C;
const MAC_VK_DownArrow                  = 0x7D;
const MAC_VK_UpArrow                    = 0x7E;

