/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

public class DefaultAttributeAction
extends AbstractSelectedAction {
    private AttributeKey[] keys;
    private Map<AttributeKey, Object> fixedAttributes;

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey) {
        this(drawingEditor, attributeKey, null, null);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Map<AttributeKey, Object> map) {
        this(drawingEditor, new AttributeKey[]{attributeKey}, null, null, map);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey[] attributeKeyArray) {
        this(drawingEditor, attributeKeyArray, null, null);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Icon icon) {
        this(drawingEditor, attributeKey, null, icon);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, String string) {
        this(drawingEditor, attributeKey, string, null);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, String string, Icon icon) {
        this(drawingEditor, new AttributeKey[]{attributeKey}, string, icon);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey[] attributeKeyArray, String string, Icon icon) {
        this(drawingEditor, attributeKeyArray, string, icon, new HashMap<AttributeKey, Object>());
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey[] attributeKeyArray, String string, Icon icon, Map<AttributeKey, Object> map) {
        super(drawingEditor);
        this.keys = attributeKeyArray;
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
        drawingEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(DefaultAttributeAction.this.keys[0])) {
                    DefaultAttributeAction.this.putValue("attribute_" + DefaultAttributeAction.this.keys[0], propertyChangeEvent.getNewValue());
                }
            }
        });
        this.fixedAttributes = map;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getView() != null && this.getView().getSelectionCount() > 0) {
            CompositeEdit compositeEdit = new CompositeEdit(this.labels.getString("drawAttributeChange"));
            this.fireUndoableEditHappened(compositeEdit);
            this.changeAttribute();
            this.fireUndoableEditHappened(compositeEdit);
        }
    }

    public void changeAttribute() {
        CompositeEdit compositeEdit = new CompositeEdit("attributes");
        this.fireUndoableEditHappened(compositeEdit);
        DrawingEditor drawingEditor = this.getEditor();
        for (Figure figure : this.getView().getSelectedFigures()) {
            figure.willChange();
            for (int i = 0; i < this.keys.length; ++i) {
                figure.set(this.keys[i], drawingEditor.getDefaultAttribute(this.keys[i]));
            }
            for (Map.Entry<AttributeKey, Object> entry : this.fixedAttributes.entrySet()) {
                figure.set(entry.getKey(), entry.getValue());
            }
            figure.changed();
        }
        this.fireUndoableEditHappened(compositeEdit);
    }

    public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
    }
}

