#!/usr/bin/perl -w
#
# Quick and dirty program to convert a NBI Linux image to an ELF image
# Calls disnbi and mkelf-linux to do the work
#
my $nbifile = shift or die "Usage: $0 nbifile elffile\n";
my $elffile = shift or die "Usage: $0 nbifile elffile\n";
-r $nbifile or die "Cannot read $nbifile\n";
my @segments = "segment0" .. "segment5";
unlink(@segments);
system("disnbi -e $nbifile");
my $params = `cat segment1`;
$params =~ tr/\000//;
undef $/;
open(O, ">kimage") or die "kimage: $!\n";
foreach $i ("segment2" .. "segment4") {
	open(I, $i) or die "$i: $!\n";
	$_ = <I>;
	print O $_;
	close(I);
}
close(O);
print "mkelf-linux -o $elffile --param='$params' kimage initrd\n";
if (-r 'segment5') {
	system('mkelf-linux', "--output=$elffile", "--param=$params", 'kimage', 'segment5');
} else {
	system('mkelf-linux', "--output=$elffile", "--param=$params", 'kimage');
}
unlink(@segments, 'nbidir', 'kimage');
exit(0);
