#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include "unity-webapps-url-db.h"
#include "unity-webapps-debug.h"

#define TEST_DB_OUTPUT_PATH "./urldb-v2.sqlite"

static void
spawn_index_updater ()
{
  g_setenv ("UNITY_WEBAPPS_URL_DB_DEFAULT_PATH", TEST_DB_OUTPUT_PATH, TRUE);
  g_setenv ("UNITY_WEBAPPS_APT_CACHE_BINARY", "./mock-apt-cache", TRUE);
  system ("../../src/index-updater/ubuntu-webapps-update-index");
}

gint 
main (gint argc, gchar **argv)
{
  UnityWebappsUrlDB *db;
  UnityWebappsUrlDBRecord *record;
  GList *records;
  
  unity_webapps_debug_initialize_flags ();

  spawn_index_updater ();
  
  db = unity_webapps_url_db_open (TRUE, "./urldb-v2.sqlite");
  unity_webapps_url_db_lookup_urls (db, "http://chrome.angrybirds.com/foo",
				    &records);
  g_assert (records);
  record = (UnityWebappsUrlDBRecord *)records->data;
  g_assert_cmpstr (record->package_name, ==, "unity-webapps-angrybirds");
  g_assert_cmpstr (record->application_name, ==, "AngryBirds");
  g_assert_cmpstr (record->domain, ==, "test.ts");
  return 0;
}
