/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;
import org.w3c.dom.Node;

public abstract class XSLGeneralIncorporate
extends StyleElement {
    String href;
    DocumentImpl includedDoc;

    public abstract boolean isImport();

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "href") {
                this.href = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.href == null) {
            this.reportAbsence("href");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkEmpty();
        this.checkTopLevel();
    }

    public XSLStyleSheet getIncludedStyleSheet(XSLStyleSheet xSLStyleSheet, int n) throws TransformerConfigurationException {
        if (this.href == null) {
            return null;
        }
        this.checkEmpty();
        this.checkTopLevel();
        try {
            XSLStyleSheet xSLStyleSheet2 = (XSLStyleSheet)this.getParentNode();
            PreparedStyleSheet preparedStyleSheet = this.getPreparedStyleSheet();
            Configuration configuration = preparedStyleSheet.getConfiguration();
            Source source = configuration.getURIResolver().resolve(this.href, this.getBaseURI());
            if (source == null) {
                source = new StandardURIResolver(configuration).resolve(this.href, this.getBaseURI());
            }
            if (source instanceof NodeInfo) {
                if (source instanceof Node) {
                    source = new DOMSource((Node)((Object)source));
                } else {
                    throw new TransformerException("URIResolver must not return a " + source.getClass());
                }
            }
            XSLStyleSheet xSLStyleSheet3 = xSLStyleSheet2;
            if (source.getSystemId() != null) {
                while (xSLStyleSheet3 != null) {
                    if (source.getSystemId().equals(xSLStyleSheet3.getSystemId())) {
                        this.compileError("A stylesheet cannot " + this.getLocalPart() + " itself");
                        return null;
                    }
                    xSLStyleSheet3 = xSLStyleSheet3.getImporter();
                }
            }
            StyleNodeFactory styleNodeFactory = new StyleNodeFactory(this.getNamePool(), configuration.isAllowExternalFunctions());
            this.includedDoc = PreparedStyleSheet.loadStylesheetModule(source, configuration, this.getNamePool(), styleNodeFactory);
            ElementImpl elementImpl = (ElementImpl)this.includedDoc.getDocumentElement();
            if (elementImpl instanceof LiteralResultElement) {
                this.includedDoc = ((LiteralResultElement)elementImpl).makeStyleSheet(this.getPreparedStyleSheet(), styleNodeFactory);
                elementImpl = (ElementImpl)this.includedDoc.getDocumentElement();
            }
            if (!(elementImpl instanceof XSLStyleSheet)) {
                this.compileError("Included document " + this.href + " is not a stylesheet");
                return null;
            }
            XSLStyleSheet xSLStyleSheet4 = (XSLStyleSheet)elementImpl;
            xSLStyleSheet4.setPrecedence(n);
            xSLStyleSheet4.setImporter(xSLStyleSheet);
            xSLStyleSheet4.spliceIncludes();
            return xSLStyleSheet4;
        }
        catch (TransformerException transformerException) {
            this.compileError(transformerException);
            return null;
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        return null;
    }
}

