; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X64

; Verify that we don't fail when shift by zero is encountered.

define i64 @test1(<2 x i64> %a) {
; X32-LABEL: test1:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movdqa %xmm0, %xmm1
; X32-NEXT:    psllq $2, %xmm1
; X32-NEXT:    movsd {{.*#+}} xmm1 = xmm0[0],xmm1[1]
; X32-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; X32-NEXT:    movd %xmm1, %edx
; X32-NEXT:    movd %xmm0, %eax
; X32-NEXT:    retl
;
; X64-LABEL: test1:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movq %xmm0, %rax
; X64-NEXT:    retq
entry:
 %c = shl <2 x i64> %a, <i64 0, i64 2>
 %d = extractelement <2 x i64> %c, i32 0
 ret i64 %d
}
