/* window.c generated by valac 0.48.6, the Vala compiler
 * generated from window.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  TODO:
 *  - Follow GNOME bug #551184 to change accelerators hexa values
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>

#define XNP_TYPE_WINDOW (xnp_window_get_type ())
#define XNP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_WINDOW, XnpWindow))
#define XNP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_WINDOW, XnpWindowClass))
#define XNP_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_WINDOW))
#define XNP_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_WINDOW))
#define XNP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_WINDOW, XnpWindowClass))

typedef struct _XnpWindow XnpWindow;
typedef struct _XnpWindowClass XnpWindowClass;
typedef struct _XnpWindowPrivate XnpWindowPrivate;

#define XNP_TYPE_ICON_BUTTON (xnp_icon_button_get_type ())
#define XNP_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_ICON_BUTTON, XnpIconButton))
#define XNP_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_ICON_BUTTON, XnpIconButtonClass))
#define XNP_IS_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_ICON_BUTTON))
#define XNP_IS_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_ICON_BUTTON))
#define XNP_ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_ICON_BUTTON, XnpIconButtonClass))

typedef struct _XnpIconButton XnpIconButton;
typedef struct _XnpIconButtonClass XnpIconButtonClass;

#define XNP_TYPE_TITLE_BAR_BUTTON (xnp_title_bar_button_get_type ())
#define XNP_TITLE_BAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButton))
#define XNP_TITLE_BAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonClass))
#define XNP_IS_TITLE_BAR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_TITLE_BAR_BUTTON))
#define XNP_IS_TITLE_BAR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_TITLE_BAR_BUTTON))
#define XNP_TITLE_BAR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_TITLE_BAR_BUTTON, XnpTitleBarButtonClass))

typedef struct _XnpTitleBarButton XnpTitleBarButton;
typedef struct _XnpTitleBarButtonClass XnpTitleBarButtonClass;
enum  {
	XNP_WINDOW_0_PROPERTY,
	XNP_WINDOW_NAME_PROPERTY,
	XNP_WINDOW_N_PAGES_PROPERTY,
	XNP_WINDOW_SHOW_TABS_PROPERTY,
	XNP_WINDOW_TABS_POSITION_PROPERTY,
	XNP_WINDOW_ABOVE_PROPERTY,
	XNP_WINDOW_STICKY_PROPERTY,
	XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY,
	XNP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* xnp_window_properties[XNP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	XNP_TITLE_BAR_BUTTON_TYPE_EMPTY,
	XNP_TITLE_BAR_BUTTON_TYPE_CLOSE,
	XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW,
	XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW,
	XNP_TITLE_BAR_BUTTON_TYPE_REFRESH
} XnpTitleBarButtonType;

#define XNP_TYPE_TITLE_BAR_BUTTON_TYPE (xnp_title_bar_button_type_get_type ())

#define XNP_TYPE_NOTE (xnp_note_get_type ())
#define XNP_NOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_NOTE, XnpNote))
#define XNP_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_NOTE, XnpNoteClass))
#define XNP_IS_NOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_NOTE))
#define XNP_IS_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_NOTE))
#define XNP_NOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_NOTE, XnpNoteClass))

typedef struct _XnpNote XnpNote;
typedef struct _XnpNoteClass XnpNoteClass;
typedef struct _XnpNotePrivate XnpNotePrivate;

#define XNP_TYPE_HYPERTEXT_VIEW (xnp_hypertext_view_get_type ())
#define XNP_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView))
#define XNP_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))
#define XNP_IS_HYPERTEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_IS_HYPERTEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XNP_TYPE_HYPERTEXT_VIEW))
#define XNP_HYPERTEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextViewClass))

typedef struct _XnpHypertextView XnpHypertextView;
typedef struct _XnpHypertextViewClass XnpHypertextViewClass;
enum  {
	XNP_WINDOW_ACTION_SIGNAL,
	XNP_WINDOW_SAVE_DATA_SIGNAL,
	XNP_WINDOW_NOTE_INSERTED_SIGNAL,
	XNP_WINDOW_NOTE_DELETED_SIGNAL,
	XNP_WINDOW_NOTE_RENAMED_SIGNAL,
	XNP_WINDOW_NUM_SIGNALS
};
static guint xnp_window_signals[XNP_WINDOW_NUM_SIGNALS] = {0};

struct _XnpWindow {
	GtkWindow parent_instance;
	XnpWindowPrivate * priv;
};

struct _XnpWindowClass {
	GtkWindowClass parent_class;
};

struct _XnpWindowPrivate {
	gint width;
	gint height;
	GtkMenu* menu;
	GtkCheckMenuItem* mi_above;
	GtkCheckMenuItem* mi_sticky;
	GtkImage* menu_image;
	GdkPixbuf* menu_pixbuf;
	GdkPixbuf* menu_hover_pixbuf;
	GtkLabel* title_label;
	XnpTitleBarButton* refresh_button;
	XnpTitleBarButton* left_arrow_button;
	XnpTitleBarButton* right_arrow_button;
	XnpTitleBarButton* close_button;
	GtkBox* content_box;
	GtkNotebook* notebook;
	GtkUIManager* ui;
	GtkActionGroup* action_group;
	gint CORNER_MARGIN;
	GdkCursor* CURSOR_RIGHT;
	GdkCursor* CURSOR_LEFT;
	GdkCursor* CURSOR_BOTTOM_RC;
	GdkCursor* CURSOR_BOTTOM;
	GdkCursor* CURSOR_BOTTOM_LC;
	GSList* window_list;
	gchar* _name;
	gint _n_pages;
	gint _tabs_position;
	gboolean _above;
	gboolean _sticky;
	gboolean _show_refresh_button;
};

struct _XnpNote {
	GtkScrolledWindow parent_instance;
	XnpNotePrivate * priv;
	XnpHypertextView* text_view;
};

struct _XnpNoteClass {
	GtkScrolledWindowClass parent_class;
};

static gint XnpWindow_private_offset;
static gpointer xnp_window_parent_class = NULL;

GType xnp_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (XnpWindow, g_object_unref)
GType xnp_icon_button_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (XnpIconButton, g_object_unref)
GType xnp_title_bar_button_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (XnpTitleBarButton, g_object_unref)
#define XNP_WINDOW_ui_string "\n" \
"<ui>\n" \
"  <accelerator action=\"close-window\" />\n" \
"  <accelerator action=\"new-window\" />\n" \
"  <accelerator action=\"delete-window\" />\n" \
"  <accelerator action=\"rename-window\" />\n" \
"  <accelerator action=\"new-note\" />\n" \
"  <accelerator action=\"delete-note\" />\n" \
"  <accelerator action=\"rename-note\" />\n" \
"  <accelerator action=\"cancel\" />\n" \
"  <accelerator action=\"next-note\" />\n" \
"  <accelerator action=\"prev-note\" />\n" \
"</ui>\n"
void xnp_window_hide (XnpWindow* self);
static void _xnp_window_hide_gtk_action_callback (GtkAction* action,
                                           gpointer self);
static void xnp_window_action_new_window (XnpWindow* self);
static void _xnp_window_action_new_window_gtk_action_callback (GtkAction* action,
                                                        gpointer self);
static void xnp_window_action_delete_window (XnpWindow* self);
static void _xnp_window_action_delete_window_gtk_action_callback (GtkAction* action,
                                                           gpointer self);
static void xnp_window_action_rename_window (XnpWindow* self);
static void _xnp_window_action_rename_window_gtk_action_callback (GtkAction* action,
                                                           gpointer self);
static void xnp_window_action_new_note (XnpWindow* self);
static void _xnp_window_action_new_note_gtk_action_callback (GtkAction* action,
                                                      gpointer self);
static void xnp_window_action_delete_note (XnpWindow* self);
static void _xnp_window_action_delete_note_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
static void xnp_window_action_rename_note (XnpWindow* self);
static void _xnp_window_action_rename_note_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
static void xnp_window_action_cancel (XnpWindow* self);
static void _xnp_window_action_cancel_gtk_action_callback (GtkAction* action,
                                                    gpointer self);
static void xnp_window_action_next_note (XnpWindow* self);
static void _xnp_window_action_next_note_gtk_action_callback (GtkAction* action,
                                                       gpointer self);
static void xnp_window_action_prev_note (XnpWindow* self);
static void _xnp_window_action_prev_note_gtk_action_callback (GtkAction* action,
                                                       gpointer self);
XnpWindow* xnp_window_new (void);
XnpWindow* xnp_window_construct (GType object_type);
static GtkMenu* xnp_window_build_menu (XnpWindow* self);
static gboolean __lambda12_ (XnpWindow* self);
static gboolean ___lambda12__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda13_ (XnpWindow* self);
static gboolean ___lambda13__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
GType xnp_title_bar_button_type_get_type (void) G_GNUC_CONST;
XnpTitleBarButton* xnp_title_bar_button_new (XnpTitleBarButtonType icon_type);
XnpTitleBarButton* xnp_title_bar_button_construct (GType object_type,
                                                   XnpTitleBarButtonType icon_type);
static gboolean xnp_window_menu_evbox_pressed_cb (XnpWindow* self,
                                           GtkWidget* widget,
                                           GdkEventButton* event);
static gboolean _xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                          GdkEventButton* event,
                                                                          gpointer self);
static void xnp_window_action_refresh_notes (XnpWindow* self);
static void _xnp_window_action_refresh_notes_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                               gpointer self);
static void _xnp_window_action_prev_note_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                           gpointer self);
static void _xnp_window_action_next_note_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                           gpointer self);
static void __lambda14_ (XnpWindow* self);
static void ___lambda14__xnp_icon_button_clicked (XnpIconButton* _sender,
                                           gpointer self);
static gboolean __lambda15_ (XnpWindow* self);
static gboolean ___lambda15__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
static gboolean __lambda16_ (XnpWindow* self);
static void xnp_window_update_navigation_sensitivity (XnpWindow* self,
                                               gint page_num);
static gboolean ___lambda16__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                 GdkEventFocus* event,
                                                 gpointer self);
static gboolean __lambda17_ (XnpWindow* self);
static gboolean ___lambda17__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
static gboolean xnp_window_window_leaved_cb (XnpWindow* self);
static gboolean _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                     GdkEventCrossing* event,
                                                                     gpointer self);
static gboolean xnp_window_window_motion_cb (XnpWindow* self,
                                      GdkEventMotion* event);
static gboolean _xnp_window_window_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                      GdkEventMotion* event,
                                                                      gpointer self);
static gboolean xnp_window_window_pressed_cb (XnpWindow* self,
                                       GdkEventButton* event);
static gboolean _xnp_window_window_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                      GdkEventButton* event,
                                                                      gpointer self);
static gboolean xnp_window_window_state_cb (XnpWindow* self,
                                     GdkEventWindowState* event);
static gboolean _xnp_window_window_state_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                    GdkEventWindowState* event,
                                                                    gpointer self);
static gboolean xnp_window_title_evbox_pressed_cb (XnpWindow* self,
                                            GtkWidget* widget,
                                            GdkEventButton* event);
static gboolean _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                           GdkEventButton* event,
                                                                           gpointer self);
static gboolean xnp_window_title_evbox_scrolled_cb (XnpWindow* self,
                                             GtkWidget* widget,
                                             GdkEventScroll* event);
static gboolean _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                      GdkEventScroll* event,
                                                                      gpointer self);
static void __lambda18_ (XnpWindow* self,
                  GtkNotebook* n,
                  GtkWidget* c,
                  guint p);
static void ___lambda18__gtk_notebook_page_added (GtkNotebook* _sender,
                                           GtkWidget* child,
                                           guint page_num,
                                           gpointer self);
static void __lambda19_ (XnpWindow* self,
                  GtkNotebook* n,
                  GtkWidget* c,
                  guint p);
static void ___lambda19__gtk_notebook_page_removed (GtkNotebook* _sender,
                                             GtkWidget* child,
                                             guint page_num,
                                             gpointer self);
static void __lambda20_ (XnpWindow* self,
                  GtkNotebook* n,
                  GtkWidget* c,
                  guint p);
GType xnp_note_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (XnpNote, g_object_unref)
static void xnp_window_update_title (XnpWindow* self,
                              const gchar* note_name);
const gchar* xnp_note_get_name (XnpNote* self);
static void ___lambda20__gtk_notebook_switch_page (GtkNotebook* _sender,
                                            GtkWidget* page,
                                            guint page_num,
                                            gpointer self);
static void __lambda21_ (XnpWindow* self);
static void ___lambda21__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda22_ (XnpWindow* self);
static void ___lambda22__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void xnp_window_unshade (XnpWindow* self);
gboolean xnp_window_get_above (XnpWindow* self);
void xnp_window_set_sticky (XnpWindow* self,
                            gboolean value);
static void xnp_window_shade (XnpWindow* self);
static void xnp_window_note_notify_name_cb (XnpWindow* self,
                                     GObject* object,
                                     GParamSpec* pspec);
static void _xnp_window_notebook_update_tabs_angle (XnpWindow* self);
XnpNote* xnp_window_insert_note (XnpWindow* self);
void xnp_window_delete_current_note (XnpWindow* self);
void xnp_window_rename_current_note (XnpWindow* self);
GType xnp_hypertext_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (XnpHypertextView, g_object_unref)
void xnp_hypertext_view_undo (XnpHypertextView* self);
static void xnp_window_menu_position (XnpWindow* self,
                               GtkMenu* menu,
                               gint* x,
                               gint* y,
                               gboolean* push_in);
static void _xnp_window_menu_position_gtk_menu_position_func (GtkMenu* menu,
                                                       gint* x,
                                                       gint* y,
                                                       gboolean* push_in,
                                                       gpointer self);
static void xnp_window_update_menu_go (XnpWindow* self,
                                GtkWidget* widget);
static void _xnp_window_update_menu_go_gtk_widget_show (GtkWidget* _sender,
                                                 gpointer self);
static void _xnp_window_action_new_note_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                         gpointer self);
static void _xnp_window_action_delete_note_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                            gpointer self);
static void _xnp_window_action_rename_note_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                            gpointer self);
static void _xnp_window_action_cancel_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                       gpointer self);
static void __lambda8_ (XnpWindow* self,
                 GtkCheckMenuItem* o);
void xnp_window_set_above (XnpWindow* self,
                           gboolean value);
static void ___lambda8__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                              gpointer self);
gboolean xnp_window_get_sticky (XnpWindow* self);
static void __lambda9_ (XnpWindow* self,
                 GtkCheckMenuItem* o);
static void ___lambda9__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                              gpointer self);
static void __lambda10_ (XnpWindow* self);
static void ___lambda10__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda11_ (XnpWindow* self);
static void ___lambda11__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda5_ (XnpWindow* self,
                 GtkWidget* w);
static void ___lambda5__gtk_callback (GtkWidget* widget,
                               gpointer self);
const gchar* xnp_window_get_name (XnpWindow* self);
static void ________lambda6_ (XnpWindow* self,
                       GtkMenuItem* i);
static void _________lambda6__gtk_menu_item_activate (GtkMenuItem* _sender,
                                               gpointer self);
static void _____lambda7_ (XnpWindow* self,
                    GtkMenuItem* i);
static void ______lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void _xnp_window_action_rename_window_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                              gpointer self);
static void _xnp_window_action_delete_window_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                              gpointer self);
static void _xnp_window_action_new_window_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                           gpointer self);
void xnp_window_get_geometry (XnpWindow* self,
                              gint* winx,
                              gint* winy,
                              gint* width,
                              gint* height);
void xnp_window_set_window_list (XnpWindow* self,
                                 GSList* list);
gint xnp_window_compare_func (XnpWindow* self,
                              XnpWindow* win2);
gint xnp_window_get_current_page (XnpWindow* self);
void xnp_window_set_current_page (XnpWindow* self,
                                  gint page);
static gboolean xnp_window_note_name_exists (XnpWindow* self,
                                      const gchar* name);
XnpNote* xnp_note_new (const gchar* name);
XnpNote* xnp_note_construct (GType object_type,
                             const gchar* name);
static void _xnp_window_note_notify_name_cb_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void __lambda4_ (XnpWindow* self,
                 XnpNote* note);
static void ___lambda4__xnp_note_save_data (XnpNote* _sender,
                                     gpointer self);
gint xnp_window_get_n_pages (XnpWindow* self);
void xnp_window_set_n_pages (XnpWindow* self,
                             gint value);
void xnp_note_set_name (XnpNote* self,
                        const gchar* value);
void xnp_window_move_note (XnpWindow* self,
                           const gchar* note_name,
                           gint page);
gchar** xnp_window_get_note_names (XnpWindow* self,
                                   gint* result_length1);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
void xnp_window_delete_note (XnpWindow* self,
                             gint page);
void xnp_window_set_font (XnpWindow* self);
const gchar* xnp_hypertext_view_get_font (XnpHypertextView* self);
void xnp_hypertext_view_set_font (XnpHypertextView* self,
                                  const gchar* value);
void xnp_window_save_notes (XnpWindow* self);
gboolean xnp_note_get_dirty (XnpNote* self);
void xnp_note_set_dirty (XnpNote* self,
                         gboolean value);
void xnp_window_set_name (XnpWindow* self,
                          const gchar* value);
gboolean xnp_window_get_show_tabs (XnpWindow* self);
void xnp_window_set_show_tabs (XnpWindow* self,
                               gboolean value);
gint xnp_window_get_tabs_position (XnpWindow* self);
void xnp_window_set_tabs_position (XnpWindow* self,
                                   gint value);
gboolean xnp_window_get_show_refresh_button (XnpWindow* self);
void xnp_window_set_show_refresh_button (XnpWindow* self,
                                         gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * xnp_window_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void xnp_window_finalize (GObject * obj);
static GType xnp_window_get_type_once (void);
static void _vala_xnp_window_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_xnp_window_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GtkActionEntry XNP_WINDOW_action_entries[10] = {{"close-window", NULL, NULL, "Escape", NULL, (GCallback) _xnp_window_hide_gtk_action_callback}, {"new-window", NULL, NULL, "<Ctrl><Shift>n", NULL, (GCallback) _xnp_window_action_new_window_gtk_action_callback}, {"delete-window", NULL, NULL, "<Ctrl><Shift>w", NULL, (GCallback) _xnp_window_action_delete_window_gtk_action_callback}, {"rename-window", NULL, NULL, "<Shift>F2", NULL, (GCallback) _xnp_window_action_rename_window_gtk_action_callback}, {"new-note", NULL, NULL, "<Ctrl>n", NULL, (GCallback) _xnp_window_action_new_note_gtk_action_callback}, {"delete-note", NULL, NULL, "<Ctrl>w", NULL, (GCallback) _xnp_window_action_delete_note_gtk_action_callback}, {"rename-note", NULL, NULL, "F2", NULL, (GCallback) _xnp_window_action_rename_note_gtk_action_callback}, {"cancel", NULL, NULL, "<Ctrl>z", NULL, (GCallback) _xnp_window_action_cancel_gtk_action_callback}, {"next-note", NULL, NULL, "<Ctrl>Page_Down", NULL, (GCallback) _xnp_window_action_next_note_gtk_action_callback}, {"prev-note", NULL, NULL, "<Ctrl>Page_Up", NULL, (GCallback) _xnp_window_action_prev_note_gtk_action_callback}};

static inline gpointer
xnp_window_get_instance_private (XnpWindow* self)
{
	return G_STRUCT_MEMBER_P (self, XnpWindow_private_offset);
}

static void
_xnp_window_hide_gtk_action_callback (GtkAction* action,
                                      gpointer self)
{
	xnp_window_hide ((XnpWindow*) self);
}

static void
_xnp_window_action_new_window_gtk_action_callback (GtkAction* action,
                                                   gpointer self)
{
	xnp_window_action_new_window ((XnpWindow*) self);
}

static void
_xnp_window_action_delete_window_gtk_action_callback (GtkAction* action,
                                                      gpointer self)
{
	xnp_window_action_delete_window ((XnpWindow*) self);
}

static void
_xnp_window_action_rename_window_gtk_action_callback (GtkAction* action,
                                                      gpointer self)
{
	xnp_window_action_rename_window ((XnpWindow*) self);
}

static void
_xnp_window_action_new_note_gtk_action_callback (GtkAction* action,
                                                 gpointer self)
{
	xnp_window_action_new_note ((XnpWindow*) self);
}

static void
_xnp_window_action_delete_note_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
	xnp_window_action_delete_note ((XnpWindow*) self);
}

static void
_xnp_window_action_rename_note_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
	xnp_window_action_rename_note ((XnpWindow*) self);
}

static void
_xnp_window_action_cancel_gtk_action_callback (GtkAction* action,
                                               gpointer self)
{
	xnp_window_action_cancel ((XnpWindow*) self);
}

static void
_xnp_window_action_next_note_gtk_action_callback (GtkAction* action,
                                                  gpointer self)
{
	xnp_window_action_next_note ((XnpWindow*) self);
}

static void
_xnp_window_action_prev_note_gtk_action_callback (GtkAction* action,
                                                  gpointer self)
{
	xnp_window_action_prev_note ((XnpWindow*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda12_ (XnpWindow* self)
{
	GtkImage* _tmp0_;
	GdkPixbuf* _tmp1_;
	gboolean result = FALSE;
	_tmp0_ = self->priv->menu_image;
	_tmp1_ = self->priv->menu_hover_pixbuf;
	gtk_image_set_from_pixbuf (_tmp0_, _tmp1_);
	result = FALSE;
	return result;
}

static gboolean
___lambda12__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda12_ ((XnpWindow*) self);
	return result;
}

static gboolean
__lambda13_ (XnpWindow* self)
{
	GtkImage* _tmp0_;
	GdkPixbuf* _tmp1_;
	gboolean result = FALSE;
	_tmp0_ = self->priv->menu_image;
	_tmp1_ = self->priv->menu_pixbuf;
	gtk_image_set_from_pixbuf (_tmp0_, _tmp1_);
	result = FALSE;
	return result;
}

static gboolean
___lambda13__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda13_ ((XnpWindow*) self);
	return result;
}

static gboolean
_xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                 GdkEventButton* event,
                                                                 gpointer self)
{
	gboolean result;
	result = xnp_window_menu_evbox_pressed_cb ((XnpWindow*) self, _sender, event);
	return result;
}

static void
_xnp_window_action_refresh_notes_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                          gpointer self)
{
	xnp_window_action_refresh_notes ((XnpWindow*) self);
}

static void
_xnp_window_action_prev_note_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                      gpointer self)
{
	xnp_window_action_prev_note ((XnpWindow*) self);
}

static void
_xnp_window_action_next_note_xnp_icon_button_clicked (XnpIconButton* _sender,
                                                      gpointer self)
{
	xnp_window_action_next_note ((XnpWindow*) self);
}

static void
__lambda14_ (XnpWindow* self)
{
	xnp_window_hide (self);
}

static void
___lambda14__xnp_icon_button_clicked (XnpIconButton* _sender,
                                      gpointer self)
{
	__lambda14_ ((XnpWindow*) self);
}

static gboolean
__lambda15_ (XnpWindow* self)
{
	gboolean result = FALSE;
	xnp_window_hide (self);
	result = TRUE;
	return result;
}

static gboolean
___lambda15__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda15_ ((XnpWindow*) self);
	return result;
}

static gboolean
__lambda16_ (XnpWindow* self)
{
	GtkImage* _tmp0_;
	GtkLabel* _tmp1_;
	XnpTitleBarButton* _tmp2_;
	GtkNotebook* _tmp3_;
	XnpTitleBarButton* _tmp4_;
	gboolean result = FALSE;
	_tmp0_ = self->priv->menu_image;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->title_label;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->refresh_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->notebook;
	xnp_window_update_navigation_sensitivity (self, gtk_notebook_get_current_page (_tmp3_));
	_tmp4_ = self->priv->close_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
	result = FALSE;
	return result;
}

static gboolean
___lambda16__gtk_widget_focus_in_event (GtkWidget* _sender,
                                        GdkEventFocus* event,
                                        gpointer self)
{
	gboolean result;
	result = __lambda16_ ((XnpWindow*) self);
	return result;
}

static gboolean
__lambda17_ (XnpWindow* self)
{
	GtkImage* _tmp0_;
	GtkLabel* _tmp1_;
	XnpTitleBarButton* _tmp2_;
	XnpTitleBarButton* _tmp3_;
	XnpTitleBarButton* _tmp4_;
	XnpTitleBarButton* _tmp5_;
	gboolean result = FALSE;
	_tmp0_ = self->priv->menu_image;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->title_label;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->refresh_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = self->priv->left_arrow_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->right_arrow_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
	_tmp5_ = self->priv->close_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	result = FALSE;
	return result;
}

static gboolean
___lambda17__gtk_widget_focus_out_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda17_ ((XnpWindow*) self);
	return result;
}

static gboolean
_xnp_window_window_leaved_cb_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                            GdkEventCrossing* event,
                                                            gpointer self)
{
	gboolean result;
	result = xnp_window_window_leaved_cb ((XnpWindow*) self);
	return result;
}

static gboolean
_xnp_window_window_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                             GdkEventMotion* event,
                                                             gpointer self)
{
	gboolean result;
	result = xnp_window_window_motion_cb ((XnpWindow*) self, event);
	return result;
}

static gboolean
_xnp_window_window_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                             GdkEventButton* event,
                                                             gpointer self)
{
	gboolean result;
	result = xnp_window_window_pressed_cb ((XnpWindow*) self, event);
	return result;
}

static gboolean
_xnp_window_window_state_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                           GdkEventWindowState* event,
                                                           gpointer self)
{
	gboolean result;
	result = xnp_window_window_state_cb ((XnpWindow*) self, event);
	return result;
}

static gboolean
_xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                  GdkEventButton* event,
                                                                  gpointer self)
{
	gboolean result;
	result = xnp_window_title_evbox_pressed_cb ((XnpWindow*) self, _sender, event);
	return result;
}

static gboolean
_xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event (GtkWidget* _sender,
                                                             GdkEventScroll* event,
                                                             gpointer self)
{
	gboolean result;
	result = xnp_window_title_evbox_scrolled_cb ((XnpWindow*) self, _sender, event);
	return result;
}

static void
__lambda18_ (XnpWindow* self,
             GtkNotebook* n,
             GtkWidget* c,
             guint p)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp0_, (gint) p);
	xnp_window_update_navigation_sensitivity (self, (gint) p);
}

static void
___lambda18__gtk_notebook_page_added (GtkNotebook* _sender,
                                      GtkWidget* child,
                                      guint page_num,
                                      gpointer self)
{
	__lambda18_ ((XnpWindow*) self, _sender, child, page_num);
}

static void
__lambda19_ (XnpWindow* self,
             GtkNotebook* n,
             GtkWidget* c,
             guint p)
{
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	xnp_window_update_navigation_sensitivity (self, (gint) p);
}

static void
___lambda19__gtk_notebook_page_removed (GtkNotebook* _sender,
                                        GtkWidget* child,
                                        guint page_num,
                                        gpointer self)
{
	__lambda19_ ((XnpWindow*) self, _sender, child, page_num);
}

static void
__lambda20_ (XnpWindow* self,
             GtkNotebook* n,
             GtkWidget* c,
             guint p)
{
	XnpNote* note = NULL;
	GtkNotebook* _tmp0_;
	GtkWidget* _tmp1_;
	XnpNote* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_nth_page (_tmp0_, (gint) p);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, XNP_TYPE_NOTE, XnpNote));
	note = _tmp2_;
	_tmp3_ = xnp_note_get_name (note);
	_tmp4_ = _tmp3_;
	xnp_window_update_title (self, _tmp4_);
	xnp_window_update_navigation_sensitivity (self, (gint) p);
	_g_object_unref0 (note);
}

static void
___lambda20__gtk_notebook_switch_page (GtkNotebook* _sender,
                                       GtkWidget* page,
                                       guint page_num,
                                       gpointer self)
{
	__lambda20_ ((XnpWindow*) self, _sender, page, page_num);
}

static void
__lambda21_ (XnpWindow* self)
{
	gint page = 0;
	GtkNotebook* _tmp0_;
	XnpNote* current_note = NULL;
	GtkNotebook* _tmp1_;
	GtkWidget* _tmp2_;
	XnpNote* _tmp3_;
	XnpNote* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	_tmp0_ = self->priv->notebook;
	page = gtk_notebook_get_current_page (_tmp0_);
	if (page == -1) {
		return;
	}
	_tmp1_ = self->priv->notebook;
	_tmp2_ = gtk_notebook_get_nth_page (_tmp1_, page);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, XNP_TYPE_NOTE, XnpNote));
	current_note = _tmp3_;
	_tmp4_ = current_note;
	_tmp5_ = xnp_note_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	xnp_window_update_title (self, _tmp6_);
	_g_object_unref0 (current_note);
}

static void
___lambda21__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda21_ ((XnpWindow*) self);
}

static void
__lambda22_ (XnpWindow* self)
{
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	_tmp0_ = self->priv->title_label;
	_tmp1_ = gtk_window_get_title ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("<b>", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "</b>", NULL);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (_tmp0_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
}

static void
___lambda22__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda22_ ((XnpWindow*) self);
}

XnpWindow*
xnp_window_construct (GType object_type)
{
	XnpWindow * self = NULL;
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkUIManager* _tmp2_;
	GtkUIManager* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkMenu* _tmp10_;
	GtkMenu* _tmp11_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp12_;
	GtkFrame* _tmp13_;
	GtkRcStyle* style = NULL;
	GtkFrame* _tmp14_;
	GtkRcStyle* _tmp15_;
	GtkRcStyle* _tmp16_;
	GtkRcStyle* _tmp17_;
	GtkRcStyle* _tmp18_;
	GtkFrame* _tmp19_;
	GtkRcStyle* _tmp20_;
	GtkFrame* _tmp21_;
	GtkFrame* _tmp22_;
	GtkBox* vbox_frame = NULL;
	GtkBox* _tmp23_;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	GtkFrame* _tmp26_;
	GtkBox* _tmp27_;
	GtkBox* title_box = NULL;
	GtkBox* _tmp28_;
	GtkEventBox* menu_evbox = NULL;
	GtkEventBox* _tmp29_;
	GtkEventBox* _tmp30_;
	GtkEventBox* _tmp31_;
	GdkPixbuf* _tmp46_;
	GtkImage* _tmp47_;
	GtkEventBox* _tmp48_;
	GtkImage* _tmp49_;
	GtkEventBox* _tmp50_;
	GtkEventBox* _tmp51_;
	GtkBox* _tmp52_;
	GtkEventBox* _tmp53_;
	GtkEventBox* title_evbox = NULL;
	GtkEventBox* _tmp54_;
	GtkLabel* _tmp55_;
	GtkLabel* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GtkLabel* _tmp63_;
	GtkLabel* _tmp64_;
	GtkLabel* _tmp65_;
	GtkBox* _tmp66_;
	XnpTitleBarButton* _tmp67_;
	XnpTitleBarButton* _tmp68_;
	XnpTitleBarButton* _tmp69_;
	XnpTitleBarButton* _tmp70_;
	GtkBox* _tmp71_;
	XnpTitleBarButton* _tmp72_;
	XnpTitleBarButton* _tmp73_;
	XnpTitleBarButton* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	XnpTitleBarButton* _tmp77_;
	GtkBox* _tmp78_;
	XnpTitleBarButton* _tmp79_;
	XnpTitleBarButton* _tmp80_;
	XnpTitleBarButton* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	XnpTitleBarButton* _tmp84_;
	GtkBox* _tmp85_;
	XnpTitleBarButton* _tmp86_;
	XnpTitleBarButton* _tmp87_;
	XnpTitleBarButton* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	GtkBox* _tmp93_;
	XnpTitleBarButton* _tmp94_;
	GtkBox* _tmp95_;
	GtkBox* _tmp96_;
	GtkBox* _tmp97_;
	GtkBox* _tmp98_;
	GtkBox* _tmp99_;
	GtkBox* _tmp100_;
	GtkBox* _tmp101_;
	GtkNotebook* _tmp102_;
	GtkNotebook* _tmp103_;
	GtkNotebook* _tmp104_;
	GtkNotebook* _tmp105_;
	GtkNotebook* _tmp106_;
	GtkNotebook* _tmp107_;
	GtkNotebook* _tmp108_;
	GtkBox* _tmp109_;
	GtkNotebook* _tmp110_;
	GtkEventBox* _tmp111_;
	XnpTitleBarButton* _tmp112_;
	XnpTitleBarButton* _tmp113_;
	XnpTitleBarButton* _tmp114_;
	XnpTitleBarButton* _tmp115_;
	GtkNotebook* _tmp116_;
	GtkNotebook* _tmp117_;
	GtkNotebook* _tmp118_;
	GError* _inner_error0_ = NULL;
	self = (XnpWindow*) g_object_new (object_type, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) ((GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK) | GDK_BUTTON_PRESS_MASK));
	_tmp0_ = gtk_action_group_new ("XNP");
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp0_;
	_tmp1_ = self->priv->action_group;
	gtk_action_group_add_actions (_tmp1_, XNP_WINDOW_action_entries, (guint) G_N_ELEMENTS (XNP_WINDOW_action_entries), self);
	_tmp2_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->ui);
	self->priv->ui = _tmp2_;
	_tmp3_ = self->priv->ui;
	_tmp4_ = self->priv->action_group;
	gtk_ui_manager_insert_action_group (_tmp3_, _tmp4_, 0);
	{
		GtkUIManager* _tmp5_;
		GtkUIManager* _tmp6_;
		GtkAccelGroup* _tmp7_;
		_tmp5_ = self->priv->ui;
		gtk_ui_manager_add_ui_from_string (_tmp5_, XNP_WINDOW_ui_string, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = self->priv->ui;
		_tmp7_ = gtk_ui_manager_get_accel_group (_tmp6_);
		gtk_window_add_accel_group ((GtkWindow*) self, _tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("window.vala:202: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = xnp_window_build_menu (self);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp10_;
	_tmp11_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp11_);
	_tmp12_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp12_);
	frame = _tmp12_;
	_tmp13_ = frame;
	gtk_frame_set_shadow_type (_tmp13_, GTK_SHADOW_NONE);
	_tmp14_ = frame;
	_tmp15_ = gtk_widget_get_modifier_style ((GtkWidget*) _tmp14_);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	style = _tmp16_;
	_tmp17_ = style;
	_tmp17_->xthickness = 1;
	_tmp18_ = style;
	_tmp18_->ythickness = 3;
	_tmp19_ = frame;
	_tmp20_ = style;
	gtk_widget_modify_style ((GtkWidget*) _tmp19_, _tmp20_);
	_tmp21_ = frame;
	gtk_widget_show ((GtkWidget*) _tmp21_);
	_tmp22_ = frame;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp22_);
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp23_);
	vbox_frame = _tmp23_;
	_tmp24_ = vbox_frame;
	gtk_box_set_spacing (_tmp24_, 1);
	_tmp25_ = vbox_frame;
	gtk_widget_show ((GtkWidget*) _tmp25_);
	_tmp26_ = frame;
	_tmp27_ = vbox_frame;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp28_);
	title_box = _tmp28_;
	_tmp29_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp29_);
	menu_evbox = _tmp29_;
	_tmp30_ = menu_evbox;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp30_, _ ("Menu"));
	_tmp31_ = menu_evbox;
	gtk_event_box_set_visible_window (_tmp31_, FALSE);
	{
		GdkPixbuf* _tmp32_ = NULL;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GdkPixbuf* _tmp35_;
		GdkPixbuf* _tmp36_;
		GdkPixbuf* _tmp37_;
		GdkPixbuf* _tmp38_ = NULL;
		gchar* _tmp39_;
		gchar* _tmp40_;
		GdkPixbuf* _tmp41_;
		GdkPixbuf* _tmp42_;
		GdkPixbuf* _tmp43_;
		_tmp33_ = g_strdup_printf ("%s/pixmaps/notes-menu.png", PKGDATADIR);
		_tmp34_ = _tmp33_;
		_tmp35_ = gdk_pixbuf_new_from_file (_tmp34_, &_inner_error0_);
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp34_);
		_tmp32_ = _tmp36_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp37_ = _tmp32_;
		_tmp32_ = NULL;
		_g_object_unref0 (self->priv->menu_pixbuf);
		self->priv->menu_pixbuf = _tmp37_;
		_tmp39_ = g_strdup_printf ("%s/pixmaps/notes-menu-active.png", PKGDATADIR);
		_tmp40_ = _tmp39_;
		_tmp41_ = gdk_pixbuf_new_from_file (_tmp40_, &_inner_error0_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp40_);
		_tmp38_ = _tmp42_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp32_);
			goto __catch1_g_error;
		}
		_tmp43_ = _tmp38_;
		_tmp38_ = NULL;
		_g_object_unref0 (self->priv->menu_hover_pixbuf);
		self->priv->menu_hover_pixbuf = _tmp43_;
		_g_object_unref0 (_tmp38_);
		_g_object_unref0 (_tmp32_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GdkPixbuf* _tmp44_;
		GdkPixbuf* _tmp45_;
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (self->priv->menu_hover_pixbuf);
		self->priv->menu_hover_pixbuf = NULL;
		_tmp44_ = self->priv->menu_hover_pixbuf;
		_tmp45_ = _g_object_ref0 (_tmp44_);
		_g_object_unref0 (self->priv->menu_pixbuf);
		self->priv->menu_pixbuf = _tmp45_;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (menu_evbox);
		_g_object_unref0 (title_box);
		_g_object_unref0 (vbox_frame);
		_g_object_unref0 (style);
		_g_object_unref0 (frame);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp46_ = self->priv->menu_pixbuf;
	_tmp47_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp46_);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->menu_image);
	self->priv->menu_image = _tmp47_;
	_tmp48_ = menu_evbox;
	_tmp49_ = self->priv->menu_image;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = menu_evbox;
	g_signal_connect_object ((GtkWidget*) _tmp50_, "enter-notify-event", (GCallback) ___lambda12__gtk_widget_enter_notify_event, self, 0);
	_tmp51_ = menu_evbox;
	g_signal_connect_object ((GtkWidget*) _tmp51_, "leave-notify-event", (GCallback) ___lambda13__gtk_widget_leave_notify_event, self, 0);
	_tmp52_ = title_box;
	_tmp53_ = menu_evbox;
	gtk_box_pack_start (_tmp52_, (GtkWidget*) _tmp53_, FALSE, FALSE, (guint) 2);
	_tmp54_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp54_);
	title_evbox = _tmp54_;
	gtk_event_box_set_visible_window (title_evbox, FALSE);
	_tmp55_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp55_;
	_tmp56_ = self->priv->title_label;
	_tmp57_ = gtk_window_get_title ((GtkWindow*) self);
	_tmp58_ = _tmp57_;
	_tmp59_ = g_strconcat ("<b>", _tmp58_, NULL);
	_tmp60_ = _tmp59_;
	_tmp61_ = g_strconcat (_tmp60_, "</b>", NULL);
	_tmp62_ = _tmp61_;
	gtk_label_set_markup (_tmp56_, _tmp62_);
	_g_free0 (_tmp62_);
	_g_free0 (_tmp60_);
	_tmp63_ = self->priv->title_label;
	gtk_label_set_ellipsize (_tmp63_, PANGO_ELLIPSIZE_END);
	_tmp64_ = self->priv->title_label;
	gtk_label_set_xalign (_tmp64_, (gfloat) 0.0);
	_tmp65_ = self->priv->title_label;
	gtk_container_add ((GtkContainer*) title_evbox, (GtkWidget*) _tmp65_);
	_tmp66_ = title_box;
	gtk_box_pack_start (_tmp66_, (GtkWidget*) title_evbox, TRUE, TRUE, (guint) 6);
	_tmp67_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_REFRESH);
	g_object_ref_sink (_tmp67_);
	_g_object_unref0 (self->priv->refresh_button);
	self->priv->refresh_button = _tmp67_;
	_tmp68_ = self->priv->refresh_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp68_, _ ("Refresh notes"));
	_tmp69_ = self->priv->refresh_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp69_, TRUE);
	_tmp70_ = self->priv->refresh_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp70_, FALSE);
	_tmp71_ = title_box;
	_tmp72_ = self->priv->refresh_button;
	gtk_box_pack_start (_tmp71_, (GtkWidget*) _tmp72_, FALSE, FALSE, (guint) 2);
	_tmp73_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_LEFT_ARROW);
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->left_arrow_button);
	self->priv->left_arrow_button = _tmp73_;
	_tmp74_ = self->priv->left_arrow_button;
	_tmp75_ = gtk_accelerator_get_label ((guint) 0xff55, GDK_CONTROL_MASK);
	_tmp76_ = _tmp75_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp74_, _tmp76_);
	_g_free0 (_tmp76_);
	_tmp77_ = self->priv->left_arrow_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp77_, FALSE);
	_tmp78_ = title_box;
	_tmp79_ = self->priv->left_arrow_button;
	gtk_box_pack_start (_tmp78_, (GtkWidget*) _tmp79_, FALSE, FALSE, (guint) 2);
	_tmp80_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_RIGHT_ARROW);
	g_object_ref_sink (_tmp80_);
	_g_object_unref0 (self->priv->right_arrow_button);
	self->priv->right_arrow_button = _tmp80_;
	_tmp81_ = self->priv->right_arrow_button;
	_tmp82_ = gtk_accelerator_get_label ((guint) 0xff56, GDK_CONTROL_MASK);
	_tmp83_ = _tmp82_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp81_, _tmp83_);
	_g_free0 (_tmp83_);
	_tmp84_ = self->priv->right_arrow_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp84_, FALSE);
	_tmp85_ = title_box;
	_tmp86_ = self->priv->right_arrow_button;
	gtk_box_pack_start (_tmp85_, (GtkWidget*) _tmp86_, FALSE, FALSE, (guint) 2);
	_tmp87_ = xnp_title_bar_button_new (XNP_TITLE_BAR_BUTTON_TYPE_CLOSE);
	g_object_ref_sink (_tmp87_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp87_;
	_tmp88_ = self->priv->close_button;
	_tmp89_ = gtk_accelerator_get_label ((guint) 0xff1b, 0);
	_tmp90_ = _tmp89_;
	_tmp91_ = g_strdup_printf (_ ("Hide (%s)"), _tmp90_);
	_tmp92_ = _tmp91_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp88_, _tmp92_);
	_g_free0 (_tmp92_);
	_g_free0 (_tmp90_);
	_tmp93_ = title_box;
	_tmp94_ = self->priv->close_button;
	gtk_box_pack_start (_tmp93_, (GtkWidget*) _tmp94_, FALSE, FALSE, (guint) 2);
	_tmp95_ = title_box;
	gtk_widget_show_all ((GtkWidget*) _tmp95_);
	_tmp96_ = vbox_frame;
	_tmp97_ = title_box;
	gtk_box_pack_start (_tmp96_, (GtkWidget*) _tmp97_, FALSE, FALSE, (guint) 0);
	_tmp98_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp98_);
	_g_object_unref0 (self->priv->content_box);
	self->priv->content_box = _tmp98_;
	_tmp99_ = self->priv->content_box;
	gtk_widget_show ((GtkWidget*) _tmp99_);
	_tmp100_ = vbox_frame;
	_tmp101_ = self->priv->content_box;
	gtk_box_pack_start (_tmp100_, (GtkWidget*) _tmp101_, TRUE, TRUE, (guint) 0);
	_tmp102_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_ref_sink (_tmp102_);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp102_;
	_tmp103_ = self->priv->notebook;
	gtk_widget_set_name ((GtkWidget*) _tmp103_, "notes-notebook");
	_tmp104_ = self->priv->notebook;
	gtk_notebook_set_show_border (_tmp104_, TRUE);
	_tmp105_ = self->priv->notebook;
	gtk_notebook_set_show_tabs (_tmp105_, FALSE);
	_tmp106_ = self->priv->notebook;
	gtk_notebook_set_tab_pos (_tmp106_, GTK_POS_TOP);
	_tmp107_ = self->priv->notebook;
	gtk_notebook_set_scrollable (_tmp107_, TRUE);
	_tmp108_ = self->priv->notebook;
	gtk_widget_show ((GtkWidget*) _tmp108_);
	_tmp109_ = self->priv->content_box;
	_tmp110_ = self->priv->notebook;
	gtk_box_pack_start (_tmp109_, (GtkWidget*) _tmp110_, TRUE, TRUE, (guint) 0);
	_tmp111_ = menu_evbox;
	g_signal_connect_object ((GtkWidget*) _tmp111_, "button-press-event", (GCallback) _xnp_window_menu_evbox_pressed_cb_gtk_widget_button_press_event, self, 0);
	_tmp112_ = self->priv->refresh_button;
	g_signal_connect_object ((XnpIconButton*) _tmp112_, "clicked", (GCallback) _xnp_window_action_refresh_notes_xnp_icon_button_clicked, self, 0);
	_tmp113_ = self->priv->left_arrow_button;
	g_signal_connect_object ((XnpIconButton*) _tmp113_, "clicked", (GCallback) _xnp_window_action_prev_note_xnp_icon_button_clicked, self, 0);
	_tmp114_ = self->priv->right_arrow_button;
	g_signal_connect_object ((XnpIconButton*) _tmp114_, "clicked", (GCallback) _xnp_window_action_next_note_xnp_icon_button_clicked, self, 0);
	_tmp115_ = self->priv->close_button;
	g_signal_connect_object ((XnpIconButton*) _tmp115_, "clicked", (GCallback) ___lambda14__xnp_icon_button_clicked, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda15__gtk_widget_delete_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-in-event", (GCallback) ___lambda16__gtk_widget_focus_in_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) ___lambda17__gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _xnp_window_window_leaved_cb_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _xnp_window_window_motion_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _xnp_window_window_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _xnp_window_window_state_cb_gtk_widget_window_state_event, self, 0);
	g_signal_connect_object ((GtkWidget*) title_evbox, "button-press-event", (GCallback) _xnp_window_title_evbox_pressed_cb_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) title_evbox, "scroll-event", (GCallback) _xnp_window_title_evbox_scrolled_cb_gtk_widget_scroll_event, self, 0);
	_tmp116_ = self->priv->notebook;
	g_signal_connect_object (_tmp116_, "page-added", (GCallback) ___lambda18__gtk_notebook_page_added, self, 0);
	_tmp117_ = self->priv->notebook;
	g_signal_connect_object (_tmp117_, "page-removed", (GCallback) ___lambda19__gtk_notebook_page_removed, self, 0);
	_tmp118_ = self->priv->notebook;
	g_signal_connect_object (_tmp118_, "switch-page", (GCallback) ___lambda20__gtk_notebook_switch_page, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::name", (GCallback) ___lambda21__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::title", (GCallback) ___lambda22__g_object_notify, self, 0);
	_g_object_unref0 (title_evbox);
	_g_object_unref0 (menu_evbox);
	_g_object_unref0 (title_box);
	_g_object_unref0 (vbox_frame);
	_g_object_unref0 (style);
	_g_object_unref0 (frame);
	return self;
}

XnpWindow*
xnp_window_new (void)
{
	return xnp_window_construct (XNP_TYPE_WINDOW);
}

/**
 * hide:
 *
 * Save position before hidding.
 */
void
xnp_window_hide (XnpWindow* self)
{
	gint winx = 0;
	gint winy = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	gtk_window_get_position ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	winx = _tmp0_;
	winy = _tmp1_;
	GTK_WIDGET_CLASS (xnp_window_parent_class)->hide ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	gtk_window_deiconify ((GtkWindow*) self);
	xnp_window_unshade (self);
	gtk_window_move ((GtkWindow*) self, winx, winy);
	_tmp2_ = xnp_window_get_above (self);
	_tmp3_ = _tmp2_;
	gtk_window_set_keep_above ((GtkWindow*) self, _tmp3_);
}

/**
 * window_leaved_cb:
 *
 * Reset the mouse cursor.
 */
static gboolean
xnp_window_window_leaved_cb (XnpWindow* self)
{
	GdkWindow* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp0_, NULL);
	result = TRUE;
	return result;
}

/**
 * window_motion_cb:
 *
 * Update mouse cursor.
 */
static gboolean
xnp_window_window_motion_cb (XnpWindow* self,
                             GdkEventMotion* event)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GtkAllocation _tmp9_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	if (event->x > ((gdouble) 4)) {
		_tmp3_ = event->y > ((gdouble) 4);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkAllocation _tmp4_;
		_tmp4_ = allocation;
		_tmp2_ = event->x < ((gdouble) (_tmp4_.width - 4));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkAllocation _tmp5_;
		_tmp5_ = allocation;
		_tmp1_ = event->y < ((gdouble) (_tmp5_.height - 4));
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GdkWindow* _tmp6_;
		_tmp6_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_cursor (_tmp6_, NULL);
		result = FALSE;
		return result;
	}
	_tmp9_ = allocation;
	if (event->x >= ((gdouble) (_tmp9_.width - self->priv->CORNER_MARGIN))) {
		_tmp8_ = event->y >= ((gdouble) self->priv->CORNER_MARGIN);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GtkAllocation _tmp10_;
		_tmp10_ = allocation;
		_tmp7_ = event->y < ((gdouble) (_tmp10_.height - self->priv->CORNER_MARGIN));
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GdkWindow* _tmp11_;
		GdkCursor* _tmp12_;
		_tmp11_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp12_ = self->priv->CURSOR_RIGHT;
		gdk_window_set_cursor (_tmp11_, _tmp12_);
	} else {
		gboolean _tmp13_ = FALSE;
		GtkAllocation _tmp14_;
		_tmp14_ = allocation;
		if (event->x >= ((gdouble) (_tmp14_.width - self->priv->CORNER_MARGIN))) {
			GtkAllocation _tmp15_;
			_tmp15_ = allocation;
			_tmp13_ = event->y >= ((gdouble) (_tmp15_.height - self->priv->CORNER_MARGIN));
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			GdkWindow* _tmp16_;
			GdkCursor* _tmp17_;
			_tmp16_ = gtk_widget_get_window ((GtkWidget*) self);
			_tmp17_ = self->priv->CURSOR_BOTTOM_RC;
			gdk_window_set_cursor (_tmp16_, _tmp17_);
		} else {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			if (event->x > ((gdouble) self->priv->CORNER_MARGIN)) {
				GtkAllocation _tmp20_;
				_tmp20_ = allocation;
				_tmp19_ = event->y > ((gdouble) (_tmp20_.height - self->priv->CORNER_MARGIN));
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				GtkAllocation _tmp21_;
				_tmp21_ = allocation;
				_tmp18_ = event->x < ((gdouble) (_tmp21_.width - self->priv->CORNER_MARGIN));
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				GdkWindow* _tmp22_;
				GdkCursor* _tmp23_;
				_tmp22_ = gtk_widget_get_window ((GtkWidget*) self);
				_tmp23_ = self->priv->CURSOR_BOTTOM;
				gdk_window_set_cursor (_tmp22_, _tmp23_);
			} else {
				gboolean _tmp24_ = FALSE;
				if (event->x <= ((gdouble) self->priv->CORNER_MARGIN)) {
					GtkAllocation _tmp25_;
					_tmp25_ = allocation;
					_tmp24_ = event->y >= ((gdouble) (_tmp25_.height - self->priv->CORNER_MARGIN));
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					GdkWindow* _tmp26_;
					GdkCursor* _tmp27_;
					_tmp26_ = gtk_widget_get_window ((GtkWidget*) self);
					_tmp27_ = self->priv->CURSOR_BOTTOM_LC;
					gdk_window_set_cursor (_tmp26_, _tmp27_);
				} else {
					gboolean _tmp28_ = FALSE;
					gboolean _tmp29_ = FALSE;
					if (event->x <= ((gdouble) self->priv->CORNER_MARGIN)) {
						_tmp29_ = event->y >= ((gdouble) self->priv->CORNER_MARGIN);
					} else {
						_tmp29_ = FALSE;
					}
					if (_tmp29_) {
						GtkAllocation _tmp30_;
						_tmp30_ = allocation;
						_tmp28_ = event->y < ((gdouble) (_tmp30_.height - self->priv->CORNER_MARGIN));
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						GdkWindow* _tmp31_;
						GdkCursor* _tmp32_;
						_tmp31_ = gtk_widget_get_window ((GtkWidget*) self);
						_tmp32_ = self->priv->CURSOR_LEFT;
						gdk_window_set_cursor (_tmp31_, _tmp32_);
					} else {
						GdkWindow* _tmp33_;
						_tmp33_ = gtk_widget_get_window ((GtkWidget*) self);
						gdk_window_set_cursor (_tmp33_, NULL);
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}

/**
 * window_pressed_cb:
 *
 * Start a window resize depending on mouse pointer location.
 */
static gboolean
xnp_window_window_pressed_cb (XnpWindow* self,
                              GdkEventButton* event)
{
	GdkWindowEdge edge = 0;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GdkWindowEdge _tmp22_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	if (event->x > ((gdouble) 4)) {
		_tmp3_ = event->y > ((gdouble) 4);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkAllocation _tmp4_;
		_tmp4_ = allocation;
		_tmp2_ = event->x < ((gdouble) (_tmp4_.width - 4));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkAllocation _tmp5_;
		_tmp5_ = allocation;
		_tmp1_ = event->y < ((gdouble) (_tmp5_.height - 4));
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	if (event->y > ((gdouble) self->priv->CORNER_MARGIN)) {
		GtkAllocation _tmp8_;
		_tmp8_ = allocation;
		_tmp7_ = event->x > ((gdouble) (_tmp8_.width - self->priv->CORNER_MARGIN));
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GtkAllocation _tmp9_;
		_tmp9_ = allocation;
		_tmp6_ = event->y < ((gdouble) (_tmp9_.height - self->priv->CORNER_MARGIN));
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		edge = GDK_WINDOW_EDGE_EAST;
	} else {
		gboolean _tmp10_ = FALSE;
		GtkAllocation _tmp11_;
		_tmp11_ = allocation;
		if (event->x >= ((gdouble) (_tmp11_.width - self->priv->CORNER_MARGIN))) {
			GtkAllocation _tmp12_;
			_tmp12_ = allocation;
			_tmp10_ = event->y >= ((gdouble) (_tmp12_.height - self->priv->CORNER_MARGIN));
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			edge = GDK_WINDOW_EDGE_SOUTH_EAST;
		} else {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			if (event->x > ((gdouble) self->priv->CORNER_MARGIN)) {
				GtkAllocation _tmp15_;
				_tmp15_ = allocation;
				_tmp14_ = event->y > ((gdouble) (_tmp15_.height - self->priv->CORNER_MARGIN));
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				GtkAllocation _tmp16_;
				_tmp16_ = allocation;
				_tmp13_ = event->x < ((gdouble) (_tmp16_.width - self->priv->CORNER_MARGIN));
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				edge = GDK_WINDOW_EDGE_SOUTH;
			} else {
				gboolean _tmp17_ = FALSE;
				if (event->x <= ((gdouble) self->priv->CORNER_MARGIN)) {
					GtkAllocation _tmp18_;
					_tmp18_ = allocation;
					_tmp17_ = event->y >= ((gdouble) (_tmp18_.height - self->priv->CORNER_MARGIN));
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					edge = GDK_WINDOW_EDGE_SOUTH_WEST;
				} else {
					gboolean _tmp19_ = FALSE;
					gboolean _tmp20_ = FALSE;
					if (event->y > ((gdouble) self->priv->CORNER_MARGIN)) {
						_tmp20_ = event->x < ((gdouble) self->priv->CORNER_MARGIN);
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						GtkAllocation _tmp21_;
						_tmp21_ = allocation;
						_tmp19_ = event->y < ((gdouble) (_tmp21_.height - self->priv->CORNER_MARGIN));
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						edge = GDK_WINDOW_EDGE_WEST;
					} else {
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp22_ = edge;
	gtk_window_begin_resize_drag ((GtkWindow*) self, _tmp22_, (gint) event->button, (gint) event->x_root, (gint) event->y_root, event->time);
	result = TRUE;
	return result;
}

/**
 * window_state_cb:
 *
 * Watch window manager actions always on top and sticky
 * window.
 */
static gboolean
xnp_window_window_state_cb (XnpWindow* self,
                            GdkEventWindowState* event)
{
	GdkWindowState _tmp0_;
	gboolean _tmp3_ = FALSE;
	GdkWindowState _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->changed_mask;
	if ((gboolean) (_tmp0_ & GDK_WINDOW_STATE_ABOVE)) {
		GtkCheckMenuItem* _tmp1_;
		GdkWindowState _tmp2_;
		_tmp1_ = self->priv->mi_above;
		_tmp2_ = event->new_window_state;
		gtk_check_menu_item_set_active (_tmp1_, (gboolean) (_tmp2_ & GDK_WINDOW_STATE_ABOVE));
	}
	_tmp4_ = event->changed_mask;
	if ((gboolean) (_tmp4_ & GDK_WINDOW_STATE_STICKY)) {
		_tmp3_ = gtk_widget_get_visible ((GtkWidget*) self);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GdkWindowState _tmp5_;
		_tmp5_ = event->new_window_state;
		xnp_window_set_sticky (self, (gboolean) ((_tmp5_ & GDK_WINDOW_STATE_STICKY) != 0));
	}
	result = FALSE;
	return result;
}

/**
 * title_evbox_pressed_cb:
 *
 * Raise/lower the window and popup window menu.
 */
static gboolean
xnp_window_title_evbox_pressed_cb (XnpWindow* self,
                                   GtkWidget* widget,
                                   GdkEventButton* event)
{
	GdkEventType _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->type;
	if (_tmp0_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	if (event->button == ((guint) 1)) {
		GdkWindow* _tmp1_;
		gint winx = 0;
		gint winy = 0;
		gint curx = 0;
		gint cury = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_show (_tmp1_);
		gtk_window_get_position ((GtkWindow*) self, &_tmp2_, &_tmp3_);
		winx = _tmp2_;
		winy = _tmp3_;
		gtk_widget_get_pointer ((GtkWidget*) self, &_tmp4_, &_tmp5_);
		curx = _tmp4_;
		cury = _tmp5_;
		winx += curx;
		winy += cury;
		gtk_window_begin_move_drag ((GtkWindow*) self, 1, winx, winy, gtk_get_current_event_time ());
	} else {
		if (event->button == ((guint) 2)) {
			GdkWindow* _tmp6_;
			_tmp6_ = gtk_widget_get_window ((GtkWidget*) self);
			gdk_window_lower (_tmp6_);
		} else {
			if (event->button == ((guint) 3)) {
				GtkMenu* _tmp7_;
				_tmp7_ = self->priv->menu;
				gtk_menu_popup (_tmp7_, NULL, NULL, NULL, NULL, (guint) 0, gtk_get_current_event_time ());
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * title_evbox_scrolled_cb:
 *
 * Shade/unshade the window and set transparency by holding ALT.
 */
static gboolean
xnp_window_title_evbox_scrolled_cb (XnpWindow* self,
                                    GtkWidget* widget,
                                    GdkEventScroll* event)
{
	GdkModifierType _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->state;
	if ((gboolean) (_tmp0_ & GDK_MOD1_MASK)) {
		GdkScrollDirection _tmp1_;
		_tmp1_ = event->direction;
		if (_tmp1_ == GDK_SCROLL_UP) {
			gdouble _tmp2_;
			gdouble _tmp3_;
			_tmp2_ = gtk_widget_get_opacity ((GtkWidget*) self);
			_tmp3_ = _tmp2_;
			gtk_widget_set_opacity ((GtkWidget*) self, _tmp3_ + 0.1);
		} else {
			GdkScrollDirection _tmp4_;
			_tmp4_ = event->direction;
			if (_tmp4_ == GDK_SCROLL_DOWN) {
				gdouble _tmp5_;
				gdouble _tmp6_;
				_tmp5_ = gtk_widget_get_opacity ((GtkWidget*) self);
				_tmp6_ = _tmp5_;
				if ((_tmp6_ - 0.1) >= 0.1) {
					gdouble _tmp7_;
					gdouble _tmp8_;
					_tmp7_ = gtk_widget_get_opacity ((GtkWidget*) self);
					_tmp8_ = _tmp7_;
					gtk_widget_set_opacity ((GtkWidget*) self, _tmp8_ - 0.1);
				}
			}
		}
	} else {
		GdkScrollDirection _tmp9_;
		_tmp9_ = event->direction;
		if (_tmp9_ == GDK_SCROLL_UP) {
			xnp_window_shade (self);
		} else {
			GdkScrollDirection _tmp10_;
			_tmp10_ = event->direction;
			if (_tmp10_ == GDK_SCROLL_DOWN) {
				xnp_window_unshade (self);
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * note_notify_name_cb:
 *
 */
static void
xnp_window_note_notify_name_cb (XnpWindow* self,
                                GObject* object,
                                GParamSpec* pspec)
{
	XnpNote* note = NULL;
	XnpNote* _tmp0_;
	GtkNotebook* _tmp1_;
	XnpNote* _tmp2_;
	XnpNote* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint page = 0;
	GtkNotebook* _tmp6_;
	XnpNote* current_note = NULL;
	GtkNotebook* _tmp7_;
	GtkWidget* _tmp8_;
	XnpNote* _tmp9_;
	XnpNote* _tmp10_;
	XnpNote* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _g_object_ref0 (XNP_IS_NOTE (object) ? ((XnpNote*) object) : NULL);
	note = _tmp0_;
	_tmp1_ = self->priv->notebook;
	_tmp2_ = note;
	_tmp3_ = note;
	_tmp4_ = xnp_note_get_name (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_notebook_set_tab_label_text (_tmp1_, (GtkWidget*) _tmp2_, _tmp5_);
	_xnp_window_notebook_update_tabs_angle (self);
	_tmp6_ = self->priv->notebook;
	page = gtk_notebook_get_current_page (_tmp6_);
	_tmp7_ = self->priv->notebook;
	_tmp8_ = gtk_notebook_get_nth_page (_tmp7_, page);
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, XNP_TYPE_NOTE, XnpNote));
	current_note = _tmp9_;
	_tmp10_ = note;
	_tmp11_ = current_note;
	if (_tmp10_ == _tmp11_) {
		XnpNote* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = note;
		_tmp13_ = xnp_note_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		xnp_window_update_title (self, _tmp14_);
	}
	_g_object_unref0 (current_note);
	_g_object_unref0 (note);
}

static void
xnp_window_action_new_window (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "create-new-window");
}

static void
xnp_window_action_delete_window (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "delete");
}

static void
xnp_window_action_rename_window (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "rename");
}

static void
xnp_window_action_new_note (XnpWindow* self)
{
	XnpNote* _tmp0_;
	XnpNote* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xnp_window_insert_note (self);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}

static void
xnp_window_action_delete_note (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	xnp_window_delete_current_note (self);
}

static void
xnp_window_action_rename_note (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	xnp_window_rename_current_note (self);
}

static void
xnp_window_action_cancel (XnpWindow* self)
{
	gint page = 0;
	GtkNotebook* _tmp0_;
	GtkWidget* child = NULL;
	GtkNotebook* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	XnpHypertextView* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	page = gtk_notebook_get_current_page (_tmp0_);
	if (page < 0) {
		return;
	}
	_tmp1_ = self->priv->notebook;
	_tmp2_ = gtk_notebook_get_nth_page (_tmp1_, page);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	child = _tmp3_;
	_tmp4_ = child;
	_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, XNP_TYPE_NOTE, XnpNote)->text_view;
	xnp_hypertext_view_undo (_tmp5_);
	_g_object_unref0 (child);
}

static void
xnp_window_action_refresh_notes (XnpWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "refresh-notes");
}

static void
xnp_window_action_next_note (XnpWindow* self)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_next_page (_tmp0_);
}

static void
xnp_window_action_prev_note (XnpWindow* self)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_prev_page (_tmp0_);
}

/**
 * menu_evbox_pressed_cb:
 *
 * Popup the window menu.
 */
static void
_xnp_window_menu_position_gtk_menu_position_func (GtkMenu* menu,
                                                  gint* x,
                                                  gint* y,
                                                  gboolean* push_in,
                                                  gpointer self)
{
	xnp_window_menu_position ((XnpWindow*) self, menu, x, y, push_in);
	g_object_unref (self);
}

static gboolean
xnp_window_menu_evbox_pressed_cb (XnpWindow* self,
                                  GtkWidget* widget,
                                  GdkEventButton* event)
{
	GtkMenu* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->menu;
	gtk_menu_popup (_tmp0_, NULL, NULL, _xnp_window_menu_position_gtk_menu_position_func, g_object_ref (self), (guint) 0, gtk_get_current_event_time ());
	result = FALSE;
	return result;
}

/**
 * menu_position:
 *
 * Menu position function for the window menu.
 */
static void
xnp_window_menu_position (XnpWindow* self,
                          GtkMenu* menu,
                          gint* x,
                          gint* y,
                          gboolean* push_in)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	gint winx = 0;
	gint winy = 0;
	gint width = 0;
	gint height = 0;
	GtkRequisition requisition = {0};
	GtkAllocation allocation = {0};
	GdkWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkRequisition _tmp5_ = {0};
	GdkWindow* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GtkBox* _tmp9_;
	GtkAllocation _tmp10_ = {0};
	GtkAllocation _tmp11_;
	GtkRequisition _tmp12_;
	GtkRequisition _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_geometry (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	winx = _tmp1_;
	winy = _tmp2_;
	width = _tmp3_;
	height = _tmp4_;
	gtk_widget_get_preferred_size ((GtkWidget*) menu, &_tmp5_, NULL);
	requisition = _tmp5_;
	_tmp6_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_origin (_tmp6_, &_tmp7_, &_tmp8_);
	_vala_x = _tmp7_;
	_vala_y = _tmp8_;
	_vala_push_in = FALSE;
	_tmp9_ = self->priv->content_box;
	gtk_widget_get_allocation ((GtkWidget*) _tmp9_, &_tmp10_);
	allocation = _tmp10_;
	_tmp11_ = allocation;
	_tmp12_ = requisition;
	if (((_vala_y + _tmp11_.y) + _tmp12_.height) > gdk_screen_height ()) {
		GtkRequisition _tmp13_;
		_tmp13_ = requisition;
		_vala_y = _vala_y - _tmp13_.height;
	} else {
		GtkAllocation _tmp14_;
		_tmp14_ = allocation;
		_vala_y = _vala_y + _tmp14_.y;
	}
	_tmp15_ = requisition;
	if ((_vala_x + _tmp15_.width) > gdk_screen_width ()) {
		gint menu_width = 0;
		gint _tmp16_ = 0;
		GtkAllocation _tmp17_;
		gtk_widget_get_preferred_width ((GtkWidget*) menu, &_tmp16_, NULL);
		menu_width = _tmp16_;
		_tmp17_ = allocation;
		_vala_x = (_vala_x - menu_width) + _tmp17_.y;
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}

/**
 * build_menu:
 *
 * Build the window menu.
 */
static void
_xnp_window_update_menu_go_gtk_widget_show (GtkWidget* _sender,
                                            gpointer self)
{
	xnp_window_update_menu_go ((XnpWindow*) self, _sender);
}

static void
_xnp_window_action_new_note_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                    gpointer self)
{
	xnp_window_action_new_note ((XnpWindow*) self);
}

static void
_xnp_window_action_delete_note_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                       gpointer self)
{
	xnp_window_action_delete_note ((XnpWindow*) self);
}

static void
_xnp_window_action_rename_note_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                       gpointer self)
{
	xnp_window_action_rename_note ((XnpWindow*) self);
}

static void
_xnp_window_action_cancel_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                  gpointer self)
{
	xnp_window_action_cancel ((XnpWindow*) self);
}

static void
__lambda8_ (XnpWindow* self,
            GtkCheckMenuItem* o)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (o != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (o);
	_tmp1_ = _tmp0_;
	xnp_window_set_above (self, _tmp1_);
}

static void
___lambda8__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                         gpointer self)
{
	__lambda8_ ((XnpWindow*) self, _sender);
}

static void
__lambda9_ (XnpWindow* self,
            GtkCheckMenuItem* o)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (o != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (o);
	_tmp1_ = _tmp0_;
	xnp_window_set_sticky (self, _tmp1_);
}

static void
___lambda9__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                         gpointer self)
{
	__lambda9_ ((XnpWindow*) self, _sender);
}

static void
__lambda10_ (XnpWindow* self)
{
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "properties");
}

static void
___lambda10__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda10_ ((XnpWindow*) self);
}

static void
__lambda11_ (XnpWindow* self)
{
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "about");
}

static void
___lambda11__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda11_ ((XnpWindow*) self);
}

static GtkMenu*
xnp_window_build_menu (XnpWindow* self)
{
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkUIManager* _tmp1_;
	GtkAccelGroup* _tmp2_;
	GtkMenuItem* mi = NULL;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* _tmp4_;
	GtkMenu* menu_go = NULL;
	GtkMenu* _tmp5_;
	GtkUIManager* _tmp6_;
	GtkAccelGroup* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkSeparatorMenuItem* _tmp9_;
	GtkMenuItem* _tmp10_;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkActionGroup* _tmp13_;
	GtkAction* _tmp14_;
	const gchar* _tmp15_;
	GtkMenuItem* _tmp16_;
	GtkMenuItem* _tmp17_;
	GtkMenuItem* _tmp18_;
	GtkMenuItem* _tmp19_;
	GtkActionGroup* _tmp20_;
	GtkAction* _tmp21_;
	const gchar* _tmp22_;
	GtkMenuItem* _tmp23_;
	GtkMenuItem* _tmp24_;
	GtkMenuItem* _tmp25_;
	GtkMenuItem* _tmp26_;
	GtkActionGroup* _tmp27_;
	GtkAction* _tmp28_;
	const gchar* _tmp29_;
	GtkMenuItem* _tmp30_;
	GtkMenuItem* _tmp31_;
	GtkMenuItem* _tmp32_;
	GtkMenuItem* _tmp33_;
	GtkActionGroup* _tmp34_;
	GtkAction* _tmp35_;
	const gchar* _tmp36_;
	GtkMenuItem* _tmp37_;
	GtkMenuItem* _tmp38_;
	GtkSeparatorMenuItem* _tmp39_;
	GtkMenuItem* _tmp40_;
	GtkCheckMenuItem* _tmp41_;
	GtkCheckMenuItem* _tmp42_;
	GtkMenuItem* _tmp43_;
	GtkMenuItem* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	GtkMenuItem* _tmp47_;
	GtkMenuItem* _tmp48_;
	GtkCheckMenuItem* _tmp49_;
	GtkCheckMenuItem* _tmp50_;
	GtkMenuItem* _tmp51_;
	GtkMenuItem* _tmp52_;
	gboolean _tmp53_;
	gboolean _tmp54_;
	GtkMenuItem* _tmp55_;
	GtkMenuItem* _tmp56_;
	GtkSeparatorMenuItem* _tmp57_;
	GtkMenuItem* _tmp58_;
	GtkMenuItem* _tmp59_;
	GtkMenuItem* _tmp60_;
	GtkMenuItem* _tmp61_;
	GtkMenuItem* _tmp62_;
	GtkMenuItem* _tmp63_;
	GtkMenuItem* _tmp64_;
	GtkMenu* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	menu = _tmp0_;
	_tmp1_ = self->priv->ui;
	_tmp2_ = gtk_ui_manager_get_accel_group (_tmp1_);
	gtk_menu_set_accel_group (menu, _tmp2_);
	_tmp3_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Groups"));
	g_object_ref_sink (_tmp3_);
	mi = _tmp3_;
	_tmp4_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp4_);
	_tmp5_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp5_);
	menu_go = _tmp5_;
	_tmp6_ = self->priv->ui;
	_tmp7_ = gtk_ui_manager_get_accel_group (_tmp6_);
	gtk_menu_set_accel_group (menu_go, _tmp7_);
	g_signal_connect_object ((GtkWidget*) menu_go, "show", (GCallback) _xnp_window_update_menu_go_gtk_widget_show, self, 0);
	_tmp8_ = mi;
	gtk_menu_item_set_submenu (_tmp8_, menu_go);
	_tmp9_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp9_;
	_tmp10_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp10_);
	_tmp11_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_New"));
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (mi);
	mi = _tmp11_;
	_tmp12_ = mi;
	_tmp13_ = self->priv->action_group;
	_tmp14_ = gtk_action_group_get_action (_tmp13_, "new-note");
	_tmp15_ = gtk_action_get_accel_path (_tmp14_);
	gtk_menu_item_set_accel_path (_tmp12_, _tmp15_);
	_tmp16_ = mi;
	g_signal_connect_object (_tmp16_, "activate", (GCallback) _xnp_window_action_new_note_gtk_menu_item_activate, self, 0);
	_tmp17_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp17_);
	_tmp18_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Delete"));
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (mi);
	mi = _tmp18_;
	_tmp19_ = mi;
	_tmp20_ = self->priv->action_group;
	_tmp21_ = gtk_action_group_get_action (_tmp20_, "delete-note");
	_tmp22_ = gtk_action_get_accel_path (_tmp21_);
	gtk_menu_item_set_accel_path (_tmp19_, _tmp22_);
	_tmp23_ = mi;
	g_signal_connect_object (_tmp23_, "activate", (GCallback) _xnp_window_action_delete_note_gtk_menu_item_activate, self, 0);
	_tmp24_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp24_);
	_tmp25_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Rename"));
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (mi);
	mi = _tmp25_;
	_tmp26_ = mi;
	_tmp27_ = self->priv->action_group;
	_tmp28_ = gtk_action_group_get_action (_tmp27_, "rename-note");
	_tmp29_ = gtk_action_get_accel_path (_tmp28_);
	gtk_menu_item_set_accel_path (_tmp26_, _tmp29_);
	_tmp30_ = mi;
	g_signal_connect_object (_tmp30_, "activate", (GCallback) _xnp_window_action_rename_note_gtk_menu_item_activate, self, 0);
	_tmp31_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp31_);
	_tmp32_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Undo"));
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (mi);
	mi = _tmp32_;
	_tmp33_ = mi;
	_tmp34_ = self->priv->action_group;
	_tmp35_ = gtk_action_group_get_action (_tmp34_, "cancel");
	_tmp36_ = gtk_action_get_accel_path (_tmp35_);
	gtk_menu_item_set_accel_path (_tmp33_, _tmp36_);
	_tmp37_ = mi;
	g_signal_connect_object (_tmp37_, "activate", (GCallback) _xnp_window_action_cancel_gtk_menu_item_activate, self, 0);
	_tmp38_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp38_);
	_tmp39_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp39_;
	_tmp40_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp40_);
	_tmp41_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Always on top"));
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->mi_above);
	self->priv->mi_above = _tmp41_;
	_tmp42_ = self->priv->mi_above;
	_tmp43_ = _g_object_ref0 ((GtkMenuItem*) _tmp42_);
	_g_object_unref0 (mi);
	mi = _tmp43_;
	_tmp44_ = mi;
	_tmp45_ = xnp_window_get_above (self);
	_tmp46_ = _tmp45_;
	gtk_check_menu_item_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_check_menu_item_get_type (), GtkCheckMenuItem), _tmp46_);
	_tmp47_ = mi;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_check_menu_item_get_type (), GtkCheckMenuItem), "toggled", (GCallback) ___lambda8__gtk_check_menu_item_toggled, self, 0);
	_tmp48_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp48_);
	_tmp49_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Sticky window"));
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->mi_sticky);
	self->priv->mi_sticky = _tmp49_;
	_tmp50_ = self->priv->mi_sticky;
	_tmp51_ = _g_object_ref0 ((GtkMenuItem*) _tmp50_);
	_g_object_unref0 (mi);
	mi = _tmp51_;
	_tmp52_ = mi;
	_tmp53_ = xnp_window_get_sticky (self);
	_tmp54_ = _tmp53_;
	gtk_check_menu_item_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_check_menu_item_get_type (), GtkCheckMenuItem), _tmp54_);
	_tmp55_ = mi;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_check_menu_item_get_type (), GtkCheckMenuItem), "toggled", (GCallback) ___lambda9__gtk_check_menu_item_toggled, self, 0);
	_tmp56_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp56_);
	_tmp57_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (mi);
	mi = (GtkMenuItem*) _tmp57_;
	_tmp58_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp58_);
	_tmp59_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic ("_Properties");
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (mi);
	mi = _tmp59_;
	_tmp60_ = mi;
	g_signal_connect_object (_tmp60_, "activate", (GCallback) ___lambda10__gtk_menu_item_activate, self, 0);
	_tmp61_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp61_);
	_tmp62_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic ("_About");
	g_object_ref_sink (_tmp62_);
	_g_object_unref0 (mi);
	mi = _tmp62_;
	_tmp63_ = mi;
	g_signal_connect_object (_tmp63_, "activate", (GCallback) ___lambda11__gtk_menu_item_activate, self, 0);
	_tmp64_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp64_);
	result = menu;
	_g_object_unref0 (menu_go);
	_g_object_unref0 (mi);
	return result;
}

/**
 * update_menu_go:
 *
 * Update the menu Go when it is shown.
 */
static void
__lambda5_ (XnpWindow* self,
            GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	gtk_widget_destroy (w);
}

static void
___lambda5__gtk_callback (GtkWidget* widget,
                          gpointer self)
{
	__lambda5_ ((XnpWindow*) self, widget);
}

static void
________lambda6_ (XnpWindow* self,
                  GtkMenuItem* i)
{
	gint page = 0;
	gconstpointer _tmp0_;
	GtkNotebook* _tmp1_;
	g_return_if_fail (i != NULL);
	_tmp0_ = g_object_get_data ((GObject*) i, "page");
	page = (gint) ((gintptr) _tmp0_);
	_tmp1_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp1_, page);
}

static void
_________lambda6__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self)
{
	________lambda6_ ((XnpWindow*) self, _sender);
}

static void
_____lambda7_ (XnpWindow* self,
               GtkMenuItem* i)
{
	XnpWindow* w = NULL;
	gconstpointer _tmp0_;
	XnpWindow* _tmp1_;
	g_return_if_fail (i != NULL);
	_tmp0_ = g_object_get_data ((GObject*) i, "window");
	_tmp1_ = _g_object_ref0 ((XnpWindow*) _tmp0_);
	w = _tmp1_;
	gtk_window_present ((GtkWindow*) w);
	_g_object_unref0 (w);
}

static void
______lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	_____lambda7_ ((XnpWindow*) self, _sender);
}

static void
_xnp_window_action_rename_window_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                         gpointer self)
{
	xnp_window_action_rename_window ((XnpWindow*) self);
}

static void
_xnp_window_action_delete_window_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                         gpointer self)
{
	xnp_window_action_delete_window ((XnpWindow*) self);
}

static void
_xnp_window_action_new_window_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                      gpointer self)
{
	xnp_window_action_new_window ((XnpWindow*) self);
}

static void
xnp_window_update_menu_go (XnpWindow* self,
                           GtkWidget* widget)
{
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkMenuItem* mi = NULL;
	GtkMenu* _tmp1_;
	GSList* _tmp2_;
	GtkMenuItem* _tmp44_;
	GtkMenuItem* _tmp45_;
	GtkActionGroup* _tmp46_;
	GtkAction* _tmp47_;
	const gchar* _tmp48_;
	GtkMenuItem* _tmp49_;
	GtkMenu* _tmp50_;
	GtkMenuItem* _tmp51_;
	GtkMenuItem* _tmp52_;
	GtkMenuItem* _tmp53_;
	GtkActionGroup* _tmp54_;
	GtkAction* _tmp55_;
	const gchar* _tmp56_;
	GtkMenuItem* _tmp57_;
	GtkMenu* _tmp58_;
	GtkMenuItem* _tmp59_;
	GtkMenuItem* _tmp60_;
	GtkMenuItem* _tmp61_;
	GtkActionGroup* _tmp62_;
	GtkAction* _tmp63_;
	const gchar* _tmp64_;
	GtkMenuItem* _tmp65_;
	GtkMenu* _tmp66_;
	GtkMenuItem* _tmp67_;
	GtkMenu* _tmp68_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_menu_get_type ()) ? ((GtkMenu*) widget) : NULL);
	menu = _tmp0_;
	_tmp1_ = menu;
	gtk_container_foreach ((GtkContainer*) _tmp1_, ___lambda5__gtk_callback, self);
	_tmp2_ = self->priv->window_list;
	{
		GSList* win_collection = NULL;
		GSList* win_it = NULL;
		win_collection = _tmp2_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			XnpWindow* _tmp3_;
			XnpWindow* win = NULL;
			_tmp3_ = _g_object_ref0 ((XnpWindow*) win_it->data);
			win = _tmp3_;
			{
				XnpWindow* _tmp4_;
				_tmp4_ = win;
				if (_tmp4_ == self) {
					XnpWindow* _tmp5_;
					const gchar* _tmp6_;
					GtkMenuItem* _tmp7_;
					GtkMenuItem* _tmp8_;
					GtkMenu* _tmp9_;
					GtkMenuItem* _tmp10_;
					gint current_page = 0;
					GtkNotebook* _tmp11_;
					XnpNote* current_note = NULL;
					GtkNotebook* _tmp12_;
					GtkWidget* _tmp13_;
					XnpNote* _tmp14_;
					gint n_pages = 0;
					GtkNotebook* _tmp15_;
					GtkSeparatorMenuItem* _tmp30_;
					GtkMenu* _tmp31_;
					GtkMenuItem* _tmp32_;
					_tmp5_ = win;
					_tmp6_ = _tmp5_->priv->_name;
					_tmp7_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp6_);
					g_object_ref_sink (_tmp7_);
					_g_object_unref0 (mi);
					mi = _tmp7_;
					_tmp8_ = mi;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
					_tmp9_ = menu;
					_tmp10_ = mi;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp9_, _tmp10_);
					_tmp11_ = self->priv->notebook;
					current_page = gtk_notebook_get_current_page (_tmp11_);
					_tmp12_ = self->priv->notebook;
					_tmp13_ = gtk_notebook_get_nth_page (_tmp12_, current_page);
					_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, XNP_TYPE_NOTE, XnpNote));
					current_note = _tmp14_;
					_tmp15_ = self->priv->notebook;
					n_pages = gtk_notebook_get_n_pages (_tmp15_);
					{
						gint p = 0;
						p = 0;
						{
							gboolean _tmp16_ = FALSE;
							_tmp16_ = TRUE;
							while (TRUE) {
								XnpNote* note = NULL;
								GtkNotebook* _tmp18_;
								GtkWidget* _tmp19_;
								XnpNote* _tmp20_;
								XnpNote* _tmp21_;
								const gchar* _tmp22_;
								const gchar* _tmp23_;
								GtkMenuItem* _tmp24_;
								GtkMenuItem* _tmp25_;
								void* _tmp26_;
								GtkMenuItem* _tmp27_;
								GtkMenu* _tmp28_;
								GtkMenuItem* _tmp29_;
								if (!_tmp16_) {
									gint _tmp17_;
									_tmp17_ = p;
									p = _tmp17_ + 1;
								}
								_tmp16_ = FALSE;
								if (!(p < n_pages)) {
									break;
								}
								_tmp18_ = self->priv->notebook;
								_tmp19_ = gtk_notebook_get_nth_page (_tmp18_, p);
								_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, XNP_TYPE_NOTE, XnpNote));
								note = _tmp20_;
								_tmp21_ = note;
								_tmp22_ = xnp_note_get_name (_tmp21_);
								_tmp23_ = _tmp22_;
								_tmp24_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp23_);
								g_object_ref_sink (_tmp24_);
								_g_object_unref0 (mi);
								mi = _tmp24_;
								_tmp25_ = mi;
								_tmp26_ = GINT_TO_POINTER (p);
								g_object_set_data_full ((GObject*) _tmp25_, "page", _tmp26_, NULL);
								_tmp27_ = mi;
								g_signal_connect_object (_tmp27_, "activate", (GCallback) _________lambda6__gtk_menu_item_activate, self, 0);
								_tmp28_ = menu;
								_tmp29_ = mi;
								gtk_menu_shell_append ((GtkMenuShell*) _tmp28_, _tmp29_);
								_g_object_unref0 (note);
							}
						}
					}
					_tmp30_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
					g_object_ref_sink (_tmp30_);
					_g_object_unref0 (mi);
					mi = (GtkMenuItem*) _tmp30_;
					_tmp31_ = menu;
					_tmp32_ = mi;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp31_, _tmp32_);
					_g_object_unref0 (current_note);
				} else {
					XnpWindow* _tmp33_;
					const gchar* _tmp34_;
					GtkMenuItem* _tmp35_;
					GtkMenuItem* _tmp36_;
					XnpWindow* _tmp37_;
					GtkMenuItem* _tmp38_;
					GtkMenu* _tmp39_;
					GtkMenuItem* _tmp40_;
					GtkSeparatorMenuItem* _tmp41_;
					GtkMenu* _tmp42_;
					GtkMenuItem* _tmp43_;
					_tmp33_ = win;
					_tmp34_ = _tmp33_->priv->_name;
					_tmp35_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp34_);
					g_object_ref_sink (_tmp35_);
					_g_object_unref0 (mi);
					mi = _tmp35_;
					_tmp36_ = mi;
					_tmp37_ = win;
					g_object_set_data_full ((GObject*) _tmp36_, "window", (void*) _tmp37_, NULL);
					_tmp38_ = mi;
					g_signal_connect_object (_tmp38_, "activate", (GCallback) ______lambda7__gtk_menu_item_activate, self, 0);
					_tmp39_ = menu;
					_tmp40_ = mi;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp39_, _tmp40_);
					_tmp41_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
					g_object_ref_sink (_tmp41_);
					_g_object_unref0 (mi);
					mi = (GtkMenuItem*) _tmp41_;
					_tmp42_ = menu;
					_tmp43_ = mi;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp42_, _tmp43_);
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp44_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Rename group"));
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (mi);
	mi = _tmp44_;
	_tmp45_ = mi;
	_tmp46_ = self->priv->action_group;
	_tmp47_ = gtk_action_group_get_action (_tmp46_, "rename-window");
	_tmp48_ = gtk_action_get_accel_path (_tmp47_);
	gtk_menu_item_set_accel_path (_tmp45_, _tmp48_);
	_tmp49_ = mi;
	g_signal_connect_object (_tmp49_, "activate", (GCallback) _xnp_window_action_rename_window_gtk_menu_item_activate, self, 0);
	_tmp50_ = menu;
	_tmp51_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp50_, _tmp51_);
	_tmp52_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Delete group"));
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (mi);
	mi = _tmp52_;
	_tmp53_ = mi;
	_tmp54_ = self->priv->action_group;
	_tmp55_ = gtk_action_group_get_action (_tmp54_, "delete-window");
	_tmp56_ = gtk_action_get_accel_path (_tmp55_);
	gtk_menu_item_set_accel_path (_tmp53_, _tmp56_);
	_tmp57_ = mi;
	g_signal_connect_object (_tmp57_, "activate", (GCallback) _xnp_window_action_delete_window_gtk_menu_item_activate, self, 0);
	_tmp58_ = menu;
	_tmp59_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp58_, _tmp59_);
	_tmp60_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Add a new group"));
	g_object_ref_sink (_tmp60_);
	_g_object_unref0 (mi);
	mi = _tmp60_;
	_tmp61_ = mi;
	_tmp62_ = self->priv->action_group;
	_tmp63_ = gtk_action_group_get_action (_tmp62_, "new-window");
	_tmp64_ = gtk_action_get_accel_path (_tmp63_);
	gtk_menu_item_set_accel_path (_tmp61_, _tmp64_);
	_tmp65_ = mi;
	g_signal_connect_object (_tmp65_, "activate", (GCallback) _xnp_window_action_new_window_gtk_menu_item_activate, self, 0);
	_tmp66_ = menu;
	_tmp67_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp66_, _tmp67_);
	_tmp68_ = menu;
	gtk_widget_show_all ((GtkWidget*) _tmp68_);
	_g_object_unref0 (mi);
	_g_object_unref0 (menu);
}

/**
 * get_geometry:
 *
 * Returns the X,Y position and width/height.
 */
void
xnp_window_get_geometry (XnpWindow* self,
                         gint* winx,
                         gint* winy,
                         gint* width,
                         gint* height)
{
	gint _vala_winx = 0;
	gint _vala_winy = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	GtkBox* _tmp0_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	if (!gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		gint _tmp1_ = 0;
		gtk_window_get_size ((GtkWindow*) self, &_tmp1_, NULL);
		self->priv->width = _tmp1_;
	} else {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
		self->priv->width = _tmp2_;
		self->priv->height = _tmp3_;
	}
	gtk_window_get_position ((GtkWindow*) self, &_tmp4_, &_tmp5_);
	_vala_winx = _tmp4_;
	_vala_winy = _tmp5_;
	_vala_width = self->priv->width;
	_vala_height = self->priv->height;
	if (winx) {
		*winx = _vala_winx;
	}
	if (winy) {
		*winy = _vala_winy;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

/**
 * set_window_list:
 *
 * Saves a list of window inside window.window_list to be shown
 * within the window menu.
 */
void
xnp_window_set_window_list (XnpWindow* self,
                            GSList* list)
{
	g_return_if_fail (self != NULL);
	self->priv->window_list = list;
}

/**
 * compare_func:
 *
 * Compare function for the window name to use with GLib.CompareFunc delegates.
 */
gint
xnp_window_compare_func (XnpWindow* self,
                         XnpWindow* win2)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (win2 != NULL, 0);
	_tmp0_ = self->priv->_name;
	_tmp1_ = win2->priv->_name;
	result = g_utf8_collate (_tmp0_, _tmp1_);
	return result;
}

/**
 * get_current_page:
 *
 * Get the current page in the notebook.
 */
gint
xnp_window_get_current_page (XnpWindow* self)
{
	GtkNotebook* _tmp0_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->notebook;
	result = gtk_notebook_get_current_page (_tmp0_);
	return result;
}

/**
 * set_current_page:
 *
 * Set the current page in the notebook.
 */
void
xnp_window_set_current_page (XnpWindow* self,
                             gint page)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp0_, page);
}

/**
 * shade:
 *
 * Shade the window (roll up) to show only the title bar.
 */
static void
xnp_window_shade (XnpWindow* self)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		GtkBox* _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->content_box;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
		gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
		self->priv->width = _tmp2_;
		self->priv->height = _tmp3_;
		gtk_window_resize ((GtkWindow*) self, self->priv->width, 1);
	}
}

/**
 * unshade:
 *
 * Unshade the window (roll down).
 */
static void
xnp_window_unshade (XnpWindow* self)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->content_box;
	if (!gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		GtkBox* _tmp1_;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->content_box;
		gtk_widget_show ((GtkWidget*) _tmp1_);
		gtk_window_get_size ((GtkWindow*) self, &_tmp2_, NULL);
		self->priv->width = _tmp2_;
		gtk_window_resize ((GtkWindow*) self, self->priv->width, self->priv->height);
	}
}

/**
 * update_title:
 *
 * Updates the window title.
 */
static void
xnp_window_update_title (XnpWindow* self,
                         const gchar* note_name)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note_name != NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strconcat (_tmp0_, " - ", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, note_name, NULL);
	_tmp4_ = _tmp3_;
	gtk_window_set_title ((GtkWindow*) self, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

/**
 * update_navigation_sensitivity:
 *
 * Update the goleft/right sensitivities.
 */
static void
xnp_window_update_navigation_sensitivity (XnpWindow* self,
                                          gint page_num)
{
	gint n_pages = 0;
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	n_pages = gtk_notebook_get_n_pages (_tmp0_);
	if (n_pages <= 1) {
		XnpTitleBarButton* _tmp1_;
		XnpTitleBarButton* _tmp2_;
		_tmp1_ = self->priv->left_arrow_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
		_tmp2_ = self->priv->right_arrow_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	} else {
		gboolean _tmp3_ = FALSE;
		XnpTitleBarButton* _tmp4_;
		gboolean _tmp5_ = FALSE;
		XnpTitleBarButton* _tmp6_;
		if (page_num > 0) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp4_ = self->priv->left_arrow_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, _tmp3_);
		if ((page_num + 1) < n_pages) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp6_ = self->priv->right_arrow_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp5_);
	}
}

/**
 * insert_note:
 *
 * Create a new note and insert it inside the notebook after
 * the current position.
 */
static void
_xnp_window_note_notify_name_cb_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	xnp_window_note_notify_name_cb ((XnpWindow*) self, _sender, pspec);
}

static void
__lambda4_ (XnpWindow* self,
            XnpNote* note)
{
	g_return_if_fail (note != NULL);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_SAVE_DATA_SIGNAL], 0, note);
}

static void
___lambda4__xnp_note_save_data (XnpNote* _sender,
                                gpointer self)
{
	__lambda4_ ((XnpWindow*) self, _sender);
}

XnpNote*
xnp_window_insert_note (XnpWindow* self)
{
	gint len = 0;
	GtkNotebook* _tmp0_;
	gchar* name = NULL;
	gchar* _tmp1_;
	gint page = 0;
	GtkNotebook* _tmp6_;
	XnpNote* note = NULL;
	const gchar* _tmp7_;
	XnpNote* _tmp8_;
	gint _tmp9_;
	GtkNotebook* _tmp10_;
	GtkNotebook* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	XnpNote* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->notebook;
	len = gtk_notebook_get_n_pages (_tmp0_);
	_tmp1_ = g_strdup (_ ("Notes"));
	name = _tmp1_;
	{
		gint id = 0;
		id = 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				const gchar* _tmp5_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = id;
					id = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(id <= (len + 1))) {
					break;
				}
				if (id > 1) {
					gchar* _tmp4_;
					_tmp4_ = g_strdup_printf (_ ("Notes %d"), id);
					_g_free0 (name);
					name = _tmp4_;
				}
				_tmp5_ = name;
				if (!xnp_window_note_name_exists (self, _tmp5_)) {
					break;
				}
			}
		}
	}
	_tmp6_ = self->priv->notebook;
	page = gtk_notebook_get_current_page (_tmp6_) + 1;
	_tmp7_ = name;
	_tmp8_ = xnp_note_new (_tmp7_);
	g_object_ref_sink (_tmp8_);
	note = _tmp8_;
	g_signal_connect_object ((GObject*) note, "notify::name", (GCallback) _xnp_window_note_notify_name_cb_g_object_notify, self, 0);
	g_signal_connect_object (note, "save-data", (GCallback) ___lambda4__xnp_note_save_data, self, 0);
	gtk_widget_show ((GtkWidget*) note);
	_tmp9_ = self->priv->_n_pages;
	xnp_window_set_n_pages (self, _tmp9_ + 1);
	_tmp10_ = self->priv->notebook;
	gtk_notebook_insert_page (_tmp10_, (GtkWidget*) note, NULL, page);
	_tmp11_ = self->priv->notebook;
	gtk_notebook_set_tab_reorderable (_tmp11_, (GtkWidget*) note, TRUE);
	_tmp12_ = xnp_note_get_name (note);
	_tmp13_ = _tmp12_;
	xnp_note_set_name (note, _tmp13_);
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_NOTE_INSERTED_SIGNAL], 0, note);
	_xnp_window_notebook_update_tabs_angle (self);
	result = note;
	_g_free0 (name);
	return result;
}

/**
 * move_note:
 *
 * Moves the note named @note_name to position @page.
 */
void
xnp_window_move_note (XnpWindow* self,
                      const gchar* note_name,
                      gint page)
{
	gint n_pages = 0;
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (note_name != NULL);
	_tmp0_ = self->priv->notebook;
	n_pages = gtk_notebook_get_n_pages (_tmp0_);
	{
		gint p = 0;
		p = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				XnpNote* note = NULL;
				GtkNotebook* _tmp3_;
				GtkWidget* _tmp4_;
				XnpNote* _tmp5_;
				XnpNote* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = p;
					p = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				_tmp3_ = self->priv->notebook;
				_tmp4_ = gtk_notebook_get_nth_page (_tmp3_, p);
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, XNP_TYPE_NOTE, XnpNote));
				note = _tmp5_;
				_tmp6_ = note;
				_tmp7_ = xnp_note_get_name (_tmp6_);
				_tmp8_ = _tmp7_;
				if (g_strcmp0 (_tmp8_, note_name) == 0) {
					GtkNotebook* _tmp9_;
					XnpNote* _tmp10_;
					_tmp9_ = self->priv->notebook;
					_tmp10_ = note;
					gtk_notebook_reorder_child (_tmp9_, (GtkWidget*) _tmp10_, page);
					xnp_window_update_navigation_sensitivity (self, page);
					_g_object_unref0 (note);
					break;
				}
				_g_object_unref0 (note);
			}
		}
	}
}

/**
 * get_note_names:
 *
 * Returns a string list of the note names in the order they are currently displayed
 * in the notebook.
 */
static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
xnp_window_get_note_names (XnpWindow* self,
                           gint* result_length1)
{
	gchar** note_names = NULL;
	gint note_names_length1;
	gint _note_names_size_;
	gint n_pages = 0;
	GtkNotebook* _tmp0_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	note_names = NULL;
	note_names_length1 = 0;
	_note_names_size_ = note_names_length1;
	_tmp0_ = self->priv->notebook;
	n_pages = gtk_notebook_get_n_pages (_tmp0_);
	{
		gint p = 0;
		p = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				XnpNote* note = NULL;
				GtkNotebook* _tmp3_;
				GtkWidget* _tmp4_;
				XnpNote* _tmp5_;
				XnpNote* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = p;
					p = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				_tmp3_ = self->priv->notebook;
				_tmp4_ = gtk_notebook_get_nth_page (_tmp3_, p);
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, XNP_TYPE_NOTE, XnpNote));
				note = _tmp5_;
				_tmp6_ = note;
				_tmp7_ = xnp_note_get_name (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strdup (_tmp8_);
				_vala_array_add1 (&note_names, &note_names_length1, &_note_names_size_, _tmp9_);
				_g_object_unref0 (note);
			}
		}
	}
	_tmp10_ = note_names;
	_tmp10__length1 = note_names_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

/**
 * delete_current_note:
 *
 * Delete the current note.
 */
void
xnp_window_delete_current_note (XnpWindow* self)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	xnp_window_delete_note (self, gtk_notebook_get_current_page (_tmp0_));
}

/**
 * delete_note:
 *
 * Delete note at page @page.
 */
void
xnp_window_delete_note (XnpWindow* self,
                        gint page)
{
	XnpNote* note = NULL;
	GtkNotebook* _tmp0_;
	GtkWidget* _tmp1_;
	XnpNote* _tmp2_;
	XnpNote* _tmp3_;
	XnpHypertextView* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	gint _tmp10_;
	GtkNotebook* _tmp11_;
	XnpNote* _tmp12_;
	XnpNote* _tmp13_;
	GtkNotebook* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_nth_page (_tmp0_, page);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, XNP_TYPE_NOTE, XnpNote));
	note = _tmp2_;
	_tmp3_ = note;
	_tmp4_ = _tmp3_->text_view;
	_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (gtk_text_buffer_get_char_count (_tmp6_) > 0) {
		GtkMessageDialog* dialog = NULL;
		GtkMessageDialog* _tmp7_;
		gint res = 0;
		GtkMessageDialog* _tmp8_;
		GtkMessageDialog* _tmp9_;
		_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, "%s", _ ("Are you sure you want to delete this note?"));
		g_object_ref_sink (_tmp7_);
		dialog = _tmp7_;
		_tmp8_ = dialog;
		res = gtk_dialog_run ((GtkDialog*) _tmp8_);
		_tmp9_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp9_);
		if (res != ((gint) GTK_RESPONSE_YES)) {
			_g_object_unref0 (dialog);
			_g_object_unref0 (note);
			return;
		}
		_g_object_unref0 (dialog);
	}
	_tmp10_ = self->priv->_n_pages;
	xnp_window_set_n_pages (self, _tmp10_ - 1);
	_tmp11_ = self->priv->notebook;
	gtk_notebook_remove_page (_tmp11_, page);
	_tmp12_ = note;
	g_signal_emit (self, xnp_window_signals[XNP_WINDOW_NOTE_DELETED_SIGNAL], 0, _tmp12_);
	_tmp13_ = note;
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->notebook;
	if (gtk_notebook_get_n_pages (_tmp14_) == 0) {
		g_signal_emit (self, xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL], 0, "delete");
	}
	_g_object_unref0 (note);
}

/**
 * rename_current_note:
 *
 * Rename the current note.
 */
void
xnp_window_rename_current_note (XnpWindow* self)
{
	gint page = 0;
	GtkNotebook* _tmp0_;
	XnpNote* note = NULL;
	GtkNotebook* _tmp1_;
	GtkWidget* _tmp2_;
	XnpNote* _tmp3_;
	GtkDialog* dialog = NULL;
	GtkWidget* _tmp4_;
	GtkDialog* _tmp5_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	GtkBox* _tmp13_;
	GtkEntry* entry = NULL;
	GtkEntry* _tmp14_;
	GtkEntry* _tmp15_;
	XnpNote* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GtkEntry* _tmp19_;
	GtkBox* _tmp20_;
	GtkEntry* _tmp21_;
	GtkBox* _tmp22_;
	gint res = 0;
	GtkDialog* _tmp23_;
	GtkDialog* _tmp24_;
	GtkDialog* _tmp42_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	page = gtk_notebook_get_current_page (_tmp0_);
	if (page == -1) {
		return;
	}
	_tmp1_ = self->priv->notebook;
	_tmp2_ = gtk_notebook_get_nth_page (_tmp1_, page);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, XNP_TYPE_NOTE, XnpNote));
	note = _tmp3_;
	_tmp4_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp5_ = (GtkDialog*) gtk_dialog_new_with_buttons (_ ("Rename note"), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, "_Cancel", GTK_RESPONSE_CANCEL, "_OK", GTK_RESPONSE_OK, NULL);
	g_object_ref_sink (_tmp5_);
	dialog = _tmp5_;
	_tmp6_ = dialog;
	_tmp7_ = gtk_dialog_get_content_area (_tmp6_);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_box_get_type (), GtkBox));
	content_area = _tmp8_;
	_tmp9_ = dialog;
	gtk_dialog_set_default_response (_tmp9_, (gint) GTK_RESPONSE_OK);
	_tmp10_ = dialog;
	gtk_window_set_resizable ((GtkWindow*) _tmp10_, FALSE);
	_tmp11_ = dialog;
	gtk_window_set_icon_name ((GtkWindow*) _tmp11_, "gtk-edit");
	_tmp12_ = dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp12_, (guint) 4);
	_tmp13_ = content_area;
	gtk_container_set_border_width ((GtkContainer*) _tmp13_, (guint) 6);
	_tmp14_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp14_);
	entry = _tmp14_;
	_tmp15_ = entry;
	_tmp16_ = note;
	_tmp17_ = xnp_note_get_name (_tmp16_);
	_tmp18_ = _tmp17_;
	gtk_entry_set_text (_tmp15_, _tmp18_);
	_tmp19_ = entry;
	gtk_entry_set_activates_default (_tmp19_, TRUE);
	_tmp20_ = content_area;
	_tmp21_ = entry;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp22_);
	_tmp23_ = dialog;
	res = gtk_dialog_run (_tmp23_);
	_tmp24_ = dialog;
	gtk_widget_hide ((GtkWidget*) _tmp24_);
	if (res == ((gint) GTK_RESPONSE_OK)) {
		gchar* name = NULL;
		GtkEntry* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp25_ = entry;
		_tmp26_ = gtk_entry_get_text (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup (_tmp27_);
		name = _tmp28_;
		_tmp29_ = name;
		if (xnp_window_note_name_exists (self, _tmp29_)) {
			GtkMessageDialog* error_dialog = NULL;
			const gchar* _tmp30_;
			GtkMessageDialog* _tmp31_;
			GtkMessageDialog* _tmp32_;
			GtkMessageDialog* _tmp33_;
			_tmp30_ = name;
			_tmp31_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("The name %s is already in use"), _tmp30_);
			g_object_ref_sink (_tmp31_);
			error_dialog = _tmp31_;
			_tmp32_ = error_dialog;
			gtk_dialog_run ((GtkDialog*) _tmp32_);
			_tmp33_ = error_dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp33_);
			_g_object_unref0 (error_dialog);
		} else {
			gchar* old_name = NULL;
			XnpNote* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			XnpNote* _tmp38_;
			const gchar* _tmp39_;
			XnpNote* _tmp40_;
			const gchar* _tmp41_;
			_tmp34_ = note;
			_tmp35_ = xnp_note_get_name (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strdup (_tmp36_);
			old_name = _tmp37_;
			_tmp38_ = note;
			_tmp39_ = name;
			xnp_note_set_name (_tmp38_, _tmp39_);
			_tmp40_ = note;
			_tmp41_ = old_name;
			g_signal_emit (self, xnp_window_signals[XNP_WINDOW_NOTE_RENAMED_SIGNAL], 0, _tmp40_, _tmp41_);
			_g_free0 (old_name);
		}
		_g_free0 (name);
	}
	_tmp42_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp42_);
	_g_object_unref0 (entry);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_g_object_unref0 (note);
}

/**
 * set_font:
 *
 * Set the font for the window.
 */
void
xnp_window_set_font (XnpWindow* self)
{
	gint page = 0;
	GtkNotebook* _tmp0_;
	XnpNote* note = NULL;
	GtkNotebook* _tmp1_;
	GtkWidget* _tmp2_;
	XnpNote* _tmp3_;
	GtkFontChooserDialog* dialog = NULL;
	GtkFontChooserDialog* _tmp4_;
	GtkFontChooserDialog* _tmp5_;
	XnpNote* _tmp6_;
	XnpHypertextView* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint res = 0;
	GtkFontChooserDialog* _tmp10_;
	GtkFontChooserDialog* _tmp11_;
	GtkFontChooserDialog* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	page = gtk_notebook_get_current_page (_tmp0_);
	if (page == -1) {
		return;
	}
	_tmp1_ = self->priv->notebook;
	_tmp2_ = gtk_notebook_get_nth_page (_tmp1_, page);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, XNP_TYPE_NOTE, XnpNote));
	note = _tmp3_;
	_tmp4_ = (GtkFontChooserDialog*) gtk_font_chooser_dialog_new ("Choose current note font", (GtkWindow*) self);
	g_object_ref_sink (_tmp4_);
	dialog = _tmp4_;
	_tmp5_ = dialog;
	_tmp6_ = note;
	_tmp7_ = _tmp6_->text_view;
	_tmp8_ = xnp_hypertext_view_get_font (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_font_chooser_set_font ((GtkFontChooser*) _tmp5_, _tmp9_);
	_tmp10_ = dialog;
	res = gtk_dialog_run ((GtkDialog*) _tmp10_);
	_tmp11_ = dialog;
	gtk_widget_hide ((GtkWidget*) _tmp11_);
	if (res == ((gint) GTK_RESPONSE_OK)) {
		XnpNote* _tmp12_;
		XnpHypertextView* _tmp13_;
		GtkFontChooserDialog* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp12_ = note;
		_tmp13_ = _tmp12_->text_view;
		_tmp14_ = dialog;
		_tmp15_ = gtk_font_chooser_get_font ((GtkFontChooser*) _tmp14_);
		_tmp16_ = _tmp15_;
		xnp_hypertext_view_set_font (_tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
	}
	_tmp17_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp17_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (note);
}

/**
 * note_name_exists:
 *
 * Verify if the given name already exists in the notebook.
 */
static gboolean
xnp_window_note_name_exists (XnpWindow* self,
                             const gchar* name)
{
	gint n_pages = 0;
	GtkNotebook* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->notebook;
	n_pages = gtk_notebook_get_n_pages (_tmp0_);
	{
		gint p = 0;
		p = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				XnpNote* note = NULL;
				GtkNotebook* _tmp3_;
				GtkWidget* _tmp4_;
				XnpNote* _tmp5_;
				XnpNote* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = p;
					p = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				_tmp3_ = self->priv->notebook;
				_tmp4_ = gtk_notebook_get_nth_page (_tmp3_, p);
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, XNP_TYPE_NOTE, XnpNote));
				note = _tmp5_;
				_tmp6_ = note;
				_tmp7_ = xnp_note_get_name (_tmp6_);
				_tmp8_ = _tmp7_;
				if (g_strcmp0 (_tmp8_, name) == 0) {
					result = TRUE;
					_g_object_unref0 (note);
					return result;
				}
				_g_object_unref0 (note);
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * save_notes:
 *
 * Send the save-data signal on every dirty note.
 */
void
xnp_window_save_notes (XnpWindow* self)
{
	gint n_pages = 0;
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	n_pages = gtk_notebook_get_n_pages (_tmp0_);
	{
		gint p = 0;
		p = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				XnpNote* note = NULL;
				GtkNotebook* _tmp3_;
				GtkWidget* _tmp4_;
				XnpNote* _tmp5_;
				XnpNote* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = p;
					p = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(p < n_pages)) {
					break;
				}
				_tmp3_ = self->priv->notebook;
				_tmp4_ = gtk_notebook_get_nth_page (_tmp3_, p);
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, XNP_TYPE_NOTE, XnpNote));
				note = _tmp5_;
				_tmp6_ = note;
				_tmp7_ = xnp_note_get_dirty (_tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					XnpNote* _tmp9_;
					XnpNote* _tmp10_;
					_tmp9_ = note;
					xnp_note_set_dirty (_tmp9_, FALSE);
					_tmp10_ = note;
					g_signal_emit (self, xnp_window_signals[XNP_WINDOW_SAVE_DATA_SIGNAL], 0, _tmp10_);
				}
				_g_object_unref0 (note);
			}
		}
	}
}

/**
 * _notebook_update_tabs_angle:
 *
 * Set the angle of each label in the tab.
 */
static void
_xnp_window_notebook_update_tabs_angle (XnpWindow* self)
{
	gint angle = 0;
	gint pages = 0;
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	angle = 0;
	if (self->priv->_tabs_position == 2) {
		angle = 270;
	} else {
		if (self->priv->_tabs_position == 4) {
			angle = 90;
		}
	}
	_tmp0_ = self->priv->notebook;
	pages = gtk_notebook_get_n_pages (_tmp0_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GtkWidget* widget = NULL;
				GtkNotebook* _tmp3_;
				GtkWidget* _tmp4_;
				GtkWidget* _tmp5_;
				GtkLabel* label = NULL;
				GtkNotebook* _tmp6_;
				GtkWidget* _tmp7_;
				GtkWidget* _tmp8_;
				GtkLabel* _tmp9_;
				GtkLabel* _tmp10_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < pages)) {
					break;
				}
				_tmp3_ = self->priv->notebook;
				_tmp4_ = gtk_notebook_get_nth_page (_tmp3_, i);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				widget = _tmp5_;
				_tmp6_ = self->priv->notebook;
				_tmp7_ = widget;
				_tmp8_ = gtk_notebook_get_tab_label (_tmp6_, _tmp7_);
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp8_) : NULL);
				label = _tmp9_;
				_tmp10_ = label;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_label_get_type ())) {
					GtkLabel* _tmp11_;
					_tmp11_ = label;
					gtk_label_set_angle (_tmp11_, (gdouble) angle);
				}
				_g_object_unref0 (label);
				_g_object_unref0 (widget);
			}
		}
	}
}

const gchar*
xnp_window_get_name (XnpWindow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
xnp_window_set_name (XnpWindow* self,
                     const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, xnp_window_get_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_NAME_PROPERTY]);
	}
}

gint
xnp_window_get_n_pages (XnpWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_n_pages;
	return result;
}

void
xnp_window_set_n_pages (XnpWindow* self,
                        gint value)
{
	g_return_if_fail (self != NULL);
	if (xnp_window_get_n_pages (self) != value) {
		self->priv->_n_pages = value;
		g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_N_PAGES_PROPERTY]);
	}
}

gboolean
xnp_window_get_show_tabs (XnpWindow* self)
{
	gboolean result;
	GtkNotebook* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->notebook;
	_tmp1_ = gtk_notebook_get_show_tabs (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
xnp_window_set_show_tabs (XnpWindow* self,
                          gboolean value)
{
	GtkNotebook* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_notebook_set_show_tabs (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_SHOW_TABS_PROPERTY]);
}

gint
xnp_window_get_tabs_position (XnpWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_tabs_position;
	return result;
}

void
xnp_window_set_tabs_position (XnpWindow* self,
                              gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tabs_position = value;
	if (self->priv->_tabs_position == 0) {
		xnp_window_set_show_tabs (self, FALSE);
	} else {
		xnp_window_set_show_tabs (self, TRUE);
		_xnp_window_notebook_update_tabs_angle (self);
		if (self->priv->_tabs_position == 1) {
			GtkNotebook* _tmp0_;
			_tmp0_ = self->priv->notebook;
			gtk_notebook_set_tab_pos (_tmp0_, GTK_POS_TOP);
		} else {
			if (self->priv->_tabs_position == 2) {
				GtkNotebook* _tmp1_;
				_tmp1_ = self->priv->notebook;
				gtk_notebook_set_tab_pos (_tmp1_, GTK_POS_RIGHT);
			} else {
				if (self->priv->_tabs_position == 3) {
					GtkNotebook* _tmp2_;
					_tmp2_ = self->priv->notebook;
					gtk_notebook_set_tab_pos (_tmp2_, GTK_POS_BOTTOM);
				} else {
					if (self->priv->_tabs_position == 4) {
						GtkNotebook* _tmp3_;
						_tmp3_ = self->priv->notebook;
						gtk_notebook_set_tab_pos (_tmp3_, GTK_POS_LEFT);
					} else {
						xnp_window_set_show_tabs (self, FALSE);
						g_warning ("window.vala:119: Bad value for tabs-position");
					}
				}
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_TABS_POSITION_PROPERTY]);
}

gboolean
xnp_window_get_above (XnpWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_above;
	return result;
}

void
xnp_window_set_above (XnpWindow* self,
                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_above = value;
	gtk_window_set_keep_above ((GtkWindow*) self, value);
	g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_ABOVE_PROPERTY]);
}

gboolean
xnp_window_get_sticky (XnpWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_sticky;
	return result;
}

void
xnp_window_set_sticky (XnpWindow* self,
                       gboolean value)
{
	GtkCheckMenuItem* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_sticky = value;
	if (value == TRUE) {
		gtk_window_stick ((GtkWindow*) self);
	} else {
		gtk_window_unstick ((GtkWindow*) self);
	}
	_tmp0_ = self->priv->mi_sticky;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_check_menu_item_get_type ())) {
		GtkCheckMenuItem* _tmp1_;
		_tmp1_ = self->priv->mi_sticky;
		gtk_check_menu_item_set_active (_tmp1_, self->priv->_sticky);
	}
	g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_STICKY_PROPERTY]);
}

gboolean
xnp_window_get_show_refresh_button (XnpWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_refresh_button;
	return result;
}

void
xnp_window_set_show_refresh_button (XnpWindow* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_refresh_button = value;
	if (value == TRUE) {
		XnpTitleBarButton* _tmp0_;
		_tmp0_ = self->priv->refresh_button;
		gtk_widget_show ((GtkWidget*) _tmp0_);
	} else {
		XnpTitleBarButton* _tmp1_;
		_tmp1_ = self->priv->refresh_button;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	g_object_notify_by_pspec ((GObject *) self, xnp_window_properties[XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static GObject *
xnp_window_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XnpWindow * self;
	parent_class = G_OBJECT_CLASS (xnp_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_WINDOW, XnpWindow);
	gtk_widget_set_name (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "notes-window");
	gtk_window_set_title ((GtkWindow*) self, _ ("Notes"));
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	g_object_set ((GtkWindow*) self, "default-height", 380, NULL);
	g_object_set ((GtkWindow*) self, "default-width", 300, NULL);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_set_icon_name ((GtkWindow*) self, "xfce4-notes-plugin");
	xnp_window_set_sticky (self, TRUE);
	gtk_widget_set_opacity ((GtkWidget*) self, 0.9);
	return obj;
}

static void
xnp_window_class_init (XnpWindowClass * klass,
                       gpointer klass_data)
{
	xnp_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_NAME_PROPERTY, xnp_window_properties[XNP_WINDOW_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_N_PAGES_PROPERTY, xnp_window_properties[XNP_WINDOW_N_PAGES_PROPERTY] = g_param_spec_int ("n-pages", "n-pages", "n-pages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_SHOW_TABS_PROPERTY, xnp_window_properties[XNP_WINDOW_SHOW_TABS_PROPERTY] = g_param_spec_boolean ("show-tabs", "show-tabs", "show-tabs", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_TABS_POSITION_PROPERTY, xnp_window_properties[XNP_WINDOW_TABS_POSITION_PROPERTY] = g_param_spec_int ("tabs-position", "tabs-position", "tabs-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_ABOVE_PROPERTY, xnp_window_properties[XNP_WINDOW_ABOVE_PROPERTY] = g_param_spec_boolean ("above", "above", "above", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_STICKY_PROPERTY, xnp_window_properties[XNP_WINDOW_STICKY_PROPERTY] = g_param_spec_boolean ("sticky", "sticky", "sticky", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY, xnp_window_properties[XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY] = g_param_spec_boolean ("show-refresh-button", "show-refresh-button", "show-refresh-button", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	xnp_window_signals[XNP_WINDOW_ACTION_SIGNAL] = g_signal_new ("action", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	xnp_window_signals[XNP_WINDOW_SAVE_DATA_SIGNAL] = g_signal_new ("save-data", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	xnp_window_signals[XNP_WINDOW_NOTE_INSERTED_SIGNAL] = g_signal_new ("note-inserted", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	xnp_window_signals[XNP_WINDOW_NOTE_DELETED_SIGNAL] = g_signal_new ("note-deleted", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_NOTE);
	xnp_window_signals[XNP_WINDOW_NOTE_RENAMED_SIGNAL] = g_signal_new ("note-renamed", XNP_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, XNP_TYPE_NOTE, G_TYPE_STRING);
}

static void
xnp_window_instance_init (XnpWindow * self,
                          gpointer klass)
{
	GdkDisplay* _tmp0_;
	GdkCursor* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkCursor* _tmp3_;
	GdkDisplay* _tmp4_;
	GdkCursor* _tmp5_;
	GdkDisplay* _tmp6_;
	GdkCursor* _tmp7_;
	GdkDisplay* _tmp8_;
	GdkCursor* _tmp9_;
	gchar* _tmp10_;
	self->priv = xnp_window_get_instance_private (self);
	self->priv->CORNER_MARGIN = 20;
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_cursor_new_for_display (_tmp0_, GDK_RIGHT_SIDE);
	self->priv->CURSOR_RIGHT = _tmp1_;
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_LEFT_SIDE);
	self->priv->CURSOR_LEFT = _tmp3_;
	_tmp4_ = gdk_display_get_default ();
	_tmp5_ = gdk_cursor_new_for_display (_tmp4_, GDK_BOTTOM_RIGHT_CORNER);
	self->priv->CURSOR_BOTTOM_RC = _tmp5_;
	_tmp6_ = gdk_display_get_default ();
	_tmp7_ = gdk_cursor_new_for_display (_tmp6_, GDK_BOTTOM_SIDE);
	self->priv->CURSOR_BOTTOM = _tmp7_;
	_tmp8_ = gdk_display_get_default ();
	_tmp9_ = gdk_cursor_new_for_display (_tmp8_, GDK_BOTTOM_LEFT_CORNER);
	self->priv->CURSOR_BOTTOM_LC = _tmp9_;
	_tmp10_ = g_strdup (_ ("Notes"));
	self->priv->_name = _tmp10_;
}

static void
xnp_window_finalize (GObject * obj)
{
	XnpWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_WINDOW, XnpWindow);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->mi_above);
	_g_object_unref0 (self->priv->mi_sticky);
	_g_object_unref0 (self->priv->menu_image);
	_g_object_unref0 (self->priv->menu_pixbuf);
	_g_object_unref0 (self->priv->menu_hover_pixbuf);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->refresh_button);
	_g_object_unref0 (self->priv->left_arrow_button);
	_g_object_unref0 (self->priv->right_arrow_button);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->content_box);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->ui);
	_g_object_unref0 (self->priv->action_group);
	_g_object_unref0 (self->priv->CURSOR_RIGHT);
	_g_object_unref0 (self->priv->CURSOR_LEFT);
	_g_object_unref0 (self->priv->CURSOR_BOTTOM_RC);
	_g_object_unref0 (self->priv->CURSOR_BOTTOM);
	_g_object_unref0 (self->priv->CURSOR_BOTTOM_LC);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (xnp_window_parent_class)->finalize (obj);
}

static GType
xnp_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpWindow), 0, (GInstanceInitFunc) xnp_window_instance_init, NULL };
	GType xnp_window_type_id;
	xnp_window_type_id = g_type_register_static (gtk_window_get_type (), "XnpWindow", &g_define_type_info, 0);
	XnpWindow_private_offset = g_type_add_instance_private (xnp_window_type_id, sizeof (XnpWindowPrivate));
	return xnp_window_type_id;
}

GType
xnp_window_get_type (void)
{
	static volatile gsize xnp_window_type_id__volatile = 0;
	if (g_once_init_enter (&xnp_window_type_id__volatile)) {
		GType xnp_window_type_id;
		xnp_window_type_id = xnp_window_get_type_once ();
		g_once_init_leave (&xnp_window_type_id__volatile, xnp_window_type_id);
	}
	return xnp_window_type_id__volatile;
}

static void
_vala_xnp_window_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	XnpWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_WINDOW, XnpWindow);
	switch (property_id) {
		case XNP_WINDOW_NAME_PROPERTY:
		g_value_set_string (value, xnp_window_get_name (self));
		break;
		case XNP_WINDOW_N_PAGES_PROPERTY:
		g_value_set_int (value, xnp_window_get_n_pages (self));
		break;
		case XNP_WINDOW_SHOW_TABS_PROPERTY:
		g_value_set_boolean (value, xnp_window_get_show_tabs (self));
		break;
		case XNP_WINDOW_TABS_POSITION_PROPERTY:
		g_value_set_int (value, xnp_window_get_tabs_position (self));
		break;
		case XNP_WINDOW_ABOVE_PROPERTY:
		g_value_set_boolean (value, xnp_window_get_above (self));
		break;
		case XNP_WINDOW_STICKY_PROPERTY:
		g_value_set_boolean (value, xnp_window_get_sticky (self));
		break;
		case XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY:
		g_value_set_boolean (value, xnp_window_get_show_refresh_button (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_xnp_window_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	XnpWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_WINDOW, XnpWindow);
	switch (property_id) {
		case XNP_WINDOW_NAME_PROPERTY:
		xnp_window_set_name (self, g_value_get_string (value));
		break;
		case XNP_WINDOW_N_PAGES_PROPERTY:
		xnp_window_set_n_pages (self, g_value_get_int (value));
		break;
		case XNP_WINDOW_SHOW_TABS_PROPERTY:
		xnp_window_set_show_tabs (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_TABS_POSITION_PROPERTY:
		xnp_window_set_tabs_position (self, g_value_get_int (value));
		break;
		case XNP_WINDOW_ABOVE_PROPERTY:
		xnp_window_set_above (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_STICKY_PROPERTY:
		xnp_window_set_sticky (self, g_value_get_boolean (value));
		break;
		case XNP_WINDOW_SHOW_REFRESH_BUTTON_PROPERTY:
		xnp_window_set_show_refresh_button (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

