(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Import Why.
Require Import Omega.

(*Why logic*) Definition q : Z -> Prop.
Admitted.

(* Why obligation from file "po.mlw", line 10, characters 47-51: *)
(*Why goal*) Lemma p1_po_1 : 
  forall (x: Z),
  forall (HW_1: (q (x + 1))),
  forall (x0: Z),
  forall (HW_2: x0 = (x + 1)),
  (q x0).
Proof.
intuition.
subst; trivial.
Save.

(* Why obligation from file "po.mlw", line 12, characters 44-48: *)
(*Why goal*) Lemma p2_po_1 : 
  forall (HW_1: (q 7)),
  forall (x: Z),
  forall (HW_2: x = (3 + 4)),
  (q x).
Proof.
intuition.
subst; trivial.
Save.

(* Why obligation from file "po.mlw", line 14, characters 49-59: *)
(*Why goal*) Lemma p3_po_1 : 
  forall (x0: Z),
  forall (x: Z),
  forall (HW_1: x = (x0 + 1)),
  forall (x1: Z),
  forall (HW_2: x1 = (x + 2)),
  x1 = (x0 + 3).
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 16, characters 44-50: *)
(*Why goal*) Lemma p4_po_1 : 
  forall (x: Z),
  forall (HW_1: x = 7),
  forall (x0: Z),
  forall (HW_2: x0 = (2 * x)),
  x0 = 14.
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 18, characters 22-32: *)
(*Why goal*) Lemma p5_po_1 : 
  (3 + 4) = 7.
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 20, characters 35-45: *)
(*Why goal*) Lemma p6_po_1 : 
  (3 + 4) = 7.
Proof.
intuition.
Save.



(* Why obligation from file "po.mlw", line 22, characters 41-52: *)
(*Why goal*) Lemma p7_po_1 : 
  (3 + (4 + 4)) = 11.
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 27, characters 47-71: *)
(*Why goal*) Lemma p8_po_1 : 
  forall (x: Z),
  forall (HW_1: (q (x + 1))),
  forall (x0: Z),
  forall (HW_2: x0 = (x + 1)),
  ((q x0) /\ (3 + x0) = (x + 4)).
Proof.
intuition.
subst; auto.
Save.

(* Why obligation from file "po.mlw", line 32, characters 48-68: *)
(*Why goal*) Lemma p9_po_1 : 
  forall (x: Z),
  forall (HW_1: x = 1),
  forall (x0: Z),
  forall (HW_2: x0 = 2),
  ((1 + 1) = 2 /\ x0 = 2).
Proof.
intuition.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "po.mlw", line 34, characters 41-61: *)
(*Why goal*) Lemma p9a_po_1 : 
  forall (x: Z),
  forall (HW_1: x = 1),
  ((1 + 1) = 2 /\ x = 1).
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 40, characters 25-35: *)
(*Why goal*) Lemma p10_po_1 : 
  forall (result: Z),
  forall (HW_1: result = (0 + 1)),
  result = 1.
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 42, characters 39-49: *)
(*Why goal*) Lemma p11_po_1 : 
  forall (result: Z),
  forall (HW_1: result = (0 + 1)),
  forall (result0: Z),
  forall (HW_2: result0 = (3 + 1)),
  (result + result0) = 5.
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 44, characters 45-55: *)
(*Why goal*) Lemma p11a_po_1 : 
  forall (result: Z),
  forall (HW_1: result = (1 + 1)),
  (result + result) = 4.
Proof.
intuition.
Save.



(* Why obligation from file "po.mlw", line 50, characters 38-43: *)
(*Why goal*) Lemma p12_po_1 : 
  forall (x: Z),
  forall (HW_1: x = 0),
  forall (x0: Z),
  forall (HW_2: x0 = (x + 1)),
  x0 = 1.
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 52, characters 52-62: *)
(*Why goal*) Lemma p13_po_1 : 
  forall (x0: Z),
  forall (x: Z),
  forall (HW_1: x = (x0 + 1)),
  forall (x1: Z),
  forall (HW_2: x1 = (x + 1)),
  x1 = (x0 + 2).
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 54, characters 37-47: *)
(*Why goal*) Lemma p13a_po_1 : 
  forall (x0: Z),
  forall (x: Z),
  forall (HW_1: x = (x0 + 1)),
  forall (x1: Z),
  forall (HW_2: x1 = (x + 1)),
  x1 = (x0 + 2).
Proof.
intuition.
Save.



(* Why obligation from file "po.mlw", line 60, characters 39-49: *)
(*Why goal*) Lemma p14_po_1 : 
  forall (x: Z),
  forall (HW_1: x = 0),
  forall (result: Z),
  forall (x0: Z),
  forall (HW_2: x0 = (x + 1) /\ result = x0),
  result = 1.
Proof.
intuition.
Save.

(*Why type*) Definition farray: Set ->Set.
Admitted.

(*Why logic*) Definition access : forall (A1:Set), (array A1) -> Z -> A1.
Admitted.
Implicit Arguments access.

(*Why logic*) Definition update :
  forall (A1:Set), (array A1) -> Z -> A1 -> (array A1).
Admitted.
Implicit Arguments update.

(*Why axiom*) Lemma access_update :
  forall (A1:Set),
  (forall (a:(array A1)),
   (forall (i:Z), (forall (v:A1), (access (update a i v) i) = v))).
Admitted.

(*Why axiom*) Lemma access_update_neq :
  forall (A1:Set),
  (forall (a:(array A1)),
   (forall (i:Z),
    (forall (j:Z),
     (forall (v:A1), (i <> j -> (access (update a i v) j) = (access a j)))))).
Admitted.

(*Why logic*) Definition array_length : forall (A1:Set), (array A1) -> Z.
Admitted.
Implicit Arguments array_length.

(*Why predicate*) Definition sorted_array  (t:(array Z)) (i:Z) (j:Z)
  := (forall (k1:Z),
      (forall (k2:Z),
       ((i <= k1 /\ k1 <= k2) /\ k2 <= j -> (access t k1) <= (access t k2)))).

(*Why predicate*) Definition exchange (A104:Set) (a1:(array A104)) (a2:(array A104)) (i:Z) (j:Z)
  := (array_length a1) = (array_length a2) /\
     (access a1 i) = (access a2 j) /\ (access a2 i) = (access a1 j) /\
     (forall (k:Z), (k <> i /\ k <> j -> (access a1 k) = (access a2 k))).
Implicit Arguments exchange.

(*Why logic*) Definition permut :
  forall (A1:Set), (array A1) -> (array A1) -> Z -> Z -> Prop.
Admitted.
Implicit Arguments permut.

(*Why axiom*) Lemma permut_refl :
  forall (A1:Set),
  (forall (t:(array A1)), (forall (l:Z), (forall (u:Z), (permut t t l u)))).
Admitted.

(*Why axiom*) Lemma permut_sym :
  forall (A1:Set),
  (forall (t1:(array A1)),
   (forall (t2:(array A1)),
    (forall (l:Z), (forall (u:Z), ((permut t1 t2 l u) -> (permut t2 t1 l u)))))).
Admitted.

(*Why axiom*) Lemma permut_trans :
  forall (A1:Set),
  (forall (t1:(array A1)),
   (forall (t2:(array A1)),
    (forall (t3:(array A1)),
     (forall (l:Z),
      (forall (u:Z),
       ((permut t1 t2 l u) -> ((permut t2 t3 l u) -> (permut t1 t3 l u)))))))).
Admitted.

(*Why axiom*) Lemma permut_exchange :
  forall (A1:Set),
  (forall (a1:(array A1)),
   (forall (a2:(array A1)),
    (forall (l:Z),
     (forall (u:Z),
      (forall (i:Z),
       (forall (j:Z),
        (l <= i /\ i <= u ->
         (l <= j /\ j <= u -> ((exchange a1 a2 i j) -> (permut a1 a2 l u)))))))))).
Admitted.

(*Why axiom*) Lemma exchange_upd :
  forall (A1:Set),
  (forall (a:(array A1)),
   (forall (i:Z),
    (forall (j:Z),
     (exchange a (update (update a i (access a j)) j (access a i)) i j)))).
Admitted.

(*Why axiom*) Lemma permut_weakening :
  forall (A1:Set),
  (forall (a1:(array A1)),
   (forall (a2:(array A1)),
    (forall (l1:Z),
     (forall (r1:Z),
      (forall (l2:Z),
       (forall (r2:Z),
        ((l1 <= l2 /\ l2 <= r2) /\ r2 <= r1 ->
         ((permut a1 a2 l2 r2) -> (permut a1 a2 l1 r1))))))))).
Admitted.

(*Why axiom*) Lemma permut_eq :
  forall (A1:Set),
  (forall (a1:(array A1)),
   (forall (a2:(array A1)),
    (forall (l:Z),
     (forall (u:Z),
      (l <= u ->
       ((permut a1 a2 l u) ->
        (forall (i:Z), (i < l \/ u < i -> (access a2 i) = (access a1 i))))))))).
Admitted.

(*Why predicate*) Definition permutation (A113:Set) (a1:(array A113)) (a2:(array A113))
  := (permut a1 a2 0 ((array_length a1) - 1)).
Implicit Arguments permutation.

(*Why axiom*) Lemma array_length_update :
  forall (A1:Set),
  (forall (a:(array A1)),
   (forall (i:Z),
    (forall (v:A1), (array_length (update a i v)) = (array_length a)))).
Admitted.

(*Why axiom*) Lemma permut_array_length :
  forall (A1:Set),
  (forall (a1:(array A1)),
   (forall (a2:(array A1)),
    (forall (l:Z),
     (forall (u:Z),
      ((permut a1 a2 l u) -> (array_length a1) = (array_length a2)))))).
Admitted.

(* Why obligation from file "po.mlw", line 68, characters 38-42: *)
(*Why goal*) Lemma p15_po_1 : 
  forall (t: (array Z)),
  forall (HW_1: (array_length t) = 10),
  (0 <= 0 /\ 0 < (array_length t)).
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 70, characters 38-47: *)
(*Why goal*) Lemma p16_po_1 : 
  forall (t: (array Z)),
  forall (HW_1: (array_length t) = 10),
  (0 <= 9 /\ 9 < (array_length t)).
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 72, characters 59-63: *)
(*Why goal*) Lemma p17_po_1 : 
  forall (t: (array Z)),
  forall (HW_1: (array_length t) = 10 /\ 0 <= (access t 0) /\ (access t 0) <
                10),
  (0 <= 0 /\ 0 < (array_length t)).
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 72, characters 57-69: *)
(*Why goal*) Lemma p17_po_2 : 
  forall (t: (array Z)),
  forall (HW_1: (array_length t) = 10 /\ 0 <= (access t 0) /\ (access t 0) <
                10),
  forall (HW_2: 0 <= 0 /\ 0 < (array_length t)),
  forall (result: Z),
  forall (HW_3: result = (access t 0)),
  (0 <= result /\ result < (array_length t)).
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 75, characters 28-57: *)
(*Why goal*) Lemma p18_po_1 : 
  forall (t: (array Z)),
  forall (HW_1: (array_length t) = 10),
  forall (x: Z),
  forall (HW_2: x = 0),
  (0 <= x /\ x < (array_length t)).
Proof.
intuition.
Save.

(* Why obligation from file "po.mlw", line 75, characters 61-69: *)
(*Why goal*) Lemma p18_po_2 : 
  forall (t: (array Z)),
  forall (HW_1: (array_length t) = 10),
  forall (x: Z),
  forall (HW_2: x = 0),
  forall (HW_3: 0 <= x /\ x < (array_length t)),
  forall (t0: (array Z)),
  forall (HW_4: t0 = (update t x x)),
  (access t0 0) = x.
Proof.
intuition.
subst.
rewrite access_update; auto.
Save.

