##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# http://www.morningstarsecurity.com/research/whatweb
##
# Version 0.3 # 2011-02-25 #
# Updated OS detection
##
# Version 0.2 #
# Updated version detection. Added OS extraction.
##
Plugin.define "phpSysInfo" do
author "Brendan Coles <bcoles@gmail.com>" # 2010-06-12
version "0.3"
description "PHPSysInfo is a customizable PHP Script that parses /proc, and formats information nicely. It will display information about system facts like Uptime, CPU, Memory, PCI devices, SCSI devices, IDE devices, Network adapters, Disk usage, and more. - homepage:http://phpsysinfo.sourceforge.net/"

# Google results as at 2010-06-09 #
# 16,400 for "Created by phpSysInfo"



# Matches #
matches [

# GHDB Match
{ :ghdb=>'"Created by phpSysInfo"', :certainty=>25 },

# Redirect page # Default JavaScript
{ :text=>'var sTargetURL = "index.php?disp=dynamic";' },

# Version detection # Redirect page # Generated by text
{ :version=>/Generated by[\s&nbsp;]*<a href="http:\/\/phpsysinfo.sourceforge.net[^>]*>[\s&nbsp;]*phpSysInfo[\s&nbsp;]*-[\s&nbsp;]*([^<]+)<\/a>/ },

# Version detection # Redirect page # Created by text
{ :version=>/Created by[\s&nbsp;]*<a href="http:\/\/phpsysinfo.sourceforge.net[^>]*>[\s&nbsp;]*phpSysInfo[\s&nbsp;]*-[\s&nbsp;]*([^<]+)<\/a>/ },

# Version detection # index.php?disp=static # Created by text
{ :version=>/<span>Created by <\/span><a href="http:\/\/phpsysinfo.sourceforge.net\/"><span>phpSysInfo - <\/span><span>([^<]+)<\/span>/ },

# Operating System Kernel Version Detection # phpSysInfo 3.x # index.php?disp=static
{ :os=>/<td style="width:160px; "><span>Kernel Version<\/span><\/td><td>([^<]+)<\/td><\/tr>/ },

# Operating System Detection # index.php?disp=static
{ :os=>/<td valign="top"><font size="-1">Distro Name<\/font><\/td>[\r\n\s]*<td><img[^>]+>[\s&nbsp;]*<font size="-1">([^<]+)<\/font><\/td>/ },

# Operating System Kernel Version Detection # index.php?disp=static
{ :os=>/<td valign="top"><font size="-1">Kernel Version<\/font><\/td>[\r\n\s]*<td><font size="-1">([^<]+)<\/font><\/td>/ },

]

end

