#include	<stdio.h>
#include	"vchar.h"

struct vchar vchar[256];
int depthratio;
int rdisp, ddisp, vdisp;

#define	LEN	256

readvchar(fn)
char *fn;
{
    FILE *f;
    char buf[LEN];
    int cc, jf, jc;
    struct vchar *vc;

    if ((f = fopen(fn, "r")) == NULL) {
	fprintf(stderr, "cannot open %s\n", fn);
	exit(1);
    }
    fgets(buf, LEN, f);
    depthratio = UNIT*atoi(buf)/1000;
    rdisp = UNIT-depthratio;
    ddisp = UNIT/2;
    vdisp = (UNIT/2)-depthratio;
    for (vc = vchar; fgets(buf, LEN, f) != NULL; vc++) {
	sscanf(buf, "%X", &cc);
	jf = cc>>8;
	jc = cc&0x7f;
	if (jf == 0x21) {
	    vc->f = VSY;
	    vc->c = jc-0x20;
	} else if (jf == 0x22) {
	    vc->f = VSY;
	    vc->c = jc-0x20+100;
	} else if (jf == 0x24) {
	    vc->f = VHIRA;
	    vc->c = jc-0x20;
	} else if (jf == 0x25) {
	    vc->f = VKATA;
	    vc->c = jc-0x20;
	} else {
	    fprintf(stderr, "vchar %X ignored\n", cc);
	    continue;
	}
	vc->cc = cc;
	vgetop(buf+4, vc);
    }
    vc->cc = 0;
}

vgetop(p, vc)
char *p;
struct vchar *vc;
{
    for (; *p == ' '; p++)
	;
    if (isdigit(*p)) {
	vc->op = vop_shift;
	vc->x = strtol(p, &p, 10)*UNIT/1000;
	vc->y = strtol(p, &p, 10)*UNIT/1000;
    } else if (*p == 'r') {
	vc->op = vop_rot;
	vc->x = 0;
	vc->y = 0;
    } else if (*p == 'm') {
	vc->op = vop_mirror;
	vc->x = 0;
	vc->y = 0;
    }
}
