/*
vdkb_tooldialog Form
implementation file:vdkb_tooldialog.cc
*/
#include <stdlib.h>
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif
#include <vdkb2/vdkb_tooldialog.h>
#include <vdk/FileDialog.h>
#include <vdkb2/vdkb_locale.h>
#include <vdkb2/vdkxpmbrowser.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_utils.h>
static char buff[256];
// Vdkb_tooldialog FORM  CLASS
/*
form constructor
*/
Vdkb_tooldialogForm::Vdkb_tooldialogForm(VDKForm* owner, 
					 char* title,
					 VDKString* pix,
					 VDKString* tip,
					 VDKString* text):
	VDKForm(owner,title),
	buttonpix(pix),
	buttontip(tip),
	buttontext(text)
{
}

/*
form destructor
*/
Vdkb_tooldialogForm::~Vdkb_tooldialogForm()
{
}

/*
form setup
*/
void
Vdkb_tooldialogForm::Setup(void)
{
	GUISetup(); // vdkb gui setup
	// put your code below here
	gtk_window_position(GTK_WINDOW(Window()),GTK_WIN_POS_MOUSE);
}

// signal response method 
bool
Vdkb_tooldialogForm::OnbrowseClick(VDKObject* sender)
{
  FileStringArray selections;
  VDKXpmBrowser *child = new VDKXpmBrowser(Owner(),&selections,
					   _(file_dialog_prompts[0]));
  child->ShowModal();
  if(selections.size() > 0)
    {
      pixfile->Text = (char*) selections[0];
      copytodir->Enabled = true;
    }
  return true;
}

// signal response method 
bool
Vdkb_tooldialogForm::OnCopyToDir(VDKObject* sender)
{
  VDKString s = (char*) pixfile->Text;
  VDKString path;
  VDKBProject* project;
  VDKBProjectManager* prjman = 
    dynamic_cast<VDKBProjectManager*>(Owner()->Owner());
      if(prjman)
	{
	  project = prjman->Project();
	  if(!project)
	    return true; 
	  path = project->Path;
	  sprintf(buff,"cp %s %s/",(char*) s, (char*) path);
	  system(buff);
	  char* p = get_shortfilename((char*) s);
	  if(p)
	    {
	      VDKString short_name = p;
	      pixfile->Text = (char*) short_name;
	      copytodir->Enabled = false;
	    }
	}
return true;
}

// signal response method 
bool
Vdkb_tooldialogForm::OnpixfileActivate(VDKObject* sender)
{
return true;
}

// signal response method 
bool
Vdkb_tooldialogForm::OntipActivate(VDKObject* sender)
{
return true;
}

// signal response method 
bool
Vdkb_tooldialogForm::OntextActivate(VDKObject* sender)
{
return true;
}

// signal response method 
bool
Vdkb_tooldialogForm::OnokClick(VDKObject* sender)
{
  if(strlen(pixfile->Text) > 0)
    *buttonpix = (char*) pixfile->Text;
  else
    *buttonpix = NIHIL_PROP;
  if(strlen(tip->Text) > 0)
    *buttontip = (char*) tip->Text;
  else
    *buttontip = NIHIL_PROP;
  if(strlen(text->Text) > 0)
    *buttontext = (char*) text->Text;
  else
    *buttontext = NIHIL_PROP;
  Close();
  return true;
}

// signal response method 
bool
Vdkb_tooldialogForm::OncancelClick(VDKObject* sender)
{
*buttonpix = "";
Close();
return true;
}
