/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_evcontain.h>
//#include <vdkb2/vdkb_labelbutton.h>
#include <vdkb2/vdkb_form.h>
#include <vdk/vdk.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_objinspect.h>
#include <stdlib.h>
#include <vdkb2/vdkb_menubar.h>
#include <vdkb2/vdkb_menuitem.h>
#include <vdkb2/vdkb_fixed.h>
#include <vdkb2/vdkb_orderdlg.h>
extern char* wi_widget_prompts[];
static char buff[128];
int VDKBMenubar::Counter = 0;

DEFINE_EVENT_LIST(VDKBMenubar,VDKBEventContainer);
DEFINE_SIGNAL_LIST(VDKBMenubar,VDKBEventContainer);

static char *shadows[] =
{
"shadow_none","shadow_in","shadow_out","shadow_etched_in",
"shadow_etched_out",0
};

char* vdkmenubar_props[] =
{
SHADOW, 0
};

/*
 */
bool
VDKBMenubar:: DelBox(VDKObject* sender)
{
  // destroy inner gtk+ placeholder widget
  gtk_widget_destroy(container);
  // call ancestor delete box
  VDKBEventContainer::DelBox(sender);
  // notify to inspector that object was deleted
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(NULL);
    }
return true;
}

/*
 */
bool
VDKBMenubar::SetBoxSize(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
      ownerform->SetBoxSize(NULL);
  return true;
}
/*
we use a little trick here:
since VDKBMenuItem::MakeWidget(ownerform, GdkEvent* = NULL)
we use (GdkEvent*) l_justify or r_justify or pos_justify+<x>
in order to appen,prepend or inser a menu item into menubar.
 */
bool
VDKBMenubar::AddMenuItem(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      GdkEventButton event;
      event.state =  l_justify;
      VDKBMenuItem::MakeWidget(ownerform, (GdkEvent*) &event);
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	{
	  prjman->objInspector->LoadTree(ownerform);
	  ownerform->Changed = true;
	}
    }
  return true;
}
bool
VDKBMenubar::PrependMenuItem(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      GdkEventButton event;
      event.state =  r_justify;
      VDKBMenuItem::MakeWidget(ownerform, (GdkEvent*) &event);
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	{
	  prjman->objInspector->LoadTree(ownerform);
	  ownerform->Changed = true;
	}
    }
  return true;
}
bool
VDKBMenubar::InsertMenuItem(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      // widget reorder dialog will receive
      // boxlist address and an int* to fill
      // with inserting pos (answer < 0 if user cancelled)
      int pos = -1;
      Vdkb_reorderdlgForm* child =
	new Vdkb_reorderdlgForm(ownerform,
				&boxlist,
				&pos,
				NULL);
      child->Setup();
      child->ShowModal(GTK_WIN_POS_MOUSE);
      if(pos > 0)
	{
	  GdkEventButton event;
	  event.state =  pos_justify+pos;
	  VDKBMenuItem::MakeWidget(ownerform,(GdkEvent*) &event);
	  VDKBProjectManager* prjman =
	    dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
	  if(prjman && prjman->objInspector)
	    {
	      prjman->objInspector->LoadTree(ownerform);
	      ownerform->Changed = true;
	    }
	}
    }
  return true;
}
/*
 */
bool
VDKBMenubar::OnButtonPressed(VDKObject* sender, GdkEvent* event)
{
  // pass to ancestor so widget will be marked
  VDKBEventContainer::OnButtonPressed(this,event);
  return false;// true;
}
//===========================================
/*
 */
VDKBMenubar::VDKBMenubar(char* name, VDKForm* owner):
  VDKBEventContainer(name,owner)
{
  Counter++;
  VDKBObject::object = this;
  Init();
}

/*
 */
VDKBMenubar::VDKBMenubar(char* name,VDKBEventContainer* outer):
    VDKBEventContainer(name,outer->Owner())
{
  Counter++;
  VDKBObject::object = this;
  outerbox = outer;
  Init();
 }
/*
 */
void
VDKBMenubar::Init()
{
  int t;
  // FIX ME: lang support
  // add  frame properties
  // names. (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkmenubar_props[t]; t++)
    proplist.add(VDKBProperty(vdkmenubar_props[t]));
  AddBox();
  // makes a pop menu
  popmenu = new VDKMenu(Owner());
  VDKMenuItem* nope =  new VDKMenuItem(popmenu,"Nop");
  nope->Enabled = false;
  popmenu->Separator();
  addmenuitem = new VDKMenuItem(popmenu,_("Append a menu item"));
  prependmenuitem = new VDKMenuItem(popmenu,_("Prepend a menu item"));
  insertmenuitem = new VDKMenuItem(popmenu,_("Insert a menu item"));
  popmenu->Separator();

  setsize = new VDKMenuItem(popmenu,_(wi_widget_prompts[19]));
  popmenu->Separator();

  delBox = new VDKMenuItem(popmenu,_("Remove menubar"));
  SignalConnect(delBox,"activate",&VDKBMenubar::DelBox);
  SignalConnect(setsize,"activate",&VDKBMenubar::SetBoxSize);
  SignalConnect(addmenuitem,"activate",&VDKBMenubar::AddMenuItem);
  SignalConnect(prependmenuitem,"activate",&VDKBMenubar::PrependMenuItem);
  SignalConnect(insertmenuitem,"activate",&VDKBMenubar::InsertMenuItem);
  EventConnect("button_press_event",
	       &VDKBMenubar::OnButtonPressed/*,true*/);
  /* assign this as parent so this can receive signals  */
  popmenu->Parent(this);
  /*
    better add it to owner, so will be surely
    destroyed even if never popped
  */
  Owner()->AddItem(popmenu);
}
/*
 */
void
VDKBMenubar::AddBox()
{
  widget = sigwid = container = gtk_menu_bar_new();
  gtk_widget_set_size_request(widget,-1,30);
  gtk_widget_show(container);
}

/*
this will be called only
by menubar with wid==NULL
Does not call VDKBObjectContainer since
is not a VDKContainer.
 */
void
VDKBMenubar::AddWidget(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  VDKMenuItem* menuitem = dynamic_cast<VDKMenuItem*>(wid);
  if(menuitem)
    {
      if(justify >= pos_justify)
	{
	  gtk_menu_shell_insert(GTK_MENU_SHELL(container),
			      wid->Widget(),
			      justify-pos_justify);
	  boxlist.insertAt(wid,justify-pos_justify);
	}
      else
	{
	  switch(justify)
	    {
	    case r_justify:
	      gtk_menu_shell_prepend(GTK_MENU_SHELL(container),wid->Widget());
	      boxlist.addH(wid);
	      break;
	    case l_justify:
	    default:
	      gtk_menu_shell_append(GTK_MENU_SHELL(container),wid->Widget());
	      boxlist.add(wid);
	    }
	}
      VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
      if(ownerform)
	ownerform->Changed = true;
      items.add(wid);
      wid->Parent(this);
      gtk_widget_show(wid->Widget());
    }
  else
    ; // FIX ME: warn user

}
/*
extra args used
 */
void
VDKBMenubar::Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
AddWidget(wid);
}
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
  4 - unuseful call
*/
int
VDKBMenubar::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable frame counter
  // to ensure unicity
  int result = 0;
  for(sprintf(buff,"Menubar%d",VDKBMenubar::Counter);
      owner->ChildWithName(buff)!= (VDKObject*) NULL;
      VDKBMenubar::Counter++)
    sprintf(buff,"Menubar%d",VDKBMenubar::Counter);
  VDKBMenubar* box = new VDKBMenubar(buff,owner);
  if(owner->Active)
    {
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  VDKBMenubar* parentbox = dynamic_cast<VDKBMenubar*>(container);
	  if(!parentbox)
	    {
	      // fixed not allowed to have menu
	      if(ev && dynamic_cast<VDKBFixed*>(container))
		result = 2;
	      else
		container->AddWidget(box);
	      box->outerbox = container;
	    }
	  else
	    // unuseful call to put a container into an empty container;
	      result =  4;
	}
      else
	// target isn't a container
	  result =  2;
    }
  else
    // no active widget
    result = 3;
  // 0 on success
  if(result)
    box->Destroy();
 return result;
}
////////////////////////////////////////////////////////////////////
/*
 */
void
VDKBMenubar::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBEventContainer::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;", PROP_SHADOW,(char*) GetProp(SHADOW));
}

char*
VDKBMenubar::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char temp[256];
  char arg[128];
  char bw[16];
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  else
    source = new char[1024];
  sprintf(temp,"\n%s = new VDKMenubar(this);" ,obj_name);
  strcpy(source,temp);
  // get size
  VDKPoint size = parser.Size(buffer);
  if(size.X() > 0 || size.Y() > 0)
    {
      sprintf(temp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
      strcat(source,temp);
    }
  if(strcmp(obj_parent,NIHIL_PROP))
    sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
  else
    sprintf(temp,"\nAdd(%s",obj_name);
  strcat(source,temp);
  // prepares arguments for add widget to container
  char justify[16],expand[16],fill[16],padding[16];
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(temp,",%s,%s,%s,%s);",
	      justify,expand,fill,padding);
      strcat(source,temp);
    }
  else
    {
      sprintf(temp,");");
      strcat(source,temp);
    }
  // get border
    if(parser.GetParam(bw,buffer,PROP_BORDERWIDTH) &&
     strcmp(bw,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->BorderWidth(%s);",obj_name,bw);
      strcat(source,temp);
    }
  // get shadow
  if(parser.GetParam(arg,buffer,PROP_SHADOW) && strcmp(arg,NIHIL_PROP))
    {
      int ndx = atoi(arg);
      ndx = (ndx >= 0) && (ndx <= 4) ? ndx : 0;
      sprintf(temp,"\n%s->Shadow = %s;", obj_name,shadows[ndx]);
      strcat(source,temp);
    }
  return source;
}
/*
 */
bool
VDKBMenubar::CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  int bw; // border width
  // packing args
  int justification = l_justify;
  int expand=0,fill=0,padding=0;
  char arg[32];
  VDKBMenubar* box;
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return false;
  // get mode and size
  VDKPoint size = parser.Size(buffer);
  if(parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL))
    justification = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL))
    expand  = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL))
    fill = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_PADDING_INTERNAL))
    padding = atoi(arg);
 if(parser.GetParam(arg,buffer,PROP_BORDERWIDTH) &&
     strcmp(arg,NIHIL_PROP))
    bw = atoi(arg);
  else
    bw = -1;
  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
    {
      box = new VDKBMenubar(obj_name,owner->InnerBox());
      owner->AddWidget(box,justification,expand,fill,padding);
    }
  // get parent container address
  else
    {
      VDKObject* p = owner->ChildWithName(obj_parent);
      VDKBEventContainer* container = p ?
	dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
      if(container)
	{
	  box = new VDKBMenubar(obj_name,container);
	  container->AddWidget(box,justification,expand,fill,padding,true);
	  box->outerbox = container;
	}
      else
	// FIX ME: user warning
	return false;
    }
  // call ancestor to set common properties
  VDKBObject::CreateWidget(box,buffer,parser);
  if(size.X() > 0 || size.Y() > 0)
    box->ObjectFromVDK()->SetSize(size.X(),size.Y());
  if(bw >= 0)
    {
      char local[16];
      box->BorderWidth(bw);
      sprintf(local,"%d",bw);
      box->SetPropValue(BORDERWIDTH,local);
    }
   // shadow
  if(parser.GetParam(arg,buffer,PROP_SHADOW) &&
     strcmp(arg,NIHIL_PROP))
    {
      box->SetPropValue(SHADOW,arg);
      // int sh = atoi(arg);
      /*
      gtk_menu_bar_set_shadow_type(GTK_MENU_BAR(box->container),
				(GtkShadowType) sh);
      */
    }
return true;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
This is called by object inspector when a widget
is selected by user, thus to allow widget to set
his own property controls.
 */

VDKObjectContainer*
VDKBMenubar::ExtraWidget(VDKBObjectInspector* isp)
{
  VDKBox* xframe = dynamic_cast<VDKBox*>(VDKBEventContainer::ExtraWidget(isp));
  if(!xframe)
    return NULL;
  // shadow
  /*
  VDKTable *table = new VDKTable(inspector,1,2);
  table->SetSize(219,-1);
  set = new VDKCustomButton(inspector,_(wi_widget_prompts[40]));
  table->AddToCell(set,0,0);
  set->Parent(this);
  SignalConnect(set,"clicked",&VDKBMenubar::OnSetShadow);

  shadow = new VDKCombo(inspector,NULL);
  StringList sl;
  int t = 0;
  for(;shadows[t];t++)
    sl.add(VDKString(shadows[t]));
  shadow->PopdownStrings = sl;
  table->AddToCell(shadow,0,1);
  shadow->SetSize(100,-1);
  int r = atoi(GetProp(SHADOW));
  shadow->SelectItem(r);
  xframe->Add(table,l_justify,false,false,false);
  */
  else
    return xframe;
}
/*
 */
bool
VDKBMenubar:: OnSetShadow(VDKObject*)
{
  int sel = shadow->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  SetPropValue(SHADOW,buff);
  // int shd = atoi(buff);
  // gtk_menu_bar_set_shadow_type(GTK_MENU_BAR(container),(GtkShadowType) shd);
  inspector->FormNeedToBeChanged();
  return true;
}




