/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/radiobtngroup.h"
#include "vdk/forms.h"
#include <cstring>
static int defaultFlag = 0; // stop emit if raised

void VDKRadioButtonGroup::ToggleEvent(GtkWidget *wid, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKRadioButton* buttonToggled  = 
    reinterpret_cast<VDKRadioButton*> (gp);

  VDKRadioButtonGroup* group = buttonToggled->Group();
  int t = 0;
  int toggled = -1;
   if(defaultFlag)
    {
      defaultFlag--;
      return;
    }
  RadioButtonListIterator li(group->Buttons); 
  for(;li;li++,t++)
    {
      if(li.current() == buttonToggled)
	{
	toggled = t;
	break;
	}
    }
  if(toggled < 0)
    return;
  bool active = GTK_TOGGLE_BUTTON(wid)->active ? true : false;
  buttonToggled->Checked(active);
  if(active)
    {
      group->Selected(toggled);
      group->SignalEmit(toggled_signal);
      group->SignalEmit("toggled");
    }
}
/*
 */
VDKRadioButton::VDKRadioButton( VDKRadioButtonGroup* group, 
			       char* label):
  VDKCheckButton(group->Owner(),label),rbgroup(group)
{
  gtk_signal_disconnect(GTK_OBJECT(widget),connectId);
  gtk_widget_destroy(widget);
  /*
  if(! rbgroup->GsGroup())
    {
      widget = gtk_radio_button_new_with_label(NULL,label);
      rbgroup->GsGroup(gtk_radio_button_group(GTK_RADIO_BUTTON(widget)));
    }
  else 
    {
      // GtkWidget* wid  = rbgroup->Buttons[rbgroup->Buttons.size()-1]->Widget();
      widget = gtk_radio_button_new_with_label(rbgroup->GsGroup(),label);
      rbgroup->GsGroup(gtk_radio_button_group(GTK_RADIO_BUTTON(widget))); 
    }
  */ 
  widget = 
    gtk_radio_button_new_with_label(
				    rbgroup->GsGroup() ? 
				    rbgroup->GsGroup() : NULL,
				    label);
  rbgroup->GsGroup(gtk_radio_button_group(GTK_RADIO_BUTTON(widget))); 
  
  gtk_signal_connect(GTK_OBJECT(widget),"toggled",
		     GTK_SIGNAL_FUNC(VDKRadioButtonGroup::ToggleEvent),
		     (gpointer) this);
  rbgroup->GBox()->Add(this);
  rbgroup->Buttons.add(this); 
}


/*
 */
VDKRadioButton::VDKRadioButton(VDKForm* owner,char* label):
  VDKCheckButton(owner,label),rbgroup(NULL)
{
}

/*
 */
void 
VDKRadioButtonGroup::Add(VDKObject* obj, int , int , int , int )
{
  char* label;
  VDKRadioButton* radiobutton = dynamic_cast<VDKRadioButton*>(obj);
  g_return_if_fail(radiobutton != NULL);
  label = new char[std::strlen(((char*)radiobutton->Caption))+1];
  std::strcpy(label,(char*)radiobutton->Caption);
  gtk_signal_disconnect(GTK_OBJECT(radiobutton->widget),
			radiobutton->connectId);
  gtk_widget_destroy(radiobutton->widget);
  radiobutton->widget = 
    gtk_radio_button_new_with_label( gs_group ? gs_group : NULL,label);
  gs_group = gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton->widget)); 
  gtk_signal_connect(GTK_OBJECT(radiobutton->widget),"toggled",
		     GTK_SIGNAL_FUNC(VDKRadioButtonGroup::ToggleEvent),
		     (gpointer) radiobutton);
  box->Add(radiobutton);
  Buttons.add(radiobutton); 
  radiobutton->Group(this);
  delete label;
}
/* 
 */
VDKRadioButtonGroup::VDKRadioButtonGroup(VDKForm* owner, 
					 int mode):
  VDKObjectContainer(owner),
  Selected(
	   "Selected",
	   this,
	   0, 
	   &VDKRadioButtonGroup::SetSelected
	   ),
  ButtonList("ButtonList",this,NULL)
{
box = new VDKEventBox(owner,mode);
widget = box->Widget(); 
owner->Objects().add(box);
gs_group = NULL; 
ButtonList(&Buttons);   
}
/*
 */
void
VDKRadioButtonGroup::RemoveButton(VDKRadioButton* button)
{
if(Buttons.remove(button))
  {
    button->Visible = false;
    if(Buttons.size() <= 0)
      gs_group = NULL;
    if (GTK_WIDGET_VISIBLE (widget))
      gtk_widget_queue_resize (GTK_WIDGET (widget));
  }
}
/* 
 */ 
void VDKRadioButtonGroup::SetDefault(int bn)
{
if(bn >= 0 && bn < Buttons.size())
  {
    defaultFlag+=2; // deny "toggled" signal processing
    GtkWidget* wid = Buttons[bn]->Widget();
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(wid),TRUE);
    Selected(bn);
  }
}

void VDKRadioButtonGroup::SetSelected(int index)
{ 
  if(index >= 0 && index < Buttons.size())
    Buttons[index]->Checked = true; 
}










