import parser
import os

_TEST_DATA_FILES = [
    "./tests/data/parser-data-1"
]

def get_callback_typedefs (parsed_data):
    return [parsed_datum for parsed_datum in parsed_data if parsed_datum['type'] == 'func_typedef' and parsed_datum['name'][1].endswith('Callback')]

def get_function_defs (parsed_data):
    return [parsed_datum for parsed_datum in parsed_data if parsed_datum['type'] == 'func_decl']

for testdata in _TEST_DATA_FILES:
    result = parser.parse (open(testdata).read())
    test_result = []
    func_defs = get_function_defs(result)
    for func_def in func_defs:
        test_result.append(func_def['name'][1])
    cb_defs = get_callback_typedefs(result)
    for cb_def in cb_defs:
        test_result.append(cb_def['name'][1])
    if not "\n".join(test_result).strip() == open(testdata + ".result").read().strip():
        print "failed test:", testdata,", got: ", "\n".join(test_result)

