package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDemand invokes the ecs.ModifyDemand API synchronously
func (client *Client) ModifyDemand(request *ModifyDemandRequest) (response *ModifyDemandResponse, err error) {
	response = CreateModifyDemandResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDemandWithChan invokes the ecs.ModifyDemand API asynchronously
func (client *Client) ModifyDemandWithChan(request *ModifyDemandRequest) (<-chan *ModifyDemandResponse, <-chan error) {
	responseChan := make(chan *ModifyDemandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDemand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDemandWithCallback invokes the ecs.ModifyDemand API asynchronously
func (client *Client) ModifyDemandWithCallback(request *ModifyDemandRequest, callback func(response *ModifyDemandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDemandResponse
		var err error
		defer close(result)
		response, err = client.ModifyDemand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDemandRequest is the request struct for api ModifyDemand
type ModifyDemandRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	StartTime            string           `position:"Query" name:"StartTime"`
	DemandDescription    string           `position:"Query" name:"DemandDescription"`
	InstanceType         string           `position:"Query" name:"InstanceType"`
	InstanceChargeType   string           `position:"Query" name:"InstanceChargeType"`
	DemandName           string           `position:"Query" name:"DemandName"`
	Amount               requests.Integer `position:"Query" name:"Amount"`
	Period               requests.Integer `position:"Query" name:"Period"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PeriodUnit           string           `position:"Query" name:"PeriodUnit"`
	DemandId             string           `position:"Query" name:"DemandId"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
}

// ModifyDemandResponse is the response struct for api ModifyDemand
type ModifyDemandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDemandRequest creates a request to invoke ModifyDemand API
func CreateModifyDemandRequest() (request *ModifyDemandRequest) {
	request = &ModifyDemandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyDemand", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDemandResponse creates a response to parse from ModifyDemand response
func CreateModifyDemandResponse() (response *ModifyDemandResponse) {
	response = &ModifyDemandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
