# String functions

## GENERAL

Functions in this family are used to create and manipulate NASL strings.

## TABLE OF CONTENT

- **[chomp](chomp.md)** - removes trailing whitespaces from a string
- **[crap](crap.md)** - fill a string of desired length with given pattern
- **[display](display.md)** - display any number of NASL values
- **[hex](hex.md)** - converts an integer into a hexadecimal number
- **[hexstr](hexstr.md)** - converts a string into a hexadecimal representation
- **[insstr](insstr.md)** - insert a string into another string, replacing the substring given with indices
- **[int](int.md)** - converts a given argument into an integer
- **[match](match.md)** - matches a string against a simple shell-like pattern
- **[ord](ord.md)** - get the ASCII code of the first character of a given string
- **[raw_string](raw_string.md)** - transforms any input into a string
- **[split](split.md)** - split a string into parts
- **[strcat](strcat.md)** - concatenate given values
- **[stridx](stridx.md)** - lookup the position of a substring within a string
- **[string](string.md)** - concatenate given values
- **[strlen](strlen.md)** - get the length of a string
- **[str_replace](str_replace.md)** - replace a substring within a string
- **[strstr](strstr.md)** - finds the first occurrence of a sub-string within a string
- **[substr](substr.md)** - get a slice out of a string
- **[tolower](tolower.md)** - converts a string to lower case
- **[toupper](toupper.md)** - converts a string to upper case
