// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TopoDS_TShape_HeaderFile
#define _TopoDS_TShape_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_TopoDS_TShape.hxx>

#include <TopoDS_ListOfShape.hxx>
#include <Standard_Integer.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_Boolean.hxx>
#include <TopAbs_ShapeEnum.hxx>
class Standard_ConstructionError;
class TopoDS_Iterator;
class TopoDS_Builder;
class TopoDS_ListOfShape;


//! A TShape  is a topological  structure describing a
//! set of points in a 2D or 3D space.
//!
//! A topological shape is a structure made from other
//! shapes.  This is a deferred class  used to support
//! topological objects.
//!
//! TShapes are   defined   by  their  optional domain
//! (geometry)  and  their  components  (other TShapes
//! with  Locations and Orientations).  The components
//! are stored in a List of Shapes.
//!
//! A   TShape contains  the   following boolean flags :
//!
//! - Free       : Free or Frozen.
//! - Modified   : Has been modified.
//! - Checked    : Has been checked.
//! - Orientable : Can be oriented.
//! - Closed     : Is closed.
//! - Infinite   : Is infinite.
//! - Convex     : Is convex.
//!
//! Users have no direct access to the classes derived
//! from TShape.  They  handle them with   the classes
//! derived from Shape.
class TopoDS_TShape : public MMgt_TShared
{

public:

  
  //! Returns the free flag.
      Standard_Boolean Free()  const;
  
  //! Sets the free flag.
      void Free (const Standard_Boolean F) ;
  
  //! Returns the locked flag.
      Standard_Boolean Locked()  const;
  
  //! Sets the locked flag.
      void Locked (const Standard_Boolean F) ;
  
  //! Returns the modification flag.
      Standard_Boolean Modified()  const;
  
  //! Sets the modification flag.
      void Modified (const Standard_Boolean M) ;
  
  //! Returns the checked flag.
      Standard_Boolean Checked()  const;
  
  //! Sets the checked flag.
      void Checked (const Standard_Boolean C) ;
  
  //! Returns the orientability flag.
      Standard_Boolean Orientable()  const;
  
  //! Sets the orientability flag.
      void Orientable (const Standard_Boolean C) ;
  
  //! Returns the closedness flag.
      Standard_Boolean Closed()  const;
  
  //! Sets the closedness flag.
      void Closed (const Standard_Boolean C) ;
  
  //! Returns the infinity flag.
      Standard_Boolean Infinite()  const;
  
  //! Sets the infinity flag.
      void Infinite (const Standard_Boolean C) ;
  
  //! Returns the convexness flag.
      Standard_Boolean Convex()  const;
  
  //! Sets the convexness flag.
      void Convex (const Standard_Boolean C) ;
  
  //! Returns the type as a term of the ShapeEnum enum :
  //! VERTEX, EDGE, WIRE, FACE, ....
  Standard_EXPORT virtual   TopAbs_ShapeEnum ShapeType()  const = 0;
  
  //! Returns a copy  of the  TShape  with no sub-shapes.
  Standard_EXPORT virtual   Handle(TopoDS_TShape) EmptyCopy()  const = 0;


friend class TopoDS_Iterator;
friend class TopoDS_Builder;


  DEFINE_STANDARD_RTTI(TopoDS_TShape)

protected:

  
  //! Constructs an empty TShape.
  //! Free       : True
  //! Modified   : True
  //! Checked    : False
  //! Orientable : True
  //! Closed     : False
  //! Infinite   : False
  //! Convex     : False
    TopoDS_TShape();



private: 

  
     const  TopoDS_ListOfShape& Shapes()  const;
  
      TopoDS_ListOfShape& ChangeShapes() ;

  TopoDS_ListOfShape myShapes;
  Standard_Integer myFlags;


};


#include <TopoDS_TShape.lxx>





#endif // _TopoDS_TShape_HeaderFile
