[comment {-*- tcl -*- doctools}]
[vset FORMATNAME png]
[vset FORMATFULLNAME {Portable Network Graphics format}]

[include format-header.inc]

This handler provides new additional configuration options. See
section [sectref {PNG OPTIONS}] for more detailed explanations.


[include format-middle.inc]


In addition the value for the option is treated as list and may
contain any of the special options listed in section

[sectref {PNG OPTIONS}].

[list_end]



[section {PNG OPTIONS}]

The handler provides the following options:

[list_begin definitions]

[lst_item "[option -matte] [arg bool]"]

This option is supported for reading only.
[nl]
If set to [const false], a matte (alpha) channel is ignored
during reading or writing. Default is [const true].


[lst_item "[option -alpha] [arg float]"]

This option is supported for reading only.
[nl]
An additional alpha filtering for the overall image, which
allows the background on which the image is displayed to show through.
This usually also has the effect of desaturating the image.
The alphaValue must be between 0.0 and 1.0. 
Specifying an alpha value, overrides the setting of the matte flag,
i.e. reading a file which has no alpha channel (Greyscale, RGB) will
add an alpha channel to the image independent of the matte flag setting.

[list_end]

The handler provides no true write options at all, but accepts pairs of keys
and values when writing a PNG file. Each pair will be written as a
named text chunk where the key provides the name of the chunk and the
value its contents.

For example

[example {
    png Author <name> Title <title> Description ...
}]


[section TRANSPARENCY]

If you want to write images to disk which contain transparency
information (e.g. PNG with alpha channel) you need at least

[package Tk] 8.3.



[list_begin definitions]
[include format-footer.inc]
