/* ui-launcher-editor-dialog.c generated by valac 0.10.4, the Vala compiler
 * generated from ui-launcher-editor-dialog.vala, do not modify */

/*
 * Desktop Agnostic Library: Icon chooser dialog.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <build-config.h>
#include <gtk/gtk.h>
#include <libdesktop-agnostic/vfs.h>
#include <libdesktop-agnostic/fdo.h>
#include <glib/gi18n-lib.h>


#define DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE (desktop_agnostic_ui_fixed_table_get_type ())
#define DESKTOP_AGNOSTIC_UI_FIXED_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE, DesktopAgnosticUIFixedTable))
#define DESKTOP_AGNOSTIC_UI_FIXED_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE, DesktopAgnosticUIFixedTableClass))
#define DESKTOP_AGNOSTIC_UI_IS_FIXED_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE))
#define DESKTOP_AGNOSTIC_UI_IS_FIXED_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE))
#define DESKTOP_AGNOSTIC_UI_FIXED_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE, DesktopAgnosticUIFixedTableClass))

typedef struct _DesktopAgnosticUIFixedTable DesktopAgnosticUIFixedTable;
typedef struct _DesktopAgnosticUIFixedTableClass DesktopAgnosticUIFixedTableClass;
typedef struct _DesktopAgnosticUIFixedTablePrivate DesktopAgnosticUIFixedTablePrivate;

#define DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG (desktop_agnostic_ui_launcher_editor_dialog_get_type ())
#define DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG, DesktopAgnosticUILauncherEditorDialog))
#define DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG, DesktopAgnosticUILauncherEditorDialogClass))
#define DESKTOP_AGNOSTIC_UI_IS_LAUNCHER_EDITOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG))
#define DESKTOP_AGNOSTIC_UI_IS_LAUNCHER_EDITOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG))
#define DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG, DesktopAgnosticUILauncherEditorDialogClass))

typedef struct _DesktopAgnosticUILauncherEditorDialog DesktopAgnosticUILauncherEditorDialog;
typedef struct _DesktopAgnosticUILauncherEditorDialogClass DesktopAgnosticUILauncherEditorDialogClass;
typedef struct _DesktopAgnosticUILauncherEditorDialogPrivate DesktopAgnosticUILauncherEditorDialogPrivate;

#define DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON (desktop_agnostic_ui_icon_button_get_type ())
#define DESKTOP_AGNOSTIC_UI_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON, DesktopAgnosticUIIconButton))
#define DESKTOP_AGNOSTIC_UI_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON, DesktopAgnosticUIIconButtonClass))
#define DESKTOP_AGNOSTIC_UI_IS_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON))
#define DESKTOP_AGNOSTIC_UI_IS_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON))
#define DESKTOP_AGNOSTIC_UI_ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_UI_TYPE_ICON_BUTTON, DesktopAgnosticUIIconButtonClass))

typedef struct _DesktopAgnosticUIIconButton DesktopAgnosticUIIconButton;
typedef struct _DesktopAgnosticUIIconButtonClass DesktopAgnosticUIIconButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DesktopAgnosticUIFixedTable {
	GtkTable parent_instance;
	DesktopAgnosticUIFixedTablePrivate * priv;
};

struct _DesktopAgnosticUIFixedTableClass {
	GtkTableClass parent_class;
};

struct _DesktopAgnosticUILauncherEditorDialog {
	GtkDialog parent_instance;
	DesktopAgnosticUILauncherEditorDialogPrivate * priv;
};

struct _DesktopAgnosticUILauncherEditorDialogClass {
	GtkDialogClass parent_class;
};

struct _DesktopAgnosticUILauncherEditorDialogPrivate {
	GtkComboBox* _type_combo;
	DesktopAgnosticUIIconButton* _icon;
	GtkEntry* _name;
	GtkEntry* _desc;
	GtkEntry* _exec;
	GtkExpander* _advanced;
	GtkCheckButton* _terminal;
	GtkCheckButton* _startup_notification;
	GtkLabel* _command_label;
	DesktopAgnosticVFSFile* _file;
	DesktopAgnosticVFSFile* _output;
	gboolean _entry_type_sensitive;
	DesktopAgnosticFDODesktopEntry* _entry;
};


static gpointer desktop_agnostic_ui_fixed_table_parent_class = NULL;
static gpointer desktop_agnostic_ui_launcher_editor_dialog_parent_class = NULL;

#define LAUNCHER_I18N_PACKAGE GETTEXT_PACKAGE
GType desktop_agnostic_ui_fixed_table_get_type (void) G_GNUC_CONST;
enum  {
	DESKTOP_AGNOSTIC_UI_FIXED_TABLE_DUMMY_PROPERTY
};
DesktopAgnosticUIFixedTable* desktop_agnostic_ui_fixed_table_new (guint columns, guint rows);
DesktopAgnosticUIFixedTable* desktop_agnostic_ui_fixed_table_construct (GType object_type, guint columns, guint rows);
void desktop_agnostic_ui_fixed_table_attach_defaults (DesktopAgnosticUIFixedTable* self, GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach);
void desktop_agnostic_ui_fixed_table_attach_fill (DesktopAgnosticUIFixedTable* self, GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach);
void desktop_agnostic_ui_fixed_table_attach_expand (DesktopAgnosticUIFixedTable* self, GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach);
GType desktop_agnostic_ui_launcher_editor_dialog_get_type (void) G_GNUC_CONST;
GType desktop_agnostic_ui_icon_button_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG, DesktopAgnosticUILauncherEditorDialogPrivate))
enum  {
	DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_FILE,
	DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_OUTPUT,
	DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_ENTRY_TYPE_SENSITIVE
};
DesktopAgnosticUILauncherEditorDialog* desktop_agnostic_ui_launcher_editor_dialog_new (DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* output, gboolean entry_type_sensitive);
DesktopAgnosticUILauncherEditorDialog* desktop_agnostic_ui_launcher_editor_dialog_construct (GType object_type, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* output, gboolean entry_type_sensitive);
static void desktop_agnostic_ui_launcher_editor_dialog_real_constructed (GObject* base);
DesktopAgnosticVFSFile* desktop_agnostic_ui_launcher_editor_dialog_get_file (DesktopAgnosticUILauncherEditorDialog* self);
static void desktop_agnostic_ui_launcher_editor_dialog_build_ui (DesktopAgnosticUILauncherEditorDialog* self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_response (DesktopAgnosticUILauncherEditorDialog* self, gint response_id);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
DesktopAgnosticUIIconButton* desktop_agnostic_ui_icon_button_new (const char* icon);
DesktopAgnosticUIIconButton* desktop_agnostic_ui_icon_button_construct (GType object_type, const char* icon);
static void desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticUIIconButton* button);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed_desktop_agnostic_ui_icon_button_icon_selected (DesktopAgnosticUIIconButton* _sender, gpointer self);
gboolean desktop_agnostic_ui_launcher_editor_dialog_get_entry_type_sensitive (DesktopAgnosticUILauncherEditorDialog* self);
static void _lambda1_ (DesktopAgnosticUILauncherEditorDialog* self);
static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_type_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkComboBox* combo);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_type_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_name_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_name_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse (DesktopAgnosticUILauncherEditorDialog* self, GtkButton* btn);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled (DesktopAgnosticUILauncherEditorDialog* self, GtkToggleButton* button);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled (DesktopAgnosticUILauncherEditorDialog* self, GtkToggleButton* button);
static void _desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
const char* desktop_agnostic_ui_icon_button_get_icon (DesktopAgnosticUIIconButton* self);
static gboolean desktop_agnostic_ui_launcher_editor_dialog_change_output_file_prompt (DesktopAgnosticUILauncherEditorDialog* self);
static void desktop_agnostic_ui_launcher_editor_dialog_set_file (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticVFSFile* value);
DesktopAgnosticVFSFile* desktop_agnostic_ui_launcher_editor_dialog_get_output (DesktopAgnosticUILauncherEditorDialog* self);
static void desktop_agnostic_ui_launcher_editor_dialog_set_output (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticVFSFile* value);
void desktop_agnostic_ui_launcher_editor_dialog_set_entry_type_sensitive (DesktopAgnosticUILauncherEditorDialog* self, gboolean value);
static void desktop_agnostic_ui_launcher_editor_dialog_finalize (GObject* obj);
static void desktop_agnostic_ui_launcher_editor_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_ui_launcher_editor_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DesktopAgnosticUIFixedTable* desktop_agnostic_ui_fixed_table_construct (GType object_type, guint columns, guint rows) {
	DesktopAgnosticUIFixedTable * self;
	self = g_object_newv (object_type, 0, NULL);
	g_object_set ((GtkTable*) self, "n-columns", columns, NULL);
	g_object_set ((GtkTable*) self, "n-rows", rows, NULL);
	gtk_table_set_homogeneous ((GtkTable*) self, FALSE);
	return self;
}


DesktopAgnosticUIFixedTable* desktop_agnostic_ui_fixed_table_new (guint columns, guint rows) {
	return desktop_agnostic_ui_fixed_table_construct (DESKTOP_AGNOSTIC_UI_TYPE_FIXED_TABLE, columns, rows);
}


void desktop_agnostic_ui_fixed_table_attach_defaults (DesktopAgnosticUIFixedTable* self, GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_table_attach ((GtkTable*) self, widget, left_attach, right_attach, top_attach, bottom_attach, GTK_FILL, GTK_SHRINK, (guint) 0, (guint) 0);
}


void desktop_agnostic_ui_fixed_table_attach_fill (DesktopAgnosticUIFixedTable* self, GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_table_attach ((GtkTable*) self, widget, left_attach, right_attach, top_attach, bottom_attach, GTK_FILL, 0, (guint) 0, (guint) 0);
}


void desktop_agnostic_ui_fixed_table_attach_expand (DesktopAgnosticUIFixedTable* self, GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_table_attach ((GtkTable*) self, widget, left_attach, right_attach, top_attach, bottom_attach, GTK_FILL | GTK_EXPAND, 0, (guint) 0, (guint) 0);
}


static void desktop_agnostic_ui_fixed_table_class_init (DesktopAgnosticUIFixedTableClass * klass) {
	desktop_agnostic_ui_fixed_table_parent_class = g_type_class_peek_parent (klass);
}


static void desktop_agnostic_ui_fixed_table_instance_init (DesktopAgnosticUIFixedTable * self) {
}


GType desktop_agnostic_ui_fixed_table_get_type (void) {
	static volatile gsize desktop_agnostic_ui_fixed_table_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_ui_fixed_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticUIFixedTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_ui_fixed_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticUIFixedTable), 0, (GInstanceInitFunc) desktop_agnostic_ui_fixed_table_instance_init, NULL };
		GType desktop_agnostic_ui_fixed_table_type_id;
		desktop_agnostic_ui_fixed_table_type_id = g_type_register_static (GTK_TYPE_TABLE, "DesktopAgnosticUIFixedTable", &g_define_type_info, 0);
		g_once_init_leave (&desktop_agnostic_ui_fixed_table_type_id__volatile, desktop_agnostic_ui_fixed_table_type_id);
	}
	return desktop_agnostic_ui_fixed_table_type_id__volatile;
}


DesktopAgnosticUILauncherEditorDialog* desktop_agnostic_ui_launcher_editor_dialog_construct (GType object_type, DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* output, gboolean entry_type_sensitive) {
	DesktopAgnosticUILauncherEditorDialog * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (DesktopAgnosticUILauncherEditorDialog*) g_object_new (object_type, "file", file, "output", output, "border-width", 4, "entry-type-sensitive", entry_type_sensitive, NULL);
	return self;
}


DesktopAgnosticUILauncherEditorDialog* desktop_agnostic_ui_launcher_editor_dialog_new (DesktopAgnosticVFSFile* file, DesktopAgnosticVFSFile* output, gboolean entry_type_sensitive) {
	return desktop_agnostic_ui_launcher_editor_dialog_construct (DESKTOP_AGNOSTIC_UI_TYPE_LAUNCHER_EDITOR_DIALOG, file, output, entry_type_sensitive);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_ui_launcher_editor_dialog_real_constructed (GObject* base) {
	DesktopAgnosticUILauncherEditorDialog * self;
	DesktopAgnosticFDODesktopEntry* _tmp1_;
	DesktopAgnosticFDODesktopEntry* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticUILauncherEditorDialog*) base;
	gtk_window_set_title ((GtkWindow*) self, _ ("Desktop Entry Editor"));
	gtk_window_set_icon_name ((GtkWindow*) self, "gtk-preferences");
	if (self->priv->_output == NULL) {
		DesktopAgnosticVFSFile* _tmp0_;
		self->priv->_output = (_tmp0_ = _g_object_ref0 (self->priv->_file), _g_object_unref0 (self->priv->_output), _tmp0_);
	}
	_tmp1_ = desktop_agnostic_fdo_desktop_entry_new_for_file (self->priv->_file, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_entry = (_tmp2_ = _tmp1_, _g_object_unref0 (self->priv->_entry), _tmp2_);
	desktop_agnostic_ui_launcher_editor_dialog_build_ui (self);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_response (self, response_id);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed_desktop_agnostic_ui_icon_button_icon_selected (DesktopAgnosticUIIconButton* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed (self, _sender);
}


static void _lambda1_ (DesktopAgnosticUILauncherEditorDialog* self) {
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_type_combo, self->priv->_entry_type_sensitive);
}


static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda1_ (self);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_type_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_type_changed (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_name_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_name_changed (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled (self, _sender);
}


static void _desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled (self, _sender);
}


static void desktop_agnostic_ui_launcher_editor_dialog_build_ui (DesktopAgnosticUILauncherEditorDialog* self) {
	DesktopAgnosticUIFixedTable* table;
	char* icon;
	GtkButton* exec_button;
	GtkImage* exec_image;
	GtkLabel* type_label;
	GtkLabel* name_label;
	GtkLabel* desc_label;
	GtkLabel* exec_label;
	GtkHBox* exec_hbox;
	GtkVBox* advanced_vbox;
	gboolean is_application;
	DesktopAgnosticUIFixedTable* _tmp0_;
	DesktopAgnosticUIIconButton* _tmp3_;
	GtkLabel* _tmp4_;
	GtkComboBox* _tmp5_;
	gint active_index;
	GtkLabel* _tmp6_;
	GtkEntry* _tmp7_;
	GtkLabel* _tmp9_;
	GtkEntry* _tmp10_;
	GtkLabel* _tmp12_;
	GtkHBox* _tmp13_;
	GtkEntry* _tmp14_;
	const char* _tmp15_;
	char* key_name;
	GtkButton* _tmp17_;
	GtkImage* _tmp18_;
	GtkExpander* _tmp19_;
	GtkVBox* _tmp20_;
	GtkCheckButton* _tmp21_;
	GtkCheckButton* _tmp22_;
	GList* focus_chain_list;
	g_return_if_fail (self != NULL);
	table = NULL;
	icon = NULL;
	exec_button = NULL;
	exec_image = NULL;
	type_label = NULL;
	name_label = NULL;
	desc_label = NULL;
	exec_label = NULL;
	exec_hbox = NULL;
	advanced_vbox = NULL;
	is_application = TRUE;
	gtk_dialog_add_buttons ((GtkDialog*) self, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_APPLY, NULL);
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_CANCEL);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_response_gtk_dialog_response, self, 0);
	table = (_tmp0_ = g_object_ref_sink (desktop_agnostic_ui_fixed_table_new ((guint) 3, (guint) 5)), _g_object_unref0 (table), _tmp0_);
	gtk_table_set_row_spacings ((GtkTable*) table, (guint) 5);
	g_object_set ((GtkTable*) table, "column-spacing", (guint) 6, NULL);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "Icon")) {
		char* _tmp1_;
		icon = (_tmp1_ = desktop_agnostic_fdo_desktop_entry_get_icon (self->priv->_entry), _g_free0 (icon), _tmp1_);
	} else {
		char* _tmp2_;
		icon = (_tmp2_ = g_strdup (GTK_STOCK_MISSING_IMAGE), _g_free0 (icon), _tmp2_);
	}
	self->priv->_icon = (_tmp3_ = g_object_ref_sink (desktop_agnostic_ui_icon_button_new (icon)), _g_object_unref0 (self->priv->_icon), _tmp3_);
	g_signal_connect_object (self->priv->_icon, "icon-selected", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed_desktop_agnostic_ui_icon_button_icon_selected, self, 0);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) self->priv->_icon, (guint) 0, (guint) 1, (guint) 0, (guint) 4);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "Type")) {
		is_application = desktop_agnostic_fdo_desktop_entry_get_entry_type (self->priv->_entry) == DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION;
	} else {
		desktop_agnostic_fdo_desktop_entry_set_entry_type (self->priv->_entry, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION);
	}
	type_label = (_tmp4_ = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (_ ("T_ype:"))), _g_object_unref0 (type_label), _tmp4_);
	g_object_set ((GtkMisc*) type_label, "xalign", 1.0f, NULL);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) type_label, (guint) 1, (guint) 2, (guint) 0, (guint) 1);
	self->priv->_type_combo = (_tmp5_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), _g_object_unref0 (self->priv->_type_combo), _tmp5_);
	gtk_combo_box_append_text (self->priv->_type_combo, _ ("Application"));
	gtk_combo_box_append_text (self->priv->_type_combo, _ ("Location"));
	gtk_label_set_mnemonic_widget (type_label, (GtkWidget*) self->priv->_type_combo);
	active_index = -1;
	switch (desktop_agnostic_fdo_desktop_entry_get_entry_type (self->priv->_entry)) {
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION:
		{
			active_index = 0;
			break;
		}
		case DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK:
		{
			active_index = 1;
			break;
		}
	}
	gtk_combo_box_set_active (self->priv->_type_combo, active_index);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->_type_combo, self->priv->_entry_type_sensitive);
	g_signal_connect_object ((GObject*) self, "notify::entry-type-sensitive", (GCallback) __lambda1__g_object_notify, self, 0);
	g_signal_connect_object (self->priv->_type_combo, "changed", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_type_changed_gtk_combo_box_changed, self, 0);
	desktop_agnostic_ui_fixed_table_attach_expand (table, (GtkWidget*) self->priv->_type_combo, (guint) 2, (guint) 3, (guint) 0, (guint) 1);
	name_label = (_tmp6_ = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Name:"))), _g_object_unref0 (name_label), _tmp6_);
	g_object_set ((GtkMisc*) name_label, "xalign", 1.0f, NULL);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) name_label, (guint) 1, (guint) 2, (guint) 1, (guint) 2);
	self->priv->_name = (_tmp7_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->_name), _tmp7_);
	gtk_label_set_mnemonic_widget (name_label, (GtkWidget*) self->priv->_name);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "Name")) {
		char* _tmp8_;
		gtk_entry_set_text (self->priv->_name, _tmp8_ = desktop_agnostic_fdo_desktop_entry_get_name (self->priv->_entry));
		_g_free0 (_tmp8_);
	}
	g_signal_connect_object ((GtkEditable*) self->priv->_name, "changed", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_name_changed_gtk_editable_changed, self, 0);
	desktop_agnostic_ui_fixed_table_attach_expand (table, (GtkWidget*) self->priv->_name, (guint) 2, (guint) 3, (guint) 1, (guint) 2);
	desc_label = (_tmp9_ = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Description:"))), _g_object_unref0 (desc_label), _tmp9_);
	g_object_set ((GtkMisc*) desc_label, "xalign", 1.0f, NULL);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) desc_label, (guint) 1, (guint) 2, (guint) 2, (guint) 3);
	self->priv->_desc = (_tmp10_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->_desc), _tmp10_);
	gtk_label_set_mnemonic_widget (desc_label, (GtkWidget*) self->priv->_desc);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "Comment")) {
		char* _tmp11_;
		gtk_entry_set_text (self->priv->_desc, _tmp11_ = desktop_agnostic_fdo_desktop_entry_get_string (self->priv->_entry, "Comment"));
		_g_free0 (_tmp11_);
	}
	g_signal_connect_object ((GtkEditable*) self->priv->_desc, "changed", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed_gtk_editable_changed, self, 0);
	desktop_agnostic_ui_fixed_table_attach_expand (table, (GtkWidget*) self->priv->_desc, (guint) 2, (guint) 3, (guint) 2, (guint) 3);
	exec_label = (_tmp12_ = g_object_ref_sink ((GtkLabel*) gtk_label_new_with_mnemonic (_ ("_Command:"))), _g_object_unref0 (exec_label), _tmp12_);
	self->priv->_command_label = exec_label;
	g_object_set ((GtkMisc*) exec_label, "xalign", 1.0f, NULL);
	desktop_agnostic_ui_fixed_table_attach_defaults (table, (GtkWidget*) exec_label, (guint) 1, (guint) 2, (guint) 3, (guint) 4);
	exec_hbox = (_tmp13_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 5)), _g_object_unref0 (exec_hbox), _tmp13_);
	self->priv->_exec = (_tmp14_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->_exec), _tmp14_);
	gtk_label_set_mnemonic_widget (exec_label, (GtkWidget*) self->priv->_exec);
	_tmp15_ = NULL;
	if (is_application) {
		_tmp15_ = "Exec";
	} else {
		_tmp15_ = "URL";
	}
	key_name = g_strdup (_tmp15_);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, key_name)) {
		char* _tmp16_;
		gtk_entry_set_text (self->priv->_exec, _tmp16_ = desktop_agnostic_fdo_desktop_entry_get_string (self->priv->_entry, key_name));
		_g_free0 (_tmp16_);
	}
	g_signal_connect_object ((GtkEditable*) self->priv->_exec, "changed", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed_gtk_editable_changed, self, 0);
	gtk_box_pack_start ((GtkBox*) exec_hbox, (GtkWidget*) self->priv->_exec, TRUE, TRUE, 0);
	exec_button = (_tmp17_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_mnemonic (_ ("_Browse..."))), _g_object_unref0 (exec_button), _tmp17_);
	exec_image = (_tmp18_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_OPEN, GTK_ICON_SIZE_BUTTON)), _g_object_unref0 (exec_image), _tmp18_);
	gtk_button_set_image (exec_button, (GtkWidget*) exec_image);
	g_signal_connect_object (exec_button, "clicked", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse_gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) exec_hbox, (GtkWidget*) exec_button, FALSE, TRUE, 0);
	desktop_agnostic_ui_fixed_table_attach_expand (table, (GtkWidget*) exec_hbox, (guint) 2, (guint) 3, (guint) 3, (guint) 4);
	self->priv->_advanced = (_tmp19_ = g_object_ref_sink ((GtkExpander*) gtk_expander_new_with_mnemonic (_ ("_Advanced"))), _g_object_unref0 (self->priv->_advanced), _tmp19_);
	advanced_vbox = (_tmp20_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 5)), _g_object_unref0 (advanced_vbox), _tmp20_);
	self->priv->_terminal = (_tmp21_ = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Run in _terminal"))), _g_object_unref0 (self->priv->_terminal), _tmp21_);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "Terminal")) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->_terminal, desktop_agnostic_fdo_desktop_entry_get_boolean (self->priv->_entry, "Terminal"));
	}
	g_signal_connect_object ((GtkToggleButton*) self->priv->_terminal, "toggled", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_container_add ((GtkContainer*) advanced_vbox, (GtkWidget*) self->priv->_terminal);
	self->priv->_startup_notification = (_tmp22_ = g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Use _startup notification"))), _g_object_unref0 (self->priv->_startup_notification), _tmp22_);
	if (desktop_agnostic_fdo_desktop_entry_key_exists (self->priv->_entry, "StartupNotify")) {
		gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->_startup_notification, desktop_agnostic_fdo_desktop_entry_get_boolean (self->priv->_entry, "StartupNotify"));
	}
	g_signal_connect_object ((GtkToggleButton*) self->priv->_startup_notification, "toggled", (GCallback) _desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_container_add ((GtkContainer*) advanced_vbox, (GtkWidget*) self->priv->_startup_notification);
	gtk_container_add ((GtkContainer*) self->priv->_advanced, (GtkWidget*) advanced_vbox);
	desktop_agnostic_ui_fixed_table_attach_expand (table, (GtkWidget*) self->priv->_advanced, (guint) 0, (guint) 3, (guint) 4, (guint) 5);
	desktop_agnostic_ui_launcher_editor_dialog_on_type_changed (self, self->priv->_type_combo);
	focus_chain_list = NULL;
	focus_chain_list = g_list_append (focus_chain_list, (GtkWidget*) self->priv->_type_combo);
	focus_chain_list = g_list_append (focus_chain_list, (GtkWidget*) self->priv->_name);
	focus_chain_list = g_list_append (focus_chain_list, (GtkWidget*) self->priv->_desc);
	focus_chain_list = g_list_append (focus_chain_list, (GtkWidget*) exec_hbox);
	focus_chain_list = g_list_append (focus_chain_list, (GtkWidget*) self->priv->_icon);
	focus_chain_list = g_list_append (focus_chain_list, (GtkWidget*) self->priv->_advanced);
	gtk_container_set_focus_chain ((GtkContainer*) table, focus_chain_list);
	gtk_container_add ((GtkContainer*) ((GtkDialog*) self)->vbox, (GtkWidget*) table);
	_g_list_free0 (focus_chain_list);
	_g_free0 (key_name);
	_g_object_unref0 (advanced_vbox);
	_g_object_unref0 (exec_hbox);
	_g_object_unref0 (exec_label);
	_g_object_unref0 (desc_label);
	_g_object_unref0 (name_label);
	_g_object_unref0 (type_label);
	_g_object_unref0 (exec_image);
	_g_object_unref0 (exec_button);
	_g_free0 (icon);
	_g_object_unref0 (table);
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_icon_changed (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticUIIconButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	desktop_agnostic_fdo_desktop_entry_set_icon (self->priv->_entry, desktop_agnostic_ui_icon_button_get_icon (button));
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_type_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkComboBox* combo) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	switch (gtk_combo_box_get_active (combo)) {
		case 0:
		{
			desktop_agnostic_fdo_desktop_entry_set_entry_type (self->priv->_entry, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION);
			break;
		}
		case 1:
		{
			desktop_agnostic_fdo_desktop_entry_set_entry_type (self->priv->_entry, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK);
			break;
		}
	}
	if (desktop_agnostic_fdo_desktop_entry_get_entry_type (self->priv->_entry) == DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK) {
		gtk_label_set_markup_with_mnemonic (self->priv->_command_label, _ ("_Location:"));
		gtk_widget_hide ((GtkWidget*) self->priv->_advanced);
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->_advanced, TRUE);
	} else {
		gtk_label_set_markup_with_mnemonic (self->priv->_command_label, _ ("_Command:"));
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->_advanced, FALSE);
		gtk_widget_show ((GtkWidget*) self->priv->_advanced);
	}
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_name_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable) {
	GtkEditable* _tmp0_;
	GtkEntry* entry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	entry = _g_object_ref0 ((_tmp0_ = editable, GTK_IS_ENTRY (_tmp0_) ? ((GtkEntry*) _tmp0_) : NULL));
	desktop_agnostic_fdo_desktop_entry_set_name (self->priv->_entry, gtk_entry_get_text (entry));
	_g_object_unref0 (entry);
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_desc_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable) {
	GtkEditable* _tmp0_;
	GtkEntry* entry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	entry = _g_object_ref0 ((_tmp0_ = editable, GTK_IS_ENTRY (_tmp0_) ? ((GtkEntry*) _tmp0_) : NULL));
	desktop_agnostic_fdo_desktop_entry_set_string (self->priv->_entry, "Comment", gtk_entry_get_text (entry));
	_g_object_unref0 (entry);
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_exec_changed (DesktopAgnosticUILauncherEditorDialog* self, GtkEditable* editable) {
	GtkEditable* _tmp0_;
	GtkEntry* entry;
	const char* _tmp1_;
	char* key_name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	entry = _g_object_ref0 ((_tmp0_ = editable, GTK_IS_ENTRY (_tmp0_) ? ((GtkEntry*) _tmp0_) : NULL));
	_tmp1_ = NULL;
	if (desktop_agnostic_fdo_desktop_entry_get_entry_type (self->priv->_entry) == DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK) {
		_tmp1_ = "URL";
	} else {
		_tmp1_ = "Exec";
	}
	key_name = g_strdup (_tmp1_);
	desktop_agnostic_fdo_desktop_entry_set_string (self->priv->_entry, key_name, gtk_entry_get_text (entry));
	_g_free0 (key_name);
	_g_object_unref0 (entry);
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_exec_browse (DesktopAgnosticUILauncherEditorDialog* self, GtkButton* btn) {
	GtkFileChooserDialog* dialog;
	gint response = 0;
	gboolean is_link;
	const char* _tmp0_;
	char* title;
	GtkFileChooserDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (btn != NULL);
	dialog = NULL;
	is_link = desktop_agnostic_fdo_desktop_entry_get_entry_type (self->priv->_entry) == DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK;
	_tmp0_ = NULL;
	if (is_link) {
		_tmp0_ = _ ("Locate a file");
	} else {
		_tmp0_ = _ ("Locate Command");
	}
	title = g_strdup (_tmp0_);
	dialog = (_tmp1_ = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (title, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL)), _g_object_unref0 (dialog), _tmp1_);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	if (response == GTK_RESPONSE_OK) {
		char* _tmp2_;
		_tmp2_ = NULL;
		if (is_link) {
			char* _tmp3_;
			_tmp2_ = (_tmp3_ = gtk_file_chooser_get_uri ((GtkFileChooser*) dialog), _g_free0 (_tmp2_), _tmp3_);
		} else {
			char* _tmp4_;
			_tmp2_ = (_tmp4_ = gtk_file_chooser_get_filename ((GtkFileChooser*) dialog), _g_free0 (_tmp2_), _tmp4_);
		}
		gtk_entry_set_text (self->priv->_exec, _tmp2_);
		_g_free0 (_tmp2_);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_free0 (title);
	_g_object_unref0 (dialog);
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_terminal_toggled (DesktopAgnosticUILauncherEditorDialog* self, GtkToggleButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	desktop_agnostic_fdo_desktop_entry_set_boolean (self->priv->_entry, "Terminal", gtk_toggle_button_get_active (button));
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_startup_notification_toggled (DesktopAgnosticUILauncherEditorDialog* self, GtkToggleButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	desktop_agnostic_fdo_desktop_entry_set_boolean (self->priv->_entry, "StartupNotify", gtk_toggle_button_get_active (button));
}


/**
     * Pops up a "Save As" dialog.
     */
static gboolean desktop_agnostic_ui_launcher_editor_dialog_change_output_file_prompt (DesktopAgnosticUILauncherEditorDialog* self) {
	gboolean result = FALSE;
	GtkFileChooserDialog* dialog;
	gint response = 0;
	gboolean try_to_save = FALSE;
	GtkFileChooserDialog* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	dialog = NULL;
	dialog = (_tmp0_ = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save As"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE_AS, GTK_RESPONSE_ACCEPT, NULL)), _g_object_unref0 (dialog), _tmp0_);
	response = gtk_dialog_run ((GtkDialog*) dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		char* _tmp1_;
		DesktopAgnosticVFSFile* _tmp2_;
		DesktopAgnosticVFSFile* _tmp3_;
		DesktopAgnosticVFSFile* _tmp4_;
		_tmp3_ = (_tmp2_ = desktop_agnostic_vfs_file_new_for_uri (_tmp1_ = gtk_file_chooser_get_uri ((GtkFileChooser*) dialog), &_inner_error_), _g_free0 (_tmp1_), _tmp2_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dialog);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		self->priv->_output = (_tmp4_ = _tmp3_, _g_object_unref0 (self->priv->_output), _tmp4_);
		try_to_save = TRUE;
	} else {
		try_to_save = FALSE;
	}
	gtk_object_destroy ((GtkObject*) dialog);
	result = try_to_save;
	_g_object_unref0 (dialog);
	return result;
}


static void desktop_agnostic_ui_launcher_editor_dialog_on_response (DesktopAgnosticUILauncherEditorDialog* self, gint response_id) {
	gboolean try_to_save;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	try_to_save = TRUE;
	if (response_id == GTK_RESPONSE_APPLY) {
		if (desktop_agnostic_vfs_file_exists (self->priv->_output)) {
			if (!desktop_agnostic_vfs_file_is_writable (self->priv->_output)) {
				try_to_save = desktop_agnostic_ui_launcher_editor_dialog_change_output_file_prompt (self);
			}
		} else {
			DesktopAgnosticVFSFile* directory;
			DesktopAgnosticVFSFile* _tmp0_;
			gboolean _tmp1_ = FALSE;
			directory = NULL;
			directory = (_tmp0_ = desktop_agnostic_vfs_file_get_parent (self->priv->_output), _g_object_unref0 (directory), _tmp0_);
			if (directory == NULL) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = !desktop_agnostic_vfs_file_is_writable (directory);
			}
			if (_tmp1_) {
				try_to_save = desktop_agnostic_ui_launcher_editor_dialog_change_output_file_prompt (self);
			}
			_g_object_unref0 (directory);
		}
		if (try_to_save) {
			if (desktop_agnostic_fdo_desktop_entry_get_entry_type (self->priv->_entry) == DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_UNKNOWN) {
				desktop_agnostic_fdo_desktop_entry_set_entry_type (self->priv->_entry, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_APPLICATION);
			}
			{
				desktop_agnostic_fdo_desktop_entry_save (self->priv->_entry, self->priv->_output, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch3_g_error;
				}
			}
			goto __finally3;
			__catch3_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					GtkMessageDialog* dialog;
					GtkMessageDialog* _tmp2_;
					dialog = NULL;
					dialog = (_tmp2_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("An error occurred while trying to save the desktop entry:\n\n%s"), err->message)), _g_object_unref0 (dialog), _tmp2_);
					gtk_dialog_run ((GtkDialog*) dialog);
					gtk_object_destroy ((GtkObject*) dialog);
					_g_object_unref0 (dialog);
					_g_error_free0 (err);
				}
			}
			__finally3:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	gtk_widget_hide ((GtkWidget*) self);
}


DesktopAgnosticVFSFile* desktop_agnostic_ui_launcher_editor_dialog_get_file (DesktopAgnosticUILauncherEditorDialog* self) {
	DesktopAgnosticVFSFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_file;
	return result;
}


static void desktop_agnostic_ui_launcher_editor_dialog_set_file (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticVFSFile* value) {
	g_return_if_fail (self != NULL);
	self->priv->_file = value;
	g_object_notify ((GObject *) self, "file");
}


DesktopAgnosticVFSFile* desktop_agnostic_ui_launcher_editor_dialog_get_output (DesktopAgnosticUILauncherEditorDialog* self) {
	DesktopAgnosticVFSFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_output;
	return result;
}


static void desktop_agnostic_ui_launcher_editor_dialog_set_output (DesktopAgnosticUILauncherEditorDialog* self, DesktopAgnosticVFSFile* value) {
	DesktopAgnosticVFSFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_output = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_output), _tmp0_);
	g_object_notify ((GObject *) self, "output");
}


gboolean desktop_agnostic_ui_launcher_editor_dialog_get_entry_type_sensitive (DesktopAgnosticUILauncherEditorDialog* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_type_sensitive;
	return result;
}


void desktop_agnostic_ui_launcher_editor_dialog_set_entry_type_sensitive (DesktopAgnosticUILauncherEditorDialog* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_entry_type_sensitive = value;
	g_object_notify ((GObject *) self, "entry-type-sensitive");
}


static void desktop_agnostic_ui_launcher_editor_dialog_class_init (DesktopAgnosticUILauncherEditorDialogClass * klass) {
	desktop_agnostic_ui_launcher_editor_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticUILauncherEditorDialogPrivate));
	G_OBJECT_CLASS (klass)->constructed = desktop_agnostic_ui_launcher_editor_dialog_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_ui_launcher_editor_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_ui_launcher_editor_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_ui_launcher_editor_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_FILE, g_param_spec_object ("file", "file", "file", DESKTOP_AGNOSTIC_VFS_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_OUTPUT, g_param_spec_object ("output", "output", "output", DESKTOP_AGNOSTIC_VFS_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_ENTRY_TYPE_SENSITIVE, g_param_spec_boolean ("entry-type-sensitive", "entry-type-sensitive", "entry-type-sensitive", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void desktop_agnostic_ui_launcher_editor_dialog_instance_init (DesktopAgnosticUILauncherEditorDialog * self) {
	self->priv = DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_GET_PRIVATE (self);
	self->priv->_entry_type_sensitive = FALSE;
}


static void desktop_agnostic_ui_launcher_editor_dialog_finalize (GObject* obj) {
	DesktopAgnosticUILauncherEditorDialog * self;
	self = DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG (obj);
	_g_object_unref0 (self->priv->_type_combo);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_name);
	_g_object_unref0 (self->priv->_desc);
	_g_object_unref0 (self->priv->_exec);
	_g_object_unref0 (self->priv->_advanced);
	_g_object_unref0 (self->priv->_terminal);
	_g_object_unref0 (self->priv->_startup_notification);
	_g_object_unref0 (self->priv->_output);
	_g_object_unref0 (self->priv->_entry);
	G_OBJECT_CLASS (desktop_agnostic_ui_launcher_editor_dialog_parent_class)->finalize (obj);
}


GType desktop_agnostic_ui_launcher_editor_dialog_get_type (void) {
	static volatile gsize desktop_agnostic_ui_launcher_editor_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_ui_launcher_editor_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticUILauncherEditorDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_ui_launcher_editor_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticUILauncherEditorDialog), 0, (GInstanceInitFunc) desktop_agnostic_ui_launcher_editor_dialog_instance_init, NULL };
		GType desktop_agnostic_ui_launcher_editor_dialog_type_id;
		desktop_agnostic_ui_launcher_editor_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "DesktopAgnosticUILauncherEditorDialog", &g_define_type_info, 0);
		g_once_init_leave (&desktop_agnostic_ui_launcher_editor_dialog_type_id__volatile, desktop_agnostic_ui_launcher_editor_dialog_type_id);
	}
	return desktop_agnostic_ui_launcher_editor_dialog_type_id__volatile;
}


static void desktop_agnostic_ui_launcher_editor_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticUILauncherEditorDialog * self;
	self = DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_FILE:
		g_value_set_object (value, desktop_agnostic_ui_launcher_editor_dialog_get_file (self));
		break;
		case DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_OUTPUT:
		g_value_set_object (value, desktop_agnostic_ui_launcher_editor_dialog_get_output (self));
		break;
		case DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_ENTRY_TYPE_SENSITIVE:
		g_value_set_boolean (value, desktop_agnostic_ui_launcher_editor_dialog_get_entry_type_sensitive (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_ui_launcher_editor_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticUILauncherEditorDialog * self;
	self = DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_FILE:
		desktop_agnostic_ui_launcher_editor_dialog_set_file (self, g_value_get_object (value));
		break;
		case DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_OUTPUT:
		desktop_agnostic_ui_launcher_editor_dialog_set_output (self, g_value_get_object (value));
		break;
		case DESKTOP_AGNOSTIC_UI_LAUNCHER_EDITOR_DIALOG_ENTRY_TYPE_SENSITIVE:
		desktop_agnostic_ui_launcher_editor_dialog_set_entry_type_sensitive (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




