/***************************************************************************
                           platform.h  -  description
                             -------------------
    begin                : Thu Jun 5 2003
    copyright            : (C) 2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _PLATFORM_H_
#define _PLATFORM_H_

/**
  *@author Mathias Küster
  *
  * Just gettimeofday() and lrint() remain after WIN32
  * directory reading, using the MS C runtime library, added to CDir.
  * Both are also provided by mingw.
  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*
 * WIN32
 */
#ifdef WIN32
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <time.h>
#include <sys/timeb.h>

extern "C" {
int gettimeofday(struct timeval *tp, void * );
}
#endif

/*
 *  lrint stuff 
 */
#ifndef HAVE_LRINT
 #include <math.h> 
 #define lrint(flt)   ((int) (flt)) 
#endif

#endif
