package latexDraw.filters;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/** 
 * This class defines a filter for ps documents (*.ps)<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 12/08/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.3<br>
 * @since 2.0.3
 */
public class PSFilter extends FileFilter
{
	public static final String PS_EXTENSION = ".ps";//$NON-NLS-1$
	
	
	@Override
	public boolean accept(File f)
	{
		return f!=null && (f.getName().endsWith(PS_EXTENSION)|| f.isDirectory());
	}



	@Override
	public String getDescription()
	{
		return "*" + PS_EXTENSION; //$NON-NLS-1$ //$NON-NLS-2$
	}
}
