package junit.test.parser.pst;

import junit.test.parser.TestCodeParser;

public abstract class TestPSTParser extends TestCodeParser
{
	@Override
	public void testSkipComment()
	{
		parser.setCode("%comment\na");
		assertEquals(parser.skipComment(), "comment");
		assertEquals(parser.getPosition(), 9);
		assertEquals(parser.getLinePosition(), 2);
		parser.setCode("\\%not a comment\na");
		assertNull(parser.skipComment());
		assertEquals(parser.getPosition(), 0);
		assertEquals(parser.getLinePosition(), 1);
		parser.setCode("%comment");
		assertEquals(parser.skipComment(), "comment");
		assertEquals(parser.getPosition(), 9);
		assertEquals(parser.getLinePosition(), 2);
	}




	@Override
	public void testSkipWSP()
	{
		parser.setCode("   test");
		parser.skipWSP();
		assertEquals('t', parser.getChar());
		parser.skipWSP();
		assertEquals('t', parser.getChar());
		parser.setCode("");
		parser.skipWSP();
		assertTrue(parser.isEOC());
		parser.setCode(" \n \t \r  test");
		parser.skipWSP();
		assertEquals('t', parser.getChar());
		parser.skipWSP();
		assertEquals('t', parser.getChar());
	}
}
