/*
 * Copyright 2010-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.checkers;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/tests-spec/testData/diagnostics")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class DiagnosticsTestSpecGenerated extends AbstractDiagnosticsTestSpec {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInDiagnostics() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true, "helpers");
    }

    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Linked extends AbstractDiagnosticsTestSpec {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLinked() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constant_literals extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConstant_literals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Boolean_literals extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInBoolean_literals() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals/p-1/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals/p-1/neg/3.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals/p-1/pos/3.1.kt");
                        }

                        @TestMetadata("3.2.kt")
                        public void test3_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals/p-1/pos/3.2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/boolean-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Integer_literals extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInteger_literals() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/binary-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Binary_integer_literals extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInBinary_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/binary-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/binary-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/binary-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg/1.1.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg/2.3.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/binary-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/decimal-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Decimal_integer_literals extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInDecimal_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/decimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/decimal-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/decimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/neg/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/neg/2.2.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/hexadecimal-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Hexadecimal_integer_literals extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInHexadecimal_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/hexadecimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/1.1.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg/2.3.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Long_integer_literals extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInLong_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/1.3.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg/2.5.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/2.1.kt");
                            }

                            @TestMetadata("2.2.kt")
                            public void test2_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/2.2.kt");
                            }

                            @TestMetadata("2.3.kt")
                            public void test2_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/2.3.kt");
                            }

                            @TestMetadata("2.4.kt")
                            public void test2_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/2.4.kt");
                            }

                            @TestMetadata("2.5.kt")
                            public void test2_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/2.5.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Real_literals extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInReal_literals() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1/neg/1.1.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1/neg/3.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1/pos/1.2.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1/pos/3.1.kt");
                        }

                        @TestMetadata("3.2.kt")
                        public void test3_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1/pos/3.2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2/neg/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2/neg/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2/neg/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2/neg/1.4.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2/pos/1.2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_3 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_3() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/neg/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/neg/1.2.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/neg/2.1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/pos/1.4.kt");
                        }

                        @TestMetadata("1.5.kt")
                        public void test1_5() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/pos/1.5.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/pos/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/pos/2.3.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_4 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_4() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/neg/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/neg/1.2.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/neg/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/neg/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/neg/2.3.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/pos/1.4.kt");
                        }

                        @TestMetadata("1.5.kt")
                        public void test1_5() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/pos/1.5.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-5")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_5 extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_5() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-5"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-5/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-5/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-5/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-5/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-5/pos/1.4.kt");
                        }

                        @TestMetadata("1.5.kt")
                        public void test1_5() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-5/pos/1.5.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/constant-literals/real-literals/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Type_inference extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInType_inference() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Smart_casts extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSmart_casts() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Smart_casts_sources extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInSmart_casts_sources() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_4 extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_4() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.1.kt");
                            }

                            @TestMetadata("1.10.kt")
                            public void test1_10() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.10.kt");
                            }

                            @TestMetadata("1.11.kt")
                            public void test1_11() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.11.kt");
                            }

                            @TestMetadata("1.12.kt")
                            public void test1_12() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.12.kt");
                            }

                            @TestMetadata("1.13.kt")
                            public void test1_13() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.13.kt");
                            }

                            @TestMetadata("1.14.kt")
                            public void test1_14() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.14.kt");
                            }

                            @TestMetadata("1.15.kt")
                            public void test1_15() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.15.kt");
                            }

                            @TestMetadata("1.16.kt")
                            public void test1_16() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.16.kt");
                            }

                            @TestMetadata("1.17.kt")
                            public void test1_17() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.17.kt");
                            }

                            @TestMetadata("1.18.kt")
                            public void test1_18() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.18.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.3.kt");
                            }

                            @TestMetadata("1.4.kt")
                            public void test1_4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.4.kt");
                            }

                            @TestMetadata("1.5.kt")
                            public void test1_5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.5.kt");
                            }

                            @TestMetadata("1.6.kt")
                            public void test1_6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.6.kt");
                            }

                            @TestMetadata("1.7.kt")
                            public void test1_7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.7.kt");
                            }

                            @TestMetadata("1.8.kt")
                            public void test1_8() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.8.kt");
                            }

                            @TestMetadata("1.9.kt")
                            public void test1_9() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos/1.9.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/type-inference/smart-casts/smart-casts-sources/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class When_expression extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWhen_expression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_11 extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_11() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/neg/1.1.kt");
                    }

                    @TestMetadata("1.2.kt")
                    public void test1_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/neg/1.2.kt");
                    }

                    @TestMetadata("3.1.kt")
                    public void test3_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/neg/3.1.kt");
                    }

                    @TestMetadata("6.1.kt")
                    public void test6_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/neg/6.1.kt");
                    }

                    @TestMetadata("7.1.kt")
                    public void test7_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/neg/7.1.kt");
                    }

                    @TestMetadata("8.1.kt")
                    public void test8_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/neg/8.1.kt");
                    }

                    @TestMetadata("8.2.kt")
                    public void test8_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/neg/8.2.kt");
                    }

                    @TestMetadata("8.3.kt")
                    public void test8_3() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/neg/8.3.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Pos extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos/1.1.kt");
                    }

                    @TestMetadata("1.2.kt")
                    public void test1_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos/1.2.kt");
                    }

                    @TestMetadata("1.3.kt")
                    public void test1_3() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos/1.3.kt");
                    }

                    @TestMetadata("3.1.kt")
                    public void test3_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos/3.1.kt");
                    }

                    @TestMetadata("6.1.kt")
                    public void test6_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos/6.1.kt");
                    }

                    @TestMetadata("7.1.kt")
                    public void test7_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos/7.1.kt");
                    }

                    @TestMetadata("8.1.kt")
                    public void test8_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos/8.1.kt");
                    }

                    @TestMetadata("8.2.kt")
                    public void test8_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos/8.2.kt");
                    }

                    @TestMetadata("8.3.kt")
                    public void test8_3() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos/8.3.kt");
                    }

                    public void testAllFilesPresentInPos() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-11/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-2")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_2 extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_2() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-2"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-2/pos")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Pos extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("3.1.kt")
                    public void test3_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-2/pos/3.1.kt");
                    }

                    @TestMetadata("3.2.kt")
                    public void test3_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-2/pos/3.2.kt");
                    }

                    public void testAllFilesPresentInPos() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_3 extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_3() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/neg/1.1.kt");
                    }

                    @TestMetadata("2.1.kt")
                    public void test2_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/neg/2.1.kt");
                    }

                    @TestMetadata("2.2.kt")
                    public void test2_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/neg/2.2.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/pos")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Pos extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/pos/1.1.kt");
                    }

                    @TestMetadata("2.1.kt")
                    public void test2_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/pos/2.1.kt");
                    }

                    @TestMetadata("2.2.kt")
                    public void test2_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/pos/2.2.kt");
                    }

                    @TestMetadata("2.3.kt")
                    public void test2_3() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/pos/2.3.kt");
                    }

                    public void testAllFilesPresentInPos() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-5")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_5 extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_5() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-5"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-5/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-5/neg/1.1.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-5/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-5/pos")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Pos extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-5/pos/1.1.kt");
                    }

                    public void testAllFilesPresentInPos() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-5/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-6")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_6 extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_6() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-6"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-6/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-6/neg/1.1.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-6/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-6/pos")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Pos extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-6/pos/1.1.kt");
                    }

                    public void testAllFilesPresentInPos() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-6/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_7 extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_7() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/neg/1.1.kt");
                    }

                    @TestMetadata("1.2.kt")
                    public void test1_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/neg/1.2.kt");
                    }

                    @TestMetadata("3.1.kt")
                    public void test3_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/neg/3.1.kt");
                    }

                    @TestMetadata("3.2.kt")
                    public void test3_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/neg/3.2.kt");
                    }

                    @TestMetadata("5.1.kt")
                    public void test5_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/neg/5.1.kt");
                    }

                    @TestMetadata("5.2.kt")
                    public void test5_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/neg/5.2.kt");
                    }

                    @TestMetadata("7.1.kt")
                    public void test7_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/neg/7.1.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Pos extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos/1.1.kt");
                    }

                    @TestMetadata("1.2.kt")
                    public void test1_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos/1.2.kt");
                    }

                    @TestMetadata("1.3.kt")
                    public void test1_3() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos/1.3.kt");
                    }

                    @TestMetadata("1.4.kt")
                    public void test1_4() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos/1.4.kt");
                    }

                    @TestMetadata("3.1.kt")
                    public void test3_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos/3.1.kt");
                    }

                    @TestMetadata("3.2.kt")
                    public void test3_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos/3.2.kt");
                    }

                    @TestMetadata("5.1.kt")
                    public void test5_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos/5.1.kt");
                    }

                    @TestMetadata("5.2.kt")
                    public void test5_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos/5.2.kt");
                    }

                    @TestMetadata("7.1.kt")
                    public void test7_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos/7.1.kt");
                    }

                    public void testAllFilesPresentInPos() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-7/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class P_9 extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInP_9() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/neg/1.1.kt");
                    }

                    @TestMetadata("1.2.kt")
                    public void test1_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/neg/1.2.kt");
                    }

                    @TestMetadata("1.3.kt")
                    public void test1_3() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/neg/1.3.kt");
                    }

                    @TestMetadata("1.4.kt")
                    public void test1_4() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/neg/1.4.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/pos")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Pos extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.1.kt")
                    public void test1_1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/pos/1.1.kt");
                    }

                    @TestMetadata("1.2.kt")
                    public void test1_2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/pos/1.2.kt");
                    }

                    @TestMetadata("1.3.kt")
                    public void test1_3() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/pos/1.3.kt");
                    }

                    @TestMetadata("1.4.kt")
                    public void test1_4() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/pos/1.4.kt");
                    }

                    public void testAllFilesPresentInPos() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/linked/when-expression/p-9/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }
        }
    }

    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NotLinked extends AbstractDiagnosticsTestSpec {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInNotLinked() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotations extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Annotation_classes extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInAnnotation_classes() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes/neg/1.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/annotation-classes/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Type_annotations extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInType_annotations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/1.kt");
                    }

                    @TestMetadata("10.kt")
                    public void test10() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/10.kt");
                    }

                    @TestMetadata("11.kt")
                    public void test11() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/11.kt");
                    }

                    @TestMetadata("2.kt")
                    public void test2() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/2.kt");
                    }

                    @TestMetadata("3.kt")
                    public void test3() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/3.kt");
                    }

                    @TestMetadata("4.kt")
                    public void test4() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/4.kt");
                    }

                    @TestMetadata("5.kt")
                    public void test5() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/5.kt");
                    }

                    @TestMetadata("6.kt")
                    public void test6() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/6.kt");
                    }

                    @TestMetadata("7.kt")
                    public void test7() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/7.kt");
                    }

                    @TestMetadata("8.kt")
                    public void test8() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/8.kt");
                    }

                    @TestMetadata("9.kt")
                    public void test9() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg/9.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/annotations/type-annotations/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Contracts extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInContracts() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Analysis extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInAnalysis() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Common extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInCommon() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/neg/1.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos/1.kt");
                        }

                        @TestMetadata("2.kt")
                        public void test2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos/2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/common/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class ControlFlow extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInControlFlow() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Initialization extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInInitialization() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/1.kt");
                            }

                            @TestMetadata("2.kt")
                            public void test2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/2.kt");
                            }

                            @TestMetadata("3.kt")
                            public void test3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/3.kt");
                            }

                            @TestMetadata("4.kt")
                            public void test4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/4.kt");
                            }

                            @TestMetadata("5.kt")
                            public void test5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/5.kt");
                            }

                            @TestMetadata("6.kt")
                            public void test6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg/6.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/1.kt");
                            }

                            @TestMetadata("2.kt")
                            public void test2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/2.kt");
                            }

                            @TestMetadata("3.kt")
                            public void test3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/3.kt");
                            }

                            @TestMetadata("4.kt")
                            public void test4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/4.kt");
                            }

                            @TestMetadata("5.kt")
                            public void test5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/5.kt");
                            }

                            @TestMetadata("6.kt")
                            public void test6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/6.kt");
                            }

                            @TestMetadata("7.kt")
                            public void test7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos/7.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/initialization/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class UnreachableCode extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInUnreachableCode() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/neg/1.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/1.kt");
                            }

                            @TestMetadata("2.kt")
                            public void test2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/2.kt");
                            }

                            @TestMetadata("3.kt")
                            public void test3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/3.kt");
                            }

                            @TestMetadata("4.kt")
                            public void test4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/4.kt");
                            }

                            @TestMetadata("5.kt")
                            public void test5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/5.kt");
                            }

                            @TestMetadata("6.kt")
                            public void test6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/6.kt");
                            }

                            @TestMetadata("7.kt")
                            public void test7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos/7.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/controlFlow/unreachableCode/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Smartcasts extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInSmartcasts() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/1.kt");
                        }

                        @TestMetadata("10.kt")
                        public void test10() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/10.kt");
                        }

                        @TestMetadata("11.kt")
                        public void test11() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/11.kt");
                        }

                        @TestMetadata("12.kt")
                        public void test12() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/12.kt");
                        }

                        @TestMetadata("13.kt")
                        public void test13() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/13.kt");
                        }

                        @TestMetadata("14.kt")
                        public void test14() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/14.kt");
                        }

                        @TestMetadata("15.kt")
                        public void test15() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/15.kt");
                        }

                        @TestMetadata("2.kt")
                        public void test2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/2.kt");
                        }

                        @TestMetadata("3.kt")
                        public void test3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/3.kt");
                        }

                        @TestMetadata("4.kt")
                        public void test4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/4.kt");
                        }

                        @TestMetadata("5.kt")
                        public void test5() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/5.kt");
                        }

                        @TestMetadata("6.kt")
                        public void test6() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/6.kt");
                        }

                        @TestMetadata("7.kt")
                        public void test7() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/7.kt");
                        }

                        @TestMetadata("8.kt")
                        public void test8() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/8.kt");
                        }

                        @TestMetadata("9.kt")
                        public void test9() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg/9.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/1.kt");
                        }

                        @TestMetadata("10.kt")
                        public void test10() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/10.kt");
                        }

                        @TestMetadata("11.kt")
                        public void test11() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/11.kt");
                        }

                        @TestMetadata("12.kt")
                        public void test12() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/12.kt");
                        }

                        @TestMetadata("13.kt")
                        public void test13() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/13.kt");
                        }

                        @TestMetadata("14.kt")
                        public void test14() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/14.kt");
                        }

                        @TestMetadata("2.kt")
                        public void test2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/2.kt");
                        }

                        @TestMetadata("3.kt")
                        public void test3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/3.kt");
                        }

                        @TestMetadata("4.kt")
                        public void test4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/4.kt");
                        }

                        @TestMetadata("5.kt")
                        public void test5() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/5.kt");
                        }

                        @TestMetadata("6.kt")
                        public void test6() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/6.kt");
                        }

                        @TestMetadata("7.kt")
                        public void test7() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/7.kt");
                        }

                        @TestMetadata("8.kt")
                        public void test8() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/8.kt");
                        }

                        @TestMetadata("9.kt")
                        public void test9() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos/9.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/analysis/smartcasts/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Declarations extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDeclarations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class ContractBuilder extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInContractBuilder() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Common extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInCommon() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Neg extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/1.kt");
                            }

                            @TestMetadata("10.kt")
                            public void test10() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/10.kt");
                            }

                            @TestMetadata("11.kt")
                            public void test11() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/11.kt");
                            }

                            @TestMetadata("12.kt")
                            public void test12() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/12.kt");
                            }

                            @TestMetadata("13.kt")
                            public void test13() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/13.kt");
                            }

                            @TestMetadata("14.kt")
                            public void test14() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/14.kt");
                            }

                            @TestMetadata("15.kt")
                            public void test15() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/15.kt");
                            }

                            @TestMetadata("16.kt")
                            public void test16() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/16.kt");
                            }

                            @TestMetadata("17.kt")
                            public void test17() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/17.kt");
                            }

                            @TestMetadata("19.kt")
                            public void test19() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/19.kt");
                            }

                            @TestMetadata("2.kt")
                            public void test2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/2.kt");
                            }

                            @TestMetadata("3.kt")
                            public void test3() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/3.kt");
                            }

                            @TestMetadata("4.kt")
                            public void test4() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/4.kt");
                            }

                            @TestMetadata("5.kt")
                            public void test5() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/5.kt");
                            }

                            @TestMetadata("6.kt")
                            public void test6() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/6.kt");
                            }

                            @TestMetadata("7.kt")
                            public void test7() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/7.kt");
                            }

                            @TestMetadata("8.kt")
                            public void test8() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/8.kt");
                            }

                            @TestMetadata("9.kt")
                            public void test9() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg/9.kt");
                            }

                            public void testAllFilesPresentInNeg() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.kt")
                            public void test1() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos/1.kt");
                            }

                            @TestMetadata("2.kt")
                            public void test2() throws Exception {
                                runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos/2.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/common/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Effects extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInEffects() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class CallsInPlace extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            public void testAllFilesPresentInCallsInPlace() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                                }

                                @TestMetadata("1.kt")
                                public void test1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg/1.kt");
                                }

                                @TestMetadata("2.kt")
                                public void test2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg/2.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                                }
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                                }

                                @TestMetadata("1.kt")
                                public void test1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos/1.kt");
                                }

                                @TestMetadata("2.kt")
                                public void test2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos/2.kt");
                                }

                                @TestMetadata("3.kt")
                                public void test3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos/3.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/callsInPlace/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                                }
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Common extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            public void testAllFilesPresentInCommon() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                                }

                                @TestMetadata("1.kt")
                                public void test1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common/neg/1.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/common/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                                }
                            }
                        }

                        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Returns extends AbstractDiagnosticsTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            public void testAllFilesPresentInReturns() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Neg extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                                }

                                @TestMetadata("1.kt")
                                public void test1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/1.kt");
                                }

                                @TestMetadata("2.kt")
                                public void test2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/2.kt");
                                }

                                @TestMetadata("3.kt")
                                public void test3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/3.kt");
                                }

                                @TestMetadata("4.kt")
                                public void test4() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/4.kt");
                                }

                                @TestMetadata("5.kt")
                                public void test5() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/5.kt");
                                }

                                @TestMetadata("6.kt")
                                public void test6() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/6.kt");
                                }

                                @TestMetadata("7.kt")
                                public void test7() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg/7.kt");
                                }

                                public void testAllFilesPresentInNeg() throws Exception {
                                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                                }
                            }

                            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos")
                            @TestDataPath("$PROJECT_ROOT")
                            @RunWith(JUnit3RunnerWithInners.class)
                            public static class Pos extends AbstractDiagnosticsTestSpec {
                                private void runTest(String testDataFilePath) throws Exception {
                                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                                }

                                @TestMetadata("1.kt")
                                public void test1() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/1.kt");
                                }

                                @TestMetadata("2.kt")
                                public void test2() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/2.kt");
                                }

                                @TestMetadata("3.kt")
                                public void test3() throws Exception {
                                    runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos/3.kt");
                                }

                                public void testAllFilesPresentInPos() throws Exception {
                                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractBuilder/effects/returns/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                                }
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class ContractFunction extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInContractFunction() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Neg extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/1.kt");
                        }

                        @TestMetadata("2.kt")
                        public void test2() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/2.kt");
                        }

                        @TestMetadata("3.kt")
                        public void test3() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/3.kt");
                        }

                        @TestMetadata("4.kt")
                        public void test4() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg/4.kt");
                        }

                        public void testAllFilesPresentInNeg() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }

                    @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractDiagnosticsTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.kt")
                        public void test1() throws Exception {
                            runTest("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos/1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/contracts/declarations/contractFunction/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/local-variables")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Local_variables extends AbstractDiagnosticsTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInLocal_variables() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/local-variables"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Type_parameters extends AbstractDiagnosticsTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInType_parameters() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractDiagnosticsTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters/neg/1.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/diagnostics/notLinked/local-variables/type-parameters/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }
        }
    }
}
