/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef FORM_PAGEPOLICY_H
#define FORM_PAGEPOLICY_H

#include <QtCore/QString>

namespace Form
{

class PagePolicy
{
  public:

    /**
     * There are 3 states the form can be in:
     *  - Add When a new entry is added.
     *  - Modify When an existing entry is modified.
     *  - Delete When an existing entry shall be deleted.
     */
    enum State
    {
      Add,
      Modify,
      Delete
    };

    /**
     * Creates a new PagePolicy object which returns 'true' for all
     * check functions.
     */
    PagePolicy();

    virtual ~PagePolicy();

    /**
     * Returns whether the field with the given name is editable in the
     * given state.
     */
    virtual bool fieldEditable( State state, const QString &name ) const;

    /**
     * Returns whether the field with the given name is visible in the
     * given state.
     */
    virtual bool fieldVisible( State state, const QString &name ) const;

    /**
     * Returns whether the whole container with the given name is
     * editable in the given state.
     */
    virtual bool containerEditable( State state, const QString &name ) const;
};

}

#endif
