
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSpinBox.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSpinBox>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLineEdit>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionSpinBox>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSpinBox

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSpinBox::staticMetaObject);
}


// QString QSpinBox::cleanText()


static void _init_f_cleanText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_cleanText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSpinBox *)cls)->cleanText ());
}


// int QSpinBox::displayIntegerBase()


static void _init_f_displayIntegerBase_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_displayIntegerBase_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSpinBox *)cls)->displayIntegerBase ());
}


// int QSpinBox::maximum()


static void _init_f_maximum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximum_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSpinBox *)cls)->maximum ());
}


// int QSpinBox::minimum()


static void _init_f_minimum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimum_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSpinBox *)cls)->minimum ());
}


// QString QSpinBox::prefix()


static void _init_f_prefix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_prefix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSpinBox *)cls)->prefix ());
}


// void QSpinBox::setDisplayIntegerBase(int base)


static void _init_f_setDisplayIntegerBase_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("base");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDisplayIntegerBase_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox *)cls)->setDisplayIntegerBase (arg1);
}


// void QSpinBox::setMaximum(int max)


static void _init_f_setMaximum_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("max");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximum_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox *)cls)->setMaximum (arg1);
}


// void QSpinBox::setMinimum(int min)


static void _init_f_setMinimum_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimum_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox *)cls)->setMinimum (arg1);
}


// void QSpinBox::setPrefix(const QString &prefix)


static void _init_f_setPrefix_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("prefix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPrefix_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox *)cls)->setPrefix (arg1);
}


// void QSpinBox::setRange(int min, int max)


static void _init_f_setRange_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRange_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox *)cls)->setRange (arg1, arg2);
}


// void QSpinBox::setSingleStep(int val)


static void _init_f_setSingleStep_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("val");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSingleStep_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox *)cls)->setSingleStep (arg1);
}


// void QSpinBox::setStepType(QAbstractSpinBox::StepType stepType)


static void _init_f_setStepType_2990 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stepType");
  decl->add_arg<const qt_gsi::Converter<QAbstractSpinBox::StepType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStepType_2990 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSpinBox::StepType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractSpinBox::StepType>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox *)cls)->setStepType (qt_gsi::QtToCppAdaptor<QAbstractSpinBox::StepType>(arg1).cref());
}


// void QSpinBox::setSuffix(const QString &suffix)


static void _init_f_setSuffix_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("suffix");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSuffix_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox *)cls)->setSuffix (arg1);
}


// void QSpinBox::setValue(int val)


static void _init_f_setValue_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("val");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setValue_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox *)cls)->setValue (arg1);
}


// int QSpinBox::singleStep()


static void _init_f_singleStep_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_singleStep_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSpinBox *)cls)->singleStep ());
}


// QAbstractSpinBox::StepType QSpinBox::stepType()


static void _init_f_stepType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSpinBox::StepType>::target_type > ();
}

static void _call_f_stepType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractSpinBox::StepType>::target_type > ((qt_gsi::Converter<QAbstractSpinBox::StepType>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSpinBox::StepType>(((QSpinBox *)cls)->stepType ()));
}


// QString QSpinBox::suffix()


static void _init_f_suffix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_suffix_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QSpinBox *)cls)->suffix ());
}


// int QSpinBox::value()


static void _init_f_value_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_value_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSpinBox *)cls)->value ());
}


// static QString QSpinBox::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSpinBox::tr (arg1, arg2, arg3));
}


// static QString QSpinBox::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QSpinBox::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSpinBox () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":cleanText", "@brief Method QString QSpinBox::cleanText()\n", true, &_init_f_cleanText_c0, &_call_f_cleanText_c0);
  methods += new qt_gsi::GenericMethod (":displayIntegerBase", "@brief Method int QSpinBox::displayIntegerBase()\n", true, &_init_f_displayIntegerBase_c0, &_call_f_displayIntegerBase_c0);
  methods += new qt_gsi::GenericMethod (":maximum", "@brief Method int QSpinBox::maximum()\n", true, &_init_f_maximum_c0, &_call_f_maximum_c0);
  methods += new qt_gsi::GenericMethod (":minimum", "@brief Method int QSpinBox::minimum()\n", true, &_init_f_minimum_c0, &_call_f_minimum_c0);
  methods += new qt_gsi::GenericMethod (":prefix", "@brief Method QString QSpinBox::prefix()\n", true, &_init_f_prefix_c0, &_call_f_prefix_c0);
  methods += new qt_gsi::GenericMethod ("setDisplayIntegerBase|displayIntegerBase=", "@brief Method void QSpinBox::setDisplayIntegerBase(int base)\n", false, &_init_f_setDisplayIntegerBase_767, &_call_f_setDisplayIntegerBase_767);
  methods += new qt_gsi::GenericMethod ("setMaximum|maximum=", "@brief Method void QSpinBox::setMaximum(int max)\n", false, &_init_f_setMaximum_767, &_call_f_setMaximum_767);
  methods += new qt_gsi::GenericMethod ("setMinimum|minimum=", "@brief Method void QSpinBox::setMinimum(int min)\n", false, &_init_f_setMinimum_767, &_call_f_setMinimum_767);
  methods += new qt_gsi::GenericMethod ("setPrefix|prefix=", "@brief Method void QSpinBox::setPrefix(const QString &prefix)\n", false, &_init_f_setPrefix_2025, &_call_f_setPrefix_2025);
  methods += new qt_gsi::GenericMethod ("setRange", "@brief Method void QSpinBox::setRange(int min, int max)\n", false, &_init_f_setRange_1426, &_call_f_setRange_1426);
  methods += new qt_gsi::GenericMethod ("setSingleStep|singleStep=", "@brief Method void QSpinBox::setSingleStep(int val)\n", false, &_init_f_setSingleStep_767, &_call_f_setSingleStep_767);
  methods += new qt_gsi::GenericMethod ("setStepType|stepType=", "@brief Method void QSpinBox::setStepType(QAbstractSpinBox::StepType stepType)\n", false, &_init_f_setStepType_2990, &_call_f_setStepType_2990);
  methods += new qt_gsi::GenericMethod ("setSuffix|suffix=", "@brief Method void QSpinBox::setSuffix(const QString &suffix)\n", false, &_init_f_setSuffix_2025, &_call_f_setSuffix_2025);
  methods += new qt_gsi::GenericMethod ("setValue|value=", "@brief Method void QSpinBox::setValue(int val)\n", false, &_init_f_setValue_767, &_call_f_setValue_767);
  methods += new qt_gsi::GenericMethod (":singleStep", "@brief Method int QSpinBox::singleStep()\n", true, &_init_f_singleStep_c0, &_call_f_singleStep_c0);
  methods += new qt_gsi::GenericMethod (":stepType", "@brief Method QAbstractSpinBox::StepType QSpinBox::stepType()\n", true, &_init_f_stepType_c0, &_call_f_stepType_c0);
  methods += new qt_gsi::GenericMethod (":suffix", "@brief Method QString QSpinBox::suffix()\n", true, &_init_f_suffix_c0, &_call_f_suffix_c0);
  methods += new qt_gsi::GenericMethod (":value", "@brief Method int QSpinBox::value()\n", true, &_init_f_value_c0, &_call_f_value_c0);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QSpinBox::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSpinBox::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("editingFinished()", "editingFinished", "@brief Signal declaration for QSpinBox::editingFinished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QSpinBox::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("valueChanged(int)", "valueChanged", gsi::arg("arg1"), "@brief Signal declaration for QSpinBox::valueChanged(int)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("valueChanged(const QString &)", "valueChanged_qs", gsi::arg("arg1"), "@brief Signal declaration for QSpinBox::valueChanged(const QString &)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QSpinBox::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QSpinBox::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QSpinBox::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSpinBox::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSpinBox::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractSpinBox> &qtdecl_QAbstractSpinBox ();

qt_gsi::QtNativeClass<QSpinBox> decl_QSpinBox (qtdecl_QAbstractSpinBox (), "QtWidgets", "QSpinBox_Native",
  methods_QSpinBox (),
  "@hide\n@alias QSpinBox");

GSI_QTWIDGETS_PUBLIC gsi::Class<QSpinBox> &qtdecl_QSpinBox () { return decl_QSpinBox; }

}


class QSpinBox_Adaptor : public QSpinBox, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSpinBox_Adaptor();

  //  [adaptor ctor] QSpinBox::QSpinBox(QWidget *parent)
  QSpinBox_Adaptor() : QSpinBox()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSpinBox::QSpinBox(QWidget *parent)
  QSpinBox_Adaptor(QWidget *parent) : QSpinBox(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QSpinBox::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QSpinBox_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QSpinBox::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QSpinBox::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QSpinBox_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QSpinBox::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QSpinBox::focusNextChild()
  bool fp_QSpinBox_focusNextChild_0 () {
    return QSpinBox::focusNextChild();
  }

  //  [expose] bool QSpinBox::focusPreviousChild()
  bool fp_QSpinBox_focusPreviousChild_0 () {
    return QSpinBox::focusPreviousChild();
  }

  //  [expose] void QSpinBox::initStyleOption(QStyleOptionSpinBox *option)
  void fp_QSpinBox_initStyleOption_c2572 (QStyleOptionSpinBox *option) const {
    QSpinBox::initStyleOption(option);
  }

  //  [expose] bool QSpinBox::isSignalConnected(const QMetaMethod &signal)
  bool fp_QSpinBox_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QSpinBox::isSignalConnected(signal);
  }

  //  [expose] QLineEdit *QSpinBox::lineEdit()
  QLineEdit * fp_QSpinBox_lineEdit_c0 () const {
    return QSpinBox::lineEdit();
  }

  //  [expose] int QSpinBox::receivers(const char *signal)
  int fp_QSpinBox_receivers_c1731 (const char *signal) const {
    return QSpinBox::receivers(signal);
  }

  //  [expose] QObject *QSpinBox::sender()
  QObject * fp_QSpinBox_sender_c0 () const {
    return QSpinBox::sender();
  }

  //  [expose] int QSpinBox::senderSignalIndex()
  int fp_QSpinBox_senderSignalIndex_c0 () const {
    return QSpinBox::senderSignalIndex();
  }

  //  [expose] void QSpinBox::setLineEdit(QLineEdit *edit)
  void fp_QSpinBox_setLineEdit_1485 (QLineEdit *edit) {
    QSpinBox::setLineEdit(edit);
  }

  //  [expose] void QSpinBox::updateMicroFocus()
  void fp_QSpinBox_updateMicroFocus_0 () {
    QSpinBox::updateMicroFocus();
  }

  //  [adaptor impl] void QSpinBox::clear()
  void cbs_clear_0_0()
  {
    QSpinBox::clear();
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QSpinBox_Adaptor>(&QSpinBox_Adaptor::cbs_clear_0_0);
    } else {
      QSpinBox::clear();
    }
  }

  //  [emitter impl] void QSpinBox::customContextMenuRequested(const QPoint &pos)
  void emitter_QSpinBox_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QSpinBox::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QSpinBox::destroyed(QObject *)
  void emitter_QSpinBox_destroyed_1302(QObject *arg1)
  {
    emit QSpinBox::destroyed(arg1);
  }

  //  [emitter impl] void QSpinBox::editingFinished()
  void emitter_QSpinBox_editingFinished_0()
  {
    emit QSpinBox::editingFinished();
  }

  //  [adaptor impl] bool QSpinBox::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QSpinBox::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSpinBox_Adaptor, bool, QObject *, QEvent *>(&QSpinBox_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QSpinBox::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QSpinBox::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QSpinBox::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QSpinBox_Adaptor, bool>(&QSpinBox_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QSpinBox::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QSpinBox::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QSpinBox::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QSpinBox_Adaptor, int, int>(&QSpinBox_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QSpinBox::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QSpinBox::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QSpinBox::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QSpinBox_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QSpinBox_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QSpinBox::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QSpinBox::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QSpinBox::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QSpinBox_Adaptor, QSize>(&QSpinBox_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QSpinBox::minimumSizeHint();
    }
  }

  //  [emitter impl] void QSpinBox::objectNameChanged(const QString &objectName)
  void emitter_QSpinBox_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QSpinBox::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QSpinBox::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QSpinBox::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QSpinBox_Adaptor, QPaintEngine *>(&QSpinBox_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QSpinBox::paintEngine();
    }
  }

  //  [adaptor impl] void QSpinBox::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QSpinBox::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QSpinBox_Adaptor, bool>(&QSpinBox_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QSpinBox::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QSpinBox::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QSpinBox::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QSpinBox_Adaptor, QSize>(&QSpinBox_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QSpinBox::sizeHint();
    }
  }

  //  [adaptor impl] void QSpinBox::stepBy(int steps)
  void cbs_stepBy_767_0(int steps)
  {
    QSpinBox::stepBy(steps);
  }

  virtual void stepBy(int steps)
  {
    if (cb_stepBy_767_0.can_issue()) {
      cb_stepBy_767_0.issue<QSpinBox_Adaptor, int>(&QSpinBox_Adaptor::cbs_stepBy_767_0, steps);
    } else {
      QSpinBox::stepBy(steps);
    }
  }

  //  [emitter impl] void QSpinBox::valueChanged(int)
  void emitter_QSpinBox_valueChanged_767(int arg1)
  {
    emit QSpinBox::valueChanged(arg1);
  }

  //  [emitter impl] void QSpinBox::valueChanged(const QString &)
  void emitter_QSpinBox_valueChanged_2025(const QString &arg1)
  {
    emit QSpinBox::valueChanged(arg1);
  }

  //  [emitter impl] void QSpinBox::windowIconChanged(const QIcon &icon)
  void emitter_QSpinBox_windowIconChanged_1787(const QIcon &icon)
  {
    emit QSpinBox::windowIconChanged(icon);
  }

  //  [emitter impl] void QSpinBox::windowIconTextChanged(const QString &iconText)
  void emitter_QSpinBox_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QSpinBox::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QSpinBox::windowTitleChanged(const QString &title)
  void emitter_QSpinBox_windowTitleChanged_2025(const QString &title)
  {
    emit QSpinBox::windowTitleChanged(title);
  }

  //  [adaptor impl] void QSpinBox::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QSpinBox::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QSpinBox_Adaptor, QActionEvent *>(&QSpinBox_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QSpinBox::actionEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::changeEvent(QEvent *event)
  void cbs_changeEvent_1217_0(QEvent *event)
  {
    QSpinBox::changeEvent(event);
  }

  virtual void changeEvent(QEvent *event)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QSpinBox_Adaptor, QEvent *>(&QSpinBox_Adaptor::cbs_changeEvent_1217_0, event);
    } else {
      QSpinBox::changeEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QSpinBox::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSpinBox_Adaptor, QChildEvent *>(&QSpinBox_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QSpinBox::childEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QSpinBox::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QSpinBox_Adaptor, QCloseEvent *>(&QSpinBox_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QSpinBox::closeEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::contextMenuEvent(QContextMenuEvent *event)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *event)
  {
    QSpinBox::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QSpinBox_Adaptor, QContextMenuEvent *>(&QSpinBox_Adaptor::cbs_contextMenuEvent_2363_0, event);
    } else {
      QSpinBox::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QSpinBox::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSpinBox_Adaptor, QEvent *>(&QSpinBox_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QSpinBox::customEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QSpinBox::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QSpinBox_Adaptor, const QMetaMethod &>(&QSpinBox_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QSpinBox::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QSpinBox::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QSpinBox::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QSpinBox_Adaptor, QDragEnterEvent *>(&QSpinBox_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QSpinBox::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QSpinBox::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QSpinBox_Adaptor, QDragLeaveEvent *>(&QSpinBox_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QSpinBox::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QSpinBox::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QSpinBox_Adaptor, QDragMoveEvent *>(&QSpinBox_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QSpinBox::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QSpinBox::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QSpinBox_Adaptor, QDropEvent *>(&QSpinBox_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QSpinBox::dropEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::enterEvent(QEvent *event)
  void cbs_enterEvent_1217_0(QEvent *event)
  {
    QSpinBox::enterEvent(event);
  }

  virtual void enterEvent(QEvent *event)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QSpinBox_Adaptor, QEvent *>(&QSpinBox_Adaptor::cbs_enterEvent_1217_0, event);
    } else {
      QSpinBox::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QSpinBox::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QSpinBox::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSpinBox_Adaptor, bool, QEvent *>(&QSpinBox_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QSpinBox::event(_event);
    }
  }

  //  [adaptor impl] void QSpinBox::fixup(QString &str)
  void cbs_fixup_c1330_0(QString &str) const
  {
    QSpinBox::fixup(str);
  }

  virtual void fixup(QString &str) const
  {
    if (cb_fixup_c1330_0.can_issue()) {
      cb_fixup_c1330_0.issue<QSpinBox_Adaptor, QString &>(&QSpinBox_Adaptor::cbs_fixup_c1330_0, str);
    } else {
      QSpinBox::fixup(str);
    }
  }

  //  [adaptor impl] void QSpinBox::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QSpinBox::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QSpinBox_Adaptor, QFocusEvent *>(&QSpinBox_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QSpinBox::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QSpinBox::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QSpinBox::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QSpinBox_Adaptor, bool, bool>(&QSpinBox_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QSpinBox::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QSpinBox::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QSpinBox::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QSpinBox_Adaptor, QFocusEvent *>(&QSpinBox_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QSpinBox::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QSpinBox::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QSpinBox_Adaptor, QHideEvent *>(&QSpinBox_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QSpinBox::hideEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QSpinBox::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QSpinBox_Adaptor, QPainter *>(&QSpinBox_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QSpinBox::initPainter(painter);
    }
  }

  //  [adaptor impl] void QSpinBox::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QSpinBox::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QSpinBox_Adaptor, QInputMethodEvent *>(&QSpinBox_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QSpinBox::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QSpinBox::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QSpinBox::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QSpinBox_Adaptor, QKeyEvent *>(&QSpinBox_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QSpinBox::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QSpinBox::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QSpinBox_Adaptor, QKeyEvent *>(&QSpinBox_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QSpinBox::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QSpinBox::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QSpinBox_Adaptor, QEvent *>(&QSpinBox_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QSpinBox::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QSpinBox::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QSpinBox::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QSpinBox_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QSpinBox_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QSpinBox::metric(arg1);
    }
  }

  //  [adaptor impl] void QSpinBox::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QSpinBox::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QSpinBox_Adaptor, QMouseEvent *>(&QSpinBox_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QSpinBox::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QSpinBox::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QSpinBox_Adaptor, QMouseEvent *>(&QSpinBox_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QSpinBox::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QSpinBox::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QSpinBox_Adaptor, QMouseEvent *>(&QSpinBox_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QSpinBox::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QSpinBox::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QSpinBox_Adaptor, QMouseEvent *>(&QSpinBox_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QSpinBox::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QSpinBox::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QSpinBox::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QSpinBox_Adaptor, QMoveEvent *>(&QSpinBox_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QSpinBox::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QSpinBox::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QSpinBox::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QSpinBox_Adaptor, bool, const QByteArray &, void *, long int *>(&QSpinBox_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QSpinBox::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QSpinBox::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QSpinBox::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QSpinBox_Adaptor, QPaintEvent *>(&QSpinBox_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QSpinBox::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QSpinBox::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QSpinBox::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QSpinBox_Adaptor, QPaintDevice *, QPoint *>(&QSpinBox_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QSpinBox::redirected(offset);
    }
  }

  //  [adaptor impl] void QSpinBox::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QSpinBox::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QSpinBox_Adaptor, QResizeEvent *>(&QSpinBox_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QSpinBox::resizeEvent(event);
    }
  }

  //  [adaptor impl] QPainter *QSpinBox::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QSpinBox::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QSpinBox_Adaptor, QPainter *>(&QSpinBox_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QSpinBox::sharedPainter();
    }
  }

  //  [adaptor impl] void QSpinBox::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QSpinBox::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QSpinBox_Adaptor, QShowEvent *>(&QSpinBox_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QSpinBox::showEvent(event);
    }
  }

  //  [adaptor impl] QFlags<QAbstractSpinBox::StepEnabledFlag> QSpinBox::stepEnabled()
  QFlags<QAbstractSpinBox::StepEnabledFlag> cbs_stepEnabled_c0_0() const
  {
    return QSpinBox::stepEnabled();
  }

  virtual QFlags<QAbstractSpinBox::StepEnabledFlag> stepEnabled() const
  {
    if (cb_stepEnabled_c0_0.can_issue()) {
      return cb_stepEnabled_c0_0.issue<QSpinBox_Adaptor, QFlags<QAbstractSpinBox::StepEnabledFlag> >(&QSpinBox_Adaptor::cbs_stepEnabled_c0_0);
    } else {
      return QSpinBox::stepEnabled();
    }
  }

  //  [adaptor impl] void QSpinBox::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QSpinBox::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QSpinBox_Adaptor, QTabletEvent *>(&QSpinBox_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QSpinBox::tabletEvent(event);
    }
  }

  //  [adaptor impl] QString QSpinBox::textFromValue(int val)
  QString cbs_textFromValue_c767_0(int val) const
  {
    return QSpinBox::textFromValue(val);
  }

  virtual QString textFromValue(int val) const
  {
    if (cb_textFromValue_c767_0.can_issue()) {
      return cb_textFromValue_c767_0.issue<QSpinBox_Adaptor, QString, int>(&QSpinBox_Adaptor::cbs_textFromValue_c767_0, val);
    } else {
      return QSpinBox::textFromValue(val);
    }
  }

  //  [adaptor impl] void QSpinBox::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QSpinBox::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSpinBox_Adaptor, QTimerEvent *>(&QSpinBox_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QSpinBox::timerEvent(event);
    }
  }

  //  [adaptor impl] QValidator::State QSpinBox::validate(QString &input, int &pos)
  qt_gsi::Converter<QValidator::State>::target_type cbs_validate_c2171_0(QString &input, int &pos) const
  {
    return qt_gsi::CppToQtAdaptor<QValidator::State>(QSpinBox::validate(input, pos));
  }

  virtual QValidator::State validate(QString &input, int &pos) const
  {
    if (cb_validate_c2171_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QValidator::State>(cb_validate_c2171_0.issue<QSpinBox_Adaptor, qt_gsi::Converter<QValidator::State>::target_type, QString &, int &>(&QSpinBox_Adaptor::cbs_validate_c2171_0, input, pos)).cref();
    } else {
      return QSpinBox::validate(input, pos);
    }
  }

  //  [adaptor impl] int QSpinBox::valueFromText(const QString &text)
  int cbs_valueFromText_c2025_0(const QString &text) const
  {
    return QSpinBox::valueFromText(text);
  }

  virtual int valueFromText(const QString &text) const
  {
    if (cb_valueFromText_c2025_0.can_issue()) {
      return cb_valueFromText_c2025_0.issue<QSpinBox_Adaptor, int, const QString &>(&QSpinBox_Adaptor::cbs_valueFromText_c2025_0, text);
    } else {
      return QSpinBox::valueFromText(text);
    }
  }

  //  [adaptor impl] void QSpinBox::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QSpinBox::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QSpinBox_Adaptor, QWheelEvent *>(&QSpinBox_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QSpinBox::wheelEvent(event);
    }
  }

  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_stepBy_767_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_fixup_c1330_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_stepEnabled_c0_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_textFromValue_c767_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_validate_c2171_0;
  gsi::Callback cb_valueFromText_c2025_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QSpinBox_Adaptor::~QSpinBox_Adaptor() { }

//  Constructor QSpinBox::QSpinBox(QWidget *parent) (adaptor class)

static void _init_ctor_QSpinBox_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QSpinBox_Adaptor> ();
}

static void _call_ctor_QSpinBox_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QSpinBox_Adaptor *> (new QSpinBox_Adaptor (arg1));
}


// void QSpinBox::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QSpinBox::changeEvent(QEvent *event)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QSpinBox::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QSpinBox::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_clear_0_0 = cb;
}


// void QSpinBox::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QSpinBox::contextMenuEvent(QContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QSpinBox::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->fp_QSpinBox_create_2208 (arg1, arg2, arg3);
}


// emitter void QSpinBox::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QSpinBox_Adaptor *)cls)->emitter_QSpinBox_customContextMenuRequested_1916 (arg1);
}


// void QSpinBox::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QSpinBox::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->fp_QSpinBox_destroy_1620 (arg1, arg2);
}


// emitter void QSpinBox::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QSpinBox_Adaptor *)cls)->emitter_QSpinBox_destroyed_1302 (arg1);
}


// void QSpinBox::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QSpinBox::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QSpinBox::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QSpinBox::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QSpinBox::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// emitter void QSpinBox::editingFinished()

static void _init_emitter_editingFinished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_editingFinished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSpinBox_Adaptor *)cls)->emitter_QSpinBox_editingFinished_0 ();
}


// void QSpinBox::enterEvent(QEvent *event)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QSpinBox::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSpinBox_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSpinBox::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSpinBox_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QSpinBox::fixup(QString &str)

static void _init_cbs_fixup_c1330_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fixup_c1330_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString &arg1 = args.read<QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_fixup_c1330_0 (arg1);
}

static void _set_callback_cbs_fixup_c1330_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_fixup_c1330_0 = cb;
}


// void QSpinBox::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QSpinBox::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSpinBox_Adaptor *)cls)->fp_QSpinBox_focusNextChild_0 ());
}


// bool QSpinBox::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QSpinBox_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QSpinBox::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QSpinBox::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSpinBox_Adaptor *)cls)->fp_QSpinBox_focusPreviousChild_0 ());
}


// bool QSpinBox::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSpinBox_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QSpinBox::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QSpinBox_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QSpinBox::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QSpinBox::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// exposed void QSpinBox::initStyleOption(QStyleOptionSpinBox *option)

static void _init_fp_initStyleOption_c2572 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionSpinBox * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_initStyleOption_c2572 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionSpinBox *arg1 = gsi::arg_reader<QStyleOptionSpinBox * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->fp_QSpinBox_initStyleOption_c2572 (arg1);
}


// void QSpinBox::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QSpinBox::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QSpinBox_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QSpinBox::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QSpinBox_Adaptor *)cls)->fp_QSpinBox_isSignalConnected_c2394 (arg1));
}


// void QSpinBox::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QSpinBox::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QSpinBox::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// exposed QLineEdit *QSpinBox::lineEdit()

static void _init_fp_lineEdit_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLineEdit * > ();
}

static void _call_fp_lineEdit_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLineEdit * > ((QLineEdit *)((QSpinBox_Adaptor *)cls)->fp_QSpinBox_lineEdit_c0 ());
}


// int QSpinBox::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QSpinBox_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QSpinBox::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QSpinBox_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QSpinBox::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QSpinBox::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QSpinBox::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QSpinBox::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QSpinBox::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QSpinBox::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QSpinBox_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// emitter void QSpinBox::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSpinBox_Adaptor *)cls)->emitter_QSpinBox_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QSpinBox::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QSpinBox_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QSpinBox::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QSpinBox::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QSpinBox_Adaptor *)cls)->fp_QSpinBox_receivers_c1731 (arg1));
}


// QPaintDevice *QSpinBox::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QSpinBox_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QSpinBox::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QSpinBox::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSpinBox_Adaptor *)cls)->fp_QSpinBox_sender_c0 ());
}


// exposed int QSpinBox::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSpinBox_Adaptor *)cls)->fp_QSpinBox_senderSignalIndex_c0 ());
}


// exposed void QSpinBox::setLineEdit(QLineEdit *edit)

static void _init_fp_setLineEdit_1485 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("edit");
  decl->add_arg<QLineEdit * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setLineEdit_1485 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLineEdit *arg1 = gsi::arg_reader<QLineEdit * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->fp_QSpinBox_setLineEdit_1485 (arg1);
}


// void QSpinBox::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QSpinBox::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QSpinBox_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QSpinBox::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QSpinBox::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QSpinBox_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QSpinBox::stepBy(int steps)

static void _init_cbs_stepBy_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_stepBy_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_stepBy_767_0 (arg1);
}

static void _set_callback_cbs_stepBy_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_stepBy_767_0 = cb;
}


// QFlags<QAbstractSpinBox::StepEnabledFlag> QSpinBox::stepEnabled()

static void _init_cbs_stepEnabled_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QAbstractSpinBox::StepEnabledFlag> > ();
}

static void _call_cbs_stepEnabled_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QAbstractSpinBox::StepEnabledFlag> > ((QFlags<QAbstractSpinBox::StepEnabledFlag>)((QSpinBox_Adaptor *)cls)->cbs_stepEnabled_c0_0 ());
}

static void _set_callback_cbs_stepEnabled_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_stepEnabled_c0_0 = cb;
}


// void QSpinBox::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// QString QSpinBox::textFromValue(int val)

static void _init_cbs_textFromValue_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("val");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_cbs_textFromValue_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QString > ((QString)((QSpinBox_Adaptor *)cls)->cbs_textFromValue_c767_0 (arg1));
}

static void _set_callback_cbs_textFromValue_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_textFromValue_c767_0 = cb;
}


// void QSpinBox::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QSpinBox::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->fp_QSpinBox_updateMicroFocus_0 ();
}


// QValidator::State QSpinBox::validate(QString &input, int &pos)

static void _init_cbs_validate_c2171_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pos");
  decl->add_arg<int & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QValidator::State>::target_type > ();
}

static void _call_cbs_validate_c2171_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString &arg1 = args.read<QString & > (heap);
  int &arg2 = args.read<int & > (heap);
  ret.write<qt_gsi::Converter<QValidator::State>::target_type > ((qt_gsi::Converter<QValidator::State>::target_type)((QSpinBox_Adaptor *)cls)->cbs_validate_c2171_0 (arg1, arg2));
}

static void _set_callback_cbs_validate_c2171_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_validate_c2171_0 = cb;
}


// emitter void QSpinBox::valueChanged(int)

static void _init_emitter_valueChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_valueChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QSpinBox_Adaptor *)cls)->emitter_QSpinBox_valueChanged_767 (arg1);
}


// emitter void QSpinBox::valueChanged(const QString &)

static void _init_emitter_valueChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_valueChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSpinBox_Adaptor *)cls)->emitter_QSpinBox_valueChanged_2025 (arg1);
}


// int QSpinBox::valueFromText(const QString &text)

static void _init_cbs_valueFromText_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_valueFromText_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<int > ((int)((QSpinBox_Adaptor *)cls)->cbs_valueFromText_c2025_0 (arg1));
}

static void _set_callback_cbs_valueFromText_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_valueFromText_c2025_0 = cb;
}


// void QSpinBox::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSpinBox_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QSpinBox_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QSpinBox::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QSpinBox_Adaptor *)cls)->emitter_QSpinBox_windowIconChanged_1787 (arg1);
}


// emitter void QSpinBox::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSpinBox_Adaptor *)cls)->emitter_QSpinBox_windowIconTextChanged_2025 (arg1);
}


// emitter void QSpinBox::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QSpinBox_Adaptor *)cls)->emitter_QSpinBox_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QSpinBox> &qtdecl_QSpinBox ();

static gsi::Methods methods_QSpinBox_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSpinBox::QSpinBox(QWidget *parent)\nThis method creates an object of class QSpinBox.", &_init_ctor_QSpinBox_Adaptor_1315, &_call_ctor_QSpinBox_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QSpinBox::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QSpinBox::changeEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSpinBox::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QSpinBox::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QSpinBox::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QSpinBox::contextMenuEvent(QContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*create|qt_create", "@brief Method void QSpinBox::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QSpinBox::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSpinBox::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*destroy|qt_destroy", "@brief Method void QSpinBox::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSpinBox::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSpinBox::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QSpinBox::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QSpinBox::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QSpinBox::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QSpinBox::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("emit_editingFinished", "@brief Emitter for signal void QSpinBox::editingFinished()\nCall this method to emit this signal.", false, &_init_emitter_editingFinished_0, &_call_emitter_editingFinished_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QSpinBox::enterEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QSpinBox::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSpinBox::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*fixup", "@brief Virtual method void QSpinBox::fixup(QString &str)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_fixup_c1330_0, &_call_cbs_fixup_c1330_0);
  methods += new qt_gsi::GenericMethod ("*fixup", "@hide", true, &_init_cbs_fixup_c1330_0, &_call_cbs_fixup_c1330_0, &_set_callback_cbs_fixup_c1330_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QSpinBox::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QSpinBox::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QSpinBox::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QSpinBox::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QSpinBox::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QSpinBox::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QSpinBox::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QSpinBox::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QSpinBox::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Method void QSpinBox::initStyleOption(QStyleOptionSpinBox *option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initStyleOption_c2572, &_call_fp_initStyleOption_c2572);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QSpinBox::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QSpinBox::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QSpinBox::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QSpinBox::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QSpinBox::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QSpinBox::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*lineEdit", "@brief Method QLineEdit *QSpinBox::lineEdit()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_lineEdit_c0, &_call_fp_lineEdit_c0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QSpinBox::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QSpinBox::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QSpinBox::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QSpinBox::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QSpinBox::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QSpinBox::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QSpinBox::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QSpinBox::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QSpinBox::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QSpinBox::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QSpinBox::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSpinBox::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QSpinBox::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QSpinBox::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSpinBox::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QSpinBox::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setLineEdit", "@brief Method void QSpinBox::setLineEdit(QLineEdit *edit)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setLineEdit_1485, &_call_fp_setLineEdit_1485);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QSpinBox::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QSpinBox::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QSpinBox::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QSpinBox::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("stepBy", "@brief Virtual method void QSpinBox::stepBy(int steps)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_stepBy_767_0, &_call_cbs_stepBy_767_0);
  methods += new qt_gsi::GenericMethod ("stepBy", "@hide", false, &_init_cbs_stepBy_767_0, &_call_cbs_stepBy_767_0, &_set_callback_cbs_stepBy_767_0);
  methods += new qt_gsi::GenericMethod ("*stepEnabled", "@brief Virtual method QFlags<QAbstractSpinBox::StepEnabledFlag> QSpinBox::stepEnabled()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_stepEnabled_c0_0, &_call_cbs_stepEnabled_c0_0);
  methods += new qt_gsi::GenericMethod ("*stepEnabled", "@hide", true, &_init_cbs_stepEnabled_c0_0, &_call_cbs_stepEnabled_c0_0, &_set_callback_cbs_stepEnabled_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QSpinBox::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*textFromValue", "@brief Virtual method QString QSpinBox::textFromValue(int val)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_textFromValue_c767_0, &_call_cbs_textFromValue_c767_0);
  methods += new qt_gsi::GenericMethod ("*textFromValue", "@hide", true, &_init_cbs_textFromValue_c767_0, &_call_cbs_textFromValue_c767_0, &_set_callback_cbs_textFromValue_c767_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSpinBox::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QSpinBox::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*validate", "@brief Virtual method QValidator::State QSpinBox::validate(QString &input, int &pos)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_validate_c2171_0, &_call_cbs_validate_c2171_0);
  methods += new qt_gsi::GenericMethod ("*validate", "@hide", true, &_init_cbs_validate_c2171_0, &_call_cbs_validate_c2171_0, &_set_callback_cbs_validate_c2171_0);
  methods += new qt_gsi::GenericMethod ("emit_valueChanged", "@brief Emitter for signal void QSpinBox::valueChanged(int)\nCall this method to emit this signal.", false, &_init_emitter_valueChanged_767, &_call_emitter_valueChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_valueChanged_qs", "@brief Emitter for signal void QSpinBox::valueChanged(const QString &)\nCall this method to emit this signal.", false, &_init_emitter_valueChanged_2025, &_call_emitter_valueChanged_2025);
  methods += new qt_gsi::GenericMethod ("*valueFromText", "@brief Virtual method int QSpinBox::valueFromText(const QString &text)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_valueFromText_c2025_0, &_call_cbs_valueFromText_c2025_0);
  methods += new qt_gsi::GenericMethod ("*valueFromText", "@hide", true, &_init_cbs_valueFromText_c2025_0, &_call_cbs_valueFromText_c2025_0, &_set_callback_cbs_valueFromText_c2025_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QSpinBox::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QSpinBox::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QSpinBox::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QSpinBox::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QSpinBox_Adaptor> decl_QSpinBox_Adaptor (qtdecl_QSpinBox (), "QtWidgets", "QSpinBox",
  methods_QSpinBox_Adaptor (),
  "@qt\n@brief Binding of QSpinBox");

}

