/* 
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package java.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public  interface   DatabaseMetaData  extends Wrapper
{
    short attributeNoNulls = 0;
    short attributeNullable = 1;
    short attributeNullableUnknown = 2;
    int bestRowNotPseudo	= 1;
    int bestRowPseudo	= 2;
    int bestRowSession     = 2;
    int bestRowTemporary   = 0;
    int bestRowTransaction = 1;
    int bestRowUnknown	= 0;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;
    int functionColumnIn = 1;
    int functionColumnInOut = 2;
    int functionColumnOut = 3;
    int functionColumnResult = 5;
    int functionColumnUnknown = 0;
    int functionNoNulls = 0;
    int functionNoTable		= 1;
    int functionNullable = 1;
    int functionNullableUnknown = 2;    
    int functionResultUnknown	= 0;
    int functionReturn = 4;
    int functionReturnsTable	= 2;
    int importedKeyCascade	= 0;
    int importedKeyInitiallyDeferred  = 5;
    int importedKeyInitiallyImmediate  = 6;
    int importedKeyNoAction = 3;
    int importedKeyNotDeferrable  = 7;
    int importedKeyRestrict = 1;
    int importedKeySetDefault  = 4;
    int importedKeySetNull  = 2;
    int procedureColumnIn = 1;
    int procedureColumnInOut = 2;
    int procedureColumnOut = 4;
    int procedureColumnResult = 3;
    int procedureColumnReturn = 5;
    int procedureColumnUnknown = 0;
    int procedureNoNulls = 0;
    int procedureNoResult		= 1;
    int procedureNullable = 1;
    int procedureNullableUnknown = 2;
    int procedureResultUnknown	= 0;
    int procedureReturnsResult	= 2;
    int sqlStateSQL = 2;
    int sqlStateSQL99 = sqlStateSQL;
    int sqlStateXOpen = 1;
    short tableIndexClustered = 1;
    short tableIndexHashed    = 2;
    short tableIndexOther     = 3;
    short tableIndexStatistic = 0;
    int typeNoNulls = 0;
    int typeNullable = 1;
    int typeNullableUnknown = 2;
    int typePredBasic = 2;
    int typePredChar = 1;
    int typePredNone = 0;
    int typeSearchable  = 3;
    int versionColumnNotPseudo	= 1;
    int versionColumnPseudo	= 2;
    int versionColumnUnknown	= 0;

    public  boolean 	allProceduresAreCallable()  throws  SQLException;
    public  boolean 	allTablesAreSelectable()    throws  SQLException;
    public  boolean 	autoCommitFailureClosesAllResultSets()  throws  SQLException;
    public  boolean 	dataDefinitionCausesTransactionCommit() throws  SQLException;
    public  boolean 	dataDefinitionIgnoredInTransactions()   throws  SQLException;
    public  boolean 	deletesAreDetected(int type)    throws  SQLException;
    public  boolean 	doesMaxRowSizeIncludeBlobs()    throws  SQLException;
    public  ResultSet 	getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern)    throws  SQLException;
    public  ResultSet 	getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable)  throws  SQLException;
    public  ResultSet 	getCatalogs()   throws  SQLException;
    public  String 	getCatalogSeparator()   throws  SQLException;
    public  String 	getCatalogTerm()    throws  SQLException;
    public  ResultSet 	getClientInfoProperties()   throws  SQLException;
    public  ResultSet 	getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern)  throws  SQLException;
    public  ResultSet 	getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws  SQLException;
    public  Connection 	getConnection() throws  SQLException;
    public  ResultSet 	getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable)  throws  SQLException;
    public  int 	getDatabaseMajorVersion()   throws  SQLException;
    public  int 	getDatabaseMinorVersion()   throws  SQLException;
    public  String 	getDatabaseProductName()    throws  SQLException;
    public  String 	getDatabaseProductVersion() throws  SQLException;
    public  int 	getDefaultTransactionIsolation()    throws  SQLException;
    public  int 	getDriverMajorVersion() throws  SQLException;
    public  int 	getDriverMinorVersion() throws  SQLException;
    public  String 	getDriverName() throws  SQLException;
    public  String 	getDriverVersion()  throws  SQLException;
    public  ResultSet 	getExportedKeys(String catalog, String schema, String table)    throws  SQLException;
    public  String 	getExtraNameCharacters()    throws  SQLException;
    public  ResultSet 	getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern)  throws  SQLException;
    public  ResultSet 	getFunctions(String catalog, String schemaPattern, String functionNamePattern)  throws  SQLException;
    public  String 	getIdentifierQuoteString()  throws  SQLException;
    public  ResultSet 	getImportedKeys(String catalog, String schema, String table)    throws  SQLException;
    public  ResultSet 	getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate)  throws  SQLException;
    public  int 	getJDBCMajorVersion()   throws  SQLException;
    public  int 	getJDBCMinorVersion()   throws  SQLException;
    public  int 	getMaxBinaryLiteralLength() throws  SQLException;
    public  int 	getMaxCatalogNameLength()   throws  SQLException;
    public  int 	getMaxCharLiteralLength()   throws  SQLException;
    public  int 	getMaxColumnNameLength()    throws  SQLException;
    public  int 	getMaxColumnsInGroupBy()    throws  SQLException;
    public  int 	getMaxColumnsInIndex()  throws  SQLException;
    public  int 	getMaxColumnsInOrderBy()    throws  SQLException;
    public  int 	getMaxColumnsInSelect() throws  SQLException;
    public  int 	getMaxColumnsInTable()  throws  SQLException;
    public  int 	getMaxConnections() throws  SQLException;
    public  int 	getMaxCursorNameLength()    throws  SQLException;
    public  int 	getMaxIndexLength() throws  SQLException;
    public  int 	getMaxProcedureNameLength() throws  SQLException;
    public  int 	getMaxRowSize() throws  SQLException;
    public  int 	getMaxSchemaNameLength()    throws  SQLException;
    public  int 	getMaxStatementLength() throws  SQLException;
    public  int 	getMaxStatements()  throws  SQLException;
    public  int 	getMaxTableNameLength() throws  SQLException;
    public  int 	getMaxTablesInSelect()  throws  SQLException;
    public  int 	getMaxUserNameLength()  throws  SQLException;
    public  String 	getNumericFunctions()   throws  SQLException;
    public  ResultSet 	getPrimaryKeys(String catalog, String schema, String table) throws  SQLException;
    public  ResultSet 	getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern)    throws  SQLException;
    public  ResultSet 	getProcedures(String catalog, String schemaPattern, String procedureNamePattern)    throws  SQLException;
    public  String 	getProcedureTerm()  throws  SQLException;
    public  int 	getResultSetHoldability()   throws  SQLException;
    public  RowIdLifetime 	getRowIdLifetime()  throws  SQLException;
    public  ResultSet 	getSchemas()    throws  SQLException;
    public  ResultSet 	getSchemas(String catalog, String schemaPattern)    throws  SQLException;
    public  String 	getSchemaTerm() throws  SQLException;
    public  String 	getSearchStringEscape() throws  SQLException;
    public  String 	getSQLKeywords()    throws  SQLException;
    public  int 	getSQLStateType()   throws  SQLException;
    public  String 	getStringFunctions()    throws  SQLException;
    public  ResultSet 	getSuperTables(String catalog, String schemaPattern, String tableNamePattern)   throws  SQLException;
    public  ResultSet 	getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws  SQLException;
    public  String 	getSystemFunctions()    throws  SQLException;
    public  ResultSet 	getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern)   throws  SQLException;
    public  ResultSet 	getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types)    throws  SQLException;
    public  ResultSet 	getTableTypes() throws  SQLException;
    public  String 	getTimeDateFunctions()  throws  SQLException;
    public  ResultSet 	getTypeInfo()   throws  SQLException;
    public  ResultSet 	getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types)  throws  SQLException;
    public  String 	getURL()    throws  SQLException;
    public  String 	getUserName()   throws  SQLException;
    public  ResultSet 	getVersionColumns(String catalog, String schema, String table)  throws  SQLException;
    public  boolean 	insertsAreDetected(int type)    throws  SQLException;
    public  boolean 	isCatalogAtStart()  throws  SQLException;
    public  boolean 	isReadOnly()    throws  SQLException;
    public  boolean 	locatorsUpdateCopy()    throws  SQLException;
    public  boolean 	nullPlusNonNullIsNull() throws  SQLException;
    public  boolean 	nullsAreSortedAtEnd()   throws  SQLException;
    public  boolean 	nullsAreSortedAtStart() throws  SQLException;
    public  boolean 	nullsAreSortedHigh()    throws  SQLException;
    public  boolean 	nullsAreSortedLow() throws  SQLException;
    public  boolean 	othersDeletesAreVisible(int type)   throws  SQLException;
    public  boolean 	othersInsertsAreVisible(int type)   throws  SQLException;
    public  boolean 	othersUpdatesAreVisible(int type)   throws  SQLException;
    public  boolean 	ownDeletesAreVisible(int type)  throws  SQLException;
    public  boolean 	ownInsertsAreVisible(int type)  throws  SQLException;
    public  boolean 	ownUpdatesAreVisible(int type)  throws  SQLException;
    public  boolean 	storesLowerCaseIdentifiers()    throws  SQLException;
    public  boolean 	storesLowerCaseQuotedIdentifiers()  throws  SQLException;
    public  boolean 	storesMixedCaseIdentifiers()    throws  SQLException;
    public  boolean 	storesMixedCaseQuotedIdentifiers()  throws  SQLException;
    public  boolean 	storesUpperCaseIdentifiers()    throws  SQLException;
    public  boolean 	storesUpperCaseQuotedIdentifiers()  throws  SQLException;
    public  boolean 	supportsAlterTableWithAddColumn()   throws  SQLException;
    public  boolean 	supportsAlterTableWithDropColumn()  throws  SQLException;
    public  boolean 	supportsANSI92EntryLevelSQL()   throws  SQLException;
    public  boolean 	supportsANSI92FullSQL() throws  SQLException;
    public  boolean 	supportsANSI92IntermediateSQL() throws  SQLException;
    public  boolean 	supportsBatchUpdates()  throws  SQLException;
    public  boolean 	supportsCatalogsInDataManipulation()    throws  SQLException;
    public  boolean 	supportsCatalogsInIndexDefinitions()    throws  SQLException;
    public  boolean 	supportsCatalogsInPrivilegeDefinitions()    throws  SQLException;
    public  boolean 	supportsCatalogsInProcedureCalls()  throws  SQLException;
    public  boolean 	supportsCatalogsInTableDefinitions()    throws  SQLException;
    public  boolean 	supportsColumnAliasing()    throws  SQLException;
    public  boolean 	supportsConvert()   throws  SQLException;
    public  boolean 	supportsConvert(int fromType, int toType)   throws  SQLException;
    public  boolean 	supportsCoreSQLGrammar()    throws  SQLException;
    public  boolean 	supportsCorrelatedSubqueries()  throws  SQLException;
    public  boolean 	supportsDataDefinitionAndDataManipulationTransactions() throws  SQLException;
    public  boolean 	supportsDataManipulationTransactionsOnly()  throws  SQLException;
    public  boolean 	supportsDifferentTableCorrelationNames()    throws  SQLException;
    public  boolean 	supportsExpressionsInOrderBy()  throws  SQLException;
    public  boolean 	supportsExtendedSQLGrammar()    throws  SQLException;
    public  boolean 	supportsFullOuterJoins()    throws  SQLException;
    public  boolean 	supportsGetGeneratedKeys()  throws  SQLException;
    public  boolean 	supportsGroupBy()   throws  SQLException;
    public  boolean 	supportsGroupByBeyondSelect()   throws  SQLException;
    public  boolean 	supportsGroupByUnrelated()  throws  SQLException;
    public  boolean 	supportsIntegrityEnhancementFacility()  throws  SQLException;
    public  boolean 	supportsLikeEscapeClause()  throws  SQLException;
    public  boolean 	supportsLimitedOuterJoins() throws  SQLException;
    public  boolean 	supportsMinimumSQLGrammar() throws  SQLException;
    public  boolean 	supportsMixedCaseIdentifiers()  throws  SQLException;
    public  boolean 	supportsMixedCaseQuotedIdentifiers()    throws  SQLException;
    public  boolean 	supportsMultipleOpenResults()   throws  SQLException;
    public  boolean 	supportsMultipleResultSets()    throws  SQLException;
    public  boolean 	supportsMultipleTransactions()  throws  SQLException;
    public  boolean 	supportsNamedParameters()   throws  SQLException;
    public  boolean 	supportsNonNullableColumns()    throws  SQLException;
    public  boolean 	supportsOpenCursorsAcrossCommit()   throws  SQLException;
    public  boolean 	supportsOpenCursorsAcrossRollback() throws  SQLException;
    public  boolean 	supportsOpenStatementsAcrossCommit()    throws  SQLException;
    public  boolean 	supportsOpenStatementsAcrossRollback()  throws  SQLException;
    public  boolean 	supportsOrderByUnrelated()  throws  SQLException;
    public  boolean 	supportsOuterJoins()    throws  SQLException;
    public  boolean 	supportsPositionedDelete()  throws  SQLException;
    public  boolean 	supportsPositionedUpdate()  throws  SQLException;
    public  boolean 	supportsResultSetConcurrency(int type, int concurrency) throws  SQLException;
    public  boolean 	supportsResultSetHoldability(int holdability)   throws  SQLException;
    public  boolean 	supportsResultSetType(int type) throws  SQLException;
    public  boolean 	supportsSavepoints()    throws  SQLException;
    public  boolean 	supportsSchemasInDataManipulation() throws  SQLException;
    public  boolean 	supportsSchemasInIndexDefinitions() throws  SQLException;
    public  boolean 	supportsSchemasInPrivilegeDefinitions() throws  SQLException;
    public  boolean 	supportsSchemasInProcedureCalls()   throws  SQLException;
    public  boolean 	supportsSchemasInTableDefinitions() throws  SQLException;
    public  boolean 	supportsSelectForUpdate()   throws  SQLException;
    public  boolean 	supportsStatementPooling()  throws  SQLException;
    public  boolean 	supportsStoredFunctionsUsingCallSyntax()    throws  SQLException;
    public  boolean 	supportsStoredProcedures()  throws  SQLException;
    public  boolean 	supportsSubqueriesInComparisons()   throws  SQLException;
    public  boolean 	supportsSubqueriesInExists()    throws  SQLException;
    public  boolean 	supportsSubqueriesInIns()   throws  SQLException;
    public  boolean 	supportsSubqueriesInQuantifieds()   throws  SQLException;
    public  boolean 	supportsTableCorrelationNames() throws  SQLException;
    public  boolean 	supportsTransactionIsolationLevel(int level)    throws  SQLException;
    public  boolean 	supportsTransactions()  throws  SQLException;
    public  boolean 	supportsUnion() throws  SQLException;
    public  boolean 	supportsUnionAll()  throws  SQLException;
    public  boolean 	updatesAreDetected(int type)    throws  SQLException;
    public  boolean 	usesLocalFilePerTable() throws  SQLException;
    public  boolean 	usesLocalFiles()    throws  SQLException;

}
