#ifndef ID_ASSIGNER_H__
#define ID_ASSIGNER_H__
#include <map>
#include "Stack.h"

template<typename T>
class IdAssigner {

public:
  IdAssigner() {idCounter=0;}
 
  int getId(T t) {
    if( contains(t) ) return idmap[t];
    int id;
    if( idStack.size() > 0 ) id = idStack.pop(); 
    else id = ++idCounter; 
    idmap[t] = id; 
    tmap[id] = t;
    return id;
  }

  T get(int id) {
    return tmap[id];
  }

  void release(T t)
  {
    if( !contains(t) ) return;
    int id = idmap[t];
    idStack.push(id);
    idmap.erase(t); 
    tmap.erase(id);
    
  }

  bool contains(T t) { 
    return idmap.find(t)!=idmap.end();
  }
  bool contains(int id) { 
    return tmap.find(id)!=tmap.end();
  }

private:
  typedef map<T,int> IdMap;
  typedef map<int,T> TMap;
  IdMap idmap;
  TMap tmap;
  int idCounter;
  Stack<int> idStack;


};





#endif
