/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.io.ValueDecoder;
import com.mysql.cj.api.io.ValueFactory;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.jdbc.ResultSetRow;
import com.mysql.cj.jdbc.exceptions.OperationNotSupportedException;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.mysqla.MysqlaUtils;
import com.mysql.cj.mysqla.io.Buffer;
import java.sql.SQLException;

public class BufferRow
extends ResultSetRow {
    private Buffer rowFromServer;
    private int homePosition = 0;
    private int preNullBitmaskHomePosition = 0;
    private int lastRequestedIndex = -1;
    private int lastRequestedPos;
    private Field[] metadata;
    private boolean isBinaryEncoded;
    private boolean[] isNull;

    public BufferRow(Buffer buf, Field[] fields, boolean isBinaryEncoded, ExceptionInterceptor exceptionInterceptor, ValueDecoder valueDecoder) throws SQLException {
        super(exceptionInterceptor);
        this.rowFromServer = buf;
        this.metadata = fields;
        this.isBinaryEncoded = isBinaryEncoded;
        this.preNullBitmaskHomePosition = this.homePosition = this.rowFromServer.getPosition();
        this.valueDecoder = valueDecoder;
        if (fields != null) {
            this.setMetadata(fields);
        }
    }

    private int findAndSeekToOffset(int index) throws SQLException {
        if (!this.isBinaryEncoded) {
            if (index == 0) {
                this.lastRequestedIndex = 0;
                this.lastRequestedPos = this.homePosition;
                this.rowFromServer.setPosition(this.homePosition);
                return 0;
            }
            if (index == this.lastRequestedIndex) {
                this.rowFromServer.setPosition(this.lastRequestedPos);
                return this.lastRequestedPos;
            }
            int startingIndex = 0;
            if (index > this.lastRequestedIndex) {
                startingIndex = this.lastRequestedIndex >= 0 ? this.lastRequestedIndex : 0;
                this.rowFromServer.setPosition(this.lastRequestedPos);
            } else {
                this.rowFromServer.setPosition(this.homePosition);
            }
            for (int i2 = startingIndex; i2 < index; ++i2) {
                this.rowFromServer.fastSkipLenByteArray();
            }
            this.lastRequestedIndex = index;
            this.lastRequestedPos = this.rowFromServer.getPosition();
            return this.lastRequestedPos;
        }
        return this.findAndSeekToOffsetForBinaryEncoding(index);
    }

    private int findAndSeekToOffsetForBinaryEncoding(int index) throws SQLException {
        if (index == 0) {
            this.lastRequestedIndex = 0;
            this.lastRequestedPos = this.homePosition;
            this.rowFromServer.setPosition(this.homePosition);
            return 0;
        }
        if (index == this.lastRequestedIndex) {
            this.rowFromServer.setPosition(this.lastRequestedPos);
            return this.lastRequestedPos;
        }
        int startingIndex = 0;
        if (index > this.lastRequestedIndex) {
            if (this.lastRequestedIndex >= 0) {
                startingIndex = this.lastRequestedIndex;
            } else {
                startingIndex = 0;
                this.lastRequestedPos = this.homePosition;
            }
            this.rowFromServer.setPosition(this.lastRequestedPos);
        } else {
            this.rowFromServer.setPosition(this.homePosition);
        }
        for (int i2 = startingIndex; i2 < index; ++i2) {
            int type;
            if (this.isNull[i2] || (type = this.metadata[i2].getMysqlTypeId()) == 6) continue;
            int length = MysqlaUtils.getBinaryEncodedLength(this.metadata[i2].getMysqlTypeId());
            if (length == 0) {
                this.rowFromServer.fastSkipLenByteArray();
                continue;
            }
            if (length == -1) {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.97") + type + Messages.getString("MysqlIO.98") + (i2 + 1) + Messages.getString("MysqlIO.99") + this.metadata.length + Messages.getString("MysqlIO.100"), "S1000", this.exceptionInterceptor);
            }
            int curPosition = this.rowFromServer.getPosition();
            this.rowFromServer.setPosition(curPosition + length);
        }
        this.lastRequestedIndex = index;
        this.lastRequestedPos = this.rowFromServer.getPosition();
        return this.lastRequestedPos;
    }

    @Override
    public byte[] getColumnValue(int index) throws SQLException {
        this.findAndSeekToOffset(index);
        if (!this.isBinaryEncoded) {
            return this.rowFromServer.readLenByteArray(0);
        }
        if (this.getNull(index)) {
            return null;
        }
        int type = this.metadata[index].getMysqlTypeId();
        switch (type) {
            case 6: {
                return null;
            }
            case 1: {
                return new byte[]{this.rowFromServer.readByte()};
            }
        }
        int length = MysqlaUtils.getBinaryEncodedLength(type);
        if (length == 0) {
            return this.rowFromServer.readLenByteArray(0);
        }
        if (length == -1) {
            throw SQLError.createSQLException(Messages.getString("MysqlIO.97") + type + Messages.getString("MysqlIO.98") + (index + 1) + Messages.getString("MysqlIO.99") + this.metadata.length + Messages.getString("MysqlIO.100"), "S1000", this.exceptionInterceptor);
        }
        return this.rowFromServer.getBytes(length);
    }

    @Override
    public boolean isNull(int index) throws SQLException {
        if (!this.isBinaryEncoded) {
            this.findAndSeekToOffset(index);
            return this.rowFromServer.readFieldLength() == -1L;
        }
        return this.isNull[index];
    }

    @Override
    public long length(int index) throws SQLException {
        this.findAndSeekToOffset(index);
        long length = this.rowFromServer.readFieldLength();
        if (length == -1L) {
            return 0L;
        }
        return length;
    }

    @Override
    public void setColumnValue(int index, byte[] value) throws SQLException {
        throw new OperationNotSupportedException();
    }

    @Override
    public ResultSetRow setMetadata(Field[] f2) throws SQLException {
        super.setMetadata(f2);
        if (this.isBinaryEncoded) {
            this.setupIsNullBitmask();
        }
        return this;
    }

    private void setupIsNullBitmask() throws SQLException {
        if (this.isNull != null) {
            return;
        }
        this.rowFromServer.setPosition(this.preNullBitmaskHomePosition);
        int nullCount = (this.metadata.length + 9) / 8;
        byte[] nullBitMask = new byte[nullCount];
        for (int i2 = 0; i2 < nullCount; ++i2) {
            nullBitMask[i2] = this.rowFromServer.readByte();
        }
        this.homePosition = this.rowFromServer.getPosition();
        this.isNull = new boolean[this.metadata.length];
        int nullMaskPos = 0;
        int bit = 4;
        for (int i3 = 0; i3 < this.metadata.length; ++i3) {
            boolean bl = this.isNull[i3] = (nullBitMask[nullMaskPos] & bit) != 0;
            if (((bit <<= 1) & 0xFF) != 0) continue;
            bit = 1;
            ++nullMaskPos;
        }
    }

    @Override
    public <T> T getValue(int columnIndex, ValueFactory<T> vf) throws SQLException {
        int length;
        this.findAndSeekToOffset(columnIndex);
        if (this.isBinaryEncoded) {
            int type = this.metadata[columnIndex].getMysqlTypeId();
            length = MysqlaUtils.getBinaryEncodedLength(type);
            if (length == 0) {
                length = (int)this.rowFromServer.readFieldLength();
            } else if (length == -1) {
                throw SQLError.createSQLException(Messages.getString("MysqlIO.97") + type + Messages.getString("MysqlIO.98") + (columnIndex + 1) + Messages.getString("MysqlIO.99") + this.metadata.length + Messages.getString("MysqlIO.100"), "S1000", this.exceptionInterceptor);
            }
        } else {
            length = (int)this.rowFromServer.readFieldLength();
        }
        int offset = this.rowFromServer.getPosition();
        return this.getValueFromBytes(columnIndex, this.rowFromServer.getByteBuffer(), offset, length, vf);
    }
}

