/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.NCLOB;

class ClobAccessor
extends Accessor {
    static final int maxLength = 4000;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    ClobAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 112, 112, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    ClobAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 112, 112, s2, false);
        this.initForDescribe(112, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 4000;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getCLOB(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    @Override
    CLOB getCLOB(int n2) throws SQLException {
        CLOB cLOB = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            cLOB = this.formOfUse == 1 ? new CLOB((OracleConnection)this.statement.connection, byArray, this.formOfUse) : new NCLOB(this.statement.connection, byArray);
            if (this.lobPrefetchSizeForThisColumn != -1 && this.prefetchedLobSize != null) {
                cLOB.setActivePrefetch(true);
                cLOB.setLength(this.prefetchedLobSize[n2]);
                cLOB.setChunkSize(this.prefetchedLobChunkSize[n2]);
                if (this.prefetchedLobDataL != null && this.prefetchedLobDataL[n2] > 0) {
                    this.initializeClobForPrefetch(n2, cLOB);
                } else {
                    cLOB.setPrefetchedData(null);
                }
            }
        }
        return cLOB;
    }

    NCLOB getNCLOB(int n2) throws SQLException {
        if (this.formOfUse != 2) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 132);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (NCLOB)this.getCLOB(n2);
    }

    void initializeClobForPrefetch(int n2, CLOB cLOB) throws SQLException {
        cLOB.setPrefetchedData(this.prefetchedLobCharData[n2]);
    }

    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getAsciiStream();
    }

    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getCharacterStream();
    }

    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        return cLOB.getAsciiStream();
    }

    @Override
    String getString(int n2) throws SQLException {
        CLOB cLOB = this.getCLOB(n2);
        if (cLOB == null) {
            return null;
        }
        Reader reader = cLOB.getCharacterStream();
        int n3 = cLOB.getBufferSize();
        int n4 = 0;
        StringWriter stringWriter = new StringWriter(n3);
        char[] cArray = new char[n3];
        try {
            while ((n4 = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n4);
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (cLOB.isTemporary()) {
            this.statement.addToTempLobsToFree(cLOB);
        }
        return stringWriter.getBuffer().substring(0);
    }

    @Override
    byte[] privateGetBytes(int n2) throws SQLException {
        return super.getBytes(n2);
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    long checksum(long l2, int n2) throws SQLException {
        this.unimpl("checksum");
        return -1L;
    }
}

