/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.util.Arrays;
import net.lingala.zip4j.crypto.AesCipherUtil;
import net.lingala.zip4j.crypto.Decrypter;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Engine;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.engine.AESEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.enums.AesKeyStrength;

public class AESDecrypter
implements Decrypter {
    public static final int PASSWORD_VERIFIER_LENGTH = 2;
    private AESExtraDataRecord aesExtraDataRecord;
    private char[] password;
    private AESEngine aesEngine;
    private MacBasedPRF mac;
    private int nonce = 1;
    private byte[] iv;
    private byte[] counterBlock;

    public AESDecrypter(AESExtraDataRecord aesExtraDataRecord, char[] password, byte[] salt, byte[] passwordVerifier) throws ZipException {
        this.aesExtraDataRecord = aesExtraDataRecord;
        this.password = password;
        this.iv = new byte[16];
        this.counterBlock = new byte[16];
        this.init(salt, passwordVerifier);
    }

    private void init(byte[] salt, byte[] passwordVerifier) throws ZipException {
        AesKeyStrength aesKeyStrength = this.aesExtraDataRecord.getAesKeyStrength();
        if (this.password == null || this.password.length <= 0) {
            throw new ZipException("empty or null password provided for AES Decryptor");
        }
        byte[] derivedKey = this.deriveKey(salt, this.password, aesKeyStrength.getKeyLength(), aesKeyStrength.getMacLength());
        if (derivedKey == null || derivedKey.length != aesKeyStrength.getKeyLength() + aesKeyStrength.getMacLength() + 2) {
            throw new ZipException("invalid derived key");
        }
        byte[] aesKey = new byte[aesKeyStrength.getKeyLength()];
        byte[] macKey = new byte[aesKeyStrength.getMacLength()];
        byte[] derivedPasswordVerifier = new byte[2];
        System.arraycopy(derivedKey, 0, aesKey, 0, aesKeyStrength.getKeyLength());
        System.arraycopy(derivedKey, aesKeyStrength.getKeyLength(), macKey, 0, aesKeyStrength.getMacLength());
        System.arraycopy(derivedKey, aesKeyStrength.getKeyLength() + aesKeyStrength.getMacLength(), derivedPasswordVerifier, 0, 2);
        if (!Arrays.equals(passwordVerifier, derivedPasswordVerifier)) {
            throw new ZipException("Wrong Password", ZipException.Type.WRONG_PASSWORD);
        }
        this.aesEngine = new AESEngine(aesKey);
        this.mac = new MacBasedPRF("HmacSHA1");
        this.mac.init(macKey);
    }

    @Override
    public int decryptData(byte[] buff, int start, int len) throws ZipException {
        for (int j = start; j < start + len; j += 16) {
            int loopCount = j + 16 <= start + len ? 16 : start + len - j;
            this.mac.update(buff, j, loopCount);
            AesCipherUtil.prepareBuffAESIVBytes(this.iv, this.nonce);
            this.aesEngine.processBlock(this.iv, this.counterBlock);
            for (int k = 0; k < loopCount; ++k) {
                buff[j + k] = (byte)(buff[j + k] ^ this.counterBlock[k]);
            }
            ++this.nonce;
        }
        return len;
    }

    private byte[] deriveKey(byte[] salt, char[] password, int keyLength, int macLength) {
        PBKDF2Parameters p = new PBKDF2Parameters("HmacSHA1", "ISO-8859-1", salt, 1000);
        PBKDF2Engine e = new PBKDF2Engine(p);
        return e.deriveKey(password, keyLength + macLength + 2);
    }

    public byte[] getCalculatedAuthenticationBytes() {
        return this.mac.doFinal();
    }
}

