/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.Config;
import SharpTools.Debug;
import SharpTools.SharpDialog;
import SharpTools.SharpOptionPane;
import SharpTools.SharpTools;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ConnectDialog
extends SharpDialog {
    private JFrame frame;
    private JOptionPane optionPane;
    private JCheckBox lockTableBox;
    private JCheckBox verifySaveBox;
    final ImageIcon removeIcon = new ImageIcon(this.getClass().getResource("/images/no.gif"));
    final ImageIcon databaseIcon = new ImageIcon(this.getClass().getResource("/images/database32.gif"));
    private static final ImageIcon dbErrorIcon = null;
    private Connection dbConnection = null;
    private final JTextField connectnameField = new JTextField();
    private final JTextField usernameField = new JTextField();
    private final JPasswordField passwordField = new JPasswordField();
    private final JTextField driverField = new JTextField();
    private final JTextField urlField = new JTextField();
    private final JCheckBox saveConnection = new JCheckBox("Save Connection", true);
    private final JCheckBox savePassword = new JCheckBox("Save Password", false);
    private int maxConn = 0;
    private final JButton removeButton = new JButton("Remove", this.removeIcon);
    private JComboBox box;

    public ConnectDialog(JFrame aFrame) {
        super(aFrame, "Connect to Database", true);
        String entry;
        this.frame = aFrame;
        String msgString0 = "Connection Name:";
        String msgString1 = "Username:";
        String msgString2 = "Password:";
        String msgString3 = "Driver:";
        String msgString4 = "URL:";
        final Config config = SharpTools.getConfig();
        this.maxConn = config.getInt("NUMCONNECTIONS");
        Vector<String> possibleValues = new Vector<String>();
        possibleValues.add("Previous connections");
        for (int i = 1; i <= this.maxConn && (entry = config.get("CONNECTION." + i + ".NAME")) != null && entry.length() > 0; ++i) {
            possibleValues.add(entry);
        }
        this.box = new JComboBox(possibleValues);
        this.box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    int index = ConnectDialog.this.box.getSelectedIndex();
                    if (index <= 0) {
                        return;
                    }
                    String key = "CONNECTION." + index;
                    ConnectDialog.this.connectnameField.setText(config.get(key + ".NAME"));
                    ConnectDialog.this.usernameField.setText(config.get(key + ".USERNAME"));
                    ConnectDialog.this.passwordField.setText(config.get(key + ".PASSWORD"));
                    ConnectDialog.this.urlField.setText(config.get(key + ".URL"));
                    ConnectDialog.this.driverField.setText(config.get(key + ".DRIVER"));
                }
            }
        });
        this.removeButton.setToolTipText("Remove the selected connection");
        this.removeButton.setMnemonic(82);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = ConnectDialog.this.box.getSelectedIndex();
                if (index <= 0) {
                    return;
                }
                for (int i = index; i < ConnectDialog.this.maxConn; ++i) {
                    config.set("CONNECTION." + i + ".NAME", config.get("CONNECTION." + (i + 1) + ".NAME"));
                    config.set("CONNECTION." + i + ".USERNAME", config.get("CONNECTION." + (i + 1) + ".USERNAME"));
                    config.set("CONNECTION." + i + ".PASSWORD", config.get("CONNECTION." + (i + 1) + ".PASSWORD"));
                    config.set("CONNECTION." + i + ".URL", config.get("CONNECTION." + (i + 1) + ".URL"));
                    config.set("CONNECTION." + i + ".DRIVER", config.get("CONNECTION." + (i + 1) + ".DRIVER"));
                }
                String maxkey = "CONNECTION." + ConnectDialog.this.maxConn;
                config.set(maxkey + ".NAME", "");
                ConnectDialog.this.box.setSelectedIndex(0);
                ConnectDialog.this.box.removeItemAt(index);
            }
        });
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(this.box);
        panel.add(this.removeButton);
        JPanel cbPanel = new JPanel(new FlowLayout());
        cbPanel.add(this.saveConnection);
        cbPanel.add(this.savePassword);
        Object[] input = new Object[]{panel, "Connection Name:", this.connectnameField, "Username:", this.usernameField, "Password:", this.passwordField, "Driver:", this.driverField, "URL:", this.urlField, cbPanel};
        this.setOptionPane(input, -1, 2, this.databaseIcon);
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    @Override
    protected boolean onOK() {
        int index;
        String connectName = this.connectnameField.getText().trim();
        String dbUsername = this.usernameField.getText().trim();
        String dbPassword = String.copyValueOf(this.passwordField.getPassword());
        String dbDriver = this.driverField.getText().trim();
        String dbUrl = this.urlField.getText().trim();
        if (!(dbUsername != null && dbUsername.length() != 0 || dbUrl != null && dbUrl.length() != 0 || dbDriver != null && dbDriver.length() != 0)) {
            SharpOptionPane.showMessageDialog(this, "You must provide values for Username, Url and Driver.\n", "Connect", 1, this.databaseIcon);
            return false;
        }
        try {
            Class.forName(dbDriver);
        }
        catch (ClassNotFoundException e) {
            SharpOptionPane.showMessageDialog(this, "Unable to load class " + dbDriver + ". Please ensure that it is in your classpath.\n" + e.toString(), "Class Not Found", 0, dbErrorIcon);
            return false;
        }
        try {
            this.dbConnection = DriverManager.getConnection(dbUrl, dbUsername, dbPassword);
        }
        catch (SQLException e) {
            SharpOptionPane.showMessageDialog(this, "Unable to connect to the database at " + dbUrl + ".\nPlease ensure that the URL, Username and Password are correct.\n\n" + e.toString(), "Connect", 0, dbErrorIcon);
            return false;
        }
        if (!this.saveConnection.isSelected()) {
            return true;
        }
        if (connectName.length() == 0) {
            SharpOptionPane.showMessageDialog(this, "You did not enter a connection name.\n\nThis connection succeeded but will not be saved.\n", "Save Connection", 2);
            return true;
        }
        for (index = 1; index < this.box.getItemCount() && !connectName.equals(this.box.getItemAt(index).toString()); ++index) {
        }
        if (index != this.box.getItemCount() || this.box.getItemCount() <= this.maxConn) {
            String key = "CONNECTION." + index;
            Debug.println("Saving " + key);
            Config config = SharpTools.getConfig();
            config.set(key + ".NAME", connectName);
            config.set(key + ".USERNAME", dbUsername);
            if (this.savePassword.isSelected()) {
                config.set(key + ".PASSWORD", dbPassword);
            }
            config.set(key + ".URL", dbUrl);
            config.set(key + ".DRIVER", dbDriver);
        } else {
            SharpOptionPane.showMessageDialog(this, "You have defined " + this.maxConn + " connections.\nYour current connection setting cannot be saved.\n\nRefer to the manual for advanced configuration.\n", "Save Connection", 2);
        }
        return true;
    }

    @Override
    protected void onOpen() {
        this.connectnameField.requestFocus();
    }
}

