/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AreaObjectDialog;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class AreaObject
extends ConstructionObject
implements InsideObject,
PointonObject,
MoveableObject {
    static Count N = new Count();
    double[] x = new double[3];
    double[] y = new double[3];
    double R;
    double X;
    double Y;
    double A;
    Vector V;
    boolean OnBoundary;
    double[] xd;
    double[] yd;
    double x1;
    double y1;

    public AreaObject(Construction construction, Vector vector) {
        super(construction);
        this.V = vector;
        this.validate();
        this.updateText();
        Global.getParameter("unit.area", "");
    }

    public String getTag() {
        return "Polygon";
    }

    public void updateText() {
        String string = Zirkel.name("text.area");
        Enumeration enumeration = this.V.elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            PointObject pointObject = (PointObject)enumeration.nextElement();
            string = !bl ? string + ", " : string + " ";
            bl = false;
            string = string + pointObject.getName();
        }
        this.setText(string);
    }

    public void validate() {
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            if (((ConstructionObject)enumeration.nextElement()).valid()) continue;
            this.Valid = false;
            return;
        }
        if (this.V.size() < 3) {
            this.Valid = false;
            return;
        }
        Enumeration enumeration2 = this.V.elements();
        double d2 = 0.0;
        double d3 = 0.0;
        while (enumeration2.hasMoreElements()) {
            PointObject pointObject = (PointObject)enumeration2.nextElement();
            d2 += pointObject.getX();
            d3 += pointObject.getY();
        }
        this.X = d2 / (double)this.V.size();
        this.Y = d3 / (double)this.V.size();
        this.A = this.area();
        this.Valid = true;
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        AreaObjectDialog areaObjectDialog = new AreaObjectDialog(zirkelCanvas.getFrame(), Zirkel.name("edit.area.title"), this);
        areaObjectDialog.setVisible(true);
        Global.setParameter("unit.area", this.Unit);
        zirkelCanvas.repaint();
        if (areaObjectDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        Object object;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        int n = this.V.size();
        if (this.x.length != n) {
            this.x = new double[n];
            this.y = new double[n];
        }
        if (this.visible(zirkelCanvas)) {
            object = this.V.elements();
            int n2 = 0;
            while (object.hasMoreElements()) {
                PointObject pointObject = (PointObject)object.nextElement();
                this.x[n2] = zirkelCanvas.col(pointObject.getX());
                this.y[n2] = zirkelCanvas.row(pointObject.getY());
                if (n2 > 0 && this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
                    ((MyGraphics13)myGraphics).drawMarkerLine(this.x[n2 - 1], this.y[n2 - 1], this.x[n2], this.y[n2]);
                }
                ++n2;
            }
            if (n2 > 1 && this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
                ((MyGraphics13)myGraphics).drawMarkerLine(this.x[n2 - 1], this.y[n2 - 1], this.x[0], this.y[0]);
            }
            myGraphics.fillPolygon(this.x, this.y, n, this.Indicated || this.Selected || this.getColorType() != 2, this.getColorType() != 1, this);
        }
        if (!((String)(object = this.getDisplayText())).equals("")) {
            if (this.getColorIndex() == 0 && this.getColorType() == 1) {
                myGraphics.setColor(Color.gray.brighter());
            } else {
                myGraphics.setColor(Color.black);
            }
            this.DisplaysText = true;
            this.TX1 = zirkelCanvas.col(this.X + this.XcOffset);
            this.TY1 = zirkelCanvas.row(this.Y + this.YcOffset);
            this.setFont(myGraphics);
            this.drawLabel(myGraphics, (String)object);
        }
    }

    public String getDisplayValue() {
        return "" + this.round(Math.abs(this.A), ZirkelCanvas.LengthsFactor);
    }

    public void printArgs(XmlWriter xmlWriter) {
        Enumeration enumeration = this.V.elements();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            xmlWriter.printArg("point" + n, constructionObject.getName());
            ++n;
        }
        super.printArgs(xmlWriter);
    }

    public Enumeration depending() {
        super.depending();
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            DL.add(constructionObject);
        }
        return DL.elements();
    }

    public void translate() {
        Enumeration enumeration = this.V.elements();
        Vector<ConstructionObject> vector = new Vector<ConstructionObject>();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            vector.addElement(constructionObject.getTranslation());
        }
        this.V = vector;
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        return this.contains(zirkelCanvas.x(n), zirkelCanvas.y(n2));
    }

    public boolean nearto(int n, int n2, boolean bl, ZirkelCanvas zirkelCanvas) {
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        if (this.contains(zirkelCanvas.x(n), zirkelCanvas.y(n2), zirkelCanvas.dx(zirkelCanvas.selectionSize()))) {
            if (bl) {
                return this.OnBoundary;
            }
            return true;
        }
        return false;
    }

    public boolean contains(double d2, double d3, double d4) {
        double d5;
        double d6;
        PointObject pointObject;
        if (!this.Valid) {
            return false;
        }
        this.OnBoundary = false;
        PointObject pointObject2 = (PointObject)this.V.elementAt(0);
        PointObject pointObject3 = pointObject2;
        if (Math.max(Math.abs(pointObject3.getX() - d2), Math.abs(pointObject3.getY() - d3)) < d4) {
            this.OnBoundary = true;
            return true;
        }
        Enumeration enumeration = this.V.elements();
        double d7 = Math.atan2(pointObject3.getX() - d2, pointObject3.getY() - d3);
        double d8 = 0.0;
        while (enumeration.hasMoreElements()) {
            pointObject = (PointObject)enumeration.nextElement();
            if (Math.max(Math.abs(pointObject.getX() - d2), Math.abs(pointObject.getY() - d3)) < d4) {
                this.OnBoundary = true;
                return true;
            }
            d6 = Math.atan2(pointObject.getX() - d2, pointObject.getY() - d3);
            d5 = d6 - d7;
            if (d5 > Math.PI) {
                d5 -= Math.PI * 2;
            } else if (d5 < -Math.PI) {
                d5 += Math.PI * 2;
            }
            if (Math.abs(Math.abs(d5) - Math.PI) < 0.1) {
                this.OnBoundary = true;
                return true;
            }
            d7 = d6;
            pointObject3 = pointObject;
            d8 += d5;
        }
        pointObject = pointObject2;
        d6 = Math.atan2(pointObject.getX() - d2, pointObject.getY() - d3);
        d5 = d6 - d7;
        if (d5 > Math.PI) {
            d5 -= Math.PI * 2;
        } else if (d5 < -Math.PI) {
            d5 += Math.PI * 2;
        }
        if (Math.abs(Math.abs(d5) - Math.PI) < 0.1) {
            this.OnBoundary = true;
            return true;
        }
        return Math.abs(d8 += d5) >= 1.5707963267948966;
    }

    public boolean contains(double d2, double d3) {
        return this.contains(d2, d3, 1.0E-4);
    }

    public double area() {
        PointObject pointObject;
        PointObject pointObject2;
        if (!this.Valid) {
            return -1.0;
        }
        PointObject pointObject3 = pointObject2 = (PointObject)this.V.elementAt(0);
        Enumeration enumeration = this.V.elements();
        double d2 = 0.0;
        while (enumeration.hasMoreElements()) {
            pointObject = (PointObject)enumeration.nextElement();
            d2 += (pointObject.getX() - this.X) * (pointObject3.getY() - this.Y) - (pointObject.getY() - this.Y) * (pointObject3.getX() - this.X);
            pointObject3 = pointObject;
        }
        pointObject = pointObject2;
        return (d2 += (pointObject.getX() - this.X) * (pointObject3.getY() - this.Y) - (pointObject.getY() - this.Y) * (pointObject3.getX() - this.X)) / 2.0;
    }

    public boolean equals(ConstructionObject constructionObject) {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4;
        if (!(constructionObject instanceof AreaObject) || !constructionObject.valid()) {
            return false;
        }
        AreaObject areaObject = (AreaObject)constructionObject;
        int n5 = this.V.size();
        int n6 = areaObject.V.size();
        Object[] objectArray = new PointObject[n5];
        this.V.copyInto(objectArray);
        Object[] objectArray2 = new PointObject[n6];
        areaObject.V.copyInto(objectArray2);
        double d2 = 0.0;
        double d3 = 0.0;
        for (n4 = 0; n4 < n6; ++n4) {
            bl = true;
            n3 = 0;
            n2 = 0;
            do {
                if ((n = n4 + n2) >= n6) {
                    n -= n6;
                }
                if (!((PointObject)objectArray[n3]).equals((ConstructionObject)objectArray2[n])) {
                    if (n3 != 0 && this.between(d2, d3, ((PointObject)objectArray[n3]).getX(), ((PointObject)objectArray[n3]).getY(), ((PointObject)objectArray2[n]).getX(), ((PointObject)objectArray2[n]).getY())) continue;
                    bl = false;
                    break;
                }
                d2 = ((PointObject)objectArray[n3]).getX();
                d3 = ((PointObject)objectArray[n3]).getY();
                ++n3;
            } while (n3 < n5 && ++n2 < n6);
            if (!bl || n2 < n6) continue;
            return true;
        }
        for (n4 = 0; n4 < n6; ++n4) {
            bl = true;
            n3 = 0;
            n2 = 0;
            do {
                if ((n = n4 + n2) >= n6) {
                    n -= n6;
                }
                if (!((PointObject)objectArray[n5 - n3 - 1]).equals((ConstructionObject)objectArray2[n])) {
                    if (n3 != 0 && this.between(d2, d3, ((PointObject)objectArray[n5 - n3 - 1]).getX(), ((PointObject)objectArray[n5 - n3 - 1]).getY(), ((PointObject)objectArray2[n]).getX(), ((PointObject)objectArray2[n]).getY())) continue;
                    bl = false;
                    break;
                }
                d2 = ((PointObject)objectArray[n5 - n3 - 1]).getX();
                d3 = ((PointObject)objectArray[n5 - n3 - 1]).getY();
                ++n3;
            } while (n3 < n5 && ++n2 < n6);
            if (!bl || n2 < n6) continue;
            return true;
        }
        return false;
    }

    public boolean between(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Math.abs(d4 - d2) > Math.abs(d5 - d3) ? (d6 - d2) / (d4 - d2) : (d7 - d3) / (d5 - d3);
        return Math.abs(d2 + d8 * (d4 - d2) - d6) < 1.0E-10 && Math.abs(d3 + d8 * (d5 - d3) - d7) < 1.0E-10;
    }

    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.A;
    }

    public boolean maybeTransparent() {
        return true;
    }

    public boolean isFilled() {
        return true;
    }

    public boolean onlynearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return false;
    }

    public void project(PointObject pointObject) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11 = pointObject.getX();
        double d12 = pointObject.getY();
        Enumeration enumeration = this.V.elements();
        PointObject pointObject2 = (PointObject)enumeration.nextElement();
        double d13 = pointObject2.getX();
        double d14 = pointObject2.getY();
        double d15 = d13;
        double d16 = d14;
        int n = 0;
        double d17 = d13;
        double d18 = d14;
        double d19 = 1.0E20;
        double d20 = 0.0;
        while (enumeration.hasMoreElements()) {
            pointObject2 = (PointObject)enumeration.nextElement();
            d10 = pointObject2.getX();
            d9 = d10 - d13;
            d6 = d9 * d9 + (d8 = (d7 = pointObject2.getY()) - d14) * d8;
            if (d6 > 1.0E-5) {
                d5 = d9 * (d11 - d13) / d6 + d8 * (d12 - d14) / d6;
                if (d5 > 1.0) {
                    d5 = 1.0;
                } else if (d5 < 0.0) {
                    d5 = 0.0;
                }
                d4 = d13 + d5 * d9;
                d3 = d14 + d5 * d8;
                d2 = Math.sqrt((d11 - d4) * (d11 - d4) + (d12 - d3) * (d12 - d3));
                if (d2 < d19) {
                    d19 = d2;
                    d17 = d4;
                    d18 = d3;
                    d20 = (double)n + d5;
                }
            }
            ++n;
            d13 = d10;
            d14 = d7;
        }
        d10 = d15;
        d9 = d10 - d13;
        d7 = d16;
        d8 = d7 - d14;
        d6 = d9 * d9 + d8 * d8;
        if (d6 > 1.0E-5) {
            d5 = d9 * (d11 - d13) / d6 + d8 * (d12 - d14) / d6;
            if (d5 > 1.0) {
                d5 = 1.0;
            } else if (d5 < 0.0) {
                d5 = 0.0;
            }
            d4 = d13 + d5 * d9;
            d3 = d14 + d5 * d8;
            d2 = Math.sqrt((d11 - d4) * (d11 - d4) + (d12 - d3) * (d12 - d3));
            if (d2 < d19) {
                d19 = d2;
                d17 = d4;
                d18 = d3;
                d20 = (double)n + d5;
            }
        }
        pointObject.move(d17, d18);
        pointObject.setA(d20);
    }

    public void project(PointObject pointObject, double d2) {
        int n = (int)Math.floor(d2);
        double d3 = d2 - (double)n;
        if (n < 0 || n >= this.V.size()) {
            this.project(pointObject);
            return;
        }
        PointObject pointObject2 = (PointObject)this.V.elementAt(n);
        PointObject pointObject3 = n == this.V.size() - 1 ? (PointObject)this.V.elementAt(0) : (PointObject)this.V.elementAt(n + 1);
        pointObject.setXY(pointObject2.getX() + d3 * (pointObject3.getX() - pointObject2.getX()), pointObject2.getY() + d3 * (pointObject3.getY() - pointObject2.getY()));
    }

    public double containsInside(PointObject pointObject) {
        boolean bl = this.contains(pointObject.getX(), pointObject.getY());
        if (bl && this.OnBoundary) {
            return 0.5;
        }
        if (bl) {
            return 1.0;
        }
        return 0.0;
    }

    public boolean keepInside(PointObject pointObject) {
        if (this.containsInside(pointObject) > 0.0) {
            return true;
        }
        this.project(pointObject);
        return false;
    }

    public void dragTo(double d2, double d3) {
        Enumeration enumeration = this.V.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            PointObject pointObject = (PointObject)enumeration.nextElement();
            pointObject.move(this.xd[n] + (d2 - this.x1), this.yd[n] + (d3 - this.y1));
            ++n;
        }
    }

    public void move(double d2, double d3) {
    }

    public boolean moveable() {
        if (this.V == null) {
            return false;
        }
        Enumeration enumeration = this.V.elements();
        while (enumeration.hasMoreElements()) {
            if (((PointObject)enumeration.nextElement()).moveable()) continue;
            return false;
        }
        return true;
    }

    public void startDrag(double d2, double d3) {
        if (this.xd == null || this.xd.length != this.V.size()) {
            this.xd = new double[this.V.size()];
            this.yd = new double[this.V.size()];
        }
        Enumeration enumeration = this.V.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            PointObject pointObject = (PointObject)enumeration.nextElement();
            this.xd[n] = pointObject.getX();
            this.yd[n] = pointObject.getY();
            ++n;
        }
        this.x1 = d2;
        this.y1 = d3;
    }

    public void snap(ZirkelCanvas zirkelCanvas) {
        if (this.moveable()) {
            Enumeration enumeration = this.V.elements();
            while (enumeration.hasMoreElements()) {
                PointObject pointObject = (PointObject)enumeration.nextElement();
                pointObject.snap(zirkelCanvas);
            }
        }
    }

    public boolean canInteresectWith(ConstructionObject constructionObject) {
        Enumeration enumeration;
        PointObject pointObject;
        ConstructionObject constructionObject2;
        return !(constructionObject instanceof PointonObject) || !(constructionObject2 = constructionObject).contains(pointObject = (PointObject)(enumeration = this.V.elements()).nextElement());
    }
}

