/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestScalarBarWidget.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkSmartPointer.h"

#include "vtkMultiBlockDataSet.h"
#include "vtkMultiBlockPLOT3DReader.h"
#include "vtkScalarBarWidget.h"
#include "vtkStructuredGridGeometryFilter.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkInteractorEventRecorder.h"
#include "vtkScalarBarActor.h"
#include "vtkStructuredGrid.h"

#include "vtkTestUtilities.h"

const char TSBWeventLog[] =
  "# StreamVersion 1\n"
  "CharEvent 153 168 0 0 105 1 i\n"
  "KeyReleaseEvent 153 168 0 0 105 1 i\n"
  "MouseMoveEvent 153 167 0 0 0 0 i\n"
  "MouseMoveEvent 154 166 0 0 0 0 i\n"
  "MouseMoveEvent 156 165 0 0 0 0 i\n"
  "MouseMoveEvent 159 163 0 0 0 0 i\n"
  "MouseMoveEvent 163 162 0 0 0 0 i\n"
  "MouseMoveEvent 167 161 0 0 0 0 i\n"
  "MouseMoveEvent 170 161 0 0 0 0 i\n"
  "MouseMoveEvent 172 161 0 0 0 0 i\n"
  "MouseMoveEvent 173 161 0 0 0 0 i\n"
  "MouseMoveEvent 176 161 0 0 0 0 i\n"
  "MouseMoveEvent 179 161 0 0 0 0 i\n"
  "MouseMoveEvent 181 161 0 0 0 0 i\n"
  "MouseMoveEvent 185 160 0 0 0 0 i\n"
  "MouseMoveEvent 188 159 0 0 0 0 i\n"
  "MouseMoveEvent 191 159 0 0 0 0 i\n"
  "MouseMoveEvent 195 158 0 0 0 0 i\n"
  "MouseMoveEvent 198 157 0 0 0 0 i\n"
  "MouseMoveEvent 201 157 0 0 0 0 i\n"
  "MouseMoveEvent 203 157 0 0 0 0 i\n"
  "MouseMoveEvent 205 157 0 0 0 0 i\n"
  "MouseMoveEvent 208 156 0 0 0 0 i\n"
  "MouseMoveEvent 212 156 0 0 0 0 i\n"
  "MouseMoveEvent 217 155 0 0 0 0 i\n"
  "MouseMoveEvent 220 155 0 0 0 0 i\n"
  "MouseMoveEvent 222 155 0 0 0 0 i\n"
  "MouseMoveEvent 224 154 0 0 0 0 i\n"
  "MouseMoveEvent 227 154 0 0 0 0 i\n"
  "MouseMoveEvent 230 154 0 0 0 0 i\n"
  "MouseMoveEvent 234 153 0 0 0 0 i\n"
  "MouseMoveEvent 237 153 0 0 0 0 i\n"
  "MouseMoveEvent 239 153 0 0 0 0 i\n"
  "MouseMoveEvent 240 153 0 0 0 0 i\n"
  "MouseMoveEvent 242 153 0 0 0 0 i\n"
  "MouseMoveEvent 243 153 0 0 0 0 i\n"
  "MouseMoveEvent 245 153 0 0 0 0 i\n"
  "MouseMoveEvent 246 153 0 0 0 0 i\n"
  "MouseMoveEvent 247 152 0 0 0 0 i\n"
  "MouseMoveEvent 248 152 0 0 0 0 i\n"
  "MouseMoveEvent 249 152 0 0 0 0 i\n"
  "MouseMoveEvent 250 152 0 0 0 0 i\n"
  "MouseMoveEvent 251 152 0 0 0 0 i\n"
  "MouseMoveEvent 252 152 0 0 0 0 i\n"
  "MouseMoveEvent 253 152 0 0 0 0 i\n"
  "MouseMoveEvent 253 151 0 0 0 0 i\n"
  "MouseMoveEvent 254 151 0 0 0 0 i\n"
  "LeftButtonPressEvent 254 151 0 0 0 0 i\n"
  "MouseMoveEvent 253 150 0 0 0 0 i\n"
  "MouseMoveEvent 251 148 0 0 0 0 i\n"
  "MouseMoveEvent 248 145 0 0 0 0 i\n"
  "MouseMoveEvent 243 141 0 0 0 0 i\n"
  "MouseMoveEvent 240 137 0 0 0 0 i\n"
  "MouseMoveEvent 236 133 0 0 0 0 i\n"
  "MouseMoveEvent 234 130 0 0 0 0 i\n"
  "MouseMoveEvent 232 128 0 0 0 0 i\n"
  "MouseMoveEvent 229 125 0 0 0 0 i\n"
  "MouseMoveEvent 226 122 0 0 0 0 i\n"
  "MouseMoveEvent 222 118 0 0 0 0 i\n"
  "MouseMoveEvent 219 115 0 0 0 0 i\n"
  "MouseMoveEvent 217 112 0 0 0 0 i\n"
  "MouseMoveEvent 215 110 0 0 0 0 i\n"
  "MouseMoveEvent 212 107 0 0 0 0 i\n"
  "MouseMoveEvent 210 103 0 0 0 0 i\n"
  "MouseMoveEvent 207 100 0 0 0 0 i\n"
  "MouseMoveEvent 203 96 0 0 0 0 i\n"
  "MouseMoveEvent 199 94 0 0 0 0 i\n"
  "MouseMoveEvent 196 91 0 0 0 0 i\n"
  "MouseMoveEvent 193 88 0 0 0 0 i\n"
  "MouseMoveEvent 191 86 0 0 0 0 i\n"
  "MouseMoveEvent 188 83 0 0 0 0 i\n"
  "MouseMoveEvent 186 80 0 0 0 0 i\n"
  "MouseMoveEvent 182 78 0 0 0 0 i\n"
  "MouseMoveEvent 179 75 0 0 0 0 i\n"
  "MouseMoveEvent 175 73 0 0 0 0 i\n"
  "MouseMoveEvent 172 70 0 0 0 0 i\n"
  "MouseMoveEvent 169 68 0 0 0 0 i\n"
  "MouseMoveEvent 167 65 0 0 0 0 i\n"
  "MouseMoveEvent 164 63 0 0 0 0 i\n"
  "MouseMoveEvent 162 60 0 0 0 0 i\n"
  "MouseMoveEvent 160 58 0 0 0 0 i\n"
  "MouseMoveEvent 157 56 0 0 0 0 i\n"
  "MouseMoveEvent 155 55 0 0 0 0 i\n"
  "MouseMoveEvent 153 53 0 0 0 0 i\n"
  "MouseMoveEvent 151 51 0 0 0 0 i\n"
  "MouseMoveEvent 149 49 0 0 0 0 i\n"
  "MouseMoveEvent 148 47 0 0 0 0 i\n"
  "MouseMoveEvent 147 46 0 0 0 0 i\n"
  "MouseMoveEvent 145 44 0 0 0 0 i\n"
  "MouseMoveEvent 143 41 0 0 0 0 i\n"
  "MouseMoveEvent 142 40 0 0 0 0 i\n"
  "MouseMoveEvent 141 40 0 0 0 0 i\n"
  "MouseMoveEvent 140 39 0 0 0 0 i\n"
  "MouseMoveEvent 139 37 0 0 0 0 i\n"
  "MouseMoveEvent 138 36 0 0 0 0 i\n"
  "MouseMoveEvent 138 35 0 0 0 0 i\n"
  "MouseMoveEvent 137 35 0 0 0 0 i\n"
  "MouseMoveEvent 136 34 0 0 0 0 i\n"
  "MouseMoveEvent 135 32 0 0 0 0 i\n"
  "MouseMoveEvent 134 32 0 0 0 0 i\n"
  "MouseMoveEvent 134 33 0 0 0 0 i\n"
  "MouseMoveEvent 132 34 0 0 0 0 i\n"
  "MouseMoveEvent 131 37 0 0 0 0 i\n"
  "MouseMoveEvent 129 40 0 0 0 0 i\n"
  "MouseMoveEvent 127 44 0 0 0 0 i\n"
  "MouseMoveEvent 126 49 0 0 0 0 i\n"
  "MouseMoveEvent 123 53 0 0 0 0 i\n"
  "MouseMoveEvent 121 56 0 0 0 0 i\n"
  "MouseMoveEvent 118 60 0 0 0 0 i\n"
  "MouseMoveEvent 115 63 0 0 0 0 i\n"
  "MouseMoveEvent 112 66 0 0 0 0 i\n"
  "MouseMoveEvent 110 68 0 0 0 0 i\n"
  "MouseMoveEvent 108 71 0 0 0 0 i\n"
  "MouseMoveEvent 105 73 0 0 0 0 i\n"
  "MouseMoveEvent 102 75 0 0 0 0 i\n"
  "MouseMoveEvent 99 78 0 0 0 0 i\n"
  "MouseMoveEvent 96 80 0 0 0 0 i\n"
  "MouseMoveEvent 93 83 0 0 0 0 i\n"
  "MouseMoveEvent 91 85 0 0 0 0 i\n"
  "MouseMoveEvent 88 87 0 0 0 0 i\n"
  "MouseMoveEvent 85 90 0 0 0 0 i\n"
  "MouseMoveEvent 82 93 0 0 0 0 i\n"
  "MouseMoveEvent 79 95 0 0 0 0 i\n"
  "MouseMoveEvent 76 96 0 0 0 0 i\n"
  "MouseMoveEvent 73 97 0 0 0 0 i\n"
  "MouseMoveEvent 70 99 0 0 0 0 i\n"
  "MouseMoveEvent 67 101 0 0 0 0 i\n"
  "MouseMoveEvent 64 102 0 0 0 0 i\n"
  "MouseMoveEvent 62 104 0 0 0 0 i\n"
  "MouseMoveEvent 58 105 0 0 0 0 i\n"
  "MouseMoveEvent 54 105 0 0 0 0 i\n"
  "MouseMoveEvent 51 106 0 0 0 0 i\n"
  "MouseMoveEvent 47 107 0 0 0 0 i\n"
  "MouseMoveEvent 45 109 0 0 0 0 i\n"
  "MouseMoveEvent 44 110 0 0 0 0 i\n"
  "MouseMoveEvent 43 112 0 0 0 0 i\n"
  "MouseMoveEvent 41 113 0 0 0 0 i\n"
  "MouseMoveEvent 40 115 0 0 0 0 i\n"
  "MouseMoveEvent 39 117 0 0 0 0 i\n"
  "MouseMoveEvent 38 119 0 0 0 0 i\n"
  "MouseMoveEvent 38 120 0 0 0 0 i\n"
  "MouseMoveEvent 38 123 0 0 0 0 i\n"
  "MouseMoveEvent 38 125 0 0 0 0 i\n"
  "MouseMoveEvent 38 128 0 0 0 0 i\n"
  "MouseMoveEvent 38 129 0 0 0 0 i\n"
  "MouseMoveEvent 37 131 0 0 0 0 i\n"
  "MouseMoveEvent 36 132 0 0 0 0 i\n"
  "MouseMoveEvent 35 133 0 0 0 0 i\n"
  "MouseMoveEvent 34 134 0 0 0 0 i\n"
  "MouseMoveEvent 33 134 0 0 0 0 i\n"
  "MouseMoveEvent 31 134 0 0 0 0 i\n"
  "MouseMoveEvent 30 134 0 0 0 0 i\n"
  "MouseMoveEvent 29 134 0 0 0 0 i\n"
  "MouseMoveEvent 28 135 0 0 0 0 i\n"
  "MouseMoveEvent 26 136 0 0 0 0 i\n"
  "MouseMoveEvent 24 137 0 0 0 0 i\n"
  "MouseMoveEvent 23 140 0 0 0 0 i\n"
  "MouseMoveEvent 22 141 0 0 0 0 i\n"
  "MouseMoveEvent 21 142 0 0 0 0 i\n"
  "MouseMoveEvent 21 143 0 0 0 0 i\n"
  "MouseMoveEvent 21 144 0 0 0 0 i\n"
  "MouseMoveEvent 20 145 0 0 0 0 i\n"
  "MouseMoveEvent 19 146 0 0 0 0 i\n"
  "MouseMoveEvent 19 148 0 0 0 0 i\n"
  "MouseMoveEvent 19 149 0 0 0 0 i\n"
  "MouseMoveEvent 19 150 0 0 0 0 i\n"
  "MouseMoveEvent 19 151 0 0 0 0 i\n"
  "MouseMoveEvent 19 152 0 0 0 0 i\n"
  "MouseMoveEvent 19 153 0 0 0 0 i\n"
  "MouseMoveEvent 18 154 0 0 0 0 i\n"
  "MouseMoveEvent 18 155 0 0 0 0 i\n"
  "MouseMoveEvent 18 156 0 0 0 0 i\n"
  "MouseMoveEvent 18 157 0 0 0 0 i\n"
  "MouseMoveEvent 18 158 0 0 0 0 i\n"
  "MouseMoveEvent 18 159 0 0 0 0 i\n"
  "MouseMoveEvent 19 160 0 0 0 0 i\n"
  "MouseMoveEvent 19 161 0 0 0 0 i\n"
  "MouseMoveEvent 19 162 0 0 0 0 i\n"
  "MouseMoveEvent 19 163 0 0 0 0 i\n"
  "MouseMoveEvent 24 165 0 0 0 0 i\n"
  "MouseMoveEvent 40 168 0 0 0 0 i\n"
  "MouseMoveEvent 58 170 0 0 0 0 i\n"
  "MouseMoveEvent 62 171 0 0 0 0 i\n"
  "MouseMoveEvent 76 174 0 0 0 0 i\n"
  "MouseMoveEvent 80 176 0 0 0 0 i\n"
  "MouseMoveEvent 84 178 0 0 0 0 i\n"
  "MouseMoveEvent 88 179 0 0 0 0 i\n"
  "MouseMoveEvent 90 181 0 0 0 0 i\n"
  "MouseMoveEvent 92 182 0 0 0 0 i\n"
  "MouseMoveEvent 95 183 0 0 0 0 i\n"
  "MouseMoveEvent 100 186 0 0 0 0 i\n"
  "MouseMoveEvent 103 188 0 0 0 0 i\n"
  "MouseMoveEvent 106 190 0 0 0 0 i\n"
  "MouseMoveEvent 109 192 0 0 0 0 i\n"
  "MouseMoveEvent 112 194 0 0 0 0 i\n"
  "MouseMoveEvent 114 196 0 0 0 0 i\n"
  "MouseMoveEvent 118 199 0 0 0 0 i\n"
  "MouseMoveEvent 122 202 0 0 0 0 i\n"
  "MouseMoveEvent 125 206 0 0 0 0 i\n"
  "MouseMoveEvent 127 208 0 0 0 0 i\n"
  "MouseMoveEvent 128 210 0 0 0 0 i\n"
  "MouseMoveEvent 129 212 0 0 0 0 i\n"
  "MouseMoveEvent 131 214 0 0 0 0 i\n"
  "MouseMoveEvent 133 217 0 0 0 0 i\n"
  "MouseMoveEvent 134 219 0 0 0 0 i\n"
  "MouseMoveEvent 135 221 0 0 0 0 i\n"
  "MouseMoveEvent 136 223 0 0 0 0 i\n"
  "MouseMoveEvent 137 225 0 0 0 0 i\n"
  "MouseMoveEvent 137 227 0 0 0 0 i\n"
  "MouseMoveEvent 137 230 0 0 0 0 i\n"
  "MouseMoveEvent 137 231 0 0 0 0 i\n"
  "MouseMoveEvent 138 233 0 0 0 0 i\n"
  "MouseMoveEvent 138 234 0 0 0 0 i\n"
  "MouseMoveEvent 138 235 0 0 0 0 i\n"
  "MouseMoveEvent 138 236 0 0 0 0 i\n"
  "MouseMoveEvent 138 238 0 0 0 0 i\n"
  "MouseMoveEvent 138 239 0 0 0 0 i\n"
  "MouseMoveEvent 138 241 0 0 0 0 i\n"
  "MouseMoveEvent 138 243 0 0 0 0 i\n"
  "MouseMoveEvent 139 245 0 0 0 0 i\n"
  "MouseMoveEvent 138 247 0 0 0 0 i\n"
  "MouseMoveEvent 138 248 0 0 0 0 i\n"
  "MouseMoveEvent 138 249 0 0 0 0 i\n"
  "MouseMoveEvent 138 250 0 0 0 0 i\n"
  "MouseMoveEvent 137 252 0 0 0 0 i\n"
  "MouseMoveEvent 136 254 0 0 0 0 i\n"
  "MouseMoveEvent 136 255 0 0 0 0 i\n"
  "MouseMoveEvent 135 256 0 0 0 0 i\n"
  "MouseMoveEvent 135 257 0 0 0 0 i\n"
  "MouseMoveEvent 135 258 0 0 0 0 i\n"
  "MouseMoveEvent 135 259 0 0 0 0 i\n"
  "MouseMoveEvent 135 260 0 0 0 0 i\n"
  "MouseMoveEvent 136 262 0 0 0 0 i\n"
  "MouseMoveEvent 136 263 0 0 0 0 i\n"
  "MouseMoveEvent 136 264 0 0 0 0 i\n"
  "MouseMoveEvent 136 265 0 0 0 0 i\n"
  "MouseMoveEvent 137 266 0 0 0 0 i\n"
  "MouseMoveEvent 138 267 0 0 0 0 i\n"
  "MouseMoveEvent 139 267 0 0 0 0 i\n"
  "MouseMoveEvent 140 268 0 0 0 0 i\n"
  "MouseMoveEvent 140 269 0 0 0 0 i\n"
  "LeftButtonReleaseEvent 140 269 0 0 0 0 i\n"
  "MouseMoveEvent 140 269 0 0 0 0 i\n"
  "MouseMoveEvent 139 269 0 0 0 0 i\n"
  "MouseMoveEvent 136 268 0 0 0 0 i\n"
  "MouseMoveEvent 131 268 0 0 0 0 i\n"
  "MouseMoveEvent 127 267 0 0 0 0 i\n"
  "MouseMoveEvent 113 266 0 0 0 0 i\n"
  "MouseMoveEvent 97 263 0 0 0 0 i\n"
  "MouseMoveEvent 79 260 0 0 0 0 i\n"
  "MouseMoveEvent 65 258 0 0 0 0 i\n"
  "MouseMoveEvent 63 258 0 0 0 0 i\n"
  "MouseMoveEvent 60 257 0 0 0 0 i\n"
  "MouseMoveEvent 58 257 0 0 0 0 i\n"
  "MouseMoveEvent 56 256 0 0 0 0 i\n"
  "MouseMoveEvent 53 255 0 0 0 0 i\n"
  "MouseMoveEvent 49 254 0 0 0 0 i\n"
  "MouseMoveEvent 45 252 0 0 0 0 i\n"
  "MouseMoveEvent 41 251 0 0 0 0 i\n"
  "MouseMoveEvent 38 250 0 0 0 0 i\n"
  "MouseMoveEvent 36 250 0 0 0 0 i\n"
  "MouseMoveEvent 34 250 0 0 0 0 i\n"
  "MouseMoveEvent 33 249 0 0 0 0 i\n"
  "MouseMoveEvent 31 249 0 0 0 0 i\n"
  "MouseMoveEvent 30 249 0 0 0 0 i\n"
  "MouseMoveEvent 30 248 0 0 0 0 i\n"
  "MouseMoveEvent 29 248 0 0 0 0 i\n"
  "MouseMoveEvent 28 248 0 0 0 0 i\n"
  "MouseMoveEvent 27 248 0 0 0 0 i\n"
  "MouseMoveEvent 27 249 0 0 0 0 i\n"
  "MouseMoveEvent 28 250 0 0 0 0 i\n"
  "MouseMoveEvent 29 250 0 0 0 0 i\n"
  "MouseMoveEvent 30 250 0 0 0 0 i\n"
  "MouseMoveEvent 30 251 0 0 0 0 i\n"
  "MouseMoveEvent 30 252 0 0 0 0 i\n"
  "MouseMoveEvent 31 252 0 0 0 0 i\n"
  "MouseMoveEvent 32 252 0 0 0 0 i\n"
  "MouseMoveEvent 33 253 0 0 0 0 i\n"
  "MouseMoveEvent 34 253 0 0 0 0 i\n"
  "MouseMoveEvent 35 253 0 0 0 0 i\n"
  "MouseMoveEvent 36 253 0 0 0 0 i\n"
  "MouseMoveEvent 37 253 0 0 0 0 i\n"
  "MouseMoveEvent 38 253 0 0 0 0 i\n"
  "LeftButtonPressEvent 38 253 0 0 0 0 i\n"
  "MouseMoveEvent 41 254 0 0 0 0 i\n"
  "MouseMoveEvent 55 255 0 0 0 0 i\n"
  "MouseMoveEvent 75 257 0 0 0 0 i\n"
  "MouseMoveEvent 91 259 0 0 0 0 i\n"
  "MouseMoveEvent 96 260 0 0 0 0 i\n"
  "MouseMoveEvent 97 260 0 0 0 0 i\n"
  "MouseMoveEvent 98 260 0 0 0 0 i\n"
  "MouseMoveEvent 99 260 0 0 0 0 i\n"
  "MouseMoveEvent 101 260 0 0 0 0 i\n"
  "MouseMoveEvent 102 260 0 0 0 0 i\n"
  "MouseMoveEvent 104 260 0 0 0 0 i\n"
  "MouseMoveEvent 107 260 0 0 0 0 i\n"
  "MouseMoveEvent 111 260 0 0 0 0 i\n"
  "MouseMoveEvent 114 261 0 0 0 0 i\n"
  "MouseMoveEvent 116 261 0 0 0 0 i\n"
  "MouseMoveEvent 118 260 0 0 0 0 i\n"
  "MouseMoveEvent 120 259 0 0 0 0 i\n"
  "MouseMoveEvent 122 259 0 0 0 0 i\n"
  "MouseMoveEvent 124 259 0 0 0 0 i\n"
  "MouseMoveEvent 126 259 0 0 0 0 i\n"
  "MouseMoveEvent 127 259 0 0 0 0 i\n"
  "MouseMoveEvent 128 258 0 0 0 0 i\n"
  "MouseMoveEvent 130 258 0 0 0 0 i\n"
  "MouseMoveEvent 132 258 0 0 0 0 i\n"
  "MouseMoveEvent 133 258 0 0 0 0 i\n"
  "MouseMoveEvent 134 258 0 0 0 0 i\n"
  "MouseMoveEvent 135 258 0 0 0 0 i\n"
  "MouseMoveEvent 136 258 0 0 0 0 i\n"
  "MouseMoveEvent 137 258 0 0 0 0 i\n"
  "MouseMoveEvent 138 258 0 0 0 0 i\n"
  "MouseMoveEvent 139 258 0 0 0 0 i\n"
  "LeftButtonReleaseEvent 139 258 0 0 0 0 i\n"
  "MouseMoveEvent 139 258 0 0 0 0 i\n"
  "MouseMoveEvent 138 258 0 0 0 0 i\n"
  "MouseMoveEvent 136 256 0 0 0 0 i\n"
  "MouseMoveEvent 135 255 0 0 0 0 i\n"
  "MouseMoveEvent 134 255 0 0 0 0 i\n"
  "MouseMoveEvent 134 253 0 0 0 0 i\n"
  "MouseMoveEvent 133 253 0 0 0 0 i\n"
  "MouseMoveEvent 132 252 0 0 0 0 i\n"
  "MouseMoveEvent 130 251 0 0 0 0 i\n"
  "MouseMoveEvent 128 250 0 0 0 0 i\n"
  "MouseMoveEvent 126 249 0 0 0 0 i\n"
  "MouseMoveEvent 124 249 0 0 0 0 i\n"
  "MouseMoveEvent 124 248 0 0 0 0 i\n"
  "MouseMoveEvent 123 248 0 0 0 0 i\n"
  "MouseMoveEvent 122 247 0 0 0 0 i\n"
  "MouseMoveEvent 121 246 0 0 0 0 i\n"
  "MouseMoveEvent 121 245 0 0 0 0 i\n"
  "MouseMoveEvent 120 244 0 0 0 0 i\n"
  "KeyPressEvent 120 244 0 0 105 1 i\n"
  "EnterEvent 296 230 0 0 0 0 i\n"
  "MouseMoveEvent 296 230 0 0 0 0 i\n"
  "MouseMoveEvent 275 231 0 0 0 0 i\n"
  "MouseMoveEvent 262 231 0 0 0 0 i\n"
  "MouseMoveEvent 252 233 0 0 0 0 i\n"
  "MouseMoveEvent 241 233 0 0 0 0 i\n"
  "MouseMoveEvent 229 236 0 0 0 0 i\n"
  "MouseMoveEvent 217 239 0 0 0 0 i\n"
  "MouseMoveEvent 206 240 0 0 0 0 i\n"
  "MouseMoveEvent 204 239 0 0 0 0 i\n"
  "MouseMoveEvent 204 238 0 0 0 0 i\n"
  "MouseMoveEvent 206 238 0 0 0 0 i\n"
  "MouseMoveEvent 207 238 0 0 0 0 i\n"
  "MouseMoveEvent 207 241 0 0 0 0 i\n"
  "MouseMoveEvent 207 242 0 0 0 0 i\n"
  "MouseMoveEvent 207 243 0 0 0 0 i\n"
  "MouseMoveEvent 207 244 0 0 0 0 i\n"
  "MouseMoveEvent 208 245 0 0 0 0 i\n"
  "MouseMoveEvent 208 246 0 0 0 0 i\n"
  "MouseMoveEvent 208 247 0 0 0 0 i\n"
  "MouseMoveEvent 209 248 0 0 0 0 i\n"
  "MouseMoveEvent 209 249 0 0 0 0 i\n"
  "MouseMoveEvent 209 250 0 0 0 0 i\n"
  "MouseMoveEvent 209 251 0 0 0 0 i\n"
  "MouseMoveEvent 208 251 0 0 0 0 i\n"
  "MouseMoveEvent 208 252 0 0 0 0 i\n"
  "MouseMoveEvent 207 252 0 0 0 0 i\n"
  "MouseMoveEvent 206 253 0 0 0 0 i\n"
  "MouseMoveEvent 203 253 0 0 0 0 i\n"
  "MouseMoveEvent 200 255 0 0 0 0 i\n"
  "MouseMoveEvent 198 256 0 0 0 0 i\n"
  "MouseMoveEvent 195 257 0 0 0 0 i\n"
  "MouseMoveEvent 193 257 0 0 0 0 i\n"
  "MouseMoveEvent 190 258 0 0 0 0 i\n"
  "MouseMoveEvent 189 258 0 0 0 0 i\n"
  "MouseMoveEvent 188 259 0 0 0 0 i\n"
  "MouseMoveEvent 187 259 0 0 0 0 i\n"
  "MouseMoveEvent 187 260 0 0 0 0 i\n"
  "MouseMoveEvent 187 261 0 0 0 0 i\n"
  "MouseMoveEvent 186 261 0 0 0 0 i\n"
  "MouseMoveEvent 185 262 0 0 0 0 i\n"
  "MouseMoveEvent 182 263 0 0 0 0 i\n"
  "MouseMoveEvent 181 264 0 0 0 0 i\n"
  "MouseMoveEvent 180 264 0 0 0 0 i\n"
  "MouseMoveEvent 177 265 0 0 0 0 i\n"
  "MouseMoveEvent 176 265 0 0 0 0 i\n"
  "MouseMoveEvent 174 265 0 0 0 0 i\n"
  "MouseMoveEvent 173 265 0 0 0 0 i\n"
  "MouseMoveEvent 171 265 0 0 0 0 i\n"
  "MouseMoveEvent 170 265 0 0 0 0 i\n"
  "MouseMoveEvent 168 265 0 0 0 0 i\n"
  "MouseMoveEvent 167 265 0 0 0 0 i\n"
  "MouseMoveEvent 166 265 0 0 0 0 i\n"
  "MouseMoveEvent 164 265 0 0 0 0 i\n"
  "MouseMoveEvent 162 265 0 0 0 0 i\n"
  "MouseMoveEvent 161 265 0 0 0 0 i\n"
  "MouseMoveEvent 160 266 0 0 0 0 i\n"
  "MouseMoveEvent 158 266 0 0 0 0 i\n"
  "MouseMoveEvent 157 266 0 0 0 0 i\n"
  "MouseMoveEvent 156 266 0 0 0 0 i\n"
  "MouseMoveEvent 155 266 0 0 0 0 i\n"
  "MouseMoveEvent 154 267 0 0 0 0 i\n"
  "MouseMoveEvent 153 267 0 0 0 0 i\n"
  "MouseMoveEvent 152 267 0 0 0 0 i\n"
  "MouseMoveEvent 151 267 0 0 0 0 i\n"
  "MouseMoveEvent 150 267 0 0 0 0 i\n"
  "MouseMoveEvent 149 268 0 0 0 0 i\n"
  "MouseMoveEvent 148 268 0 0 0 0 i\n"
  "MouseMoveEvent 147 268 0 0 0 0 i\n"
  "MouseMoveEvent 146 268 0 0 0 0 i\n"
  "MouseMoveEvent 145 268 0 0 0 0 i\n"
  "MouseMoveEvent 144 268 0 0 0 0 i\n"
  "MouseMoveEvent 143 268 0 0 0 0 i\n"
  "MouseMoveEvent 142 268 0 0 0 0 i\n"
  "MouseMoveEvent 141 268 0 0 0 0 i\n"
  "LeftButtonPressEvent 141 268 0 0 0 0 i\n"
  "MouseMoveEvent 140 268 0 0 0 0 i\n"
  "MouseMoveEvent 139 268 0 0 0 0 i\n"
  "MouseMoveEvent 137 268 0 0 0 0 i\n"
  "MouseMoveEvent 136 268 0 0 0 0 i\n"
  "MouseMoveEvent 135 268 0 0 0 0 i\n"
  "MouseMoveEvent 133 268 0 0 0 0 i\n"
  "MouseMoveEvent 131 268 0 0 0 0 i\n"
  "MouseMoveEvent 129 268 0 0 0 0 i\n"
  "MouseMoveEvent 128 268 0 0 0 0 i\n"
  "MouseMoveEvent 126 268 0 0 0 0 i\n"
  "MouseMoveEvent 125 268 0 0 0 0 i\n"
  "MouseMoveEvent 123 268 0 0 0 0 i\n"
  "MouseMoveEvent 122 268 0 0 0 0 i\n"
  "MouseMoveEvent 121 268 0 0 0 0 i\n"
  "MouseMoveEvent 119 268 0 0 0 0 i\n"
  "MouseMoveEvent 118 268 0 0 0 0 i\n"
  "MouseMoveEvent 116 268 0 0 0 0 i\n"
  "MouseMoveEvent 115 268 0 0 0 0 i\n"
  "MouseMoveEvent 114 268 0 0 0 0 i\n"
  "MouseMoveEvent 112 268 0 0 0 0 i\n"
  "MouseMoveEvent 111 268 0 0 0 0 i\n"
  "MouseMoveEvent 108 268 0 0 0 0 i\n"
  "MouseMoveEvent 107 268 0 0 0 0 i\n"
  "MouseMoveEvent 105 268 0 0 0 0 i\n"
  "MouseMoveEvent 104 268 0 0 0 0 i\n"
  "MouseMoveEvent 103 268 0 0 0 0 i\n"
  "MouseMoveEvent 101 268 0 0 0 0 i\n"
  "MouseMoveEvent 100 268 0 0 0 0 i\n"
  "MouseMoveEvent 99 268 0 0 0 0 i\n"
  "MouseMoveEvent 98 268 0 0 0 0 i\n"
  "MouseMoveEvent 94 268 0 0 0 0 i\n"
  "MouseMoveEvent 92 268 0 0 0 0 i\n"
  "MouseMoveEvent 91 268 0 0 0 0 i\n"
  "MouseMoveEvent 88 268 0 0 0 0 i\n"
  "MouseMoveEvent 87 268 0 0 0 0 i\n"
  "MouseMoveEvent 85 268 0 0 0 0 i\n"
  "MouseMoveEvent 83 268 0 0 0 0 i\n"
  "MouseMoveEvent 81 268 0 0 0 0 i\n"
  "MouseMoveEvent 80 268 0 0 0 0 i\n"
  "MouseMoveEvent 78 268 0 0 0 0 i\n"
  "MouseMoveEvent 77 268 0 0 0 0 i\n"
  "MouseMoveEvent 76 268 0 0 0 0 i\n"
  "MouseMoveEvent 74 268 0 0 0 0 i\n"
  "MouseMoveEvent 73 268 0 0 0 0 i\n"
  "MouseMoveEvent 71 268 0 0 0 0 i\n"
  "MouseMoveEvent 69 268 0 0 0 0 i\n"
  "MouseMoveEvent 67 268 0 0 0 0 i\n"
  "MouseMoveEvent 65 268 0 0 0 0 i\n"
  "MouseMoveEvent 64 268 0 0 0 0 i\n"
  "MouseMoveEvent 63 268 0 0 0 0 i\n"
  "MouseMoveEvent 61 268 0 0 0 0 i\n"
  "MouseMoveEvent 60 268 0 0 0 0 i\n"
  "MouseMoveEvent 59 268 0 0 0 0 i\n"
  "LeftButtonReleaseEvent 59 268 0 0 0 0 i\n"
  "MouseMoveEvent 61 268 0 0 0 0 i\n"
  "MouseMoveEvent 68 268 0 0 0 0 i\n"
  "MouseMoveEvent 83 263 0 0 0 0 i\n"
  "MouseMoveEvent 93 261 0 0 0 0 i\n"
  "MouseMoveEvent 105 258 0 0 0 0 i\n"
  "MouseMoveEvent 116 257 0 0 0 0 i\n"
  "MouseMoveEvent 124 256 0 0 0 0 i\n"
  "MouseMoveEvent 132 255 0 0 0 0 i\n"
  "MouseMoveEvent 139 254 0 0 0 0 i\n"
  "MouseMoveEvent 145 253 0 0 0 0 i\n"
  "MouseMoveEvent 149 251 0 0 0 0 i\n"
  "MouseMoveEvent 151 251 0 0 0 0 i\n"
  "MouseMoveEvent 154 250 0 0 0 0 i\n"
  "MouseMoveEvent 155 249 0 0 0 0 i\n"
  "LeftButtonPressEvent 155 249 0 0 0 0 i\n"
  "MouseMoveEvent 156 249 0 0 0 0 i\n"
  "MouseMoveEvent 156 248 0 0 0 0 i\n"
  "MouseMoveEvent 157 247 0 0 0 0 i\n"
  "MouseMoveEvent 157 246 0 0 0 0 i\n"
  "MouseMoveEvent 157 244 0 0 0 0 i\n"
  "MouseMoveEvent 157 242 0 0 0 0 i\n"
  "MouseMoveEvent 157 241 0 0 0 0 i\n"
  "MouseMoveEvent 158 239 0 0 0 0 i\n"
  "MouseMoveEvent 158 237 0 0 0 0 i\n"
  "MouseMoveEvent 158 232 0 0 0 0 i\n"
  "MouseMoveEvent 158 230 0 0 0 0 i\n"
  "MouseMoveEvent 158 228 0 0 0 0 i\n"
  "MouseMoveEvent 158 225 0 0 0 0 i\n"
  "MouseMoveEvent 158 223 0 0 0 0 i\n"
  "MouseMoveEvent 158 220 0 0 0 0 i\n"
  "MouseMoveEvent 158 217 0 0 0 0 i\n"
  "MouseMoveEvent 158 212 0 0 0 0 i\n"
  "MouseMoveEvent 158 207 0 0 0 0 i\n"
  "MouseMoveEvent 158 204 0 0 0 0 i\n"
  "MouseMoveEvent 158 201 0 0 0 0 i\n"
  "MouseMoveEvent 158 198 0 0 0 0 i\n"
  "MouseMoveEvent 158 196 0 0 0 0 i\n"
  "MouseMoveEvent 158 193 0 0 0 0 i\n"
  "MouseMoveEvent 158 191 0 0 0 0 i\n"
  "MouseMoveEvent 158 189 0 0 0 0 i\n"
  "MouseMoveEvent 159 187 0 0 0 0 i\n"
  "MouseMoveEvent 160 181 0 0 0 0 i\n"
  "MouseMoveEvent 160 179 0 0 0 0 i\n"
  "MouseMoveEvent 160 178 0 0 0 0 i\n"
  "MouseMoveEvent 160 176 0 0 0 0 i\n"
  "MouseMoveEvent 160 172 0 0 0 0 i\n"
  "MouseMoveEvent 160 170 0 0 0 0 i\n"
  "MouseMoveEvent 160 167 0 0 0 0 i\n"
  "MouseMoveEvent 160 165 0 0 0 0 i\n"
  "MouseMoveEvent 160 162 0 0 0 0 i\n"
  "MouseMoveEvent 160 158 0 0 0 0 i\n"
  "MouseMoveEvent 160 155 0 0 0 0 i\n"
  "MouseMoveEvent 161 152 0 0 0 0 i\n"
  "MouseMoveEvent 161 150 0 0 0 0 i\n"
  "MouseMoveEvent 161 149 0 0 0 0 i\n"
  "MouseMoveEvent 162 147 0 0 0 0 i\n"
  "MouseMoveEvent 162 143 0 0 0 0 i\n"
  "MouseMoveEvent 162 141 0 0 0 0 i\n"
  "MouseMoveEvent 162 140 0 0 0 0 i\n"
  "MouseMoveEvent 162 139 0 0 0 0 i\n"
  "MouseMoveEvent 162 138 0 0 0 0 i\n"
  "MouseMoveEvent 162 136 0 0 0 0 i\n"
  "MouseMoveEvent 163 136 0 0 0 0 i\n"
  "MouseMoveEvent 163 135 0 0 0 0 i\n"
  "MouseMoveEvent 163 133 0 0 0 0 i\n"
  "MouseMoveEvent 163 131 0 0 0 0 i\n"
  "MouseMoveEvent 163 130 0 0 0 0 i\n"
  "MouseMoveEvent 163 129 0 0 0 0 i\n"
  "MouseMoveEvent 163 128 0 0 0 0 i\n"
  "MouseMoveEvent 163 127 0 0 0 0 i\n"
  "MouseMoveEvent 163 126 0 0 0 0 i\n"
  "MouseMoveEvent 163 125 0 0 0 0 i\n"
  "LeftButtonReleaseEvent 163 125 0 0 0 0 i\n"
  "MouseMoveEvent 161 125 0 0 0 0 i\n"
  "MouseMoveEvent 154 128 0 0 0 0 i\n"
  "MouseMoveEvent 142 131 0 0 0 0 i\n"
  "MouseMoveEvent 135 132 0 0 0 0 i\n"
  "MouseMoveEvent 127 133 0 0 0 0 i\n"
  "MouseMoveEvent 120 134 0 0 0 0 i\n"
  "MouseMoveEvent 113 134 0 0 0 0 i\n"
  "MouseMoveEvent 104 135 0 0 0 0 i\n"
  "MouseMoveEvent 99 135 0 0 0 0 i\n"
  "MouseMoveEvent 93 136 0 0 0 0 i\n"
  "MouseMoveEvent 91 136 0 0 0 0 i\n"
  "MouseMoveEvent 89 136 0 0 0 0 i\n"
  "MouseMoveEvent 87 136 0 0 0 0 i\n"
  "MouseMoveEvent 86 136 0 0 0 0 i\n"
  "MouseMoveEvent 86 137 0 0 0 0 i\n"
  "MouseMoveEvent 84 138 0 0 0 0 i\n"
  "MouseMoveEvent 83 138 0 0 0 0 i\n"
  "MouseMoveEvent 82 140 0 0 0 0 i\n"
  "MouseMoveEvent 81 140 0 0 0 0 i\n"
  "MouseMoveEvent 79 142 0 0 0 0 i\n"
  "MouseMoveEvent 77 142 0 0 0 0 i\n"
  "MouseMoveEvent 76 144 0 0 0 0 i\n"
  "MouseMoveEvent 74 144 0 0 0 0 i\n"
  "MouseMoveEvent 73 145 0 0 0 0 i\n"
  "MouseMoveEvent 72 145 0 0 0 0 i\n"
  "MouseMoveEvent 70 145 0 0 0 0 i\n"
  "MouseMoveEvent 69 145 0 0 0 0 i\n"
  "MouseMoveEvent 68 145 0 0 0 0 i\n"
  "MouseMoveEvent 66 145 0 0 0 0 i\n"
  "MouseMoveEvent 66 146 0 0 0 0 i\n"
  "MouseMoveEvent 65 146 0 0 0 0 i\n"
  "MouseMoveEvent 63 146 0 0 0 0 i\n"
  "MouseMoveEvent 63 147 0 0 0 0 i\n"
  "LeftButtonPressEvent 63 147 0 0 0 0 i\n"
  "MouseMoveEvent 64 147 0 0 0 0 i\n"
  "MouseMoveEvent 65 147 0 0 0 0 i\n"
  "MouseMoveEvent 66 147 0 0 0 0 i\n"
  "MouseMoveEvent 67 147 0 0 0 0 i\n"
  "MouseMoveEvent 68 147 0 0 0 0 i\n"
  "MouseMoveEvent 69 147 0 0 0 0 i\n"
  "MouseMoveEvent 70 147 0 0 0 0 i\n"
  "MouseMoveEvent 72 147 0 0 0 0 i\n"
  "MouseMoveEvent 74 146 0 0 0 0 i\n"
  "MouseMoveEvent 76 146 0 0 0 0 i\n"
  "MouseMoveEvent 77 145 0 0 0 0 i\n"
  "MouseMoveEvent 78 145 0 0 0 0 i\n"
  "MouseMoveEvent 79 145 0 0 0 0 i\n"
  "MouseMoveEvent 80 145 0 0 0 0 i\n"
  "MouseMoveEvent 81 145 0 0 0 0 i\n"
  "MouseMoveEvent 82 145 0 0 0 0 i\n"
  "MouseMoveEvent 83 145 0 0 0 0 i\n"
  "MouseMoveEvent 84 145 0 0 0 0 i\n"
  "MouseMoveEvent 85 145 0 0 0 0 i\n"
  "MouseMoveEvent 86 145 0 0 0 0 i\n"
  "MouseMoveEvent 88 145 0 0 0 0 i\n"
  "MouseMoveEvent 90 145 0 0 0 0 i\n"
  "MouseMoveEvent 91 145 0 0 0 0 i\n"
  "MouseMoveEvent 94 145 0 0 0 0 i\n"
  "MouseMoveEvent 95 145 0 0 0 0 i\n"
  "MouseMoveEvent 97 145 0 0 0 0 i\n"
  "MouseMoveEvent 99 145 0 0 0 0 i\n"
  "MouseMoveEvent 102 145 0 0 0 0 i\n"
  "MouseMoveEvent 105 145 0 0 0 0 i\n"
  "MouseMoveEvent 109 145 0 0 0 0 i\n"
  "MouseMoveEvent 112 145 0 0 0 0 i\n"
  "MouseMoveEvent 113 146 0 0 0 0 i\n"
  "MouseMoveEvent 115 146 0 0 0 0 i\n"
  "MouseMoveEvent 117 146 0 0 0 0 i\n"
  "MouseMoveEvent 118 146 0 0 0 0 i\n"
  "MouseMoveEvent 119 146 0 0 0 0 i\n"
  "MouseMoveEvent 120 146 0 0 0 0 i\n"
  "MouseMoveEvent 121 146 0 0 0 0 i\n"
  "MouseMoveEvent 122 146 0 0 0 0 i\n"
  "MouseMoveEvent 123 146 0 0 0 0 i\n"
  "MouseMoveEvent 124 146 0 0 0 0 i\n"
  "MouseMoveEvent 125 146 0 0 0 0 i\n"
  "MouseMoveEvent 126 146 0 0 0 0 i\n"
  "MouseMoveEvent 127 146 0 0 0 0 i\n"
  "MouseMoveEvent 128 146 0 0 0 0 i\n"
  "MouseMoveEvent 129 146 0 0 0 0 i\n"
  "MouseMoveEvent 130 146 0 0 0 0 i\n"
  "MouseMoveEvent 131 146 0 0 0 0 i\n"
  "MouseMoveEvent 132 146 0 0 0 0 i\n"
  "MouseMoveEvent 133 146 0 0 0 0 i\n"
  "MouseMoveEvent 134 146 0 0 0 0 i\n"
  "MouseMoveEvent 135 146 0 0 0 0 i\n"
  "MouseMoveEvent 136 146 0 0 0 0 i\n"
  "MouseMoveEvent 137 146 0 0 0 0 i\n"
  "MouseMoveEvent 138 146 0 0 0 0 i\n"
  "MouseMoveEvent 139 146 0 0 0 0 i\n"
  "MouseMoveEvent 140 146 0 0 0 0 i\n"
  "MouseMoveEvent 141 146 0 0 0 0 i\n"
  "MouseMoveEvent 142 146 0 0 0 0 i\n"
  "MouseMoveEvent 143 146 0 0 0 0 i\n"
  "MouseMoveEvent 144 146 0 0 0 0 i\n"
  "MouseMoveEvent 145 146 0 0 0 0 i\n"
  "MouseMoveEvent 146 146 0 0 0 0 i\n"
  "MouseMoveEvent 147 146 0 0 0 0 i\n"
  "MouseMoveEvent 148 146 0 0 0 0 i\n"
  "MouseMoveEvent 149 146 0 0 0 0 i\n"
  "MouseMoveEvent 150 146 0 0 0 0 i\n"
  "MouseMoveEvent 151 146 0 0 0 0 i\n"
  "MouseMoveEvent 152 146 0 0 0 0 i\n"
  "MouseMoveEvent 153 146 0 0 0 0 i\n"
  "MouseMoveEvent 154 146 0 0 0 0 i\n"
  "MouseMoveEvent 155 146 0 0 0 0 i\n"
  "MouseMoveEvent 156 146 0 0 0 0 i\n"
  "MouseMoveEvent 157 146 0 0 0 0 i\n"
  "MouseMoveEvent 158 146 0 0 0 0 i\n"
  "MouseMoveEvent 159 146 0 0 0 0 i\n"
  "MouseMoveEvent 160 146 0 0 0 0 i\n"
  "MouseMoveEvent 161 146 0 0 0 0 i\n"
  "MouseMoveEvent 162 146 0 0 0 0 i\n"
  "MouseMoveEvent 163 146 0 0 0 0 i\n"
  "LeftButtonReleaseEvent 163 146 0 0 0 0 i\n"
  "MouseMoveEvent 163 150 0 0 0 0 i\n"
  "MouseMoveEvent 161 154 0 0 0 0 i\n"
  "MouseMoveEvent 160 158 0 0 0 0 i\n"
  "MouseMoveEvent 158 163 0 0 0 0 i\n"
  "MouseMoveEvent 154 175 0 0 0 0 i\n"
  "MouseMoveEvent 151 183 0 0 0 0 i\n"
  "MouseMoveEvent 148 191 0 0 0 0 i\n"
  "MouseMoveEvent 144 199 0 0 0 0 i\n"
  "MouseMoveEvent 140 208 0 0 0 0 i\n"
  "MouseMoveEvent 136 215 0 0 0 0 i\n"
  "MouseMoveEvent 133 221 0 0 0 0 i\n"
  "MouseMoveEvent 131 229 0 0 0 0 i\n"
  "MouseMoveEvent 129 233 0 0 0 0 i\n"
  "MouseMoveEvent 126 242 0 0 0 0 i\n"
  "MouseMoveEvent 124 248 0 0 0 0 i\n"
  "MouseMoveEvent 122 252 0 0 0 0 i\n"
  "MouseMoveEvent 120 256 0 0 0 0 i\n"
  "MouseMoveEvent 119 259 0 0 0 0 i\n"
  "MouseMoveEvent 117 261 0 0 0 0 i\n"
  "MouseMoveEvent 116 265 0 0 0 0 i\n"
  "MouseMoveEvent 115 267 0 0 0 0 i\n"
  "MouseMoveEvent 114 268 0 0 0 0 i\n"
  "MouseMoveEvent 114 269 0 0 0 0 i\n"
  "MouseMoveEvent 113 270 0 0 0 0 i\n"
  "MouseMoveEvent 112 271 0 0 0 0 i\n"
  "MouseMoveEvent 111 271 0 0 0 0 i\n"
  "MouseMoveEvent 111 272 0 0 0 0 i\n"
  "MouseMoveEvent 110 272 0 0 0 0 i\n"
  "MouseMoveEvent 109 273 0 0 0 0 i\n"
  "MouseMoveEvent 108 274 0 0 0 0 i\n"
  "MouseMoveEvent 106 276 0 0 0 0 i\n"
  "MouseMoveEvent 106 278 0 0 0 0 i\n"
  "MouseMoveEvent 105 278 0 0 0 0 i\n"
  "MouseMoveEvent 104 279 0 0 0 0 i\n"
  "MouseMoveEvent 102 281 0 0 0 0 i\n"
  "MouseMoveEvent 101 282 0 0 0 0 i\n"
  "MouseMoveEvent 100 282 0 0 0 0 i\n"
  "MouseMoveEvent 101 284 0 0 0 0 i\n"
  "MouseMoveEvent 101 285 0 0 0 0 i\n"
  "MouseMoveEvent 100 285 0 0 0 0 i\n"
  "MouseMoveEvent 99 285 0 0 0 0 i\n"
  ;

int TestScalarBarWidget( int argc, char *argv[] )
{
  char* fname =
    vtkTestUtilities::ExpandDataFileName(argc, argv, "Data/combxyz.bin");
  char* fname2 =
    vtkTestUtilities::ExpandDataFileName(argc, argv, "Data/combq.bin");

  // Start by loading some data.
  vtkSmartPointer<vtkMultiBlockPLOT3DReader> pl3d =
    vtkSmartPointer<vtkMultiBlockPLOT3DReader>::New();
  pl3d->SetXYZFileName(fname);
  pl3d->SetQFileName(fname2);
  pl3d->SetScalarFunctionNumber(100);
  pl3d->SetVectorFunctionNumber(202);
  pl3d->Update();
  vtkDataSet* pl3d_block0 = vtkDataSet::SafeDownCast(pl3d->GetOutput()->GetBlock(0));

  delete [] fname;
  delete [] fname2;

  // An outline is shown for context.
  vtkSmartPointer<vtkStructuredGridGeometryFilter> outline =
    vtkSmartPointer<vtkStructuredGridGeometryFilter>::New();
  outline->SetInputData(pl3d_block0);
  outline->SetExtent(0,100,0,100,9,9);

  vtkSmartPointer<vtkPolyDataMapper> outlineMapper =
    vtkSmartPointer<vtkPolyDataMapper>::New();
  outlineMapper->SetInputConnection(outline->GetOutputPort());

  vtkSmartPointer<vtkActor> outlineActor =
    vtkSmartPointer<vtkActor>::New();
  outlineActor->SetMapper(outlineMapper);

  // Create the RenderWindow, Renderer and both Actors
  //
  vtkSmartPointer<vtkRenderer> ren1 =
    vtkSmartPointer<vtkRenderer>::New();
  vtkSmartPointer<vtkRenderWindow> renWin =
    vtkSmartPointer<vtkRenderWindow>::New();
  renWin->AddRenderer(ren1);

  vtkSmartPointer<vtkRenderWindowInteractor> iren =
    vtkSmartPointer<vtkRenderWindowInteractor>::New();
  iren->SetRenderWindow(renWin);

  vtkSmartPointer<vtkScalarBarWidget> scalarWidget =
    vtkSmartPointer<vtkScalarBarWidget>::New();
  scalarWidget->SetInteractor(iren);
  scalarWidget->GetScalarBarActor()->SetTitle("Temperature");
  scalarWidget->GetScalarBarActor()->SetLookupTable(outlineMapper->GetLookupTable());

  ren1->AddActor(outlineActor);

  // Add the actors to the renderer, set the background and size
  //
  ren1->SetBackground(0.1, 0.2, 0.4);
  renWin->SetSize(300, 300);

  // record events
  vtkSmartPointer<vtkInteractorEventRecorder> recorder =
    vtkSmartPointer<vtkInteractorEventRecorder>::New();
  recorder->SetInteractor(iren);
//  recorder->SetFileName("c:/record.log");
//  recorder->Record();
  recorder->ReadFromInputStringOn();
  recorder->SetInputString(TSBWeventLog);

  // render the image
  iren->Initialize();
  renWin->Render();
  //scalarWidget->EnabledOn();
  recorder->Play();
  //recorder->EnabledOn();

  // Remove the observers so we can go interactive. Without this the "-I"
  // testing option fails.
  recorder->Off();

  iren->Start();

  recorder->Off();

  return EXIT_SUCCESS;
}
