# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
from oslo_config import cfg

from senlin.common.i18n import _


CONDUCTOR_GROUP = cfg.OptGroup('conductor')
CONDUCTOR_OPTS = [
    cfg.IntOpt('workers',
               default=1,
               help=_('Number of senlin-conductor processes.')),
    cfg.IntOpt('threads',
               default=1000,
               help=_('Number of senlin-conductor threads.')),
]


def register_opts(conf):
    conf.register_group(CONDUCTOR_GROUP)
    conf.register_opts(CONDUCTOR_OPTS, group=CONDUCTOR_GROUP)


def list_opts():
    return {
        CONDUCTOR_GROUP: CONDUCTOR_OPTS,
    }
