#pragma once
#include "ConnectionGraphicsObject.hpp"
#include "Export.hpp"
#include "NodeData.hpp"
#include "NodeGeometry.hpp"
#include "NodeGraphicsObject.hpp"
#include "NodeState.hpp"
#include "PortType.hpp"
#include "Serializable.hpp"
#include "memory.hpp"

#include <QtCore/QJsonObject>
#include <QtCore/QObject>
#include <QtCore/QUuid>
namespace QtNodes
{
    class Connection;
    class ConnectionState;
    class NodeGraphicsObject;
    class NodeDataModel;
    class NODE_EDITOR_PUBLIC Node
        : public QObject
        , public Serializable
    {
        Q_OBJECT
      public:
        /// NodeDataModel should be an rvalue and is moved into the Node
        Node(std::unique_ptr<NodeDataModel> &&dataModel);
        virtual ~Node();

      public:
        QJsonObject save() const override;
        void restore(QJsonObject const &json) override;

      public:
        QUuid id() const;
        void reactToPossibleConnection(PortType, std::shared_ptr<NodeDataType>, QPointF const &scenePoint);
        void resetReactionToConnection();

      public:
        NodeGraphicsObject const &nodeGraphicsObject() const;
        NodeGraphicsObject &nodeGraphicsObject();
        void setGraphicsObject(std::unique_ptr<NodeGraphicsObject> &&graphics);
        NodeGeometry &nodeGeometry();
        NodeGeometry const &nodeGeometry() const;
        NodeState const &nodeState() const;
        NodeState &nodeState();
        NodeDataModel *nodeDataModel() const;
      public Q_SLOTS: // data propagation
        /// Propagates incoming data to the underlying model.
        void propagateData(PortIndex inPortIndex) const;
        /// Fetches data from model's OUT #index port
        /// and propagates it to the connection
        void onDataUpdated(PortIndex index);
        /// update the graphic part if the size of the embeddedwidget changes
        void onNodeSizeUpdated();

      private:
        // addressing
        QUuid _uid;
        // data
        std::unique_ptr<NodeDataModel> _nodeDataModel;
        NodeState _nodeState;
        // painting
        NodeGeometry _nodeGeometry;
        std::unique_ptr<NodeGraphicsObject> _nodeGraphicsObject;
    };
} // namespace QtNodes
