# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DeviceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the device."""

    UNKNOWN = "Unknown"
    AZURE_STACK_EDGE = "AzureStackEdge"


class DiskCreateOptionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies how the virtual machine should be created."""

    UNKNOWN = "Unknown"
    EMPTY = "Empty"


class HttpMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The http method of the request."""

    UNKNOWN = "Unknown"
    POST = "Post"
    PUT = "Put"
    GET = "Get"
    PATCH = "Patch"
    DELETE = "Delete"


class IPAllocationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IP address allocation method."""

    UNKNOWN = "Unknown"
    STATIC = "Static"
    DYNAMIC = "Dynamic"


class IPVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IP address version."""

    UNKNOWN = "Unknown"
    I_PV4 = "IPv4"


class NetworkFunctionRoleConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Role type."""

    UNKNOWN = "Unknown"
    VIRTUAL_MACHINE = "VirtualMachine"


class NetworkFunctionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The network function type."""

    UNKNOWN = "Unknown"
    VIRTUAL_NETWORK_FUNCTION = "VirtualNetworkFunction"
    CONTAINERIZED_NETWORK_FUNCTION = "ContainerizedNetworkFunction"


class OperatingSystemTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The OS type."""

    UNKNOWN = "Unknown"
    WINDOWS = "Windows"
    LINUX = "Linux"


class OperationalState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operational state of the role instance."""

    UNKNOWN = "Unknown"
    STOPPED = "Stopped"
    RUNNING = "Running"
    STOPPING = "Stopping"
    STARTING = "Starting"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    UNKNOWN = "Unknown"
    SUCCEEDED = "Succeeded"
    ACCEPTED = "Accepted"
    DELETING = "Deleting"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"


class SkuDeploymentMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sku deployment mode."""

    UNKNOWN = "Unknown"
    AZURE = "Azure"
    PRIVATE_EDGE_ZONE = "PrivateEdgeZone"


class SkuType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sku type."""

    UNKNOWN = "Unknown"
    EVOLVED_PACKET_CORE = "EvolvedPacketCore"
    SDWAN = "SDWAN"
    FIREWALL = "Firewall"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current device status."""

    UNKNOWN = "Unknown"
    NOT_REGISTERED = "NotRegistered"
    REGISTERED = "Registered"
    DELETED = "Deleted"


class VendorProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current vendor provisioning state."""

    UNKNOWN = "Unknown"
    NOT_PROVISIONED = "NotProvisioned"
    PROVISIONING = "Provisioning"
    PROVISIONED = "Provisioned"
    DEPROVISIONED = "Deprovisioned"
    USER_DATA_VALIDATION_FAILED = "UserDataValidationFailed"


class VirtualMachineSizeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The size of the virtual machine."""

    UNKNOWN = "Unknown"
    STANDARD_D1_V2 = "Standard_D1_v2"
    STANDARD_D2_V2 = "Standard_D2_v2"
    STANDARD_D3_V2 = "Standard_D3_v2"
    STANDARD_D4_V2 = "Standard_D4_v2"
    STANDARD_D5_V2 = "Standard_D5_v2"
    STANDARD_D11_V2 = "Standard_D11_v2"
    STANDARD_D12_V2 = "Standard_D12_v2"
    STANDARD_D13_V2 = "Standard_D13_v2"
    STANDARD_DS1_V2 = "Standard_DS1_v2"
    STANDARD_DS2_V2 = "Standard_DS2_v2"
    STANDARD_DS3_V2 = "Standard_DS3_v2"
    STANDARD_DS4_V2 = "Standard_DS4_v2"
    STANDARD_DS5_V2 = "Standard_DS5_v2"
    STANDARD_DS11_V2 = "Standard_DS11_v2"
    STANDARD_DS12_V2 = "Standard_DS12_v2"
    STANDARD_DS13_V2 = "Standard_DS13_v2"
    STANDARD_F1 = "Standard_F1"
    STANDARD_F2 = "Standard_F2"
    STANDARD_F4 = "Standard_F4"
    STANDARD_F8 = "Standard_F8"
    STANDARD_F16 = "Standard_F16"
    STANDARD_F1_S = "Standard_F1s"
    STANDARD_F2_S = "Standard_F2s"
    STANDARD_F4_S = "Standard_F4s"
    STANDARD_F8_S = "Standard_F8s"
    STANDARD_F16_S = "Standard_F16s"


class VMSwitchType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the VM switch."""

    UNKNOWN = "Unknown"
    MANAGEMENT = "Management"
    WAN = "Wan"
    LAN = "Lan"
