# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, cast, overload
from urllib.parse import parse_qs, urljoin, urlparse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.polling.base_polling import LROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer
from .._vendor import _format_url_section

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_dev_center_list_projects_request(
    *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_center_get_project_request(project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_center_list_all_dev_boxes_request(
    *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/devboxes"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_center_list_all_dev_boxes_by_user_request(
    user_id: str = "me", *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/users/{userId}/devboxes"
    path_format_arguments = {
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_list_pools_request(
    project_name: str, *, top: Optional[int] = None, filter: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/pools"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_get_pool_request(pool_name: str, project_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/pools/{poolName}"
    path_format_arguments = {
        "poolName": _SERIALIZER.url(
            "pool_name", pool_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-_.]{2,62}$"
        ),
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_list_schedules_by_pool_request(
    project_name: str, pool_name: str, *, top: Optional[int] = None, filter: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/pools/{poolName}/schedules"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "poolName": _SERIALIZER.url(
            "pool_name", pool_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-_.]{2,62}$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_get_schedule_by_pool_request(
    project_name: str, pool_name: str, schedule_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/pools/{poolName}/schedules/{scheduleName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "poolName": _SERIALIZER.url(
            "pool_name", pool_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-_.]{2,62}$"
        ),
        "scheduleName": _SERIALIZER.url("schedule_name", schedule_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_list_dev_boxes_by_user_request(
    project_name: str, user_id: str = "me", *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/devboxes"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["filter"] = _SERIALIZER.query("filter", filter, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_get_dev_box_by_user_request(
    project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/devboxes/{devBoxName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "devBoxName": _SERIALIZER.url(
            "dev_box_name",
            dev_box_name,
            "str",
            max_length=63,
            min_length=3,
            pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-_.]{2,62}$",
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_create_dev_box_request(
    project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/devboxes/{devBoxName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "devBoxName": _SERIALIZER.url(
            "dev_box_name",
            dev_box_name,
            "str",
            max_length=63,
            min_length=3,
            pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-_.]{2,62}$",
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_delete_dev_box_request(
    project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/devboxes/{devBoxName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "devBoxName": _SERIALIZER.url(
            "dev_box_name",
            dev_box_name,
            "str",
            max_length=63,
            min_length=3,
            pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-_.]{2,62}$",
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_start_dev_box_request(
    project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/devboxes/{devBoxName}:start"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "devBoxName": _SERIALIZER.url(
            "dev_box_name",
            dev_box_name,
            "str",
            max_length=63,
            min_length=3,
            pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-_.]{2,62}$",
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_stop_dev_box_request(
    project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/devboxes/{devBoxName}:stop"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "devBoxName": _SERIALIZER.url(
            "dev_box_name",
            dev_box_name,
            "str",
            max_length=63,
            min_length=3,
            pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-_.]{2,62}$",
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_dev_boxes_get_remote_connection_request(
    project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/remoteConnection"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "devBoxName": _SERIALIZER.url(
            "dev_box_name",
            dev_box_name,
            "str",
            max_length=63,
            min_length=3,
            pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-_.]{2,62}$",
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_list_environments_request(
    project_name: str, *, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/environments"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_list_environments_by_user_request(
    project_name: str, user_id: str = "me", *, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/environments"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_get_environment_by_user_request(
    project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/environments/{environmentName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "environmentName": _SERIALIZER.url("environment_name", environment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_create_or_update_environment_request(
    project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/environments/{environmentName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "environmentName": _SERIALIZER.url("environment_name", environment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_update_environment_request(
    project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/environments/{environmentName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "environmentName": _SERIALIZER.url("environment_name", environment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_delete_environment_request(
    project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/environments/{environmentName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "environmentName": _SERIALIZER.url("environment_name", environment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_deploy_environment_action_request(
    project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/environments/{environmentName}:deploy"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "environmentName": _SERIALIZER.url("environment_name", environment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_delete_environment_action_request(
    project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/environments/{environmentName}:delete"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "environmentName": _SERIALIZER.url("environment_name", environment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_custom_environment_action_request(
    project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/environments/{environmentName}:custom"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "environmentName": _SERIALIZER.url("environment_name", environment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_list_artifacts_by_environment_request(
    project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/environments/{environmentName}/artifacts"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "environmentName": _SERIALIZER.url("environment_name", environment_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_list_artifacts_by_environment_and_path_request(
    project_name: str, environment_name: str, artifact_path: str, user_id: str = "me", **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/users/{userId}/environments/{environmentName}/artifacts/{artifactPath}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "userId": _SERIALIZER.url(
            "user_id",
            user_id,
            "str",
            max_length=36,
            min_length=2,
            pattern=r"^[a-zA-Z0-9]{8}-([a-zA-Z0-9]{4}-){3}[a-zA-Z0-9]{12}$|^me$",
        ),
        "environmentName": _SERIALIZER.url("environment_name", environment_name, "str"),
        "artifactPath": _SERIALIZER.url("artifact_path", artifact_path, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_list_catalog_items_request(
    project_name: str, *, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/catalogItems"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_get_catalog_item_request(project_name: str, catalog_item_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/catalogItems/{catalogItemId}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "catalogItemId": _SERIALIZER.url("catalog_item_id", catalog_item_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_list_catalog_item_versions_request(
    project_name: str, catalog_item_id: str, *, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/catalogItems/{catalogItemId}/versions"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "catalogItemId": _SERIALIZER.url("catalog_item_id", catalog_item_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_get_catalog_item_version_request(
    project_name: str, catalog_item_id: str, version: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/catalogItems/{catalogItemId}/versions/{version}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
        "catalogItemId": _SERIALIZER.url("catalog_item_id", catalog_item_id, "str"),
        "version": _SERIALIZER.url("version", version, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_environments_list_environment_types_request(
    project_name: str, *, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01-preview"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/projects/{projectName}/environmentTypes"
    path_format_arguments = {
        "projectName": _SERIALIZER.url(
            "project_name", project_name, "str", max_length=63, min_length=3, pattern=r"^[a-zA-Z0-9][a-zA-Z0-9-]{2,62}$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class DevCenterOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.developer.devcenter.DevCenterClient`'s
        :attr:`dev_center` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_projects(
        self, *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists all projects.

        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "description": "str",  # Optional. Description of the project.
                    "name": "str"  # Optional. Name of the project.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_dev_center_list_projects_request(
                    filter=filter,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_project(self, project_name: str, **kwargs: Any) -> JSON:
        """Gets a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "description": "str",  # Optional. Description of the project.
                    "name": "str"  # Optional. Name of the project.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_dev_center_get_project_request(
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_all_dev_boxes(
        self, *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists Dev Boxes that the caller has access to in the DevCenter.

        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_dev_center_list_all_dev_boxes_request(
                    filter=filter,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_all_dev_boxes_by_user(
        self, user_id: str = "me", *, filter: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists Dev Boxes in the Dev Center for a particular user.

        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_dev_center_list_all_dev_boxes_by_user_request(
                    user_id=user_id,
                    filter=filter,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)


class DevBoxesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.developer.devcenter.DevCenterClient`'s
        :attr:`dev_boxes` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_pools(
        self, project_name: str, *, top: Optional[int] = None, filter: Optional[str] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists available pools.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether owners of Dev
                      Boxes in this pool are local administrators on the Dev Boxes. Known values are:
                      "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where Dev Boxes in the pool are
                      located.
                    "name": "str",  # Optional. Pool name.
                    "osType": "str",  # Optional. The operating system type of Dev Boxes in this
                      pool. "Windows"
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_dev_boxes_list_pools_request(
                    project_name=project_name,
                    top=top,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_pool(self, pool_name: str, project_name: str, **kwargs: Any) -> JSON:
        """Gets a pool.

        :param pool_name: The name of a pool of Dev Boxes. Required.
        :type pool_name: str
        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether owners of Dev
                      Boxes in this pool are local administrators on the Dev Boxes. Known values are:
                      "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where Dev Boxes in the pool are
                      located.
                    "name": "str",  # Optional. Pool name.
                    "osType": "str",  # Optional. The operating system type of Dev Boxes in this
                      pool. "Windows"
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_dev_boxes_get_pool_request(
            pool_name=pool_name,
            project_name=project_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_schedules_by_pool(
        self,
        project_name: str,
        pool_name: str,
        *,
        top: Optional[int] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists available schedules for a pool.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param pool_name: The name of a pool of Dev Boxes. Required.
        :type pool_name: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "frequency": "str",  # Optional. The frequency of this scheduled task.
                      "Daily"
                    "name": "str",  # Optional. Display name for the Schedule.
                    "time": "str",  # Optional. The target time to trigger the action. The format
                      is HH:MM.
                    "timeZone": "str",  # Optional. The IANA timezone id at which the schedule
                      should execute.
                    "type": "str"  # Optional. Supported type this scheduled task represents.
                      "StopDevBox"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_dev_boxes_list_schedules_by_pool_request(
                    project_name=project_name,
                    pool_name=pool_name,
                    top=top,
                    filter=filter,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_schedule_by_pool(self, project_name: str, pool_name: str, schedule_name: str, **kwargs: Any) -> JSON:
        """Gets a schedule.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param pool_name: The name of a pool of Dev Boxes. Required.
        :type pool_name: str
        :param schedule_name: The name of a schedule. Required.
        :type schedule_name: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "frequency": "str",  # Optional. The frequency of this scheduled task.
                      "Daily"
                    "name": "str",  # Optional. Display name for the Schedule.
                    "time": "str",  # Optional. The target time to trigger the action. The format
                      is HH:MM.
                    "timeZone": "str",  # Optional. The IANA timezone id at which the schedule
                      should execute.
                    "type": "str"  # Optional. Supported type this scheduled task represents.
                      "StopDevBox"
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_dev_boxes_get_schedule_by_pool_request(
            project_name=project_name,
            pool_name=pool_name,
            schedule_name=schedule_name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_dev_boxes_by_user(
        self,
        project_name: str,
        user_id: str = "me",
        *,
        filter: Optional[str] = None,
        top: Optional[int] = None,
        **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists Dev Boxes in the project for a particular user.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword filter: An OData filter clause to apply to the operation. Default value is None.
        :paramtype filter: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_dev_boxes_list_dev_boxes_by_user_request(
                    project_name=project_name,
                    user_id=user_id,
                    filter=filter,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_dev_box_by_user(self, project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any) -> JSON:
        """Gets a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_dev_boxes_get_dev_box_by_user_request(
            project_name=project_name,
            dev_box_name=dev_box_name,
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    def _create_dev_box_initial(
        self, project_name: str, dev_box_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_dev_boxes_create_dev_box_request(
            project_name=project_name,
            dev_box_name=dev_box_name,
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    def begin_create_dev_box(
        self,
        project_name: str,
        dev_box_name: str,
        body: JSON,
        user_id: str = "me",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Creates or updates a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param body: Represents a environment. Required.
        :type body: JSON
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }

                # response body for status code(s): 200, 201
                response == {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }
        """

    @overload
    def begin_create_dev_box(
        self,
        project_name: str,
        dev_box_name: str,
        body: IO,
        user_id: str = "me",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Creates or updates a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param body: Represents a environment. Required.
        :type body: IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }
        """

    @distributed_trace
    def begin_create_dev_box(
        self, project_name: str, dev_box_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> LROPoller[JSON]:
        """Creates or updates a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param body: Represents a environment. Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._create_dev_box_initial(  # type: ignore
                project_name=project_name,
                dev_box_name=dev_box_name,
                body=body,
                user_id=user_id,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod,
                LROBasePolling(
                    lro_delay,
                    lro_options={"final-state-via": "original-uri"},
                    path_format_arguments=path_format_arguments,
                    **kwargs
                ),
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _delete_dev_box_initial(
        self, project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        request = build_dev_boxes_delete_dev_box_request(
            project_name=project_name,
            dev_box_name=dev_box_name,
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def begin_delete_dev_box(
        self, project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
    ) -> LROPoller[JSON]:
        """Deletes a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._delete_dev_box_initial(  # type: ignore
                project_name=project_name,
                dev_box_name=dev_box_name,
                user_id=user_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _start_dev_box_initial(
        self, project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        request = build_dev_boxes_start_dev_box_request(
            project_name=project_name,
            dev_box_name=dev_box_name,
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def begin_start_dev_box(
        self, project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
    ) -> LROPoller[JSON]:
        """Starts a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._start_dev_box_initial(  # type: ignore
                project_name=project_name,
                dev_box_name=dev_box_name,
                user_id=user_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod,
                LROBasePolling(
                    lro_delay,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=path_format_arguments,
                    **kwargs
                ),
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _stop_dev_box_initial(
        self, project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
    ) -> Optional[JSON]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        request = build_dev_boxes_stop_dev_box_request(
            project_name=project_name,
            dev_box_name=dev_box_name,
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def begin_stop_dev_box(
        self, project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any
    ) -> LROPoller[JSON]:
        """Stops a Dev Box.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "poolName": "str",  # The name of the Dev Box pool this machine belongs to.
                      Required.
                    "actionState": "str",  # Optional. The current action state of the Dev Box.
                      This is state is based on previous action performed by user.
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Creation time of this Dev
                      Box.
                    "errorDetails": {
                        "code": "str",  # Optional. The error code.
                        "message": "str"  # Optional. The error message.
                    },
                    "hardwareProfile": {
                        "memoryGB": 0,  # Optional. The amount of memory available for the
                          Dev Box.
                        "skuName": "str",  # Optional. The name of the SKU.
                        "vCPUs": 0  # Optional. The number of vCPUs available for the Dev
                          Box.
                    },
                    "imageReference": {
                        "name": "str",  # Optional. The name of the image used.
                        "operatingSystem": "str",  # Optional. The operating system of the
                          image.
                        "osBuildNumber": "str",  # Optional. The operating system build
                          number of the image.
                        "publishedDate": "2020-02-20 00:00:00",  # Optional. The datetime
                          that the backing image version was published.
                        "version": "str"  # Optional. The version of the image.
                    },
                    "localAdministrator": "str",  # Optional. Indicates whether the owner of the
                      Dev Box is a local administrator. Known values are: "Enabled" and "Disabled".
                    "location": "str",  # Optional. Azure region where this Dev Box is located.
                      This will be the same region as the Virtual Network it is attached to.
                    "name": "str",  # Optional. Display name for the Dev Box.
                    "osType": "str",  # Optional. The operating system type of this Dev Box.
                      "Windows"
                    "powerState": "str",  # Optional. The current power state of the Dev Box.
                      Known values are: "Unknown", "Deallocated", "PoweredOff", "Running", and
                      "Hibernated".
                    "projectName": "str",  # Optional. Name of the project this Dev Box belongs
                      to.
                    "provisioningState": "str",  # Optional. The current provisioning state of
                      the Dev Box.
                    "storageProfile": {
                        "osDisk": {
                            "diskSizeGB": 0  # Optional. The size of the OS Disk in
                              gigabytes.
                        }
                    },
                    "uniqueId": "str",  # Optional. A unique identifier for the Dev Box. This is
                      a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
                    "user": "str"  # Optional. User identifier of the user this vm is assigned
                      to.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._stop_dev_box_initial(  # type: ignore
                project_name=project_name,
                dev_box_name=dev_box_name,
                user_id=user_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod,
                LROBasePolling(
                    lro_delay,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=path_format_arguments,
                    **kwargs
                ),
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def get_remote_connection(self, project_name: str, dev_box_name: str, user_id: str = "me", **kwargs: Any) -> JSON:
        """Gets RDP Connection info.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param dev_box_name: The name of a Dev Box. Required.
        :type dev_box_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "rdpConnectionUrl": "str",  # Optional. Link to open a Remote Desktop
                      session.
                    "webUrl": "str"  # Optional. URL to open a browser based RDP session.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_dev_boxes_get_remote_connection_request(
            project_name=project_name,
            dev_box_name=dev_box_name,
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class EnvironmentsOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.developer.devcenter.DevCenterClient`'s
        :attr:`environments` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_environments(self, project_name: str, *, top: Optional[int] = None, **kwargs: Any) -> Iterable[JSON]:
        """Lists the environments for a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "environmentType": "str",  # Environment type. Required.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "name": "str",  # Optional. Environment name.
                    "owner": "str",  # Optional. Identifier of the owner of this Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_environments_list_environments_request(
                    project_name=project_name,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_environments_by_user(
        self, project_name: str, user_id: str = "me", *, top: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists the environments for a project and user.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "environmentType": "str",  # Environment type. Required.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "name": "str",  # Optional. Environment name.
                    "owner": "str",  # Optional. Identifier of the owner of this Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_environments_list_environments_by_user_request(
                    project_name=project_name,
                    user_id=user_id,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_environment_by_user(
        self, project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
    ) -> JSON:
        """Gets an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "environmentType": "str",  # Environment type. Required.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "name": "str",  # Optional. Environment name.
                    "owner": "str",  # Optional. Identifier of the owner of this Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_environments_get_environment_by_user_request(
            project_name=project_name,
            environment_name=environment_name,
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    def _create_or_update_environment_initial(
        self, project_name: str, environment_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_environments_create_or_update_environment_request(
            project_name=project_name,
            environment_name=environment_name,
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @overload
    def begin_create_or_update_environment(
        self,
        project_name: str,
        environment_name: str,
        body: JSON,
        user_id: str = "me",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Creates or updates an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Represents a environment. Required.
        :type body: JSON
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "environmentType": "str",  # Environment type. Required.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "name": "str",  # Optional. Environment name.
                    "owner": "str",  # Optional. Identifier of the owner of this Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }

                # response body for status code(s): 200, 201
                response == {
                    "environmentType": "str",  # Environment type. Required.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "name": "str",  # Optional. Environment name.
                    "owner": "str",  # Optional. Identifier of the owner of this Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }
        """

    @overload
    def begin_create_or_update_environment(
        self,
        project_name: str,
        environment_name: str,
        body: IO,
        user_id: str = "me",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[JSON]:
        """Creates or updates an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Represents a environment. Required.
        :type body: IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "environmentType": "str",  # Environment type. Required.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "name": "str",  # Optional. Environment name.
                    "owner": "str",  # Optional. Identifier of the owner of this Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }
        """

    @distributed_trace
    def begin_create_or_update_environment(
        self, project_name: str, environment_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> LROPoller[JSON]:
        """Creates or updates an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Represents a environment. Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "environmentType": "str",  # Environment type. Required.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "name": "str",  # Optional. Environment name.
                    "owner": "str",  # Optional. Identifier of the owner of this Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._create_or_update_environment_initial(  # type: ignore
                project_name=project_name,
                environment_name=environment_name,
                body=body,
                user_id=user_id,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod,
                LROBasePolling(
                    lro_delay,
                    lro_options={"final-state-via": "original-uri"},
                    path_format_arguments=path_format_arguments,
                    **kwargs
                ),
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @overload
    def update_environment(
        self,
        project_name: str,
        environment_name: str,
        body: JSON,
        user_id: str = "me",
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Partially updates an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Updatable environment properties. Required.
        :type body: JSON
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "environmentType": "str",  # Environment type. Required.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "name": "str",  # Optional. Environment name.
                    "owner": "str",  # Optional. Identifier of the owner of this Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }
        """

    @overload
    def update_environment(
        self,
        project_name: str,
        environment_name: str,
        body: IO,
        user_id: str = "me",
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> JSON:
        """Partially updates an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Updatable environment properties. Required.
        :type body: IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "environmentType": "str",  # Environment type. Required.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "name": "str",  # Optional. Environment name.
                    "owner": "str",  # Optional. Identifier of the owner of this Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }
        """

    @distributed_trace
    def update_environment(
        self, project_name: str, environment_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> JSON:
        """Partially updates an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Updatable environment properties. Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "environmentType": "str",  # Environment type. Required.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. Description of the Environment.
                    "name": "str",  # Optional. Environment name.
                    "owner": "str",  # Optional. Identifier of the owner of this Environment.
                    "parameters": {},  # Optional. Parameters object for the deploy action.
                    "provisioningState": "str",  # Optional. The provisioning state of the
                      environment.
                    "resourceGroupId": "str",  # Optional. The identifier of the resource group
                      containing the environment's resources.
                    "scheduledTasks": {
                        "str": {
                            "startTime": "2020-02-20 00:00:00",  # Date/time by which the
                              environment should expire. Required.
                            "type": "str",  # Supported type this scheduled task
                              represents. Required. "AutoExpire"
                            "enabled": "str"  # Optional. Indicates whether or not this
                              scheduled task is enabled. Known values are: "Enabled" and "Disabled".
                        }
                    },
                    "tags": {
                        "str": "str"  # Optional. Key value pairs that will be applied to
                          resources deployed in this environment as tags.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_environments_update_environment_request(
            project_name=project_name,
            environment_name=environment_name,
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    def _delete_environment_initial(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_environments_delete_environment_request(
            project_name=project_name,
            environment_name=environment_name,
            user_id=user_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def begin_delete_environment(
        self, project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
    ) -> LROPoller[None]:
        """Deletes an environment and all it's associated resources.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._delete_environment_initial(  # type: ignore
                project_name=project_name,
                environment_name=environment_name,
                user_id=user_id,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod,
                LROBasePolling(
                    lro_delay,
                    lro_options={"final-state-via": "original-uri"},
                    path_format_arguments=path_format_arguments,
                    **kwargs
                ),
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _deploy_environment_action_initial(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, environment_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_environments_deploy_environment_action_request(
            project_name=project_name,
            environment_name=environment_name,
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, None, response_headers)

    @overload
    def begin_deploy_environment_action(
        self,
        project_name: str,
        environment_name: str,
        body: JSON,
        user_id: str = "me",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[None]:
        """Executes a deploy action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Action properties overriding the environment's default values. Required.
        :type body: JSON
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "actionId": "str",  # The Catalog Item action id to execute. Required.
                    "parameters": {}  # Optional. Parameters object for the Action.
                }
        """

    @overload
    def begin_deploy_environment_action(
        self,
        project_name: str,
        environment_name: str,
        body: IO,
        user_id: str = "me",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[None]:
        """Executes a deploy action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Action properties overriding the environment's default values. Required.
        :type body: IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_deploy_environment_action(
        self, project_name: str, environment_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> LROPoller[None]:
        """Executes a deploy action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Action properties overriding the environment's default values. Is either a model
         type or a IO type. Required.
        :type body: JSON or IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._deploy_environment_action_initial(  # type: ignore
                project_name=project_name,
                environment_name=environment_name,
                body=body,
                user_id=user_id,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod,
                LROBasePolling(
                    lro_delay,
                    lro_options={"final-state-via": "original-uri"},
                    path_format_arguments=path_format_arguments,
                    **kwargs
                ),
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _delete_environment_action_initial(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, environment_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_environments_delete_environment_action_request(
            project_name=project_name,
            environment_name=environment_name,
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, None, response_headers)

    @overload
    def begin_delete_environment_action(
        self,
        project_name: str,
        environment_name: str,
        body: JSON,
        user_id: str = "me",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[None]:
        """Executes a delete action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Action properties overriding the environment's default values. Required.
        :type body: JSON
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "actionId": "str",  # The Catalog Item action id to execute. Required.
                    "parameters": {}  # Optional. Parameters object for the Action.
                }
        """

    @overload
    def begin_delete_environment_action(
        self,
        project_name: str,
        environment_name: str,
        body: IO,
        user_id: str = "me",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[None]:
        """Executes a delete action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Action properties overriding the environment's default values. Required.
        :type body: IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_delete_environment_action(
        self, project_name: str, environment_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> LROPoller[None]:
        """Executes a delete action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Action properties overriding the environment's default values. Is either a model
         type or a IO type. Required.
        :type body: JSON or IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._delete_environment_action_initial(  # type: ignore
                project_name=project_name,
                environment_name=environment_name,
                body=body,
                user_id=user_id,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod,
                LROBasePolling(
                    lro_delay,
                    lro_options={"final-state-via": "original-uri"},
                    path_format_arguments=path_format_arguments,
                    **kwargs
                ),
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _custom_environment_action_initial(  # pylint: disable=inconsistent-return-statements
        self, project_name: str, environment_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_environments_custom_environment_action_request(
            project_name=project_name,
            environment_name=environment_name,
            user_id=user_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, None, response_headers)

    @overload
    def begin_custom_environment_action(
        self,
        project_name: str,
        environment_name: str,
        body: JSON,
        user_id: str = "me",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[None]:
        """Executes a custom action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Action properties overriding the environment's default values. Required.
        :type body: JSON
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "actionId": "str",  # The Catalog Item action id to execute. Required.
                    "parameters": {}  # Optional. Parameters object for the Action.
                }
        """

    @overload
    def begin_custom_environment_action(
        self,
        project_name: str,
        environment_name: str,
        body: IO,
        user_id: str = "me",
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[None]:
        """Executes a custom action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Action properties overriding the environment's default values. Required.
        :type body: IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_custom_environment_action(
        self, project_name: str, environment_name: str, body: Union[JSON, IO], user_id: str = "me", **kwargs: Any
    ) -> LROPoller[None]:
        """Executes a custom action.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param body: Action properties overriding the environment's default values. Is either a model
         type or a IO type. Required.
        :type body: JSON or IO
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._custom_environment_action_initial(  # type: ignore
                project_name=project_name,
                environment_name=environment_name,
                body=body,
                user_id=user_id,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }

        if polling is True:
            polling_method = cast(
                PollingMethod,
                LROBasePolling(
                    lro_delay,
                    lro_options={"final-state-via": "original-uri"},
                    path_format_arguments=path_format_arguments,
                    **kwargs
                ),
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def list_artifacts_by_environment(
        self, project_name: str, environment_name: str, user_id: str = "me", **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists the artifacts for an environment.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Time the artifact was
                      created.
                    "downloadUri": "str",  # Optional. Uri where the file contents can be
                      downloaded.
                    "fileSize": 0.0,  # Optional. Size of file in bytes, if the artifact is a
                      file.
                    "id": "str",  # Optional. Artifact identifier.
                    "isDirectory": bool,  # Optional. Whether artifact is a directory.
                    "lastModifiedTime": "2020-02-20 00:00:00",  # Optional. Time the artifact was
                      last modified.
                    "name": "str"  # Optional. Artifact name.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_environments_list_artifacts_by_environment_request(
                    project_name=project_name,
                    environment_name=environment_name,
                    user_id=user_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_artifacts_by_environment_and_path(
        self, project_name: str, environment_name: str, artifact_path: str, user_id: str = "me", **kwargs: Any
    ) -> Iterable[JSON]:
        """Lists the artifacts for an environment at a specified path, or returns the file at the path.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param environment_name: The name of the environment. Required.
        :type environment_name: str
        :param artifact_path: The path of the artifact. Required.
        :type artifact_path: str
        :param user_id: The AAD object id of the user. If value is 'me', the identity is taken from the
         authentication context. Default value is "me".
        :type user_id: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdTime": "2020-02-20 00:00:00",  # Optional. Time the artifact was
                      created.
                    "downloadUri": "str",  # Optional. Uri where the file contents can be
                      downloaded.
                    "fileSize": 0.0,  # Optional. Size of file in bytes, if the artifact is a
                      file.
                    "id": "str",  # Optional. Artifact identifier.
                    "isDirectory": bool,  # Optional. Whether artifact is a directory.
                    "lastModifiedTime": "2020-02-20 00:00:00",  # Optional. Time the artifact was
                      last modified.
                    "name": "str"  # Optional. Artifact name.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_environments_list_artifacts_by_environment_and_path_request(
                    project_name=project_name,
                    environment_name=environment_name,
                    artifact_path=artifact_path,
                    user_id=user_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_catalog_items(self, project_name: str, *, top: Optional[int] = None, **kwargs: Any) -> Iterable[JSON]:
        """Lists latest version of all catalog items available for a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "id": "str",  # Optional. Unique identifier of the catalog item.
                    "name": "str"  # Optional. Name of the catalog item.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_environments_list_catalog_items_request(
                    project_name=project_name,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_catalog_item(self, project_name: str, catalog_item_id: str, **kwargs: Any) -> JSON:
        """Get a catalog item from a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param catalog_item_id: The unique id of the catalog item. Required.
        :type catalog_item_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "id": "str",  # Optional. Unique identifier of the catalog item.
                    "name": "str"  # Optional. Name of the catalog item.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_environments_get_catalog_item_request(
            project_name=project_name,
            catalog_item_id=catalog_item_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_catalog_item_versions(
        self, project_name: str, catalog_item_id: str, *, top: Optional[int] = None, **kwargs: Any
    ) -> Iterable[JSON]:
        """List all versions of a catalog item from a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param catalog_item_id: The unique id of the catalog item. Required.
        :type catalog_item_id: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actions": [
                        {
                            "description": "str",  # Optional. Description of the action.
                            "id": "str",  # Optional. Unique identifier of the action.
                            "name": "str",  # Optional. Display name of the action.
                            "parameters": [
                                {
                                    "allowed": [
                                        {}  # Optional. An array of allowed
                                          values.
                                    ],
                                    "default": {},  # Optional. Default value of
                                      the parameter.
                                    "description": "str",  # Optional.
                                      Description of the parameter.
                                    "id": "str",  # Optional. Unique ID of the
                                      parameter.
                                    "name": "str",  # Optional. Display name of
                                      the parameter.
                                    "readOnly": bool,  # Optional. Whether or not
                                      this parameter is read-only.  If true, default should have a
                                      value.
                                    "required": bool,  # Optional. Whether or not
                                      this parameter is required.
                                    "type": "str"  # Optional. A string of one of
                                      the basic JSON types (number, integer, null, array, object,
                                      boolean, string). Known values are: "array", "boolean",
                                      "integer", "null", "number", "object", and "string".
                                }
                            ],
                            "parametersSchema": "str",  # Optional. JSON schema defining
                              the parameters specific to the custom action.
                            "runner": "str",  # Optional. The container image to use to
                              execute the action.
                            "type": "str",  # Optional. The action type. Known values
                              are: "Custom", "Deploy", and "Delete".
                            "typeName": "str"  # Optional. Name of the custom action
                              type.
                        }
                    ],
                    "catalogItemId": "str",  # Optional. Unique identifier of the catalog item.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. A long description of the catalog item.
                    "eligibleForLatestVersion": bool,  # Optional. Whether the version is
                      eligible to be the latest version.
                    "parameters": [
                        {
                            "allowed": [
                                {}  # Optional. An array of allowed values.
                            ],
                            "default": {},  # Optional. Default value of the parameter.
                            "description": "str",  # Optional. Description of the
                              parameter.
                            "id": "str",  # Optional. Unique ID of the parameter.
                            "name": "str",  # Optional. Display name of the parameter.
                            "readOnly": bool,  # Optional. Whether or not this parameter
                              is read-only.  If true, default should have a value.
                            "required": bool,  # Optional. Whether or not this parameter
                              is required.
                            "type": "str"  # Optional. A string of one of the basic JSON
                              types (number, integer, null, array, object, boolean, string). Known
                              values are: "array", "boolean", "integer", "null", "number", "object",
                              and "string".
                        }
                    ],
                    "parametersSchema": "str",  # Optional. JSON schema defining the parameters
                      object passed to actions.
                    "runner": "str",  # Optional. The default container image to use to execute
                      actions.
                    "status": "str",  # Optional. Defines whether the specific catalog item
                      version can be used. Known values are: "Enabled" and "Disabled".
                    "summary": "str",  # Optional. A short summary of the catalog item.
                    "templatePath": "str",  # Optional. Path to the catalog item entrypoint file.
                    "version": "str"  # Optional. The version of the catalog item.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_environments_list_catalog_item_versions_request(
                    project_name=project_name,
                    catalog_item_id=catalog_item_id,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_catalog_item_version(self, project_name: str, catalog_item_id: str, version: str, **kwargs: Any) -> JSON:
        """Get a specific catalog item version from a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :param catalog_item_id: The unique id of the catalog item. Required.
        :type catalog_item_id: str
        :param version: The version of the catalog item. Required.
        :type version: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actions": [
                        {
                            "description": "str",  # Optional. Description of the action.
                            "id": "str",  # Optional. Unique identifier of the action.
                            "name": "str",  # Optional. Display name of the action.
                            "parameters": [
                                {
                                    "allowed": [
                                        {}  # Optional. An array of allowed
                                          values.
                                    ],
                                    "default": {},  # Optional. Default value of
                                      the parameter.
                                    "description": "str",  # Optional.
                                      Description of the parameter.
                                    "id": "str",  # Optional. Unique ID of the
                                      parameter.
                                    "name": "str",  # Optional. Display name of
                                      the parameter.
                                    "readOnly": bool,  # Optional. Whether or not
                                      this parameter is read-only.  If true, default should have a
                                      value.
                                    "required": bool,  # Optional. Whether or not
                                      this parameter is required.
                                    "type": "str"  # Optional. A string of one of
                                      the basic JSON types (number, integer, null, array, object,
                                      boolean, string). Known values are: "array", "boolean",
                                      "integer", "null", "number", "object", and "string".
                                }
                            ],
                            "parametersSchema": "str",  # Optional. JSON schema defining
                              the parameters specific to the custom action.
                            "runner": "str",  # Optional. The container image to use to
                              execute the action.
                            "type": "str",  # Optional. The action type. Known values
                              are: "Custom", "Deploy", and "Delete".
                            "typeName": "str"  # Optional. Name of the custom action
                              type.
                        }
                    ],
                    "catalogItemId": "str",  # Optional. Unique identifier of the catalog item.
                    "catalogItemName": "str",  # Optional. Name of the catalog item.
                    "catalogName": "str",  # Optional. Name of the catalog.
                    "description": "str",  # Optional. A long description of the catalog item.
                    "eligibleForLatestVersion": bool,  # Optional. Whether the version is
                      eligible to be the latest version.
                    "parameters": [
                        {
                            "allowed": [
                                {}  # Optional. An array of allowed values.
                            ],
                            "default": {},  # Optional. Default value of the parameter.
                            "description": "str",  # Optional. Description of the
                              parameter.
                            "id": "str",  # Optional. Unique ID of the parameter.
                            "name": "str",  # Optional. Display name of the parameter.
                            "readOnly": bool,  # Optional. Whether or not this parameter
                              is read-only.  If true, default should have a value.
                            "required": bool,  # Optional. Whether or not this parameter
                              is required.
                            "type": "str"  # Optional. A string of one of the basic JSON
                              types (number, integer, null, array, object, boolean, string). Known
                              values are: "array", "boolean", "integer", "null", "number", "object",
                              and "string".
                        }
                    ],
                    "parametersSchema": "str",  # Optional. JSON schema defining the parameters
                      object passed to actions.
                    "runner": "str",  # Optional. The default container image to use to execute
                      actions.
                    "status": "str",  # Optional. Defines whether the specific catalog item
                      version can be used. Known values are: "Enabled" and "Disabled".
                    "summary": "str",  # Optional. A short summary of the catalog item.
                    "templatePath": "str",  # Optional. Path to the catalog item entrypoint file.
                    "version": "str"  # Optional. The version of the catalog item.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_environments_get_catalog_item_version_request(
            project_name=project_name,
            catalog_item_id=catalog_item_id,
            version=version,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "tenantId": self._serialize.url("self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True),
            "devCenter": self._serialize.url(
                "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
            ),
            "devCenterDnsSuffix": self._serialize.url(
                "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
            ),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def list_environment_types(self, project_name: str, *, top: Optional[int] = None, **kwargs: Any) -> Iterable[JSON]:
        """Lists all environment types configured for a project.

        :param project_name: The DevCenter Project upon which to execute operations. Required.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the operation. Example: 'top=10'.
         Default value is None.
        :paramtype top: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "deploymentTargetId": "str",  # Optional. Id of a subscription or management
                      group that the environment type will be mapped to. The environment's resources
                      will be deployed into this subscription or management group.
                    "name": "str",  # Optional. Name of the environment type.
                    "status": "str"  # Optional. Defines whether this Environment Type can be
                      used in this Project. Known values are: "Enabled" and "Disabled".
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_environments_list_environment_types_request(
                    project_name=project_name,
                    top=top,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urlparse(next_link)
                _next_request_params = case_insensitive_dict(parse_qs(_parsed_next_link.query))
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest("GET", urljoin(next_link, _parsed_next_link.path), params=_next_request_params)
                path_format_arguments = {
                    "tenantId": self._serialize.url(
                        "self._config.tenant_id", self._config.tenant_id, "str", skip_quote=True
                    ),
                    "devCenter": self._serialize.url(
                        "self._config.dev_center", self._config.dev_center, "str", skip_quote=True
                    ),
                    "devCenterDnsSuffix": self._serialize.url(
                        "self._config.dev_center_dns_suffix", self._config.dev_center_dns_suffix, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
