C$TEST LBAJ
C***********************************************************************
C
C  EXAMPLE OF USE OF THE PORT PROGRAM BADC
C
C***********************************************************************
       SUBROUTINE NEWTON(N,M,ML,X,EPS,FUN,JAC,LIMIT,F)
C
C THIS SUBROUTINE IMPLEMENTS A LINEARIZED FORM OF NEWTONS
C METHOD TO FIND THE ZERO OF A FUNCTION F DEFINED BY
C FUN, WHOSE BAND JACOBIAN (WITH BANDWIDTH M AND ML
C LOWER DIAGONALS) IS EVALUATED IN JAC. LIMIT GIVES
C A BOUND ON THE NUMBER OF ITERATIONS AND IN F THE
C FINAL FUNCTION VALUE IS RETURNED.
C
       INTEGER N, ML, M, LIMIT
       INTEGER JG, JAL, JINTER, ISTKGT, MU, LIM, I
       INTEGER IST(1000)
       REAL EPS, X(N), F(N)
       REAL FU, SNRM2, R(1000)
       DOUBLE PRECISION D(500)
       EXTERNAL FUN,JAC
       COMMON /CSTAK/ D
       EQUIVALENCE (D(1),R(1)),(D(1),IST(1))
C
C GET SPACE FOR G,INTER, AND AL FROM
C THE STORAGE STACK
C
       JG= ISTKGT(M*N,3)
       JAL = ISTKGT ((ML-1)*N,3)
       JINTER = ISTKGT(N,2)
       CALL JAC(N,M,ML,X,R(JG),M)
       CALL BADC(N,ML,M,R(JH),M,R(JAL),ML-1,IST(JINTER),MU)
       LIM=0
  10   CALL FUN(N,X,F)
       FU=SNRM2(N,F,1)
C
C CHECK FOR CONVERGENCE OR IF ITERATION LIMIT IS REACHED
C
      IF (FU.LE.EPS.OR.LIM.GT.LIMIT) RETURN
      LIM=LIM+1
C SOLVE THE LINEAR SYSTEM
      CALL BAFS(N,ML,R(JAL),ML-1,IST(JINTER),F,N,1)
      CALL BABS(N,R(JG),M,F,N,1,MU)
C CORRECT THE CURRENT ESTIMATE OF THE SOLUTION
      DO 20 I=1,N
         X(I)=X(I)-F(I)
  20  CONTINUE
      GO TO 10
      END
