.\" Automatically generated by Pandoc 1.19.2.1
.\"
.TH "PROSODYCTL" "1" "2017\-09\-02" "" ""
.hy
.SH NAME
.PP
prosodyctl \- Manage a Prosody XMPP server
.SH SYNOPSIS
.IP
.nf
\f[C]
prosodyctl\ command\ [\-\-help]
\f[]
.fi
.SH DESCRIPTION
.PP
prosodyctl is the control tool for the Prosody XMPP server.
It may be used to control the server daemon and manage users.
.PP
prosodyctl needs to be executed with sufficient privileges to perform
its commands.
This typically means executing prosodyctl as the root user.
If a user named "prosody" is found then prosodyctl will change to that
user before executing its commands.
.SH COMMANDS
.SS User Management
.PP
In the following commands users are identified by a Jabber ID, jid, of
the usual form: user\@domain.
.TP
.B adduser jid
Adds a user with Jabber ID, jid, to the server.
You will be prompted to enter the user\[aq]s password.
.RS
.RE
.TP
.B passwd jid
Changes the password of an existing user with Jabber ID, jid.
You will be prompted to enter the user\[aq]s new password.
.RS
.RE
.TP
.B deluser jid
Deletes an existing user with Jabber ID, jid, from the server.
.RS
.RE
.SS Daemon Management
.PP
Although prosodyctl has commands to manage the prosody daemon it is
recommended that you utilize your distributions daemon management
features if you attained Prosody through a package.
.PP
To perform daemon control commands prosodyctl needs a pidfile value
specified in \f[C]/etc/prosody/prosody.cfg.lua\f[].
Failure to do so will cause prosodyctl to complain.
.TP
.B start
Starts the prosody server daemon.
If run as root prosodyctl will attempt to change to a user named
"prosody" before executing.
This operation will block for up to five seconds to wait for the server
to execute.
.RS
.RE
.TP
.B stop
Stops the prosody server daemon.
This operation will block for up to five seconds to wait for the server
to stop executing.
.RS
.RE
.TP
.B restart
Restarts the prosody server daemon.
Equivalent to running prosodyctl stop followed by prosodyctl start.
.RS
.RE
.TP
.B reload
Signals the prosody server daemon to reload configuration and reopen log
files.
.RS
.RE
.TP
.B status
Prints the current execution status of the prosody server daemon.
.RS
.RE
.SS Certificates
.PP
prosodyctl can create self\-signed certificates, certificate requests
and private keys for use with Prosody.
Commands are of the form \f[C]prosodyctl\ cert\ subcommand\f[].
Commands take a list of hosts to be included in the certificate.
.TP
.B \f[C]request\ hosts\f[]
Create a certificate request (CSR) file for submission to a certificate
authority.
Multiple hosts can be given, sub\-domains are automatically included.
.RS
.RE
.TP
.B \f[C]generate\ hosts\f[]
Generate a self\-signed certificate.
.RS
.RE
.TP
.B \f[C]key\ host\ [size]\f[]
Generate a private key of \[aq]size\[aq] bits (defaults to 2048).
Invoked automatically by \[aq]request\[aq] and \[aq]generate\[aq] if
needed.
.RS
.RE
.TP
.B \f[C]config\ hosts\f[]
Produce a config file for the list of hosts.
Invoked automatically by \[aq]request\[aq] and \[aq]generate\[aq] if
needed.
.RS
.RE
.TP
.B \f[C]import\ hosts\ paths\f[]
Copy certificates for hosts into the certificate path and reload
prosody.
.RS
.RE
.SS Debugging
.PP
prosodyctl can also show some information about the environment,
dependencies and such to aid in debugging.
.TP
.B \f[C]about\f[]
Shows environment, various paths used by Prosody and installed
dependencies.
.RS
.RE
.TP
.B \f[C]check\ [what]\f[]
Performs various sanity checks on the configuration, DNS setup and
configured TLS certificates.
\f[C]what\f[] can be one of \f[C]config\f[], \f[C]dns\f[] and
\f[C]certs\f[] to run only that check.
.RS
.RE
.SS Ejabberd Compatibility
.PP
ejabberd is another XMPP server which provides a comparable control
tool, ejabberdctl, to control its server\[aq]s operations.
prosodyctl implements some commands which are compatible with
ejabberdctl.
For details of how these commands work you should see ejabberdctl(8).
.IP
.nf
\f[C]
register\ user\ server\ password

unregister\ user\ server
\f[]
.fi
.SH OPTIONS
.TP
.B \f[C]\-\-config\ filename\f[]
Use the specified config file instead of the default.
.RS
.RE
.TP
.B \f[C]\-\-root\f[]
Don\[aq]t drop root privileges.
.RS
.RE
.TP
.B \f[C]\-\-help\f[]
Display help text for the specified command.
.RS
.RE
.SH FILES
.TP
.B \f[C]/etc/prosody/prosody.cfg.lua\f[]
The main prosody configuration file.
prosodyctl reads this to determine the process ID file of the prosody
server daemon and to determine if a host has been configured.
.RS
.RE
.SH ONLINE
.PP
More information may be found online at: <https://prosody.im/>
.SH AUTHORS
Dwayne Bent <dbb.1@liqd.org>; Kim Alvefur.
