/* NVTV Null TV-I2C access -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: tv_null.c,v 1.11 2004/01/27 17:05:25 dthierbach Exp $
 *
 * Contents:
 *
 * Routines to fake null I2C access if no chip is found.
 *
 */

#include "local.h" /* before everything else */

#include "xf86i2c.h"
#include "tv_null.h"

/* -------- Null chip -------- */

/* This is just to make sure nothing crashes if no chip can be detected. */

void TVNullCreate (TVEncoderObj *this, TVChip chip_type, void* ctrl)
{
  RAISE (MSG_ERROR, "Null chip: create");
  this->type = chip_type;
  this->ctrl = ctrl;
  this->hwconfig = 0; 
}

void TVNullInitRegs (TVEncoderObj *this, int flags)
{
  RAISE (MSG_ERROR, "Null chip: Init");
}

void TVNullSetRegs (TVEncoderObj *this, TVEncoderRegs *r, TVState state)
{
  RAISE (MSG_ERROR, "Null chip: SetRegs");
}

void TVNullGetRegs (TVEncoderObj *this, TVEncoderRegs *r)
{
  RAISE (MSG_ERROR, "Null chip: GetRegs");
}

void TVNullSetPort (TVEncoderObj *this, int port)
{
  RAISE (MSG_ERROR, "Null chip: SetPort");
}

void TVNullGetPort (TVEncoderObj *this, int *port)
{
  RAISE (MSG_ERROR, "Null chip: GetPort");
}

void TVNullSetState (TVEncoderObj *this, TVEncoderRegs *r, TVState state)
{
  RAISE (MSG_ERROR, "Null chip: SetState");
}

TVConnect TVNullGetConnect (TVEncoderObj *this)
{
  RAISE (MSG_ERROR, "Null chip: Connect");
  return CONNECT_NONE;
}

long TVNullGetStatus (TVEncoderObj *this, int index)
{
  RAISE (MSG_ERROR, "Null chip: Status");
  return 0;
}

TVEncoderObj tvNullTemplate = {
  type: TV_NO_CHIP, ctrl: NULL, minClock: 0, maxClock: 0, 
  Create:     TVNullCreate,
  InitRegs:   TVNullInitRegs, 
  SetRegs:    TVNullSetRegs, 
  GetRegs:    TVNullGetRegs, 
  SetPort:    TVNullSetPort,
  GetPort:    TVNullGetPort,
  SetState:   TVNullSetState,
  GetConnect: TVNullGetConnect, 
  GetStatus:  TVNullGetStatus
};
