/* $Id: TMgr_AnnotCounts.cpp 414848 2013-09-27 10:09:37Z meric $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'trackmgr.asn'.
 */

#include <ncbi_pch.hpp>
#include <objects/trackmgr/TMgr_AnnotCounts.hpp>
#include <objects/trackmgr/TMgr_LengthStats.hpp>
#include <objects/trackmgr/TMgr_PositionStats.hpp>


BEGIN_NCBI_SCOPE
BEGIN_objects_SCOPE // namespace ncbi::objects::


CTMgr_AnnotCounts::CTMgr_AnnotCounts(void)
{
}

CTMgr_AnnotCounts::~CTMgr_AnnotCounts(void)
{
}

CTMgr_AnnotCounts::TTypeStatRef
CTMgr_AnnotCounts::x_GetCount(ETMgr_AnnotType type) const
{   
    // use a map to short-circuit search for any previously-found counts
    TCountMap::const_iterator it = m_Counts.find(type);
    if (it != m_Counts.end()) {
        return it->second;
    }
    TTypeStatRef retval;
    NON_CONST_ITERATE (TCounts, it, const_cast<CTMgr_AnnotCounts*>(this)->SetCounts()) {
        TTypeStatRef cnt = *it;
        m_Counts.insert(make_pair(cnt->GetType(), cnt));
        if (cnt->GetType() == type) {
            retval = cnt;
            break;
        }
    }
    return retval;
}

CTMgr_TypeStat::TCount
CTMgr_AnnotCounts::GetCount(const ETMgr_AnnotType type) const
{   
    TTypeStatRef cnt = x_GetCount(type);
    return (cnt.IsNull() ? 0 : cnt->GetCount());
}

void
CTMgr_AnnotCounts::Add(const ETMgr_AnnotType type, const Int8 count)
{   
    TTypeStatRef cnt = x_GetCount(type);
    if (cnt.IsNull()) {
        cnt.Reset(new CTMgr_TypeStat());
        cnt->SetType(type);
        cnt->SetCount(0);
        SetCounts().push_back(cnt);
    }
    cnt->SetCount(cnt->GetCount() + count);
}

void
CTMgr_AnnotCounts::AddPosition(const ETMgr_AnnotType type, const Uint8 start, const Uint8 stop)
{   
    TTypeStatRef cnt = x_GetCount(type);
    if (cnt.IsNull()) {
        cnt.Reset(new CTMgr_TypeStat());
        cnt->SetType(type);
        cnt->SetCount(0);
        SetCounts().push_back(cnt);
    }
    const CTMgr_TypeStat::TCount c = cnt->GetCount();
    cnt->SetCount(c + 1);
    cnt->SetLength_stats().Add(stop - start + 1, c);
    cnt->SetPosition_stats().Add(start, stop, c);
}


END_objects_SCOPE // namespace ncbi::objects::
END_NCBI_SCOPE

