/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 *
 * DO NOT EDIT: AUTOMATICALLY GENERATED FILE !!
 */

#include <string.h>
#include <stdint.h>
#include <wchar.h>
#include <assert.h>
#include <cuda.h>
#include <cuda_runtime.h>
#include "yaksuri_cudai_base.h"
#include "yaksuri_cudai_pup.h"

__global__ void yaksuri_cudai_kernel_pack_LXOR_blkhindx__Bool(const void *inbuf, void *outbuf, uintptr_t count, const yaksuri_cudai_md_s *__restrict__ md)
{
    const char *__restrict__ sbuf = (const char *) inbuf;
    char *__restrict__ dbuf = (char *) outbuf;
    uintptr_t extent = md->extent;
    uintptr_t idx = blockIdx.x * blockDim.x + threadIdx.x;
    uintptr_t res = idx;
    uintptr_t inner_elements = md->num_elements;
    
    if (idx >= (count * inner_elements))
        return;
    
    uintptr_t x0 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.count;
    
    uintptr_t x1 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.blocklength;
    uintptr_t x2 = res;
    
    intptr_t *array_of_displs1 = md->u.blkhindx.array_of_displs;
    YAKSURI_CUDAI_OP_LXOR(*((const _Bool *) (const void *) (sbuf + x0 * extent + array_of_displs1[x1] + x2 * sizeof(_Bool))), *((_Bool *) (void *) (dbuf + idx * sizeof(_Bool))));
}

__global__ void yaksuri_cudai_kernel_unpack_LXOR_blkhindx__Bool(const void *inbuf, void *outbuf, uintptr_t count, const yaksuri_cudai_md_s *__restrict__ md)
{
    const char *__restrict__ sbuf = (const char *) inbuf;
    char *__restrict__ dbuf = (char *) outbuf;
    uintptr_t extent = md->extent;
    uintptr_t idx = blockIdx.x * blockDim.x + threadIdx.x;
    uintptr_t res = idx;
    uintptr_t inner_elements = md->num_elements;
    
    if (idx >= (count * inner_elements))
        return;
    
    uintptr_t x0 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.count;
    
    uintptr_t x1 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.blocklength;
    uintptr_t x2 = res;
    
    intptr_t *array_of_displs1 = md->u.blkhindx.array_of_displs;
    YAKSURI_CUDAI_OP_LXOR(*((const _Bool *) (const void *) (sbuf + idx * sizeof(_Bool))), *((_Bool *) (void *) (dbuf + x0 * extent + array_of_displs1[x1] + x2 * sizeof(_Bool))));
}

__global__ void yaksuri_cudai_kernel_pack_LAND_blkhindx__Bool(const void *inbuf, void *outbuf, uintptr_t count, const yaksuri_cudai_md_s *__restrict__ md)
{
    const char *__restrict__ sbuf = (const char *) inbuf;
    char *__restrict__ dbuf = (char *) outbuf;
    uintptr_t extent = md->extent;
    uintptr_t idx = blockIdx.x * blockDim.x + threadIdx.x;
    uintptr_t res = idx;
    uintptr_t inner_elements = md->num_elements;
    
    if (idx >= (count * inner_elements))
        return;
    
    uintptr_t x0 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.count;
    
    uintptr_t x1 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.blocklength;
    uintptr_t x2 = res;
    
    intptr_t *array_of_displs1 = md->u.blkhindx.array_of_displs;
    YAKSURI_CUDAI_OP_LAND(*((const _Bool *) (const void *) (sbuf + x0 * extent + array_of_displs1[x1] + x2 * sizeof(_Bool))), *((_Bool *) (void *) (dbuf + idx * sizeof(_Bool))));
}

__global__ void yaksuri_cudai_kernel_unpack_LAND_blkhindx__Bool(const void *inbuf, void *outbuf, uintptr_t count, const yaksuri_cudai_md_s *__restrict__ md)
{
    const char *__restrict__ sbuf = (const char *) inbuf;
    char *__restrict__ dbuf = (char *) outbuf;
    uintptr_t extent = md->extent;
    uintptr_t idx = blockIdx.x * blockDim.x + threadIdx.x;
    uintptr_t res = idx;
    uintptr_t inner_elements = md->num_elements;
    
    if (idx >= (count * inner_elements))
        return;
    
    uintptr_t x0 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.count;
    
    uintptr_t x1 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.blocklength;
    uintptr_t x2 = res;
    
    intptr_t *array_of_displs1 = md->u.blkhindx.array_of_displs;
    YAKSURI_CUDAI_OP_LAND(*((const _Bool *) (const void *) (sbuf + idx * sizeof(_Bool))), *((_Bool *) (void *) (dbuf + x0 * extent + array_of_displs1[x1] + x2 * sizeof(_Bool))));
}

__global__ void yaksuri_cudai_kernel_pack_LOR_blkhindx__Bool(const void *inbuf, void *outbuf, uintptr_t count, const yaksuri_cudai_md_s *__restrict__ md)
{
    const char *__restrict__ sbuf = (const char *) inbuf;
    char *__restrict__ dbuf = (char *) outbuf;
    uintptr_t extent = md->extent;
    uintptr_t idx = blockIdx.x * blockDim.x + threadIdx.x;
    uintptr_t res = idx;
    uintptr_t inner_elements = md->num_elements;
    
    if (idx >= (count * inner_elements))
        return;
    
    uintptr_t x0 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.count;
    
    uintptr_t x1 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.blocklength;
    uintptr_t x2 = res;
    
    intptr_t *array_of_displs1 = md->u.blkhindx.array_of_displs;
    YAKSURI_CUDAI_OP_LOR(*((const _Bool *) (const void *) (sbuf + x0 * extent + array_of_displs1[x1] + x2 * sizeof(_Bool))), *((_Bool *) (void *) (dbuf + idx * sizeof(_Bool))));
}

__global__ void yaksuri_cudai_kernel_unpack_LOR_blkhindx__Bool(const void *inbuf, void *outbuf, uintptr_t count, const yaksuri_cudai_md_s *__restrict__ md)
{
    const char *__restrict__ sbuf = (const char *) inbuf;
    char *__restrict__ dbuf = (char *) outbuf;
    uintptr_t extent = md->extent;
    uintptr_t idx = blockIdx.x * blockDim.x + threadIdx.x;
    uintptr_t res = idx;
    uintptr_t inner_elements = md->num_elements;
    
    if (idx >= (count * inner_elements))
        return;
    
    uintptr_t x0 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.count;
    
    uintptr_t x1 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.blocklength;
    uintptr_t x2 = res;
    
    intptr_t *array_of_displs1 = md->u.blkhindx.array_of_displs;
    YAKSURI_CUDAI_OP_LOR(*((const _Bool *) (const void *) (sbuf + idx * sizeof(_Bool))), *((_Bool *) (void *) (dbuf + x0 * extent + array_of_displs1[x1] + x2 * sizeof(_Bool))));
}

__global__ void yaksuri_cudai_kernel_pack_REPLACE_blkhindx__Bool(const void *inbuf, void *outbuf, uintptr_t count, const yaksuri_cudai_md_s *__restrict__ md)
{
    const char *__restrict__ sbuf = (const char *) inbuf;
    char *__restrict__ dbuf = (char *) outbuf;
    uintptr_t extent = md->extent;
    uintptr_t idx = blockIdx.x * blockDim.x + threadIdx.x;
    uintptr_t res = idx;
    uintptr_t inner_elements = md->num_elements;
    
    if (idx >= (count * inner_elements))
        return;
    
    uintptr_t x0 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.count;
    
    uintptr_t x1 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.blocklength;
    uintptr_t x2 = res;
    
    intptr_t *array_of_displs1 = md->u.blkhindx.array_of_displs;
    YAKSURI_CUDAI_OP_REPLACE(*((const _Bool *) (const void *) (sbuf + x0 * extent + array_of_displs1[x1] + x2 * sizeof(_Bool))), *((_Bool *) (void *) (dbuf + idx * sizeof(_Bool))));
}

__global__ void yaksuri_cudai_kernel_unpack_REPLACE_blkhindx__Bool(const void *inbuf, void *outbuf, uintptr_t count, const yaksuri_cudai_md_s *__restrict__ md)
{
    const char *__restrict__ sbuf = (const char *) inbuf;
    char *__restrict__ dbuf = (char *) outbuf;
    uintptr_t extent = md->extent;
    uintptr_t idx = blockIdx.x * blockDim.x + threadIdx.x;
    uintptr_t res = idx;
    uintptr_t inner_elements = md->num_elements;
    
    if (idx >= (count * inner_elements))
        return;
    
    uintptr_t x0 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.count;
    
    uintptr_t x1 = res / inner_elements;
    res %= inner_elements;
    inner_elements /= md->u.blkhindx.blocklength;
    uintptr_t x2 = res;
    
    intptr_t *array_of_displs1 = md->u.blkhindx.array_of_displs;
    YAKSURI_CUDAI_OP_REPLACE(*((const _Bool *) (const void *) (sbuf + idx * sizeof(_Bool))), *((_Bool *) (void *) (dbuf + x0 * extent + array_of_displs1[x1] + x2 * sizeof(_Bool))));
}

void yaksuri_cudai_pack_blkhindx__Bool(const void *inbuf, void *outbuf, uintptr_t count, yaksa_op_t op, yaksuri_cudai_md_s *md, int n_threads, int n_blocks_x, int n_blocks_y, int n_blocks_z, cudaStream_t stream)
{
void *args[] = { &inbuf, &outbuf, &count, &md };
    cudaError_t cerr;
    switch (op) {
        case YAKSA_OP__LXOR:
        cerr = cudaLaunchKernel((const void *) yaksuri_cudai_kernel_pack_LXOR_blkhindx__Bool,
            dim3(n_blocks_x, n_blocks_y, n_blocks_z), dim3(n_threads), args, 0, stream);
        YAKSURI_CUDAI_CUDA_ERR_CHECK(cerr);
        break;

        case YAKSA_OP__LAND:
        cerr = cudaLaunchKernel((const void *) yaksuri_cudai_kernel_pack_LAND_blkhindx__Bool,
            dim3(n_blocks_x, n_blocks_y, n_blocks_z), dim3(n_threads), args, 0, stream);
        YAKSURI_CUDAI_CUDA_ERR_CHECK(cerr);
        break;

        case YAKSA_OP__LOR:
        cerr = cudaLaunchKernel((const void *) yaksuri_cudai_kernel_pack_LOR_blkhindx__Bool,
            dim3(n_blocks_x, n_blocks_y, n_blocks_z), dim3(n_threads), args, 0, stream);
        YAKSURI_CUDAI_CUDA_ERR_CHECK(cerr);
        break;

        case YAKSA_OP__REPLACE:
        cerr = cudaLaunchKernel((const void *) yaksuri_cudai_kernel_pack_REPLACE_blkhindx__Bool,
            dim3(n_blocks_x, n_blocks_y, n_blocks_z), dim3(n_threads), args, 0, stream);
        YAKSURI_CUDAI_CUDA_ERR_CHECK(cerr);
        break;

    }
}

void yaksuri_cudai_unpack_blkhindx__Bool(const void *inbuf, void *outbuf, uintptr_t count, yaksa_op_t op, yaksuri_cudai_md_s *md, int n_threads, int n_blocks_x, int n_blocks_y, int n_blocks_z, cudaStream_t stream)
{
void *args[] = { &inbuf, &outbuf, &count, &md };
    cudaError_t cerr;
    switch (op) {
        case YAKSA_OP__LXOR:
        cerr = cudaLaunchKernel((const void *) yaksuri_cudai_kernel_unpack_LXOR_blkhindx__Bool,
            dim3(n_blocks_x, n_blocks_y, n_blocks_z), dim3(n_threads), args, 0, stream);
        YAKSURI_CUDAI_CUDA_ERR_CHECK(cerr);
        break;

        case YAKSA_OP__LAND:
        cerr = cudaLaunchKernel((const void *) yaksuri_cudai_kernel_unpack_LAND_blkhindx__Bool,
            dim3(n_blocks_x, n_blocks_y, n_blocks_z), dim3(n_threads), args, 0, stream);
        YAKSURI_CUDAI_CUDA_ERR_CHECK(cerr);
        break;

        case YAKSA_OP__LOR:
        cerr = cudaLaunchKernel((const void *) yaksuri_cudai_kernel_unpack_LOR_blkhindx__Bool,
            dim3(n_blocks_x, n_blocks_y, n_blocks_z), dim3(n_threads), args, 0, stream);
        YAKSURI_CUDAI_CUDA_ERR_CHECK(cerr);
        break;

        case YAKSA_OP__REPLACE:
        cerr = cudaLaunchKernel((const void *) yaksuri_cudai_kernel_unpack_REPLACE_blkhindx__Bool,
            dim3(n_blocks_x, n_blocks_y, n_blocks_z), dim3(n_threads), args, 0, stream);
        YAKSURI_CUDAI_CUDA_ERR_CHECK(cerr);
        break;

    }
}

