/**
 * \file pappsomspp/obo/obopsimodmap.h
 * \date 2/10/2024
 * \author Olivier Langella
 * \brief map container for obo psi mod terms
 **/

/*******************************************************************************
 * Copyright (c) 2024 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once


#include "obopsimod.h"

namespace pappso
{

class PMSPP_LIB_DECL FilterOboPsiModMap : public OboPsiModHandlerInterface
{

  public:
  FilterOboPsiModMap();
  /**
   * Destructor
   */
  virtual ~FilterOboPsiModMap();

  virtual void setOboPsiModTerm(const OboPsiModTerm &term) override;

  const OboPsiModTerm &getOboPsiModTermWithAccession(const QString &accession) const;

  /** @brief get the first occurence of term with this name
   * @warning not reliable, it does not check for unicity
   */
  const OboPsiModTerm &getOboPsiModTermWithName(const QString &name) const;

  private:
  std::map<QString, const OboPsiModTerm> m_mapOboPsiModTerm;
};
} // namespace pappso
