; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='default<Os>' -S %s | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"


declare void @use(i16)

define void @test_remove_check_with_incrementing_integer_induction(i16 %start, i8 %len.n, i16 %a) {
; CHECK-LABEL: @test_remove_check_with_incrementing_integer_induction(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LEN:%.*]] = zext i8 [[LEN_N:%.*]] to i16
; CHECK-NEXT:    [[LEN_NEG_NOT:%.*]] = icmp ult i16 [[LEN]], [[A:%.*]]
; CHECK-NEXT:    [[C1:%.*]] = icmp ne i8 [[LEN_N]], 0
; CHECK-NEXT:    [[OR_COND3:%.*]] = and i1 [[LEN_NEG_NOT]], [[C1]]
; CHECK-NEXT:    br i1 [[OR_COND3]], label [[LOOP_LATCH_PREHEADER:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.latch.preheader:
; CHECK-NEXT:    [[TMP0:%.*]] = add i16 [[A]], -1
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i16 [[LEN]], -1
; CHECK-NEXT:    [[UMIN:%.*]] = tail call i16 @llvm.umin.i16(i16 [[TMP0]], i16 [[TMP1]])
; CHECK-NEXT:    br label [[LOOP_LATCH:%.*]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[IV2:%.*]] = phi i16 [ [[IV_NEXT:%.*]], [[LOOP_LATCH]] ], [ 0, [[LOOP_LATCH_PREHEADER]] ]
; CHECK-NEXT:    tail call void @use(i16 [[IV2]])
; CHECK-NEXT:    [[IV_NEXT]] = add nuw nsw i16 [[IV2]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i16 [[IV2]], [[UMIN]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[EXIT]], label [[LOOP_LATCH]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %len = zext i8 %len.n to i16
  %upper = add nuw nsw i16 %start, %len
  %len.neg = icmp uge i16 %len, %a
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %iv = phi i16 [ 0, %loop.ph ], [ %iv.next, %loop.latch ]
  %c = icmp eq i16 %iv, %len
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge i16 %iv, 0
  %t.2 = icmp ult i16 %iv, %a
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(i16 %iv)
  %iv.next = add nuw nsw i16 %iv, 1
  br label %loop.header

exit:
  ret void
}
